<?php
/**
 * Single Product title
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/title.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see        https://docs.woocommerce.com/document/template-structure/
 * @package    WooCommerce\Templates
 * @version    1.6.4
 */
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
global $product;
global $post;
$options = get_option( 'kaveh_frame' );
$catname = wp_get_post_terms( $product->get_id(), 'product_cat', array());
$catlink = get_term_link( $catname[0]->term_id , 'product_cat' );
$brname = wp_get_post_terms( $product->get_id(), 'brands', array());
if ( isset( $brname[0] ) ) {
    $brlink = get_term_link( $brname[0]->term_id , 'brands' );
}
$stocka = $product->get_stock_status();
$rating_count = $product->get_rating_count();
$review_count = $product->get_review_count();
$average      = $product->get_average_rating();
$kaveh_pr_metas = get_post_meta( $product->get_id(), 'single_product_options', true );

if($options['kaveh_pr_single_select']=='value-1'):
do_action('customstyleinprsingle');	
?>
<?php if ( $rating_count > 0 ) : ?>
<!-- Start Count Comments & Rate -->
<div class="count-comments-rate d-flex align-items-center">
	<div class="count-comment">
	<?php echo $review_count; ?>
	<span> نظر </span>
	</div>
	<div class="count-rate">
	<?php echo $average; ?>
	<i class="icon-star"></i>
	</div>
</div>
<!-- Start Count Comments & Rate -->
<?php endif ?>
<h1 class="name"> <?php the_title(); ?> </h1>
<?php
if (is_plugin_active('dokan-lite/dokan.php')) {
    $seller_info = dokan_get_store_info(get_the_author_meta('ID'));
    if ($seller_info) {
        $seller_name = $seller_info['store_name'];
		global $wpdb;
		$product_id = $product->get_id();
		$pids=array($product_id);
		$has_multivendor = get_post_meta( $product_id, '_has_multi_vendor', true );
		if ( !empty( $has_multivendor ) ) {
		$sql     = "SELECT `product_id` FROM `{$wpdb->prefix}dokan_product_map` WHERE `map_id`= '$has_multivendor' AND `product_id` != $product_id AND `is_trash` = 0";
		$results = $wpdb->get_results( $sql );
		}
		foreach($results as $result){
			$pids[]= $result->product_id;
		}
		?>
		<a href="#other_sellers">
			<span class="seller-kaveh mt-2"><strong>فروشنده:</strong> <?php echo $seller_name ?> || فروش توسط  </span>
			<span class="seller-kaveh mt-2"> <?php echo count($pids)-1; ?> <strong>فروشنده دیگر</strong> </span>
		</a>
		<style>
			.seller-kaveh {
				margin-bottom: 20px;
				display: inline-block;
			}
		</style>
		<?php
    }
}

?>
<ul class="full-info d-flex align-items-sm-center justify-content-sm-between position-relative flex-wrap flex-sm-nowrap">
<?php if("instock"==$stocka): ?>
<li>
<i class="icon-check-circle"></i>
موجود در انبار
</li>
<?php elseif("onbackorder"==$stocka): ?>
<li class="obstock">
<i class="far fa-clock"></i>
در پیش خرید
</li>	
<?php else: ?>
<li class="oustock">
<i class="isax isax-close-circle"></i>
ناموجود در انبار
</li>
<?php endif; ?>
<?php if(!empty($catname[0]->name)): ?>
<li>
<span> دسته بندی </span>
<?php
foreach($catname as $cats){
?>
<a href="<?php echo get_term_link( $cats->term_id , 'product_cat' ); ?>"> <?php echo $cats->name; ?> </a>
<?php
} 
?>
</li>
<?php endif; ?>
<?php if(!empty($brname[0]->name)): ?>
<li>
<span> برند </span>
<a href="<?php echo $brlink; ?>"> <?php echo $brname[0]->name; ?> </a>
</li>
<?php endif; ?>
<?php
$cus_l = get_post_meta( get_the_ID(), "cus_lab_g", true );
$cus_v = get_post_meta( get_the_ID(), "cus_lab_g", true );
if(!empty($cus_l) and !empty($cus_v)):
?>	
<li>
<span> <?php echo $cus_l[0]['cus_lab']; ?> </span>
<a> <?php echo $cus_v[0]['cus_val']; ?> </a>
</li>
<?php
endif;
?>
</ul>

<?php if($options['featuresinsingle'] === '1'): ?>
<?php
	$product_attributes = array();
	// Display weight and dimensions before attribute list.
	$display_dimensions = apply_filters( 'wc_product_enable_dimensions_display', $product->has_weight() || $product->has_dimensions() );

	if ( $display_dimensions && $product->has_weight() ) {
		$product_attributes['weight'] = array(
			'label' => __( 'Weight', 'woocommerce' ),
			'value' => wc_format_weight( $product->get_weight() ),
		);
	}
	if ( $display_dimensions && $product->has_dimensions() ) {
		$product_attributes['dimensions'] = array(
			'label' => __( 'Dimensions', 'woocommerce' ),
			'value' => wc_format_dimensions( $product->get_dimensions( false ) ),
		);
	}
	// Add product attributes to list.
	$attributes = array_filter( $product->get_attributes(), 'wc_attributes_array_filter_visible' );
	foreach ( $attributes as $attribute ) {
		$values = array();
		if ( $attribute->is_taxonomy() ) {
			$attribute_taxonomy = $attribute->get_taxonomy_object();
			$attribute_values   = wc_get_product_terms( $product->get_id(), $attribute->get_name(), array( 'fields' => 'all' ) );

			foreach ( $attribute_values as $attribute_value ) {
				$value_name = esc_html( $attribute_value->name );

				if ( $attribute_taxonomy->attribute_public ) {
					$values[] = '<a href="' . esc_url( get_term_link( $attribute_value->term_id, $attribute->get_name() ) ) . '" rel="tag">' . $value_name . '</a>';
				} else {
					$values[] = $value_name;
				}
			}
		} else {
			$values = $attribute->get_options();

			foreach ( $values as &$value ) {
				$value = make_clickable( esc_html( $value ) );
			}
		}
		$product_attributes[ 'attribute_' . sanitize_title_with_dashes( $attribute->get_name() ) ] = array(
			'label' => wc_attribute_label( $attribute->get_name() ),
			'value' => apply_filters( 'woocommerce_attribute', wpautop( wptexturize( implode( ', ', $values ) ) ), $attribute, $values ),
		);
	}

if(!empty($product_attributes)):
?>
<div class="options position-relative">
<div class="title">
ویژگی‌های ﻣﺤﺼﻮل
</div>
<ul class="d-flex align-items-center flex-wrap">
<?php $countme=0; ?>	
<?php foreach ( $product_attributes as $product_attribute_key => $product_attribute ) : ?>
<?php if($countme < 8): ?>	
<li> <?php echo $product_attribute['label']; ?> : <?php echo str_replace( 'p>' , 'span>' , $product_attribute['value'] ); ?> </li>
<?php $countme += 1; ?>
<?php endif; ?>
<?php endforeach; ?>
</ul>
</div>
<?php endif; ?>
<?php endif; ?>


<?php if($options['excerptinsingle'] === '1'): ?>
<div class="options position-relative">
<div class="title tozi">
<?php woocommerce_template_single_excerpt() ?>
</div>
</div>
<?php endif; ?>
<div class="mb-4"></div>
<?php
woocommerce_template_single_add_to_cart();
?>


			
<?php		
elseif($options['kaveh_pr_single_select']=='value-2'):
?>


<h1 class="detail-product-two-name"> <?php the_title(); ?> </h1>
<ul class="info d-flex align-items-center justify-content-between">

<?php if(!empty($catname[0]->name)): ?>
<li>
<span> دسته بندی </span>
<a href="<?php echo $catlink; ?>"> <?php echo $catname[0]->name; ?> </a>
</li>
<?php endif; ?>
<?php if(!empty($brname[0]->name)): ?>
<li>
<span> برند </span>
<a href="<?php echo $brlink; ?>"> <?php echo $brname[0]->name; ?> </a>
</li>
<?php endif; ?>
<?php
$cus_l = get_post_meta( get_the_ID(), "cus_lab_g", true );
$cus_v = get_post_meta( get_the_ID(), "cus_lab_g", true );
if(!empty($cus_l) and !empty($cus_v)):
?>	
<li>
<span> <?php echo $cus_l[0]['cus_lab']; ?> </span>
<a> <?php echo $cus_v[0]['cus_val']; ?> </a>
</li>
<?php
endif;  
?>
</ul>
<div class="row">
<div class="col-sm-6">
<?php if($options['featuresinsingle'] === '1'): ?>
<div class="options-product">
<div class="title"> ویژگی‌های ﻣﺤﺼﻮل </div>
<?php
	$product_attributes = array();
	// Display weight and dimensions before attribute list.
	$display_dimensions = apply_filters( 'wc_product_enable_dimensions_display', $product->has_weight() || $product->has_dimensions() );

	if ( $display_dimensions && $product->has_weight() ) {
		$product_attributes['weight'] = array(
			'label' => __( 'Weight', 'woocommerce' ),
			'value' => wc_format_weight( $product->get_weight() ),
		);
	}
	if ( $display_dimensions && $product->has_dimensions() ) {
		$product_attributes['dimensions'] = array(
			'label' => __( 'Dimensions', 'woocommerce' ),
			'value' => wc_format_dimensions( $product->get_dimensions( false ) ),
		);
	}
	// Add product attributes to list.
	$attributes = array_filter( $product->get_attributes(), 'wc_attributes_array_filter_visible' );
	foreach ( $attributes as $attribute ) {
		$values = array();
		if ( $attribute->is_taxonomy() ) {
			$attribute_taxonomy = $attribute->get_taxonomy_object();
			$attribute_values   = wc_get_product_terms( $product->get_id(), $attribute->get_name(), array( 'fields' => 'all' ) );

			foreach ( $attribute_values as $attribute_value ) {
				$value_name = esc_html( $attribute_value->name );

				if ( $attribute_taxonomy->attribute_public ) {
					$values[] = '<a href="' . esc_url( get_term_link( $attribute_value->term_id, $attribute->get_name() ) ) . '" rel="tag">' . $value_name . '</a>';
				} else {
					$values[] = $value_name;
				}
			}
		} else {
			$values = $attribute->get_options();

			foreach ( $values as &$value ) {
				$value = make_clickable( esc_html( $value ) );
			}
		}
		$product_attributes[ 'attribute_' . sanitize_title_with_dashes( $attribute->get_name() ) ] = array(
			'label' => wc_attribute_label( $attribute->get_name() ),
			'value' => apply_filters( 'woocommerce_attribute', wpautop( wptexturize( implode( ', ', $values ) ) ), $attribute, $values ),
		);
	}
?>
	<ul>
	<?php $countme=0; ?>	
	<?php foreach ( $product_attributes as $product_attribute_key => $product_attribute ) : ?>
	<?php if($countme < 4): ?>	
	<li> <?php echo $product_attribute['label']; ?> : <?php echo str_replace( 'p>' , 'span>' , $product_attribute['value'] ); ?> </li>
	<?php $countme += 1; ?>
	<?php endif; ?>
	<?php endforeach; ?>
	</ul>
</div>
</div>
<?php endif; ?>
<div class="col-sm-6">
	
<div class="status d-flex align-items-center mb-4">
<span class="titr"> وضعیت </span>
<?php if("instock"==$stocka): ?>	
<div> موجود در انبار </div>
<?php elseif("onbackorder"==$stocka): ?>
<div> در پیش خرید</div>
<?php else: ?>
<div class="nam"> ناموجود در انبار </div>
<?php endif; ?>
</div>

</div>
</div>
				 
<?php woocommerce_template_single_excerpt(); ?>
<div class="mb-4"></div>
<?php woocommerce_template_single_add_to_cart(); ?>
<?php
elseif($options['kaveh_pr_single_select']=='value-3'):
global $post;
?>
<h1 class="detail-product-three-name"> <?php the_title(); ?></h1>
<div class="d-flex align-items-center justify-content-between">
	<div class="status d-flex align-items-center">
	<span class="titr"> وضعیت </span>
	<?php if("instock"==$stocka): ?>	
	<div> موجود در انبار </div>
	<?php elseif("onbackorder"==$stocka): ?>
	<div> در پیش خرید</div>
	<?php else: ?>
	<div class="nam"> ناموجود در انبار </div>
	<?php endif; ?>
	</div>
	<?php $skuid = get_the_ID(); ?>
	<div class="code-product"> کد محصول <?php echo $skuid; ?> </div>
</div>
<?php if($options['featuresinsingle'] === '1'): ?>
<div class="options-product">
<div class="title"> ویژگی‌های ﻣﺤﺼﻮل </div>
	<?php
	$product_attributes = array();
	// Display weight and dimensions before attribute list.
	$display_dimensions = apply_filters( 'wc_product_enable_dimensions_display', $product->has_weight() || $product->has_dimensions() );

	if ( $display_dimensions && $product->has_weight() ) {
		$product_attributes['weight'] = array(
			'label' => __( 'Weight', 'woocommerce' ),
			'value' => wc_format_weight( $product->get_weight() ),
		);
	}
	if ( $display_dimensions && $product->has_dimensions() ) {
		$product_attributes['dimensions'] = array(
			'label' => __( 'Dimensions', 'woocommerce' ),
			'value' => wc_format_dimensions( $product->get_dimensions( false ) ),
		);
	}
	// Add product attributes to list.
	$attributes = array_filter( $product->get_attributes(), 'wc_attributes_array_filter_visible' );
	foreach ( $attributes as $attribute ) {
		$values = array();
		if ( $attribute->is_taxonomy() ) {
			$attribute_taxonomy = $attribute->get_taxonomy_object();
			$attribute_values   = wc_get_product_terms( $product->get_id(), $attribute->get_name(), array( 'fields' => 'all' ) );

			foreach ( $attribute_values as $attribute_value ) {
				$value_name = esc_html( $attribute_value->name );

				if ( $attribute_taxonomy->attribute_public ) {
					$values[] = '<a href="' . esc_url( get_term_link( $attribute_value->term_id, $attribute->get_name() ) ) . '" rel="tag">' . $value_name . '</a>';
				} else {
					$values[] = $value_name;
				}
			}
		} else {
			$values = $attribute->get_options();

			foreach ( $values as &$value ) {
				$value = make_clickable( esc_html( $value ) );
			}
		}
		$product_attributes[ 'attribute_' . sanitize_title_with_dashes( $attribute->get_name() ) ] = array(
			'label' => wc_attribute_label( $attribute->get_name() ),
			'value' => apply_filters( 'woocommerce_attribute', wpautop( wptexturize( implode( ', ', $values ) ) ), $attribute, $values ),
		);
	}
?>
	<ul>
	<?php $countme=0; ?>	
	<?php foreach ( $product_attributes as $product_attribute_key => $product_attribute ) : ?>
	<?php if($countme < 5): ?>	
	<li> <?php echo $product_attribute['label']; ?> : <?php echo str_replace( 'p>' , 'span>' , $product_attribute['value'] ); ?></li>
	<?php $countme += 1; ?>
	<?php endif; ?>
	<?php endforeach; ?>
	</ul>

	
</div>
<?php endif; ?>
<div class="brands d-flex align-items-center justify-content-between">
<?php if(!empty($brname[0]->name)): ?>
	<span>
	برند محصول :
	<a href="<?php echo $brlink; ?>"> <?php echo $brname[0]->name; ?> </a>
	</span>
	<?php endif; ?>
	<?php
	$numberlimit = $options['excerptinsinglenumber'];
	$short_description = apply_filters( 'woocommerce_short_description', $post->post_excerpt );
	if($options['excerptlimit'] !== '1'){
		echo $short_description;
	}else{
		echo wp_trim_words($short_description,$numberlimit);
	}
	?>
</div>

<?php elseif($options['kaveh_pr_single_select']=='value-4'): ?>


	<div class="detail-product-four-box">
		<h1 class="title-detail-product fw-semibold fs-6"> <?php echo $product->get_name(); ?> </h1>
		<?php if(!empty($kaveh_pr_metas['kpr_english_name'])): ?>
		<h4 class="title-detail-product fw-semibold fs-6"> <?php echo $kaveh_pr_metas['kpr_english_name']; ?> </h4>
		<?php endif; ?>
	</div>

	
	<?php do_action('kaveh_single_meta'); ?>
	<?php if(!empty($brname[0]->name)): ?>
		<span class="posted_in me-3">برند: 
        <a href="<?php echo $brlink; ?>" rel="tag"><?php echo $brname[0]->name; ?></a>
    </span>
	<?php endif; ?>

	<div class="star-comments d-flex align-items-lg-center position-relative">
	<div class="star">
		<i class="icon-icon-action-star-on me-1"></i>
		<?php if($average === '0' ){ echo 'بدون امتیاز'; }else{ echo $average; } ?>
	</div>
	<div class="comments-text">
	<?php echo $review_count; ?> دیدگاه
	</div>
	</div>
	<?php if($options['featuresinsingle'] === '1'): ?>
	<div class="volume d-flex align-items-center mt-2">
	<i class="isax isax-category-2"></i>
	ویژگی های محصول
	</div>
	<!-- Start Carousel Valumes -->
	<div class="swiper swiper-volume-detail-product overflow-hidden position-relative">
		<div class="swiper-wrapper">
			<?php             
			$i = 0;
            $product_attributes = $product->get_attributes();
            if(!empty($product_attributes)): 
			// Loop through each attribute
			foreach ($product_attributes as $attribute):
			$attribute_slug = $attribute->get_name();
			if($i<10):
			?>
			<!-- Start Slide -->
			<div class="swiper-slide w-auto">
				<input type="radio" name="volume" value="1" id="volume-1" hidden checked>
				<label for="volume-1" class="volume-item d-block rounded-pill">
					<?php echo wc_attribute_label( $attribute_slug ) ?> : <?php echo $product->get_attribute( $attribute_slug ) ?>
				</label>
			</div>
			<!-- End Slide -->
			<?php 
			$i++;
			endif;
			endforeach;
			endif;
			?> 
		</div>
	</div>
	<!-- End Carousel Valumes -->
	<?php endif; ?>
<?php
endif;

