<?php
/**
 * Related Products
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/related.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     3.9.0
 */

if (!defined('ABSPATH')) {
  exit;
}
$options = get_option('kaveh_frame');
$mkshopcart = $options['kaveh_sh_cart_select'];
$heading = apply_filters('woocommerce_product_related_products_heading', __('Related products', 'woocommerce'));
if ($related_products): ?>
  <?php if ($options['kaveh_pr_single_select'] == 'value-4'): ?>
    <?php if ($related_products): ?>
      <!-- Start Products Related -->
      <section class="detail-product-four-related">
        <div class="container position-relative">
          <!-- Start Heading -->
          <div
            class="section-heading-eight d-flex align-items-sm-center flex-wrap flex-lg-nowrap gap-4 gap-lg-0 flex-column flex-sm-row">
            <div class="text-nowrap">
              <?php if ($heading): ?>
                <div class="section-heading-eight-title">
                  <?php echo esc_html($heading); ?>
                </div>
              <?php endif; ?>
            </div>
            <a href="<?php echo get_permalink(wc_get_page_id('shop')); ?>"
              class="btn btn-purple-2 d-flex align-items-center justify-content-center text-nowrap ms-auto">
              مشاهده همه
              <i class="icon-angle-circle-top-left ms-2"></i>
            </a>
            <div class="swiper-bottom end-0 d-none d-md-flex align-items-md-center ms-lg-4">
              <div
                class="swiper-detail-product-four-related-pagination swiper-pagination m-0 position-relative top-0 start-0 bottom-0 end-0 d-flex">
              </div>
              <div
                class="swiper-detail-product-four-related-button-prev swiper-button-prev m-0 w-auto h-auto position-relative top-0 start-0 bottom-0 end-0 mx-3">
              </div>
              <div
                class="swiper-detail-product-four-related-button-next swiper-button-next m-0 w-auto h-auto position-relative top-0 start-0 bottom-0 end-0">
              </div>
            </div>
          </div>
          <!-- End Heading -->
          <?php woocommerce_product_loop_start(); ?>
          <!-- Start Carousel -->
          <div class="swiper swiper-detail-product-four-related swiper-button-arrow swiper-visible">
            <div class="swiper-wrapper">
              <?php foreach ($related_products as $related_product): ?>
                <?php
                $post_object = get_post($related_product->get_id());

                setup_postdata($GLOBALS['post'] =& $post_object); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited, Squiz.PHP.DisallowMultipleAssignments.Found
                ?>
                <div class="swiper-slide">
                  <?php
                  $template_parts = array(
                    'value-1' => 'template-part/product-cart-one',
                    'value-2' => 'template-part/product-cart-two',
                    'value-3' => 'template-part/product-cart-three',
                    'value-4' => 'template-part/product-cart-four',
                    'value-5' => 'template-part/product-cart-five',
                    'value-6' => 'template-part/product-cart-six',
                    'value-7' => 'template-part/product-cart-seven',
                    'value-8' => 'template-part/product-cart-eight',
                    'value-9' => 'template-part/product-cart-nine',
                    'value-10' => 'template-part/product-cart-ten',
                    'value-11' => 'template-part/product-cart-eleven',
                    'value-12' => 'template-part/product-cart-twelve',
                    'value-13' => 'template-part/product-cart-thirteen',
                    'value-14' => 'template-part/product-cart-fourteen',
                    'value-15' => 'template-part/product-cart-fifteen',
                    'value-16' => 'template-part/product-cart-sixteen',
                    'value-18' => 'template-part/product-cart-eighteen',
                  );
                  if (array_key_exists($mkshopcart, $template_parts)) {
                    get_template_part($template_parts[$mkshopcart]);
                  }
                  ?>
                </div>

              <?php endforeach; ?>

            </div>
            <div
              class="swiper-bottom position-absolute w-100 start-0 bottom-0 end-0 mx-auto d-flex d-md-none align-items-center justify-content-center">
              <div class="swiper-pagination swiper-pagination m-0 position-relative top-0 start-0 bottom-0 end-0 d-flex">
              </div>
              <div
                class="swiper-button-prev swiper-button-prev m-0 w-auto h-auto position-relative top-0 start-0 bottom-0 end-0 mx-3">
              </div>
              <div
                class="swiper-button-next swiper-button-next m-0 w-auto h-auto position-relative top-0 start-0 bottom-0 end-0">
              </div>
            </div>

          </div>
          <!-- End Carousel -->
          <?php woocommerce_product_loop_end(); ?>
          <?php wp_reset_postdata(); ?>
        </div>
      </section>
      <!-- End Products Related -->
    <?php endif; ?>
  <?php else: ?>
    <section class="related products">

      <!-- Start Products Proposal -->
      <div class="top-seller-home">
        <div class="container position-relative">
          <!-- Start Heading -->
          <div
            class="section-heading position-relative d-flex align-items-sm-center justify-content-sm-between flex-column flex-sm-row">
            <div class="detail">
              <h3 class="section-heading-title"> محصولات </h3>
              <h6 class="section-heading-sub-title"> مرتبط</h6>
            </div>
            <a href="<?php echo get_permalink(wc_get_page_id('shop')); ?>"
              class="section-heading-link btn btn-outline-dark"> مشاهده همه </a>
          </div>

          <?php woocommerce_product_loop_start(); ?>
          <!-- End Heading -->
          <!-- Start Products -->
          <div class="swiper swiper-products"
            data-swiper='{"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"320":{"slidesPerView":<?php echo '2'; ?>,"spaceBetween":4},"500":{"slidesPerView":<?php echo '2'; ?>,"spaceBetween":14},"768":{"slidesPerView":<?php echo '2'; ?>,"spaceBetween":14},"992":{"slidesPerView":<?php echo '3'; ?>,"spaceBetween":20},"1200":{"slidesPerView":<?php echo '4'; ?>,"spaceBetween":31}}}'>
            <div class="swiper-wrapper">

              <?php foreach ($related_products as $related_product): ?>

                <?php
                $post_object = get_post($related_product->get_id());

                setup_postdata($GLOBALS['post'] =& $post_object); // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited, Squiz.PHP.DisallowMultipleAssignments.Found
                ?>
                <div class="swiper-slide">
                  <?php
                  switch ($mkshopcart):
                    case "value-1":
                      get_template_part("template-part/product-cart-one");
                      break;
                    case "value-2":
                      get_template_part("template-part/product-cart-two");
                      break;
                    case "value-3":
                      get_template_part("template-part/product-cart-three");
                      break;
                    case "value-4":
                      get_template_part("template-part/product-cart-four");
                      break;
                    case "value-5":
                      get_template_part("template-part/product-cart-five");
                      break;
                    case "value-6":
                      get_template_part("template-part/product-cart-six");
                      break;
                    case "value-7":
                      get_template_part("template-part/product-cart-seven");
                      break;
                    case "value-8":
                      get_template_part("template-part/product-cart-eight");
                      break;
                    case "value-9":
                      get_template_part("template-part/product-cart-nine");
                      break;
                    case "value-10":
                      get_template_part("template-part/product-cart-ten");
                      break;
                    case "value-11":
                      get_template_part("template-part/product-cart-eleven");
                      break;
                    case "value-12":
                      get_template_part("template-part/product-cart-twelve");
                      break;
                    case "value-13":
                      get_template_part("template-part/product-cart-thirteen");
                      break;
                    case "value-14":
                      get_template_part("template-part/product-cart-fourteen");
                      break;
                    case "value-15":
                      get_template_part("template-part/product-cart-fifteen");
                      break;
                    case "value-16":
                      get_template_part("template-part/product-cart-sixteen");
                      break;
                  endswitch;
                  ?>
                </div>


              <?php endforeach; ?>
            </div>
            <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div>
          </div>
          <!-- End Products -->
          <?php woocommerce_product_loop_end(); ?>


        </div>
      </div>
      <!-- End Products Proposal -->

    </section>


    <?php
  endif;

  wp_reset_postdata();


endif;


