<?php
/**
 * Single Product Thumbnails
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-thumbnails.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see         https://docs.woocommerce.com/document/template-structure/
 * @package     WooCommerce\Templates
 * @version     9.5.0
 */

defined( 'ABSPATH' ) || exit;

// Note: `wc_get_gallery_image_html` was added in WC 3.3.2 and did not exist prior. This check protects against theme overrides being used on older versions of WC.
if ( ! function_exists( 'wc_get_gallery_image_html' ) ) {
	return;
}
global $product;
$attachment_ids = $product->get_gallery_image_ids();
$options = get_option( 'kaveh_frame' );
$kaveh_pr_metas = get_post_meta( $product->get_id(), 'single_product_options', true );

if($options['kaveh_pr_single_select']=='value-1'):
?>

<!-- Start Gallery Image Items -->
<div class="swiper gallery-image-items overflow-hidden" data-swiper='{"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"0":{"slidesPerView":3,"spaceBetween":10},"768":{"slidesPerView":3,"spaceBetween":20}}}'>
    <div class="swiper-wrapper">
   
<?php
if ( $attachment_ids && $product->get_image_id() ) {
	foreach ( $attachment_ids as $attachment_id ) {
		?>

		  <div class="swiper-slide">
        <div class="gallery-image-item" data-bs-toggle="modal" data-bs-target="#modal-gallery">
          <img src="<?php echo wp_get_attachment_url( $attachment_id ); ?>" alt="product" />
        </div>
      </div>
		<?php
	}
}

?>
 <div class="swiper-slide">
          <div class="gallery-image-item" data-bs-toggle="modal" data-bs-target="#modal-gallery">
          <?php
                    $thumbnail_id = $product->get_image_id(); // Get the attachment ID of the product thumbnail
                    $thumbnail_url = wp_get_attachment_url($thumbnail_id);
                    ?>
            <img src="<?php echo $thumbnail_url; ?>" alt="product" />
          </div>
    </div>

    </div>
    <div class="swiper-button-next"></div>
    <div class="swiper-button-prev"></div>
  </div>
  <!-- End Gallery Image Items -->


<?php elseif($options['kaveh_pr_single_select']=='value-2'): ?>


<?php elseif($options['kaveh_pr_single_select']=='value-3'): ?>



<?php elseif($options['kaveh_pr_single_select']=='value-4'): ?>    
  
  <?php
// Note: `wc_get_gallery_image_html` was added in WC 3.3.2 and did not exist prior. This check protects against theme overrides being used on older versions of WC.
if ( ! function_exists( 'wc_get_gallery_image_html' ) ) {
  return;
}

$attachment_ids = $product->get_gallery_image_ids();
if ( $attachment_ids && $product->get_image_id() ) {
  ?>
  <div class="detail-product-four-gallery-items position-relative d-none d-lg-flex justify-content-between gap-2">
      <?php 
      if (isset($kaveh_pr_metas['ksingle_options_off']) && $kaveh_pr_metas['ksingle_options_off'] === '0') {
          $kvideo_show = $kaveh_pr_metas['kvideo_show'];
      } else {
          $kvideo_show = $options['kvideo_show'];
      }
      ?>
      <?php if(!empty($kvideo_show)): ?>
      <?php if($kvideo_show === '1'): ?>
      <div class="item bg-white kvideo" data-bs-toggle="modal" data-bs-target="#modal-gallery">
        <i class="isax isax-play"></i>
      </div>
      <?php endif; ?>
      <?php endif; ?>

  <?php
  $i = 0;
  $count = count($attachment_ids);
  foreach ( $attachment_ids as $attachment_id ) {
    if($i < 4):
      ?>
      <div class="item bg-white <?php if(($count >= 3 && $i === 3) || ($count-1 === $i)){ echo 'has-items position-relative'; } ?>" data-bs-toggle="modal" data-bs-target="#modal-gallery">
        <?php echo wp_get_attachment_image( $attachment_id, 'woocommerce_thumbnail', false, array( 'width' => 37, 'height' => 33 ) ); ?>
      </div>
      <?php
    $i++;
    endif;
  }
  ?>
  </div>
  <?php
}
?>


<?php endif; ?>	