<?php
/**
 * Single Product Image
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-image.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.0.0
 */

defined( 'ABSPATH' ) || exit;

// Note: `wc_get_gallery_image_html` was added in WC 3.3.2 and did not exist prior. This check protects against theme overrides being used on older versions of WC.
if ( ! function_exists( 'wc_get_gallery_image_html' ) ) {
	return;
}

global $product;
$currentURL = 'http';
if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') {
    $currentURL .= 's';
}
$currentURL .= "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";
$kaveh_pr_metas = get_post_meta( $product->get_id(), 'single_product_options', true );
$sale_price = $product->get_sale_price();
$product_id = $product->get_id();
$product_title = get_the_title($product_id);
$rating_count = $product->get_rating_count();
$review_count = $product->get_review_count();
$average      = $product->get_average_rating();
$columns           = apply_filters( 'woocommerce_product_thumbnails_columns', 4 );
$post_thumbnail_id = $product->get_image_id();
$wrapper_classes   = apply_filters(
	'woocommerce_single_product_image_gallery_classes',
	array(
		'woocommerce-product-gallery',
		'woocommerce-product-gallery--' . ( $post_thumbnail_id ? 'with-images' : 'without-images' ),
		'woocommerce-product-gallery--columns-' . absint( $columns ),
		'images',
	)
);


$options = get_option( 'kaveh_frame' );
if($options['kaveh_pr_single_select']=='value-1'):
?>  
	
	<div class="gallery-image position-relative">
      <!-- Start Gallery Image Origin -->
      <div class="gallery-image-origin d-flex align-items-center justify-content-center">
      <?php $image = wp_get_attachment_image_src( get_post_thumbnail_id( $product_id ), 'single-post-thumbnail' );?>
      <div class="<?php echo esc_attr( implode( ' ', array_map( 'sanitize_html_class', $wrapper_classes ) ) ); ?>" data-columns="<?php echo esc_attr( $columns ); ?>" style="opacity: 0; transition: opacity .25s ease-in-out;">
      <div class="woocommerce-product-gallery__wrapper">
    <?php
    if ( $post_thumbnail_id ) {
      $html = wc_get_gallery_image_html( $post_thumbnail_id, true );
    } else {
      $html  = '<div class="woocommerce-product-gallery__image--placeholder">';
      $html .= sprintf( '<img src="%s" alt="%s" class="wp-post-image" />', esc_url( wc_placeholder_img_src( 'woocommerce_single' ) ), esc_html__( 'Awaiting product image', 'woocommerce' ) );
      $html .= '</div>';
    }

    echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', $html, $post_thumbnail_id );
    ?>
        </div>
    </div>
	</div> 
	<!-- End Gallery Image Origin -->
  

		<?php do_action( 'woocommerce_product_thumbnails' ); ?>

               <?php if(!empty($sale_price) ) { ?>
	              <!-- Start Offer -->
	              <div class="detail-product-offer">
                <?php
                $percentage = round( ( ( $product->get_regular_price() - $product->get_sale_price() ) / $product->get_regular_price() ) * 100 );
                echo $percentage . "%";
                ?>
                </div>
                <!-- End Offer -->
                <?php } ?>

                <!-- Start Icons -->
                <ul class="detail-product-icons">
                   <li data-bs-toggle="tooltip" title="مقایسه" data-bs-placement="left">
                  <?php
                    if ( is_plugin_active( 'woo-smart-compare/wpc-smart-compare.php' ) ) {
                      echo do_shortcode( '[woosc id="".<?php echo get_the_ID(); ?>.""]' ); 
                    } else {
                        
                    }
                    ?>
                  </li>
                  <li data-bs-toggle="tooltip" title="اشتراک گذاری" data-bs-placement="left">
                    <i class="isax isax-share5" data-bs-toggle="modal" data-bs-target="#exampleModal"></i>
                  </li>
                  <li data-bs-toggle="tooltip" title="افزودن به موردعلاقه" data-bs-placement="left">
                  <?php
                  if ( is_plugin_active( 'woo-smart-wishlist/wpc-smart-wishlist.php' ) ) { ?>
                    <?php echo do_shortcode( '[woosw id="".<?php echo get_the_ID(); ?>.""]' ); ?>
                  <?php
                  } else {
                      
                  }
                  ?>
                  </li>
                </ul>
              <!-- End Icons -->

  </div>
      
    <div class="butboxed mt-3">
        <?php 
        if (isset($kaveh_pr_metas['ksingle_options_off']) && $kaveh_pr_metas['ksingle_options_off'] === '0') {
            $kticketsthumnail_single = $kaveh_pr_metas['kticketsthumnail_single'];
        } else {
            $kticketsthumnail_single = $options['kticketsthumnail_single'];
        }
        ?>
        <?php if(!empty($kticketsthumnail_single)):
          $kaveh_pr_ktickets = $kticketsthumnail_single;
          foreach($kaveh_pr_ktickets as $kaveh_pr_kticket): ?>
            <a href="<?php echo $kaveh_pr_kticket['kticketsthumnail_single_link']; ?>">
            <button class="butboxqr qwe" style="background-color:<?php echo $kaveh_pr_kticket['kticketsthumnail_single_color1']; ?>">
              <img style="background-color:<?php echo $kaveh_pr_kticket['kticketsthumnail_single_color2']; ?>" src="<?php echo $kaveh_pr_kticket['kticketsthumnail_single_image']; ?>" alt="<?php echo $kaveh_pr_kticket['kticketsthumnail_single_text1']; ?>">
              <p class="d-inline" style="<?php echo $kaveh_pr_kticket['kticketsthumnail_single_color3']; ?>"><?php echo $kaveh_pr_kticket['kticketsthumnail_single_text1']; ?></p>
            </button>
            </a>
          <?php endforeach; ?>
          <?php endif; ?>
    </div>



<?php elseif($options['kaveh_pr_single_select']=='value-2'): ?>
        <?php $image = wp_get_attachment_image_src( get_post_thumbnail_id( $product_id ), 'single-post-thumbnail' ); ?>
        <?php $attachment_ids = $product->get_gallery_image_ids(); ?>
          <div class="gallery position-relative">
            <div class="origin-image position-relative">
            <?php $image = wp_get_attachment_image_src( get_post_thumbnail_id( $product_id ), 'single-post-thumbnail' );?>
              <div class="<?php echo esc_attr( implode( ' ', array_map( 'sanitize_html_class', $wrapper_classes ) ) ); ?>" data-columns="<?php echo esc_attr( $columns ); ?>" style="opacity: 0; transition: opacity .25s ease-in-out;">
              <div class="woocommerce-product-gallery__wrapper">
            <?php
            if ( $post_thumbnail_id ) {
              $html = wc_get_gallery_image_html( $post_thumbnail_id, true );
            } else {
              $html  = '<div class="woocommerce-product-gallery__image--placeholder">';
              $html .= sprintf( '<img src="%s" alt="%s" class="wp-post-image" />', esc_url( wc_placeholder_img_src( 'woocommerce_single' ) ), esc_html__( 'Awaiting product image', 'woocommerce' ) );
              $html .= '</div>';
            }

            echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', $html, $post_thumbnail_id );
            ?>
                </div>
            </div>
              <button type="button" class="zoom"  data-bs-toggle="modal" data-bs-target="#modal-gallery">
                <i class="icon-arrow-zoom"></i>
              </button>
            </div>
            <div class="swiper swiper-gallery-product-two overflow-hidden" data-swiper='{"slidesPerView":3,"spaceBetween":0}'>
              <div class="swiper-wrapper">
              <?php
              if ( $attachment_ids && $product->get_image_id() ) {
                foreach ( $attachment_ids as $attachment_id ) {
                  ?>
              
                <div class="swiper-slide">
                  <div class="gallery-product-two-item d-flex align-items-center h-100"  data-bs-toggle="modal" data-bs-target="#modal-gallery">
                    <img src="<?php echo wp_get_attachment_url( $attachment_id ); ?>" alt="product" class="mx-auto w-100" data-gallery="origin-image" />
                  </div>
                </div>
                <?php
                  }
                }
                ?>
                <div class="swiper-slide">
                  <div class="gallery-product-two-item d-flex align-items-center h-100"  data-bs-toggle="modal" data-bs-target="#modal-gallery">
                  <?php
                    $thumbnail_id = $product->get_image_id(); // Get the attachment ID of the product thumbnail
                    $thumbnail_url = wp_get_attachment_url($thumbnail_id);
                  ?>
                    <img src="<?php echo $thumbnail_url; ?>" alt="product" class="mx-auto w-100" data-gallery="origin-image" />
                  </div>
                </div>
                
              </div>
          </div>
           
        

            <ul class="icons">
           <li>
                  <a href="javascript:void(0)">
                    <?php
              if ( is_plugin_active( 'woo-smart-compare/wpc-smart-compare.php' ) ) {
                echo do_shortcode( '[woosc id="".<?php echo get_the_ID(); ?>.""]' ); 
              } else {
                  
              }
              ?>
                  </a>
                </li>
                <li>
                  <a href="javascript:void(0)">
                    <i class="isax isax-share5" data-bs-toggle="modal" data-bs-target="#exampleModal"></i>
                  </a>
                </li>
                <li>
                  <a href="javascript:void(0)">
                            <?php
      if ( is_plugin_active( 'woo-smart-wishlist/wpc-smart-wishlist.php' ) ) { ?>
        <?php echo do_shortcode( '[woosw id="".<?php echo get_the_ID(); ?>.""]' ); ?>
      <?php
      } else {
          
      }
      ?>
                  </a>
                </li>
            </ul>

 
            <div class="rate">
              <i class="icon-star d-block"></i>
              <?php echo $average; ?>
            </div>
            <?php if(!empty($sale_price) ) { ?>
            <div class="offer">
            <?php
                $percentage = round( ( ( $product->get_regular_price() - $product->get_sale_price() ) / $product->get_regular_price() ) * 100 );
                echo $percentage . "%";
                ?>
              <span class="fw-light d-block"> تخفیف </span>
            </div>
            <?php } ?>
          </div>


<?php elseif($options['kaveh_pr_single_select']=='value-3'): ?>

  <?php $image = wp_get_attachment_image_src( get_post_thumbnail_id( $product_id ), 'single-post-thumbnail' ); ?>
        <?php $attachment_ids = $product->get_gallery_image_ids(); ?>
          

        <div class="gallery">
          <div class="gallery-origin">
            <?php
			  global $product;

$columns           = apply_filters( 'woocommerce_product_thumbnails_columns', 4 );
$post_thumbnail_id = $product->get_image_id();
$wrapper_classes   = apply_filters(
	'woocommerce_single_product_image_gallery_classes',
	array(
		'woocommerce-product-gallery',
		'woocommerce-product-gallery--' . ( $post_thumbnail_id ? 'with-images' : 'without-images' ),
		'woocommerce-product-gallery--columns-' . absint( $columns ),
		'images',
	)
);
?>
<div class="<?php echo esc_attr( implode( ' ', array_map( 'sanitize_html_class', $wrapper_classes ) ) ); ?>" data-columns="<?php echo esc_attr( $columns ); ?>" style="opacity: 0; transition: opacity .25s ease-in-out;">
	<div class="woocommerce-product-gallery__wrapper">
		<?php
		if ( $post_thumbnail_id ) {
			$html = wc_get_gallery_image_html( $post_thumbnail_id, true );
		} else {
			$html  = '<div class="woocommerce-product-gallery__image--placeholder">';
			$html .= sprintf( '<img src="%s" alt="product" id="gallery-origin" />', esc_url( wc_placeholder_img_src( 'woocommerce_single' ) ), esc_html__( 'Awaiting product image', 'woocommerce' ) );
			$html .= '</div>';
		}

		echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', $html, $post_thumbnail_id ); // phpcs:disable WordPress.XSS.EscapeOutput.OutputNotEscaped

		do_action( 'woocommerce_product_thumbnails' );
		?>
	</div>
</div>
            <button type="button" class="zoom"  data-bs-toggle="modal" data-bs-target="#modal-gallery">
              <i class="icon-arrow-zoom"></i>
            </button>
          </div>
          <div class="swiper swiper-gallery-product-three overflow-hidden w-100 mx-auto" data-swiper='{"breakpoints":{"320":{"slidesPerView":3,"spaceBetween":0},"576":{"slidesPerView":4,"spaceBetween":0}}}'>
            <div class="swiper-wrapper">
              <?php
              if ( $attachment_ids && $product->get_image_id() ) {
                foreach ( $attachment_ids as $attachment_id ) {
                  ?>
                <div class="swiper-slide">
                  <div class="gallery-product-three-item d-flex align-items-center justify-content-center"  data-bs-toggle="modal" data-bs-target="#modal-gallery">
                    <img src="<?php echo wp_get_attachment_url( $attachment_id ); ?>" alt="product" data-gallery="gallery-origin" />
                  </div>
                </div>
                <?php
                  }
                }
                ?>
                  <div class="swiper-slide">
                  <?php
                    $thumbnail_id = $product->get_image_id(); // Get the attachment ID of the product thumbnail
                    $thumbnail_url = wp_get_attachment_url($thumbnail_id);
                  ?>
                  <div class="gallery-product-three-item d-flex align-items-center justify-content-center"  data-bs-toggle="modal" data-bs-target="#modal-gallery">
                    <img src="<?php echo $thumbnail_url; ?>" alt="product" data-gallery="gallery-origin" />
                  </div>
                </div>
            </div>
          </div>
      
        </div>




<?php elseif($options['kaveh_pr_single_select']=='value-4'):        

// Note: `wc_get_gallery_image_html` was added in WC 3.3.2 and did not exist prior. This check protects against theme overrides being used on older versions of WC.
if ( ! function_exists( 'wc_get_gallery_image_html' ) ) {
	return;
}

global $product;
$thumnail_ids = $product->get_gallery_image_ids();
$columns           = apply_filters( 'woocommerce_product_thumbnails_columns', 4 );
$post_thumbnail_id = $product->get_image_id();
$wrapper_classes   = apply_filters(
	'woocommerce_single_product_image_gallery_classes',
	array(
		'woocommerce-product-gallery',
		'woocommerce-product-gallery--' . ( $post_thumbnail_id ? 'with-images' : 'without-images' ),
		'woocommerce-product-gallery--columns-' . absint( $columns ),
		'images',
	)
);
?>
<div class="detail-product-four-gallery-origin position-relative">
  <div class="icons-detail-product position-absolute d-none d-lg-block">
    <button type="button"
      class="d-flex align-items-center justify-content-center rounded-circle text-white mx-auto mb-2"
      aria-label="show icons"> .... </button>
    <ul class="d-flex flex-column align-items-center gap-4">
      <li class="text-white">
      <?php
        if ( is_plugin_active( 'woo-smart-wishlist/wpc-smart-wishlist.php' ) ) { ?>
          <?php echo do_shortcode( '[woosw id="".<?php echo get_the_ID(); ?>.""]' ); ?>
        <?php
        } else {
            
        }
        ?>
      </li>
      <li class="text-white">
        <i class="isax isax-share5" data-bs-toggle="modal" data-bs-target="#exampleModal"></i>
      </li>
      <li class="text-white">
      <?php
      if ( is_plugin_active( 'woo-smart-compare/wpc-smart-compare.php' ) ) {
        echo do_shortcode( '[woosc id="".<?php echo get_the_ID(); ?>.""]' ); 
      } else {
          
      }
      ?>
      </li>
    </ul>
  </div>

    <div class="<?php echo esc_attr( implode( ' ', array_map( 'sanitize_html_class', $wrapper_classes ) ) ); ?>" data-columns="<?php echo esc_attr( $columns ); ?>" style="opacity: 0; transition: opacity .25s ease-in-out;">

      <!-- Start Carousel -->
      <div class="swiper swiper-detail-product-four-gallery">
        <div class="swiper-wrapper">

        <div class="woocommerce-product-gallery__wrapper swiper-slide h-auto">
          <?php
          if ( $post_thumbnail_id ) {
            $html = wc_get_gallery_image_html( $post_thumbnail_id, true );
          } else {
            $html  = '<div class="woocommerce-product-gallery__image--placeholder" id="img-container">';
            $html .= sprintf( '<img width="451" height="474" src="%s" alt="%s" class="wp-post-image w-100 d-block h-100 detail4-img" />', esc_url( wc_placeholder_img_src( 'woocommerce_single' ) ), esc_html__( 'Awaiting product image', 'woocommerce' ) );
            $html .= '</div>';
          }
          echo apply_filters( 'woocommerce_single_product_image_thumbnail_html', $html, $post_thumbnail_id ); // phpcs:disable WordPress.XSS.EscapeOutput.OutputNotEscaped
          do_action( 'woocommerce_product_thumbnails' );
          ?>
        </div>

        <?php if(wp_is_mobile()): ?>
          <?php foreach($thumnail_ids as $id): ?>
            <!-- Start Slide -->
            <div class="swiper-slide h-auto">
              <div id="img-container">
                <img src="<?php echo wp_get_attachment_url($id); ?>" alt="product" width="451" height="474"
                  class="w-100 d-block h-100 detail4-img">
              </div>
            </div>
            <!-- End Slide -->
          <?php endforeach; ?>
        <?php endif; ?>
      
        </div>
        <!-- Start Button -->
        <div class="swiper-button-next d-flex d-lg-none align-items-center justify-content-center rounded-pill end-0">
        </div>
        <div class="swiper-button-prev d-flex d-lg-none align-items-center justify-content-center rounded-pill start-0">
        </div>
        <!-- End Button -->
        <div class="swiper-pagination gall4"></div>
      </div>

      <!-- End Carousel -->
    </div>
  
</div>

<?php endif; ?>	 