<?php
/**
 * Product attributes
 *
 * Used by list_attributes() in the products class.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/single-product/product-attributes.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.3.0
 */

defined( 'ABSPATH' ) || exit;

if ( ! $product_attributes ) {
	return;
}
$options = get_option( 'kaveh_frame' );
?>

<?php if($options['kaveh_pr_single_select']=='value-1'): ?>

 	<div id="specifications">
	 <ul>
	<?php foreach ( $product_attributes as $product_attribute_key => $product_attribute ) : ?>		
				<li class="d-flex align-items-center flex-wrap position-relative">
				<span> <?php echo $product_attribute['label'] ?></span>
				<span> <?php echo $product_attribute['value'] ?></span>
				</li>
	<?php endforeach; ?>
	</ul>
	</div>
	<?php elseif($options['kaveh_pr_single_select']=='value-2'): ?>
		
		<div id="specifications" class="tab-pane show fade active">
          <ul>
          <?php foreach ( $product_attributes as $product_attribute_key => $product_attribute ) : ?>		
				<li class="d-flex align-items-center flex-wrap position-relative">
				<span> <?php echo $product_attribute['label'] ?></span>
				<span> <?php echo $product_attribute['value'] ?></span>
				</li>
	<?php endforeach; ?>
          </ul>
        </div>

	<?php elseif($options['kaveh_pr_single_select']=='value-3'): ?>

    <div id="specifications">
      <h4 class="section-titr"> </h4>
      <ul>
      <?php foreach ( $product_attributes as $product_attribute_key => $product_attribute ) : ?>		
				<li class="d-flex align-items-center flex-wrap position-relative">
				<span> <?php echo $product_attribute['label'] ?></span>
				<span> <?php echo $product_attribute['value'] ?></span>
				</li>
	<?php endforeach; ?>
      </ul>
    </div>

<?php elseif($options['kaveh_pr_single_select']=='value-4'): ?>
        <!-- Start Tab Content -->
        <div id="info" class="">
          <ul>
			<?php $i = 0; ?>
		  	<?php foreach ( $product_attributes as $product_attribute_key => $product_attribute ) : ?>	
			<?php if($i<4): ?>
            <li class="d-flex position-relative">
              <span class="fw-normal w-100 align-self-center"><?php echo $product_attribute['label'] ?></span>
              <span class="fw-bold w-100 plainfo"><?php echo $product_attribute['value'] ?></span>
            </li>
			<?php endif; ?>
			<?php $i++; ?>
			<?php endforeach; ?>
          </ul>
          <button type="button" class="btn d-flex align-items-center justify-content-center w-100"
            aria-label="view-more" data-bs-toggle="modal" data-bs-target="#modal-info-product"> مشاهده بیشتر </button>
        </div>
        <!-- End Tab Content -->


		<!-- Start Modal Info -->
		<div id="modal-info-product" class="modal modal-info-product fade">
		<div class="modal-dialog modal-dialog-centered">
			<div class="modal-content">
			<div class="modal-header d-flex align-items-center justify-content-between">
				<h2 class="modal-title fw-normal mb-0">  مشخصات </h2>
				<button type="button" data-bs-dismiss="modal" aria-label="close">
				<i class="icon icon-close fs-5"></i>
				</button>
			</div>
			<div class="modal-body">
				<ul>
				<?php foreach ( $product_attributes as $product_attribute_key => $product_attribute ) : ?>	
				<li class="d-flex align-items-center position-relative">
					<span class="fw-normal w-100"><?php echo $product_attribute['label'] ?></span>
					<span class="fw-bold w-100 plainfo"><?php echo $product_attribute['value'] ?></span>
				</li>
				<?php endforeach; ?>

				</ul>
			</div>
			</div>
		</div>
		</div>
		<!-- End Modal Info -->

<?php endif; ?>


