<?php
/**
 * The template for displaying product content in the single-product.php template
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-single-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 */

defined( 'ABSPATH' ) || exit;
global $product;
global $post;
$short_description = apply_filters( 'woocommerce_short_description', $post->post_excerpt );
$options = get_option( 'kaveh_frame' );
$kaveh_pr_metas = get_post_meta( $product->get_id(), 'single_product_options', true );

if($options['kaveh_pr_single_select']=='value-1'):
/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked woocommerce_output_all_notices - 10
 */
do_action( 'woocommerce_before_single_product' );

if ( post_password_required() ) {
	echo get_the_password_form(); // WPCS: XSS ok.
	return;
}
?>
       <!-- Start Info Product -->
	   <div class="detail-product-info">
<div id="product-<?php the_ID(); ?>" <?php wc_product_class( 'insingle_pr', $product ); ?>>
          <div class="row align-items-start">
<!-- Start Gallery Image -->
<div class="col-lg-5 mb-auto">
	<?php
	/**
	 * Hook: woocommerce_before_single_product_summary.
	 *
	 * @hooked woocommerce_show_product_sale_flash - 10
	 * @hooked woocommerce_show_product_images - 20
	 */
	do_action( 'woocommerce_before_single_product_summary' );
	?>
</div>
<!-- End Gallery Image -->
<?php do_action('kaveh_single_modal_gallery'); ?>
<!-- Start Detail -->
<div class="col-lg-7 pt-3">
<div class="detail">
	<div class="summary entry-summary <?php if( $product->is_type( 'simple' ) ){ echo 'detsimple'; } ?>">
		<?php
	
		  woocommerce_template_single_title();
		  woocommerce_template_single_rating();
		  woocommerce_template_single_price();
		  woocommerce_template_single_meta();


		?>
	</div>
	</div>
	</div>
<!-- End Detail -->
<style>
	.woocommerce #content div.product div.summary, .woocommerce div.product div.summary, .woocommerce-page #content div.product div.summary, .woocommerce-page div.product div.summary {
      float: unset;
      width: unset;
      clear: none;
  }

</style>
	<?php if($options['pro-pic-repeater-show'] === '1'): ?>
	<div class="options-box">
      <div class="container">
        <ul class="d-flex align-items-center justify-content-between flex-wrap">
		<?php
			if(!empty($options['pro-pic-repeater'])):
			$productfebox = $options['pro-pic-repeater'];
            for ($i = 0; $i < count($productfebox); $i++) {
                ?>
             	<li>
					<i class="<?php echo $productfebox[$i]['pro-pic-icon']; ?>"></i>
					<span> <?php echo $productfebox[$i]['pro-pic-text']; ?> </span>
				</li>
                <?php
            }
			endif;
            ?>
        </ul>
      </div>
    </div>
	<?php endif; ?>

	<?php
	/**
	 * Hook: woocommerce_after_single_product_summary.
	 *
	 * @hooked woocommerce_output_product_data_tabs - 10
	 * @hooked woocommerce_upsell_display - 15
	 * @hooked woocommerce_output_related_products - 20
	 */
	do_action( 'woocommerce_after_single_product_summary' );
	?>
	 


<?php do_action( 'woocommerce_after_single_product' ); ?>
</div>
</div>
		</div>
<?php elseif($options['kaveh_pr_single_select']=='value-2'): ?>
<?php
/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked woocommerce_output_all_notices - 10
 */
do_action( 'woocommerce_before_single_product' );

if ( post_password_required() ) {
	echo get_the_password_form(); // WPCS: XSS ok.
	return;
}
?>
<style>
	.product .status {
    background-color: unset;
    color: unset;
    width: unset;
}
.detail-product-two .gallery .images {
    border: unset;
}
	.woocommerce #content div.product div.summary, .woocommerce div.product div.summary, .woocommerce-page #content div.product div.summary, .woocommerce-page div.product div.summary {
    float: unset;
    width: unset;
    clear: none;
}
.detail-product-two .product {
    background-color: unset;
    -webkit-box-shadow: unset;
    -moz-box-shadow: unset;
    box-shadow: unset;
	-webkit-border-radius: unset;
    -moz-border-radius: unset;
    border-radius: unset;
	
}
.woocommerce .detail-product-two div.product form.cart {
    margin-bottom: 0;
}
.woocommerce div.product div.images img {
    display: block;
    width: 75%;
    height: auto;
    box-shadow: none;
}
.woocommerce #content div.product div.images, .woocommerce div.product div.images, .woocommerce-page #content div.product div.images, .woocommerce-page div.product div.images {
    float: unset;
    width: 100%;
}
</style>

<div id="product-<?php the_ID(); ?>" <?php wc_product_class( 'insingle_pr', $product ); ?>>
<?php do_action('kaveh_single_modal_gallery'); ?>
	<div class="row">
        <div class="col-lg-5">
		<?php
			/**
			 * Hook: woocommerce_before_single_product_summary.
			 *
			 * @hooked woocommerce_show_product_sale_flash - 10
			 * @hooked woocommerce_show_product_images - 20
			 */
			do_action( 'woocommerce_before_single_product_summary' );
			?>
        </div>
        <div class="col-lg-7 detail-product-two-left">
		<?php
				
				 woocommerce_template_single_title();
				 woocommerce_template_single_rating();
				 woocommerce_template_single_price();
				 woocommerce_template_single_meta();
				 woocommerce_template_single_sharing();
				
				?>
          
         
        
        </div>
      </div>
    </div>
	<?php if($options['pro-pic-repeater-show'] === '1'): ?>
    <div class="options-box">
      <div class="container">
        <ul class="d-flex align-items-center justify-content-between flex-wrap">
		<?php
			if(!empty($options['pro-pic-repeater'])):
			$productfebox = $options['pro-pic-repeater'];
            for ($i = 0; $i < count($productfebox); $i++) {
                ?>
             	<li>
					<i class="<?php echo $productfebox[$i]['pro-pic-icon']; ?>"></i>
					<span> <?php echo $productfebox[$i]['pro-pic-text']; ?> </span>
				</li>
                <?php
            }
			endif;
            ?>
	      
    
        </ul>
      </div>
    </div>
	<?php endif; ?>


<?php
	/**
	 * Hook: woocommerce_after_single_product_summary.
	 *
	 * @hooked woocommerce_output_product_data_tabs - 10
	 * @hooked woocommerce_upsell_display - 15
	 * @hooked woocommerce_output_related_products - 20
	 */
	do_action( 'woocommerce_after_single_product_summary' );
	?>
        </div>



<?php do_action( 'woocommerce_after_single_product' ); ?>


<?php elseif($options['kaveh_pr_single_select']=='value-3'): ?>
<?php
/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked woocommerce_output_all_notices - 10
 */
do_action( 'woocommerce_before_single_product' );

if ( post_password_required() ) {
	echo get_the_password_form(); // WPCS: XSS ok.
	return;
}
?>
<style>
	.woocommerce #content div.product div.images, .woocommerce div.product div.images, .woocommerce-page #content div.product div.images, .woocommerce-page div.product div.images {
  float: unset !important;
  width: unset !important;
}
.detail-product-three .status {
  background-color: #fff !important;
  width: unset !important;
}
</style>
<div id="product-<?php the_ID(); ?>" <?php wc_product_class( 'insingle_pr', $product ); ?>>
<?php do_action('kaveh_single_modal_gallery'); ?>
	<div class="row">
		
		<div class="col-lg-4 col-xl-3 order-2 order-lg-1">
				<?php
				/**
				 * Hook: woocommerce_single_product_summary.
				 *
				 * @hooked woocommerce_template_single_title - 5
				 * @hooked woocommerce_template_single_rating - 10
				 * @hooked woocommerce_template_single_price - 10
				 * @hooked woocommerce_template_single_excerpt - 20
				 * @hooked woocommerce_template_single_add_to_cart - 30
				 * @hooked woocommerce_template_single_meta - 40
				 * @hooked woocommerce_template_single_sharing - 50
				 * @hooked WC_Structured_Data::generate_product_data() - 60
				 */
				woocommerce_template_single_title();
				?>
		</div>

		<div class="col-lg-5 col-xl-6 order-1 order-lg-2">
			
			<?php
			/**
			 * Hook: woocommerce_before_single_product_summary.
			 *
			 * @hooked woocommerce_show_product_sale_flash - 10
			 * @hooked woocommerce_show_product_images - 20
			 */
			do_action( 'woocommerce_before_single_product_summary' );
			?>

		</div>

		<div class="col-lg-3 order-3 order-lg-3">
		<?php require_once( KAVEH_TEMPLATE_PATH . '/woocommerce/single-product/col3.php'); ?>
			
		</div>


	</div>
		<?php if($options['pro-pic-repeater-show'] === '1'): ?>
		<div class="options-box">
          <ul class="d-flex align-items-center justify-content-between flex-wrap">
        	 <?php
			if(!empty($options['pro-pic-repeater'])):
			$productfebox = $options['pro-pic-repeater'];
            for ($i = 0; $i < count($productfebox); $i++) {
                ?>
             	<li>
					<i class="<?php echo $productfebox[$i]['pro-pic-icon']; ?>"></i>
					<span> <?php echo $productfebox[$i]['pro-pic-text']; ?> </span>
				</li>
                <?php
            }
			endif;
            ?>
          </ul>
        </div>
		<?php endif; ?>
        </div>

	<?php
	/**
	 * Hook: woocommerce_after_single_product_summary.
	 *
	 * @hooked woocommerce_output_product_data_tabs - 10
	 * @hooked woocommerce_upsell_display - 15
	 * @hooked woocommerce_output_related_products - 20
	 */
	do_action( 'woocommerce_after_single_product_summary' );
	?>

<?php do_action( 'woocommerce_after_single_product' ); ?>


<?php elseif($options['kaveh_pr_single_select']=='value-4'):

$stocka = $product->get_stock_status();

/**
 * Hook: woocommerce_before_single_product.
 *
 * @hooked woocommerce_output_all_notices - 10
 */
do_action( 'woocommerce_before_single_product' );

if ( post_password_required() ) {
  echo get_the_password_form(); // WPCS: XSS ok.
  return;
}
?>
<div id="product-<?php the_ID(); ?>" <?php wc_product_class( 'insingle_pr', $product ); ?>>
  
    <?php do_action('mobile_header'); ?>


    <!-- Start Detail Product -->
    <section class="detail-product-four">
      <div class="container">

        <!-- Start Timear Mobile -->
        <div class="timear-proposal d-flex d-lg-none align-items-center justify-content-between">
          <div>
            <?php if ($product->is_type('variable') && $product->is_on_sale()): ?>
            <div class="proposal">
              پیشنهاد شگفت انگیز!
            </div>
            <?php elseif ($product->is_on_sale()): ?>
              <div class="proposal">
              پیشنهاد شگفت انگیز!
            </div>
            <?php endif; ?>
       
          </div>
          <?php if ($product->is_type('variable') && $product->is_on_sale()): ?>
              <?php foreach ($product->get_children() as $variation_id): ?>
                <?php $variation = wc_get_product($variation_id); ?>
                  <?php if ($variation->is_on_sale() && $variation->get_date_on_sale_to()): ?>
                    <ul class="timear-detail-product d-flex align-items-center gap-1" data-time="<?php echo $variation->get_date_on_sale_to(); ?>">
            <li class="fw-normal text-center bg-white d-flex align-items-center justify-content-center flex-column">
              <span class="second fw-bold"> 00 </span>
              ثانیه
            </li>:
            <li class="fw-normal text-center bg-white d-flex align-items-center justify-content-center flex-column">
              <span class="minute fw-bold"> 00 </span>
              دقیقه
            </li>:
            <li class="fw-normal text-center bg-white d-flex align-items-center justify-content-center flex-column">
              <span class="hour fw-bold"> 00 </span>
              ساعت
            </li>:
            <li class="fw-normal text-center bg-white d-flex align-items-center justify-content-center flex-column">
              <span class="day fw-bold"> 00 </span>
              روز
            </li>
          </ul>
                  <?php endif; ?>
              <?php endforeach; ?>
          <?php elseif ($product->is_on_sale() && $product->get_date_on_sale_to() ): ?>
            <ul class="timear-detail-product d-flex align-items-center gap-1" data-time="<?php echo $product->get_date_on_sale_to(); ?>">
            <li class="fw-normal text-center bg-white d-flex align-items-center justify-content-center flex-column">
              <span class="second fw-bold"> 00 </span>
              ثانیه
            </li>:
            <li class="fw-normal text-center bg-white d-flex align-items-center justify-content-center flex-column">
              <span class="minute fw-bold"> 00 </span>
              دقیقه
            </li>:
            <li class="fw-normal text-center bg-white d-flex align-items-center justify-content-center flex-column">
              <span class="hour fw-bold"> 00 </span>
              ساعت
            </li>:
            <li class="fw-normal text-center bg-white d-flex align-items-center justify-content-center flex-column">
              <span class="day fw-bold"> 00 </span>
              روز
            </li>
          </ul>
          <?php endif; ?>


        </div>
        <!-- End Timear Mobile -->

        <div class="row">
          <div class="col-lg-4 order-1 order-md-1">
              <!-- Start Gallery -->
              <div class="detail-product-four-gallery">
                <?php
                /**
                 * Hook: woocommerce_before_single_product_summary.
                 *
                 * @hooked woocommerce_show_product_sale_flash - 10
                 * @hooked woocommerce_show_product_images - 20
                 */
                do_action( 'woocommerce_before_single_product_summary' );
                ?>
              </div>
              <!-- End Gallery -->
              <div class="butboxed">
                  <?php 
                  if (isset($kaveh_pr_metas['ksingle_options_off']) && $kaveh_pr_metas['ksingle_options_off'] === '0') {
                      $kticketsthumnail_single = $kaveh_pr_metas['kticketsthumnail_single'];
                  } else {
                      $kticketsthumnail_single = $options['kticketsthumnail_single'];
                  }
                  ?>
                  <?php if(!empty($kticketsthumnail_single)):
                    $kaveh_pr_ktickets = $kticketsthumnail_single;
                    foreach($kaveh_pr_ktickets as $kaveh_pr_kticket): ?>
                      <a href="<?php echo $kaveh_pr_kticket['kticketsthumnail_single_link']; ?>">
                      <button class="butboxqr qwe" style="background-color:<?php echo $kaveh_pr_kticket['kticketsthumnail_single_color1']; ?>">
                        <img style="background-color:<?php echo $kaveh_pr_kticket['kticketsthumnail_single_color2']; ?>" src="<?php echo $kaveh_pr_kticket['kticketsthumnail_single_image']; ?>" alt="<?php echo $kaveh_pr_kticket['kticketsthumnail_single_text1']; ?>">
                        <p class="d-inline" style="<?php echo $kaveh_pr_kticket['kticketsthumnail_single_color3']; ?>"><?php echo $kaveh_pr_kticket['kticketsthumnail_single_text1']; ?></p>
                      </button>
                      </a>
                    <?php endforeach; ?>
                    <?php endif; ?>
                    <?php
                    if (isset($kaveh_pr_metas['ksingle_options_off']) && $kaveh_pr_metas['ksingle_options_off'] === '0') {
                      $kcoupon_single = $kaveh_pr_metas['kcoupon_single'];
                    } else {
                      $kcoupon_single = $options['kcoupon_single'];
                    }
                    ?>
                    <?php
                    if (isset($kaveh_pr_metas['ksingle_options_off']) && $kaveh_pr_metas['ksingle_options_off'] === '0') {
                      $kcoupon_single_image = $kaveh_pr_metas['kcoupon_single_image'];
                    } else {
                      $kcoupon_single_image = $options['kcoupon_single_image'];
                    }
                    ?>
                    <?php
                    if (isset($kaveh_pr_metas['ksingle_options_off']) && $kaveh_pr_metas['ksingle_options_off'] === '0') {
                      $kcoupon_single_text = $kaveh_pr_metas['kcoupon_single_text'];
                    } else {
                      $kcoupon_single_text = $options['kcoupon_single_text'];
                    }
                    ?>
                    <?php
                    if (isset($kaveh_pr_metas['ksingle_options_off']) && $kaveh_pr_metas['ksingle_options_off'] === '0') {
                      $kcoupon_single_link = $kaveh_pr_metas['kcoupon_single_link'];
                    } else {
                      $kcoupon_single_link = $options['kcoupon_single_link'];
                    }
                    ?>
                    <?php if (!empty($kcoupon_single)): ?>
                      <?php if ($kcoupon_single === '1'): ?>
                        <a class="mb-4" href="<?php echo $kcoupon_single_link; ?>">
                          <button class="butboxin">
                            <img src="<?php echo $kcoupon_single_image; ?>" alt="<?php echo $kcoupon_single_image; ?>">
                            <p class="d-inline"><?php echo $kcoupon_single_text; ?></p>
                          </button>
                        </a>
                      <?php endif; ?>
                    <?php endif; ?>
              </div>

          </div>
          <div class="col-lg-4 col-xxl-5 order-3 order-md-2">
            <div class="summary entry-summary">
              <?php
              /**
               * Hook: woocommerce_single_product_summary.
               *
               * @hooked woocommerce_template_single_title - 5
               * @hooked woocommerce_template_single_rating - 10
               * @hooked woocommerce_template_single_price - 10
               * @hooked woocommerce_template_single_excerpt - 20
               * @hooked woocommerce_template_single_add_to_cart - 30
               * @hooked woocommerce_template_single_meta - 40
               * @hooked woocommerce_template_single_sharing - 50
               * @hooked WC_Structured_Data::generate_product_data() - 60
               */
              do_action( 'woocommerce_single_product_summary' );
              ?>
              <?php do_action('kaveh_single_title'); ?>

              <div class="mt-4"></div>
              <?php if($short_description): ?>
              <?php if($options['excerptinsingle'] === '1'): ?>
              <div class="detail-product-four-note mt-3 mt-lg-0">
                <?php do_action('kaveh_single_excerpt'); ?>
              </div>
              <?php endif; ?>
              <?php endif; ?>
              <div class="mt-4"></div>
                <div class="d-flex align-items-start justify-content-between">
                <div class="">
                  <?php 
                  if (isset($kaveh_pr_metas['ksingle_options_off']) && $kaveh_pr_metas['ksingle_options_off'] === '0') {
                      $ktickets_single = $kaveh_pr_metas['ktickets_single'];
                  } else {
                      $ktickets_single = $options['ktickets_single'];
                  }
                  ?>
                  <?php if(!empty($ktickets_single)):
                    $kaveh_pr_ktickets = $ktickets_single;
                    foreach($kaveh_pr_ktickets as $kaveh_pr_kticket): ?>
                    <a class="d-block my-2" href="<?php echo $kaveh_pr_kticket['ktickets_single_link'] ?>">
                    <button style="background-color:<?php echo $kaveh_pr_kticket['ktickets_single_color1'] ?>" class="butboxqr d-flex align-items-center justify-content-between">
                      <div class="divqr">
                        <img style="background-color:<?php echo $kaveh_pr_kticket['ktickets_single_color2'] ?>" src="<?php echo $kaveh_pr_kticket['ktickets_single_image'] ?>" alt="<?php echo $kaveh_pr_kticket['ktickets_single_text2'] ?>">
                      </div>
                      <div class="divqr" style="color:<?php echo $kaveh_pr_kticket['ktickets_single_color3'] ?>">
                      <?php echo $kaveh_pr_kticket['ktickets_single_text1'] ?> <span> <?php echo $kaveh_pr_kticket['ktickets_single_text2'] ?> </span>
                      </div>
                    </button>
                    </a>
                    <?php endforeach; ?>
                    <?php endif; ?>
                  </div>
                  <?php 
                  if (isset($kaveh_pr_metas['ksingle_options_off']) && $kaveh_pr_metas['ksingle_options_off'] === '0') {
                      $kvideo_qr_single = $kaveh_pr_metas['kvideo_qr_single'];
                  } else {
                      $kvideo_qr_single = $options['kvideo_qr_single'];
                  }
                  ?>
                  <?php 
                  if (isset($kaveh_pr_metas['ksingle_options_off']) && $kaveh_pr_metas['ksingle_options_off'] === '0') {
                      $kvideo_qr_single_text1 = $kaveh_pr_metas['kvideo_qr_single_text1'];
                  } else {
                      $kvideo_qr_single_text1 = $options['kvideo_qr_single_text1'];
                  }
                  ?>
                  <?php 
                  if (isset($kaveh_pr_metas['ksingle_options_off']) && $kaveh_pr_metas['ksingle_options_off'] === '0') {
                      $kvideo_qr_single_text2 = $kaveh_pr_metas['kvideo_qr_single_text2'];
                  } else {
                      $kvideo_qr_single_text2 = $options['kvideo_qr_single_text2'];
                  }
                  ?>
                  <?php if(!empty($kvideo_qr_single)): ?>
                  <?php if($kvideo_qr_single === '1'): ?>
                    <div class="kqrbox1 d-none d-xl-block">
                        <img class="qrcodesinglekaveh" src="https://qr-code.ir/api/qr-code?e=L&s=4&d=<?php echo $product->get_permalink(); ?>" alt="QR:  <?php echo $product->get_name(); ?>"/>
                        <div class="gro">
                          <h4><?php echo $kvideo_qr_single_text1; ?></h4>
                          <p><?php echo $kvideo_qr_single_text2; ?></p>
                        </div>
                    </div>
                  <?php endif; ?>
                  <?php endif; ?>
                </div>
              <div class="mt-4"></div>
              <?php 
              if (isset($kaveh_pr_metas['ksingle_options_off']) && $kaveh_pr_metas['ksingle_options_off'] === '0') {
                  $kvideo_ersalrygan_single = $kaveh_pr_metas['kvideo_ersalrygan_single'];
              } else {
                  $kvideo_ersalrygan_single = $options['kvideo_ersalrygan_single'];
              }
              ?>
              <?php 
              if (isset($kaveh_pr_metas['ksingle_options_off']) && $kaveh_pr_metas['ksingle_options_off'] === '0') {
                  $kvideo_ersalrygan_single_image = $kaveh_pr_metas['kvideo_ersalrygan_single_image'];
              } else {
                  $kvideo_ersalrygan_single_image = $options['kvideo_ersalrygan_single_image'];
              }
              ?>
              <?php 
              if (isset($kaveh_pr_metas['ksingle_options_off']) && $kaveh_pr_metas['ksingle_options_off'] === '0') {
                  $kvideo_ersalrygan_single_text1 = $kaveh_pr_metas['kvideo_ersalrygan_single_text1'];
              } else {
                  $kvideo_ersalrygan_single_text1 = $options['kvideo_ersalrygan_single_text1'];
              }
              ?>
              <?php 
              if (isset($kaveh_pr_metas['ksingle_options_off']) && $kaveh_pr_metas['ksingle_options_off'] === '0') {
                  $kvideo_ersalrygan_single_text2 = $kaveh_pr_metas['kvideo_ersalrygan_single_text2'];
              } else {
                  $kvideo_ersalrygan_single_text2 = $options['kvideo_ersalrygan_single_text2'];
              }
              ?>
              <?php if(!empty($kvideo_ersalrygan_single)): ?>
              <?php if($kvideo_ersalrygan_single === '1'): ?>
              <div class="detail-product-four-send position-relative">
                <img class="position-absolute ersalrayimg" src="<?php echo $kvideo_ersalrygan_single_image; ?>" alt="<?php echo $kvideo_ersalrygan_single_text1; ?>">
                <div class="detail-product-four-send-title d-flex align-items-center">
                  <?php echo $kvideo_ersalrygan_single_text1; ?>
                </div>
                <p class="mb-0"> <?php echo $kvideo_ersalrygan_single_text2; ?> </p>
              </div>
              <?php endif; ?>
              <?php endif; ?>

            </div>
          </div>
          <div class="col-lg-4 col-xxl-3 mt-4 mt-lg-0 order-2 order-md-3">
     
            <div class="detail-product-four-sidebar">

              <?php if ($product->is_type('variable') && $product->is_on_sale()): ?>
                <?php foreach ($product->get_children() as $variation_id): ?>
                  <?php $variation = wc_get_product($variation_id); ?>
                  <?php if ($variation->is_on_sale() && $variation->get_date_on_sale_to()): ?>
                    <?php if(!empty($variation->get_date_on_sale_to())): ?>
                    <div class="proposal-timear d-none d-lg-flex align-items-lg-center justify-content-lg-between">
                      <div class="proposal">
                        پیشنهاد
                        <span class="d-block"> شگفت انگیز </span>
                      </div>
                      <ul class="timear-detail-product d-flex align-items-center gap-1" data-time="<?php echo $variation->get_date_on_sale_to(); ?>">
                        <li class="fw-normal text-center bg-white d-flex align-items-center justify-content-center flex-column">
                          <span class="second fw-bold"> 00 </span>
                          ثانیه
                        </li>:
                        <li class="fw-normal text-center bg-white d-flex align-items-center justify-content-center flex-column">
                          <span class="minute fw-bold"> 00 </span>
                          دقیقه
                        </li>:
                        <li class="fw-normal text-center bg-white d-flex align-items-center justify-content-center flex-column">
                          <span class="hour fw-bold"> 00 </span>
                          ساعت
                        </li>:
                        <li class="fw-normal text-center bg-white d-flex align-items-center justify-content-center flex-column">
                          <span class="day fw-bold"> 00 </span>
                          روز
                        </li>
                      </ul>
                    </div>
                  <?php endif; ?>
                  <?php endif; ?>
                <?php endforeach; ?>
              <?php elseif ($product->is_on_sale()): ?>
                <?php if(!empty($product->get_date_on_sale_to())): ?>
                <div class="proposal-timear d-none d-lg-flex align-items-lg-center justify-content-lg-between">
                  <div class="proposal">
                    پیشنهاد
                    <span class="d-block"> شگفت انگیز </span>
                  </div>
                  <ul class="timear-detail-product d-flex align-items-center gap-1" data-time="<?php echo $product->get_date_on_sale_to(); ?>">
                    <li class="fw-normal text-center bg-white d-flex align-items-center justify-content-center flex-column">
                      <span class="second fw-bold"> 00 </span>
                      ثانیه
                    </li>:
                    <li class="fw-normal text-center bg-white d-flex align-items-center justify-content-center flex-column">
                      <span class="minute fw-bold"> 00 </span>
                      دقیقه
                    </li>:
                    <li class="fw-normal text-center bg-white d-flex align-items-center justify-content-center flex-column">
                      <span class="hour fw-bold"> 00 </span>
                      ساعت
                    </li>:
                    <li class="fw-normal text-center bg-white d-flex align-items-center justify-content-center flex-column">
                      <span class="day fw-bold"> 00 </span>
                      روز
                    </li>
                  </ul>
                </div>
              <?php endif; ?>
              <?php endif; ?>
         
              <div class="exists-product d-flex align-items-center">
                <?php if("instock"==$stocka): ?>
                  <i class="icon-check-circle"></i>
                  <span>موجود در انبار</span>
                <?php elseif("onbackorder"==$stocka): ?>
                  <i class="far fa-clock"></i>
                  <span>در پیش خرید</span>
                <?php else: ?>
                  <i class="isax isax-close-circle"></i>
                  <span>ناموجود در انبار</span>
                <?php endif; ?>
              </div>
              <?php 
              if (isset($kaveh_pr_metas['ksingle_options_off']) && $kaveh_pr_metas['ksingle_options_off'] === '0') {
                  $klis_single = $kaveh_pr_metas['klis_single'];
              } else {
                  $klis_single = $options['klis_single'];
              }
              ?>
              <?php if(!empty($klis_single)): ?>
              <ul class="options-send">
                <?php $lists = $klis_single; ?>
                <?php foreach($lists as $list): ?>
                <li class="d-flex align-items-center">
                  <i class="<?php echo $list['klis_single_icon']; ?>"></i>
                  <?php echo $list['klis_single_text1'] .' '. $list['klis_single_text2']; ?>
                </li>
                <?php endforeach; ?>
              </ul>
              <?php endif; ?>
              <div class="detailfouradd <?php if( $product->is_type( 'simple' ) ){ echo 'det4simple'; } ?>">
                <?php do_action('kaveh_single_add_to_cart'); ?>
              </div>
              <div class="detailfourprice d-flex align-items-lg-center justify-content-lg-end">
                <div>
                  <?php do_action('kaveh_single_price'); ?>
                </div>
              </div>
       
      

            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- End Detail Product -->
    <?php do_action('kaveh_single_modal_gallery'); ?>   

    <?php do_action('kaveh_single_options'); ?> 
               
    <?php do_action('kaveh_single_tabs'); ?>             


    <div class="detail-product-four-bottom bg-white position-fixed d-flex d-lg-none align-items-center">
    </div>
  </div>
<?php do_action( 'woocommerce_after_single_product' ); ?>

<?php endif; ?>
