<?php
/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.4.0
 */

defined( 'ABSPATH' ) || exit;

global $product;
$options = get_option( 'kaveh_frame' );
$mkshopcart = $options['kaveh_sh_cart_select'];

// Ensure visibility.
if ( empty( $product ) || ! $product->is_visible() ) {
    return;
}
$template_parts = array(
    'value-1' => 'template-part/product-cart-one',
    'value-2' => 'template-part/product-cart-two',
    'value-3' => 'template-part/product-cart-three',
    'value-4' => 'template-part/product-cart-four',
    'value-5' => 'template-part/product-cart-five',
    'value-6' => 'template-part/product-cart-six',
    'value-7' => 'template-part/product-cart-seven',
    'value-8' => 'template-part/product-cart-eight',
    'value-9' => 'template-part/product-cart-nine',
    'value-10' => 'template-part/product-cart-ten',
    'value-11' => 'template-part/product-cart-eleven',
    'value-12' => 'template-part/product-cart-twelve',
    'value-13' => 'template-part/product-cart-thirteen',
    'value-14' => 'template-part/product-cart-fourteen',
    'value-15' => 'template-part/product-cart-fifteen',
    'value-16' => 'template-part/product-cart-sixteen',
    'value-17' => 'template-part/product-cart-seventeen',
    'value-18' => 'template-part/product-cart-eighteen',
    'value-19' => 'template-part/product-cart-nineteen',
    'value-20' => 'template-part/product-cart-twenty',
    'value-21' => 'template-part/product-cart-twenty-one',
);
$columns = wc_get_default_products_per_row();
$bootstrap_class = 'col-lg-' . ( 12 / $columns );
?>
<div class="col-6 <?php echo esc_attr( $bootstrap_class ); ?> mb-4">
<?php
if ( array_key_exists( $mkshopcart, $template_parts ) ) {
    get_template_part( $template_parts[ $mkshopcart ] );
}
?>
</div>
