<?php
/**
 * Review order table
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/review-order.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 5.2.0
 */

defined( 'ABSPATH' ) || exit;
?>

<aside class="cart-three-sidebar sticky-top shop_table woocommerce-checkout-review-order-table">
    <div class="cart-three-sidebar-content bg-white position-relative">

      <img src="<?php echo esc_url( KAVEH_TEMPLATE_URI ); ?>/assets/images/kaveh/ic.png" alt="image" width="73" height="73" class="position-absolute top-0 end-50">

	  <div class="price total-price d-flex align-items-center justify-content-between fw-bold cart-subtotal">
		<?php esc_html_e( 'Subtotal', 'woocommerce' ); ?>
			<div>
			<?php wc_cart_totals_subtotal_html(); ?>
			</div>
      </div>

	  <?php foreach ( WC()->cart->get_coupons() as $code => $coupon ) : ?>
	  <div class="price total-price d-flex align-items-center justify-content-between fw-bold cart-discount coupon-<?php echo esc_attr( sanitize_title( $code ) ); ?>">
	  	<?php wc_cart_totals_coupon_label( $coupon ); ?>
        <div>
		<?php wc_cart_totals_coupon_html( $coupon ); ?>
        </div>
      </div>
	  <?php endforeach; ?>


	<div class="divider position-relative"></div>
    


	  <?php if ( WC()->cart->needs_shipping() && WC()->cart->show_shipping() ) : ?>
	  <div class="price total-price d-flex align-items-center justify-content-between fw-bold">
	  	<?php do_action( 'woocommerce_review_order_before_shipping' ); ?>
	  	<?php wc_cart_totals_shipping_html(); ?>
		<?php do_action( 'woocommerce_review_order_after_shipping' ); ?>
      </div>
  	  <?php endif; ?>

	  <?php foreach ( WC()->cart->get_fees() as $fee ) : ?>
	  <div class="price total-price d-flex align-items-center justify-content-between fw-bold fee">
	  	<?php echo esc_html( $fee->name ); ?>
        <div>
		<?php wc_cart_totals_fee_html( $fee ); ?>
        </div>
      </div>
	  <?php endforeach; ?>

	  <?php if ( wc_tax_enabled() && ! WC()->cart->display_prices_including_tax() ) : ?>
    	<?php if ( 'itemized' === get_option( 'woocommerce_tax_total_display' ) ) : ?>
			<?php foreach ( WC()->cart->get_tax_totals() as $code => $tax ) : // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited ?>
			<div class="price total-price d-flex align-items-center justify-content-between fw-bold tax-rate tax-rate-<?php echo esc_attr( sanitize_title( $code ) ); ?>">
				<?php echo esc_html( $tax->label ); ?>
				<div>
				<?php echo wp_kses_post( $tax->formatted_amount ); ?>
				</div>
			</div>
			<?php endforeach; ?>
			<?php else : ?>
			<div class="price total-price d-flex align-items-center justify-content-between fw-bold tax-total">
				<?php echo esc_html( WC()->countries->tax_or_vat() ); ?>
				<div>
				<?php wc_cart_totals_taxes_total_html(); ?>
				</div>
			</div>
		<?php endif; ?>
 	  <?php endif; ?>

	  <?php do_action( 'woocommerce_review_order_before_order_total' ); ?>
		<div class="price profit total-price d-flex align-items-center justify-content-between fw-bold order-total">
			<?php esc_html_e( 'Total', 'woocommerce' ); ?>
				<div>
				<?php wc_cart_totals_order_total_html(); ?>
				</div>
			</div>
		</div>
	  <?php do_action( 'woocommerce_review_order_after_order_total' ); ?>



	
</aside>




