<?php
/**
 * Checkout Form
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/checkout/form-checkout.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 9.4.0
 */

if (!defined('ABSPATH')) {
	exit;
}

do_action('woocommerce_before_checkout_form', $checkout);

// If checkout registration is disabled and not logged in, the user cannot checkout.
if (!$checkout->is_registration_enabled() && $checkout->is_registration_required() && !is_user_logged_in()) {
	echo esc_html(apply_filters('woocommerce_checkout_must_be_logged_in_message', __('You must be logged in to checkout.', 'woocommerce')));
	return;
}
$options = get_option('kaveh_frame');
?>

<form name="checkout" method="post" class="checkout woocommerce-checkout"
	action="<?php echo esc_url(wc_get_checkout_url()); ?>" enctype="multipart/form-data">
	<section class="checkout-two py-4">
		<div class="container">
			<div class="row">
				<div class="col-lg-8 col-xl-9 mb-5 mb-lg-0">
					<?php if ($options['kcheckout_modern'] === '1'): ?>
						<div id="modern_checkout">
							<!-- Start Modal New Address -->
							<div id="modal-new-address" class="modal modal-new-address fade" role="dialog"
								aria-labelledby="myModalLabel" aria-hidden="true">
								<div class="modal-dialog modal-dialog-centered inner-modal">

								</div>
							</div>
							<!-- End Modal New Address -->
							<?php if (!is_user_logged_in()): ?>
								<!-- Start Send Order -->
								<div
									class="checkout-two-send-order checkout-two-box shadow-cart bg-white d-flex align-items-center justify-content-between position-relative">
									<div class="d-flex align-items-center">
										<div class="title fw-bold">
											جهت تکمیل سفارش باید وارد سایت شوید روی دکمه روبرو کلیک کنید
										</div>
									</div>
									<button class="btn-cart btn btn-success-5" data-auth-toggle="modal"
										data-auth-target="auth-gajmarket">
										ورود / ثبت نام
									</button>
								</div>
								<!-- End Send Order -->
							<?php else: ?>
								<?php do_action('woocommerce_checkout_billing'); ?>
								<?php
								$user_id = get_current_user_id();
								$bill_meta_value0 = '';
								$num = '';
								$max_bills = 100; // Set this to the maximum number of bills you expect
								
								for ($i = 0; $i < $max_bills; $i++) {
									$bill_meta_value = get_user_meta($user_id, 'bill' . $i, true);
									if (!empty($bill_meta_value)) {
										$bill_meta_value0 = $bill_meta_value;
										$num = $i;
										break;
									}
								}
								
								// Now $bill_meta_value0 will contain the first non-empty bill value found
								
								$billing_address = get_user_meta($user_id, 'billing_address_1', true);
								if (!empty($bill_meta_value0)):
									?>
									<!-- Start Select Address -->
									<div
										class="checkout-two-select-address checkout-two-box bg-white shadow-cart position-relative">
										<!-- Start Heading -->
										<div
											class="checkout-two-select-address-heading d-flex align-items-center justify-content-between">
											<div class="checkout-two-select-address-heading-title fw-bold"> انتخاب آدرس </div>
											<button userid="<?php echo $user_id; ?>" id="kaveh_new_address" type="button"
												class="new-address d-flex align-items-center fw-bold" data-bs-toggle="modal"
												data-bs-target="#modal-new-address">
												<i class="isax isax-location-add"></i>
												ثبت آدرس جدید
											</button>
										</div>
										<!-- End Heading -->
										<!-- Start Body -->
										<div class="checkout-two-select-address-items d-flex d-md-block">

											<?php
											for ($z = 1; $z <= $num; $z++) {
												$shipping_address = get_user_meta($user_id, $z . 'shipping_address_1', true);
												?>
												<!-- Start Address -->
												<div class="checkout-two-select-address-item position-relative">
													<input type="radio" name="address" class="position-absolute top-0 end-0 w-100 h-100"
														checked>
													<div class="position-relative d-flex bg-white">
														<div class="right">
															<span class="radio position-relative d-block"></span>
														</div>
														<div class="info">
															<div class="address fw-bold">
																<i class="isax isax-location4"></i>
																آدرس:
																<span>
																	<?php if (!empty($shipping_address)): ?>
																		<?php echo $shipping_address; ?>
																	<?php endif; ?>
																</span>
															</div>
															<ul class="d-flex align-items-center flex-wrap">
																<?php
																$first_name = get_user_meta($user_id, $z . 'shipping_first_name', true);
																$last_name = get_user_meta($user_id, $z . 'shipping_last_name', true);
																if (!empty($first_name) && !empty($last_name)):
																	?>
																	<li class="d-flex align-items-center">
																		<i class="icon-user-fill lh-1"></i>
																		<span>
																			<?php echo '&nbsp;' . $first_name . ' ' . $last_name; ?>
																		</span>
																	</li>
																<?php endif; ?>
															</ul>
															<button userid="<?php echo $user_id; ?>" icd="<?php echo $z; ?>"
																id="kaveh_edit_address" type="button"
																class="edit position-absolute top-50 translate-middle-y z-99"
																data-bs-toggle="modal" data-bs-target="#modal-new-address">
																<i class="isax isax-edit"></i> ویرایش
															</button>
															<button userid="<?php echo $user_id; ?>" icd="<?php echo $z; ?>"
																id="kaveh_remove_address" type="button"
																class="edit position-absolute top-50 translate-middle-y left50 z-99">
																<i class="isax isax-trash"></i> حذف
															</button>
														</div>
													</div>
												</div>
												<!-- End Address -->
												<?php
											}
											?>
											<?php if (!empty($billing_address)): ?>
											<!-- Start Address -->
											<div class="checkout-two-select-address-item position-relative">
												<input type="radio" name="address" class="position-absolute top-0 end-0 w-100 h-100"
													checked>
												<div class="position-relative d-flex bg-white">
													<div class="right">
														<span class="radio position-relative d-block"></span>
													</div>
													<div class="info">
														<div class="address fw-bold">
															<i class="isax isax-location4"></i>
															آدرس:
															<span>
																<?php if (!empty($billing_address)): ?>
																	<?php echo $billing_address; ?>
																<?php endif; ?>
															</span>
														</div>
														<ul class="d-flex align-items-center flex-wrap">
															<?php
															$first_name = get_user_meta($user_id, 'billing_first_name', true);
															$last_name = get_user_meta($user_id, 'billing_last_name', true);
															if (!empty($first_name) && !empty($last_name)):
																?>
																<li class="d-flex align-items-center">
																	<i class="icon-user-fill lh-1"></i>
																	<span>
																		<?php echo '&nbsp;' . $first_name . ' ' . $last_name; ?>
																	</span>
																</li>
															<?php endif; ?>
														</ul>
														<button userid="<?php echo $user_id; ?>" icd="0" id="kaveh_edit_address"
															type="button"
															class="edit position-absolute top-50 translate-middle-y z-99"
															data-bs-toggle="modal" data-bs-target="#modal-new-address">
															<i class="isax isax-edit"></i> ویرایش
														</button>
														<button userid="<?php echo $user_id; ?>" icd="0" id="kaveh_remove_address"
															type="button"
															class="edit position-absolute top-50 translate-middle-y left50 z-99">
															<i class="isax isax-trash"></i> حذف
														</button>
													</div>
												</div>
											</div>
											<!-- End Address -->
											<?php endif; ?>


										</div>
										<!-- End Body -->

									</div>
									<!-- End Select Address -->
								<?php else: ?>
									<?php $user_id = get_current_user_id(); ?>
									<!-- Start Select Address empty -->
									<div
										class="checkout-two-select-address checkout-two-box bg-white shadow-cart position-relative">
										<!-- Start Heading -->
										<div
											class="checkout-two-select-address-heading d-flex align-items-center justify-content-between">
											<div class="checkout-two-select-address-heading-title fw-bold"> انتخاب آدرس </div>
										</div>
										<!-- End Heading -->
										<!-- Start Body -->
										<div
											class="checkout-two-select-address-empty d-flex align-items-center justify-content-center flex-column position-relative">
											<img src="<?php echo esc_url(KAVEH_TEMPLATE_URI); ?>/assets/images/kaveh/location.svg"
												alt="location" width="85" height="85" class="d-block mx-auto">
											<div class="title text-center fw-bold"> آدرس تحویل ثبت نشده است. </div>
											<button userid="<?php echo $user_id; ?>" id="kaveh_new_address" type="button"
												class="btn btn-outline-success-2 d-flex align-items-center justify-content-center"
												data-bs-toggle="modal" data-bs-target="#modal-new-address">
												<i class="isax isax-location-add"></i>
												ثبت آدرس جدید
											</button>
										</div>
										<!-- End Body -->
									</div>
									<!-- End Select Address Empty -->
								<?php endif; ?>
							<?php endif; ?>
							<!-- Start Type Send -->
							<div class="checkout-two-type-send checkout-two-box bg-white shadow-cart position-relative">
								<div class="title fw-bold"> توضیحات مهم سفارش </div>
								<div class="row">
									<!-- Start Tabs -->
									<div class="col-lg-12 mb-4">
										<!-- Start Tabs Contents -->
										<div class="tab-content">
											<?php echo $options['kwoocheckoutdesc']; ?>
										</div>
										<!-- End Tabs Contents -->
									</div>
								</div>
							</div>
							<!-- End Type Send -->
						</div>
					<?php else: ?>
						<div class="checkout-two-select-address checkout-two-box bg-white shadow-cart position-relative">
							<?php if ($checkout->get_checkout_fields()): ?>
								<?php do_action('woocommerce_checkout_before_customer_details'); ?>
								<?php do_action('woocommerce_checkout_billing'); ?>
								<?php do_action('woocommerce_checkout_shipping'); ?>
								<?php do_action('woocommerce_checkout_after_customer_details'); ?>
							<?php endif; ?>
						</div>
					<?php endif; ?>
				</div>
				<div class="col-lg-4 col-xl-3">
					<?php do_action('woocommerce_checkout_before_order_review_heading'); ?>
					<?php do_action('woocommerce_checkout_before_order_review'); ?>
					<div id="order_review" class="woocommerce-checkout-review-order">
						<?php do_action('woocommerce_checkout_order_review'); ?>
					</div>
					<?php do_action('woocommerce_checkout_after_order_review'); ?>
				</div>
			</div>
		</div>
	</section>
</form>


<?php do_action('woocommerce_after_checkout_form', $checkout); ?>