<?php
/**
 * Cart totals
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/cart/cart-totals.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woo.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 2.3.6
 */

defined( 'ABSPATH' ) || exit;
?>

<div class="cart_totals <?php echo ( WC()->customer->has_calculated_shipping() ) ? 'calculated_shipping' : ''; ?>">

	<?php do_action( 'woocommerce_before_cart_totals' ); ?>

	<aside class="cart-three-sidebar shop_table">
		<div class="cart-three-sidebar-content bg-white position-relative">
			<img src="<?php echo esc_url( KAVEH_TEMPLATE_URI ); ?>/assets/images/kaveh/ic.png" alt="image" width="73" height="73" class="position-absolute top-0 end-50">

			<div class="price d-flex align-items-center justify-content-between">
				<?php esc_html_e( 'Subtotal', 'woocommerce' ); ?> :
				<div>
				<?php wc_cart_totals_subtotal_html(); ?>
				</div>
			</div>

			<?php if ( WC()->cart->needs_shipping() && WC()->cart->show_shipping() ) : ?>

				<?php do_action( 'woocommerce_cart_totals_before_shipping' ); ?>

				<?php wc_cart_totals_shipping_html(); ?>

				<?php do_action( 'woocommerce_cart_totals_after_shipping' ); ?>

			<?php elseif ( WC()->cart->needs_shipping() && 'yes' === get_option( 'woocommerce_enable_shipping_calc' ) ) : ?>

				<div class="price d-flex align-items-center justify-content-between shipping">
					<?php esc_html_e( 'Shipping', 'woocommerce' ); ?> :
					<div data-title="<?php esc_attr_e( 'Shipping', 'woocommerce' ); ?>">
					<?php woocommerce_shipping_calculator(); ?>
					</div>
				</div>

			<?php endif; ?>

			<?php
			if ( wc_tax_enabled() && ! WC()->cart->display_prices_including_tax() ) {
				$taxable_address = WC()->customer->get_taxable_address();
				$estimated_text  = '';

				if ( WC()->customer->is_customer_outside_base() && ! WC()->customer->has_calculated_shipping() ) {
					/* translators: %s location. */
					$estimated_text = sprintf( ' <small>' . esc_html__( '(estimated for %s)', 'woocommerce' ) . '</small>', WC()->countries->estimated_for_prefix( $taxable_address[0] ) . WC()->countries->countries[ $taxable_address[0] ] );
				}

				if ( 'itemized' === get_option( 'woocommerce_tax_total_display' ) ) {
					foreach ( WC()->cart->get_tax_totals() as $code => $tax ) { // phpcs:ignore WordPress.WP.GlobalVariablesOverride.Prohibited
						?>
						<div class="price d-flex align-items-center justify-content-between tax-rate tax-rate-<?php echo esc_attr( sanitize_title( $code ) ); ?>">
							<?php echo esc_html( $tax->label ) . $estimated_text; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?> :
							<div data-title="<?php echo esc_attr( $tax->label ); ?>">
							<?php echo wp_kses_post( $tax->formatted_amount ); ?>
							</div>
						</div>
						<?php
					}
				} else {
					?>
					<div class="price d-flex align-items-center justify-content-between tax-total">
						<?php echo esc_html( WC()->countries->tax_or_vat() ) . $estimated_text; // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?> :
						<div data-title="<?php echo esc_attr( WC()->countries->tax_or_vat() ); ?>">
						<?php wc_cart_totals_taxes_total_html(); ?>
						</div>
					</div>
					<?php
				}
			}
			?>

			<?php foreach ( WC()->cart->get_coupons() as $code => $coupon ) : ?>
				<div class="price d-flex align-items-center justify-content-between cart-discount coupon-<?php echo esc_attr( sanitize_title( $code ) ); ?>">
					<?php wc_cart_totals_coupon_label( $coupon ); ?> :
					<div data-title="<?php echo esc_attr( wc_cart_totals_coupon_label( $coupon, false ) ); ?>">
					<?php wc_cart_totals_coupon_html( $coupon ); ?>
					</div>
				</div>
			<?php endforeach; ?>

			<?php foreach ( WC()->cart->get_fees() as $fee ) : ?>
				<div class="price d-flex align-items-center justify-content-between fee">
					<?php echo esc_html( $fee->name ); ?> :
					<div data-title="<?php echo esc_attr( $fee->name ); ?>">
					<?php wc_cart_totals_fee_html( $fee ); ?>
					</div>
				</div>
			<?php endforeach; ?>	

			<div class="divider position-relative"></div>
			<p class="fw-normal"> هزینه ارسال در ادامه بر اساس آدرس و نحوه‌ی ارسال محاسبه و اضافه خواهد شد </p>
			<div class="price profit total-price d-flex align-items-center justify-content-between fw-bold">
				<?php do_action( 'woocommerce_cart_totals_before_order_total' ); ?>
				<?php esc_html_e( 'Total', 'woocommerce' ); ?> :
				<div>
				<?php wc_cart_totals_order_total_html(); ?>
				</div>
				<?php do_action( 'woocommerce_cart_totals_after_order_total' ); ?>
			</div>
		</div>
	</aside> 

	<div class="wc-proceed-to-checkout">
		<?php do_action( 'woocommerce_proceed_to_checkout' ); ?>
	</div>

	<?php do_action( 'woocommerce_after_cart_totals' ); ?>

</div>


