<?php
$product = wc_get_product(get_the_ID());
$sale_price = $product->get_sale_price();
$normal_price = $product->get_regular_price();
$options = get_option('kaveh_frame');
$woo_currency = get_woocommerce_currency_symbol();
$min_regular_price = NULL;
$max_regular_price = NULL;
$min_sale_price = NULL;
$max_sale_price = NULL;
if ($product->is_type('variable')) {
  $min_regular_price = $product->get_variation_regular_price('min');
  $max_regular_price = $product->get_variation_regular_price('max');
  $min_sale_price = $product->get_variation_sale_price('min');
  $max_sale_price = $product->get_variation_sale_price('max');
}
$pr_id = get_the_ID();
$stocka = $product->get_stock_status();
?>
<div <?php wc_product_class('product product-five', $product); ?>>
    <div class="content">
        <h2>
            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
        </h2>

        <?php if ("instock" == $stocka) { ?>
            <?php if (!$product->is_type('variable')) { ?>
                <?php if (empty($sale_price) && empty($normal_price)) { ?>
                    <?php
                    $price_v = $product->get_price_html(); ?>
                    <div><?php
                    echo str_replace("&ndash;", "<span class=\"dashvar\"> – </span>", $price_v); ?>
                    </div>
                    <?php
                    ?>
                <?php } else { ?>
                    <?php if (!empty($sale_price)) { ?>
                        <div class="price">
                            <del> <?php if (!empty($normal_price)) {
                                echo number_format($normal_price, 0, '.', ',');
                            } ?> </del>
                            <span> <?php echo number_format($sale_price, 0, '.', ','); ?> </span>
                            <?php echo $woo_currency; ?>
                        </div>
                    <?php } else { ?>
                        <div class="price">
                            <span> <?php if (!empty($normal_price)) {
                                echo number_format($normal_price, 0, '.', ',');
                            } ?> </span>
                            <?php echo $woo_currency; ?>
                        </div>
                    <?php } ?>
                <?php }
            } else {
                ?>

                


                    <?php if ($product->is_on_sale()){ ?>
                        <div class="price">
                            <del> <?php if (!empty($max_regular_price)) {
                                echo number_format($max_regular_price, 0, '.', ',');
                            } ?> </del>
                            <span> <?php echo number_format($min_sale_price, 0, '.', ','); ?> </span>
                            <?php echo $woo_currency; ?>
                        </div>
                    <?php } else { ?>
                        <div class="price">
                            <span>

                                <!-- show range -->
                                <?php if ($min_regular_price !== $max_regular_price): ?>
                                    <?php if (!empty($min_regular_price)): ?>
                                        <?php echo number_format($min_regular_price, 0, '.', ',') . ' - ' . number_format($max_regular_price, 0, '.', ',') . ' '; ?>
                                    <?php endif; ?>
                                <?php else: ?>
                                    <?php if (!empty($min_regular_price)): ?>
                                        <?php echo number_format($min_regular_price, 0, '.', ',') . ' '; ?>
                                    <?php endif; ?>
                                <?php endif; ?>
                                <!-- show range -->
                            </span>
                            <?php echo $woo_currency; ?>
                        </div>
                    <?php } ?>





                <?php
            }
        }
        ?>
        <div class="product-hover">
            <?php if (!$product->is_type('variable')) { ?>
                <a href="<?php the_permalink(); ?>" class="btn btn-secondary rounded-pill"> مشاهده محصول </a>
            <?php } else { ?>
                <a href="<?php the_permalink(); ?>" class="btn btn-secondary rounded-pill"> مشاهده گزینه ها </a>
            <?php }
            if (!$product->is_type('variable')) {
                if ("instock" == $stocka) { ?>
                    <button type="submit" name="add-to-cart" value="<?php echo $pr_id ?>"
                        class="single_add_to_cart_button btn btn-secondary rounded-circle icarrt">
                        <i class="icon icon-cart-3"></i>
                    </button>
                <?php }
            }
            if (is_plugin_active('woo-smart-compare/wpc-smart-compare.php')) {
                echo do_shortcode('[woosc id="".<?php echo get_the_ID(); ?>.""]');
            } else {
            }
            ?>
            <?php
            if (is_plugin_active('woo-smart-wishlist/wpc-smart-wishlist.php')) { ?>
                <?php echo do_shortcode('[woosw id="".<?php echo get_the_ID(); ?>.""]'); ?>
                <?php
            } else {

            }
            ?>
            <button id="eyeid" type="button" class="btn btn-secondary rounded-circle eyeid" data-bs-toggle="modal"
                data-bs-target="#modal-product" value="<?php echo $pr_id; ?>">
                <i class="isax isax-eye3"></i>
            </button>
        </div>
    </div>
    <?php
    if ("instock" != $stocka) { ?>
        <div class="status">
            ناموجود
        </div>
    <?php } ?>
    <div class="product-image">
        <?php if ($product->is_on_sale()): ?>
            <div class="discount">
                <?php if (class_exists('kavehWoo')) {
                    $offer_percentage = kavehWoo::showofferpercentage($product);
                    echo $offer_percentage;
                } ?>
            </div>
        <?php endif; ?>
        <a href="<?php the_permalink(); ?>">
            <img src="<?php if(get_the_post_thumbnail_url()): ?>
<?php the_post_thumbnail_url('full'); ?>
<?php else: ?>
<?php echo wc_placeholder_img_src(); ?>
<?php endif; ?>" alt="<?php the_title(); ?>">
        </a>
    </div>
</div>