<?php
$product = wc_get_product(get_the_ID());
$sale_price = $product->get_sale_price();
$normal_price = $product->get_regular_price();
$options = get_option('kaveh_frame');
$woo_currency = get_woocommerce_currency_symbol();
$stocka = $product->get_stock_status();
?>

<div class="product-new-three d-flex flex-column">
    <div class="image">
        <a href="<?php the_permalink(); ?>" class="d-block">
            <img src="<?php if (get_the_post_thumbnail_url()): ?>
            <?php the_post_thumbnail_url('full'); ?>
            <?php else: ?>
            <?php echo wc_placeholder_img_src(); ?>
            <?php endif; ?>" alt="<?php the_title(); ?>" width="243" height="141" class="d-block mx-auto w-100">
        </a>
    </div>
    <div class="content h-100 d-flex flex-column">
        <h2 class="title mb-auto overflow-hidden">
            <a href="<?php the_permalink(); ?>" class="d-block"> <?php the_title(); ?> </a>
        </h2>
        <div class="d-flex align-items-center justify-content-between">
            <div class="price d-flex flex-column position-relative">
                <?php if ($product->is_type('simple')): ?>
                    <?php if ($product->is_on_sale()): ?>
                        <?php if (!empty($normal_price)): ?>
                            <span> <?php echo number_format($sale_price, 0, '.', ','); ?> </span>
                            <?php echo $woo_currency; ?>
                            <del> <?php echo number_format($normal_price, 0, '.', ','); ?> </del>
                        <?php endif; ?>

                    <?php else: ?>
                        <?php if (!empty($normal_price)): ?>

                            <span> <?php echo number_format($normal_price, 0, '.', ','); ?> </span>
                            <?php echo $woo_currency; ?>
                        <?php endif; ?>

                    <?php endif; ?>
                <?php elseif ($product->is_type('variable')): ?>

                    <?php
                    $min_price = $product->get_variation_price('min', true);
                    $max_price = $product->get_variation_price('max', true);
                    ?>
                    <?php if ($product->is_on_sale()): ?>



                        <?php if ($min_price === $max_price): ?>
                            <span> <?php echo number_format($min_price, 0, '.', ','); ?> </span>
                            <?php echo $woo_currency; ?>
                        <?php else: ?>
                            <span> <?php echo number_format($min_price, 0, '.', ','); ?> -
                                <?php echo number_format($max_price, 0, '.', ','); ?> </span>
                            <?php echo $woo_currency; ?>
                        <?php endif; ?>


                    <?php else: ?>


                        <?php if ($min_price === $max_price): ?>
                            <span> <?php echo number_format($min_price, 0, '.', ','); ?> </span>
                            <?php echo $woo_currency; ?>
                        <?php else: ?>
                            <span> <?php echo number_format($min_price, 0, '.', ','); ?> -
                                <?php echo number_format($max_price, 0, '.', ','); ?> </span>
                            <?php echo $woo_currency; ?>
                        <?php endif; ?>

                    <?php endif; ?>
                <?php endif; ?>
            </div>
            <?php if ($product->is_on_sale()): ?>
                <div class="offer d-flex align-items-center justify-content-center">
                    <?php
                    $offer_percentage = kavehWoo::showofferpercentage($product);
                    if ($product->is_on_sale()) {
                        echo $offer_percentage;
                    }
                    ?>
                </div>
            <?php endif; ?>

        </div>

    </div>
</div>