<?php
$product = wc_get_product(get_the_ID());
$sale_price = $product->get_sale_price();
$normal_price = $product->get_regular_price();
$options = get_option('kaveh_frame');
$woo_currency = get_woocommerce_currency_symbol();
$stocka = $product->get_stock_status();
?>

<div class="product-new-four d-flex flex-column">
    
    <?php if ($product->is_on_sale()): ?>
    <div class="offer d-flex align-items-center justify-content-center position-absolute top-0"> <?php
    $offer_percentage = kavehWoo::showofferpercentage($product);
    echo $offer_percentage;
    ?> </div>
    <?php endif; ?>

    <div class="image">
        <a href="<?php the_permalink(); ?>" class="d-block">
            <img src="<?php if (get_the_post_thumbnail_url()): ?>
            <?php the_post_thumbnail_url('full'); ?>
            <?php else: ?>
            <?php echo wc_placeholder_img_src(); ?>
            <?php endif; ?>" alt="image" width="243" height="240" class="d-block w-100 mx-auto">
        </a>
    </div>
    <h2 class="title overflow-hidden text-center">
        <a href="<?php the_permalink(); ?>" class="d-block"> <?php the_title(); ?> </a>
    </h2>
    <div class="price d-flex align-items-center justify-content-center bg-white position-relative mt-auto flex-wrap">
        <?php if ($product->is_type('simple')): ?>
            <?php if ($product->is_on_sale()): ?>
                <?php if (!empty($normal_price)): ?>

                    <del> <?php echo number_format($normal_price, 0, '.', ','); ?> </del>
                    <span> <?php echo number_format($sale_price, 0, '.', ','); ?> </span>
                    <?php echo $woo_currency; ?>
                <?php endif; ?>

            <?php else: ?>
                <?php if (!empty($normal_price)): ?>

                    <span> <?php echo number_format($normal_price, 0, '.', ','); ?> </span>
                    <?php echo $woo_currency; ?>
                <?php endif; ?>

            <?php endif; ?>
        <?php elseif ($product->is_type('variable')): ?>
            <?php
            $min_price = $product->get_variation_price('min', true);
            $max_price = $product->get_variation_price('max', true);
            ?>
            <?php if ($product->is_on_sale()): ?>
                
               
                    <?php if ($min_price === $max_price): ?>
                        <span> <?php echo number_format($min_price, 0, '.', ','); ?> </span>
                        <?php echo $woo_currency; ?>
                    <?php else: ?>
                        <span> <?php echo number_format($min_price, 0, '.', ','); ?> -
                            <?php echo number_format($max_price, 0, '.', ','); ?> </span>
                        <?php echo $woo_currency; ?>
                    <?php endif; ?>

            <?php else: ?>

               
                    <?php if ($min_price === $max_price): ?>
                        <span> <?php echo number_format($min_price, 0, '.', ','); ?> </span>
                        <?php echo $woo_currency; ?>
                    <?php else: ?>
                        <span> <?php echo number_format($min_price, 0, '.', ','); ?> -
                            <?php echo number_format($max_price, 0, '.', ','); ?> </span>
                        <?php echo $woo_currency; ?>
                    <?php endif; ?>

            <?php endif; ?>
        <?php endif; ?>
    </div>

</div>