<?php
$product = wc_get_product(get_the_ID());
$sale_price = $product->get_sale_price();
$normal_price = $product->get_regular_price();
$options = get_option('kaveh_frame');
$woo_currency = get_woocommerce_currency_symbol();
$min_regular_price = NULL;
$max_regular_price = NULL;
$min_sale_price = NULL;
$max_sale_price = NULL;
if ($product->is_type('variable')) {
  $min_regular_price = $product->get_variation_regular_price('min');
  $max_regular_price = $product->get_variation_regular_price('max');
  $min_sale_price = $product->get_variation_sale_price('min');
  $max_sale_price = $product->get_variation_sale_price('max');
}
$pr_id = get_the_ID();
$stocka = $product->get_stock_status();
?>
<div <?php wc_product_class('product product-eleven overflow-hidden', $product); ?>>
  <div class="product-image">
    <?php
    if (is_plugin_active('woo-smart-compare/wpc-smart-compare.php')) {
      echo do_shortcode('[woosc id="".<?php echo get_the_ID(); ?>.""]');
    } else {

    }
    ?>
    <?php
    if ("instock" != $stocka) { ?>
      <div class="status">
        ناموجود
      </div>
    <?php } ?>
    <?php if ($product->is_on_sale()): ?>
      <div class="discount">
        <?php if (class_exists('kavehWoo')) {
          $offer_percentage = kavehWoo::showofferpercentage($product);
          echo $offer_percentage;
        } ?>
      </div>
      <button type="button" class="bookmark btn btn-warning p-0 position-absolute">
        <i class="isax isax-ticket-discount5"></i>
      </button>
    <?php endif; ?>
    <ul class="colors position-absolute">
      <?php
      // Get the terms associated with the product
      
      $terms = get_the_terms($pr_id, 'pa_color');
      // Loop through the terms
      foreach ($terms as $term) {
        $val = get_term_meta($term->term_id, 'wpcvs_color', true) ?: '';
        $tooltip = get_term_meta($term->term_id, 'wpcvs_tooltip', true) ?: $term->name;
        ?>
        <li>
          <a href="<?php the_permalink(); ?>" class="rounded-circle d-block hint--right"
            aria-label="<?php echo esc_attr($tooltip) ?>" title="<?php echo esc_attr($tooltip) ?>"
            style="background-color: <?php echo esc_attr($val) ?>;"></a>
        </li>

        <?php
      }
      ?>
    </ul>
    <a href="<?php the_permalink(); ?>">
      <img src="<?php if(get_the_post_thumbnail_url()): ?>
<?php the_post_thumbnail_url('full'); ?>
<?php else: ?>
<?php echo wc_placeholder_img_src(); ?>
<?php endif; ?>" alt="product">
    </a>
  </div>
  <div class="detail">
    <?php if ("instock" == $stocka) { ?>
      <?php if (!$product->is_type('variable')) { ?>
        <?php if (empty($sale_price) && empty($normal_price)) { ?>
          <?php
          $price_v = $product->get_price_html(); ?>
          <div><?php
          echo str_replace("&ndash;", "<span class=\"dashvar\"> – </span>", $price_v); ?>
          </div>
          <?php
          ?>
        <?php } else { ?>
          <?php if (!empty($sale_price)) { ?>
            <div class="offer">
              <?php if (!empty($normal_price)) {
                echo number_format($normal_price, 0, '.', ',');
              } ?>
            </div>
            <div class="price">
              <?php echo number_format($sale_price, 0, '.', ','); ?>
              <span> <?php echo $woo_currency; ?> </span>
            </div>
          <?php } else { ?>
            <div class="price nor12p">
              <?php if (!empty($normal_price)) {
                echo number_format($normal_price, 0, '.', ',');
              } ?>
              <span> <?php echo $woo_currency; ?></span>
            </div>
          <?php } ?>
        <?php }
      } else {
        ?>

       

          <?php if ($product->is_on_sale()){ ?>
            <div class="offer">
              <?php if (!empty($max_regular_price)) {
                echo number_format($max_regular_price, 0, '.', ',');
              } ?>
            </div>
            <div class="price">
              <?php echo number_format($min_sale_price, 0, '.', ','); ?>
              <span> <?php echo $woo_currency; ?> </span>
            </div>
          <?php } else { ?>
            <div class="price nor12p">

              <!-- show range -->
              <?php if ($min_regular_price !== $max_regular_price): ?>
                <?php if (!empty($min_regular_price)): ?>
                  <?php echo number_format($min_regular_price, 0, '.', ',') . ' - ' . number_format($max_regular_price, 0, '.', ',') . ' '; ?>
                <?php endif; ?>
              <?php else: ?>
                <?php if (!empty($min_regular_price)): ?>
                  <?php echo number_format($min_regular_price, 0, '.', ',') . ' '; ?>
                <?php endif; ?>
              <?php endif; ?>
              <!-- show range -->
              <span> <?php echo $woo_currency; ?></span>
            </div>
          <?php } ?>


        <?php
      }
      ?>
    <?php } else {
      ?>
      <div class="mt-p12"></div>
      <?php
    } ?>
    <?php if (empty($normal_price)) { ?>
      <div class="mt-p121"></div>
    <?php } ?>
    <h2>
      <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
    </h2>
    <div class="btns d-flex align-items-center justify-content-center">
      <?php if (!$product->is_type('variable')) {
        if ("instock" == $stocka) { ?>
          <button type="button" class="add-to-cart single_add_to_cart_button position-relative cart11"
            value="<?php echo $pr_id; ?>">
            <i class="icon icon-cart-3"></i>
          </button>
        <?php }
      } ?>
      <button id="eyeid" type="button" value="<?php echo $pr_id; ?>" class="rounded-circle text-center d-block eyeid"
        data-bs-toggle="modal" data-bs-target="#modal-product">
        <i class="isax isax-eye3"></i>
      </button>
      <?php
      if (is_plugin_active('woo-smart-wishlist/wpc-smart-wishlist.php')) { ?>
        <?php echo do_shortcode('[woosw id="".<?php echo get_the_ID(); ?>.""]'); ?>
        <?php
      } else {

      }
      ?>
    </div>
  </div>
</div>