<?php
$product = wc_get_product(get_the_ID());
$sale_price = $product->get_sale_price();
$normal_price = $product->get_regular_price();

$pr_id = get_the_ID();
$stocka = $product->get_stock_status();
?>

<div <?php wc_product_class('product product-fifteen position-relative d-flex align-items-sm-center bg-white flex-column flex-sm-row', $product); ?>>
    <?php if ($product->is_on_sale()): ?>
        <div class="discount d-flex align-items-center justify-content-center position-absolute top-0 start-0">
            <?php if (class_exists('kavehWoo')) {
                $offer_percentage = kavehWoo::showofferpercentage($product);
                echo $offer_percentage;
            } ?>
        </div>
    <?php endif; ?>
    <div class="image-price position-relative">
        <ul
            class="btns position-absolute top-50 start-50 translate-middle mb-0 d-flex d-sm-block align-items-center justify-content-center">
            <li>
                <a href="javascript:void(0)" name="add-to-cart" value="<?php echo $pr_id ?>"
                    class="d-flex align-items-center justify-content-center single_add_to_cart_button"
                    aria-label="cart">
                    <i class="icon-cart-4"></i>
                </a>
            </li>
            <li>
                <a href="javascript:void(0)" class="d-flex align-items-center justify-content-center" aria-label="toggle">
                    <i class="icon-arrow-toggle"></i>
                </a>
            </li>
            <li>
                <a href="javascript:void(0)" class="d-flex align-items-center justify-content-center" aria-label="view">
                    <i class="icon-eye-2"></i>
                </a>
            </li>
        </ul>
        <img src="<?php if(get_the_post_thumbnail_url()): ?>
<?php the_post_thumbnail_url('full'); ?>
<?php else: ?>
<?php echo wc_placeholder_img_src(); ?>
<?php endif; ?>" alt="product" width="178" height="103">
        <div class="price position-relative text-center text-sm-start">
            <?php if ("instock" == $stocka) { ?>
                <?php if (!$product->is_type('variable')) { ?>
                    <?php if (empty($sale_price) && empty($normal_price)) { ?>
                        <?php
                        $price_v = $product->get_price_html(); ?>
                        <div><?php
                        echo str_replace("&ndash;", "<span class=\"dashvar\"> – </span>", $price_v); ?>
                        </div>
                        <?php
                        ?>
                    <?php } else { ?>
                        <?php if (!empty($sale_price)) { ?>
                            <del class="d-block"> <?php echo number_format($normal_price, 0, '.', ','); ?> </del>
                            <div class="d-flex align-items-center justify-content-center justify-content-sm-start position-relative">
                                <span> <?php echo number_format($sale_price, 0, '.', ','); ?> </span>
                                <?php echo $woo_currency; ?>
                            </div>
                            <?php
                        } else {
                            ?>
                            <div class="d-flex align-items-center justify-content-center justify-content-sm-start position-relative">
                                <span> <?php echo number_format($normal_price, 0, '.', ','); ?> </span>
                                <?php echo $woo_currency; ?>
                            </div>
                        <?php
                        }
                    }
                } else {
                    $price_v = $product->get_price_html();
                    echo str_replace("&ndash;", "<span class=\"dashvar\"> – </span>", $price_v);
                }
            }
            ?>
        </div>
    </div>
    <div class="info text-center text-sm-start mt-3 mt-sm-0">
        <a href="<?php the_permalink(); ?>">
            <h2 class="title mb-1"> <?php the_title(); ?> </h2>
        </a>
        <div class="title-en"> </div>
        <?php
        $product_attributes = array();

        // Display weight and dimensions before attribute list.
        $display_dimensions = apply_filters('wc_product_enable_dimensions_display', $product->has_weight() || $product->has_dimensions());

        if ($display_dimensions && $product->has_weight()) {
            $product_attributes['weight'] = array(
                'label' => __('Weight', 'woocommerce'),
                'value' => wc_format_weight($product->get_weight()),
            );
        }

        if ($display_dimensions && $product->has_dimensions()) {
            $product_attributes['dimensions'] = array(
                'label' => __('Dimensions', 'woocommerce'),
                'value' => wc_format_dimensions($product->get_dimensions(false)),
            );
        }

        // Add product attributes to list.
        $attributes = array_filter($product->get_attributes(), 'wc_attributes_array_filter_visible');

        foreach ($attributes as $attribute) {
            $values = array();

            if ($attribute->is_taxonomy()) {
                $attribute_taxonomy = $attribute->get_taxonomy_object();
                $attribute_values = wc_get_product_terms($product->get_id(), $attribute->get_name(), array('fields' => 'all'));

                foreach ($attribute_values as $attribute_value) {
                    $value_name = esc_html($attribute_value->name);

                    if ($attribute_taxonomy->attribute_public) {
                        $values[] = '<a href="' . esc_url(get_term_link($attribute_value->term_id, $attribute->get_name())) . '" rel="tag">' . $value_name . '</a>';
                    } else {
                        $values[] = $value_name;
                    }
                }
            } else {
                $values = $attribute->get_options();

                foreach ($values as &$value) {
                    $value = make_clickable(esc_html($value));
                }
            }

            $product_attributes['attribute_' . sanitize_title_with_dashes($attribute->get_name())] = array(
                'label' => wc_attribute_label($attribute->get_name()),
                'value' => apply_filters('woocommerce_attribute', wpautop(wptexturize(implode(', ', $values))), $attribute, $values),
            );
        }
        if (!empty($product_attributes)):
            ?>
            <ul class="mb-0 text-end me-1">
                <?php $i = 0;
                foreach ($product_attributes as $product_attribute_key => $product_attribute):
                    if ($i < 4): ?>
                        <li> <?php echo $product_attribute['label']; ?> :
                            <?php echo str_replace('p>', 'span>', $product_attribute['value']); ?> </li>
                    <?php endif;
                    $i += 1;
                endforeach; ?>
            </ul>
        <?php endif; ?>

    </div>
</div>