<?php
$product = wc_get_product(get_the_ID());
$sale_price = $product->get_sale_price();
$normal_price = $product->get_regular_price();
$options = get_option('kaveh_frame');
$woo_currency = get_woocommerce_currency_symbol();
$stocka = $product->get_stock_status();
?>

<div class="product-new-two d-flex flex-column">
    <div class="image-title h-100">
        <div class="image">
            <a href="<?php the_permalink(); ?>" class="d-block">
                <img src="<?php if (get_the_post_thumbnail_url()): ?>
            <?php the_post_thumbnail_url('full'); ?>
            <?php else: ?>
            <?php echo wc_placeholder_img_src(); ?>
            <?php endif; ?>" alt="<?php the_title(); ?>" width="243" height="240" class="d-block mx-auto w-100">
            </a>
        </div>
        <h2 class="title mb-0 overflow-hidden">
            <a href="<?php the_permalink(); ?>" class="d-block text-center"> <?php the_title(); ?> </a>
        </h2>
    </div>
    <div class="btn-cart-price d-flex align-items-center">
        <a name="add-to-cart" value="<?php echo get_the_ID() ?>" href="<?php echo esc_url($product->add_to_cart_url()); ?>"
            class="single_add_to_cart_button add-to-cart d-flex align-items-center justify-content-center lh-1">
            <i class="icon-shopping-bag-3"></i>
        </a>
        <div>
            <?php if ($product->is_type('simple')): ?>
                <?php if ($product->is_on_sale()): ?>
                    <?php if (!empty($normal_price)): ?>
                        <div class="offer d-flex align-items-center">
                            <span class="rounded-pill text-white text-center">
                                <?php echo kavehWoo::showofferpercentage($product); ?>
                            </span>
                            <del> <?php echo number_format($normal_price, 0, '.', ','); ?> </del>
                        </div>
                        <div class="price">
                            <span class="d-block"> <?php echo number_format($sale_price, 0, '.', ','); ?> </span>
                            <?php echo $woo_currency; ?>
                        </div>
                    <?php endif; ?>

                <?php else: ?>
                    <?php if (!empty($normal_price)): ?>
                        <div class="price">
                            <span class="d-block"> <?php echo number_format($normal_price, 0, '.', ','); ?> </span>
                            <?php echo $woo_currency; ?>
                        </div>
                    <?php endif; ?>

                <?php endif; ?>
            <?php elseif ($product->is_type('variable')): ?>
                <?php
                $min_price = $product->get_variation_price('min', true);
                $max_price = $product->get_variation_price('max', true);
                ?>
                <?php if ($product->is_on_sale()): ?>

          
                        <div class="price">
                            <?php if ($min_price === $max_price): ?>
                                <span class="d-block"> <?php echo number_format($min_price, 0, '.', ','); ?> </span>
                                <?php echo $woo_currency; ?>
                            <?php else: ?>
                                <span class="d-block"> <?php echo number_format($min_price, 0, '.', ','); ?> -
                                    <?php echo number_format($max_price, 0, '.', ','); ?> </span>
                                <?php echo $woo_currency; ?>
                            <?php endif; ?>
                        </div>

                <?php else: ?>

                   
                        <div class="price">
                            <?php if ($min_price === $max_price): ?>
                                <span class="d-block"> <?php echo number_format($min_price, 0, '.', ','); ?> </span>
                                <?php echo $woo_currency; ?>
                            <?php else: ?>
                                <span class="d-block"> <?php echo number_format($min_price, 0, '.', ','); ?> -
                                    <?php echo number_format($max_price, 0, '.', ','); ?> </span>
                                <?php echo $woo_currency; ?>
                            <?php endif; ?>
                        </div>
                    
                <?php endif; ?>
            <?php endif; ?>
        </div>
    </div>

</div>