<?php
$product = wc_get_product(get_the_ID());
$sale_price = $product->get_sale_price();
$normal_price = $product->get_regular_price();
$options = get_option('kaveh_frame');
$woo_currency = get_woocommerce_currency_symbol();
$min_regular_price = NULL;
$max_regular_price = NULL;
$min_sale_price = NULL;
$max_sale_price = NULL;
if ($product->is_type('variable')) {
  $min_regular_price = $product->get_variation_regular_price('min');
  $max_regular_price = $product->get_variation_regular_price('max');
  $min_sale_price = $product->get_variation_sale_price('min');
  $max_sale_price = $product->get_variation_sale_price('max');
}
$pr_id = get_the_ID();
$stocka = $product->get_stock_status();
?>
<div <?php wc_product_class('product product-thirteen position-relative bg-white radius-15 overflow-hidden', $product); ?>>
    <?php if ("instock" != $stocka) { ?>
        <div class="status">
            ناموجود
        </div>
    <?php } ?>
    <?php if ($product->is_on_sale()): ?>
        <div class="discount position-absolute text-white rounded-circle text-center fw-bold">
            <?php if (class_exists('kavehWoo')) {
                $offer_percentage = kavehWoo::showofferpercentage($product);
                echo $offer_percentage;
            } ?>
        </div>
    <?php endif; ?>
    <div class="product-image pt-0">
        <?php
        if (is_plugin_active('woo-smart-compare/wpc-smart-compare.php')) {
            echo do_shortcode('[woosc id="".<?php echo get_the_ID(); ?>.""]');
        } else {

        }
        ?>
        <?php
        $attachment_ids = $product->get_gallery_image_ids();
        $imurl = wp_get_attachment_url($attachment_ids[0])
            ?>
        <a href="<?php the_permalink(); ?>" class="d-block">
            <img src="<?php if(get_the_post_thumbnail_url()): ?>
<?php the_post_thumbnail_url('full'); ?>
<?php else: ?>
<?php echo wc_placeholder_img_src(); ?>
<?php endif; ?>" alt="product" class="d-block w-100 dbnone" />
            <img src="<?php echo $imurl; ?>" alt="product" class="d-none w-100 dbblock" />
        </a>
        <style>
            .product-thirteen:hover .product-image>a>img.dbnone {
                display: none !important;
            }

            .product-thirteen:hover .product-image>a>img.dbblock {
                display: block !important;
            }
        </style>
        <ul class="btns position-absolute">
            <?php
            if (!empty($normal_price)) {
                if (!$product->is_type('variable')) {
                    if ("instock" == $stocka) { ?>
                        <li>
                            <a type="submit" name="add-to-cart" value="<?php echo $pr_id ?>"
                                class="rounded-circle text-center d-block position-relative single_add_to_cart_button">
                                <i class="icon icon-cart-3"></i>
                            </a>
                        </li>
                    <?php }
                }
            } ?>
            <li>
                <a id="eyeid" type="button" value="<?php echo $pr_id; ?>"
                    class="rounded-circle text-center d-block eyeid" data-bs-toggle="modal"
                    data-bs-target="#modal-product">
                    <i class="isax isax-eye3"></i>
                </a>
            </li>
            <?php if (is_plugin_active('woo-smart-wishlist/wpc-smart-wishlist.php')) : ?>
            <li>
                <a href="javascript:void(0)" class="rounded-circle text-center d-block">
                        <?php echo do_shortcode('[woosw id="".<?php echo get_the_ID(); ?>.""]'); ?>
                </a>
            </li>
            <?php endif; ?>
        </ul>
    </div>
    <div class="detail p-0">
        <h2 class="text-center mt-0">
            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
        </h2>
        <?php if ("instock" == $stocka) { ?>
            <?php if (!$product->is_type('variable')) { ?>
        <?php if (empty($sale_price) && empty($normal_price)) { ?>
          <?php
          $price_v = $product->get_price_html(); ?>
          <div><?php
          echo str_replace("&ndash;", "<span class=\"dashvar\"> – </span>", $price_v); ?>
          </div>
          <?php
          ?>
        <?php } else { ?>
          <?php if (!empty($sale_price)) { ?>
            <div class="offer">
              <?php if (!empty($normal_price)) {
                echo number_format($normal_price, 0, '.', ',');
              } ?>
            </div>
            <div class="price">
              <?php echo number_format($sale_price, 0, '.', ','); ?>
              <span> <?php echo $woo_currency; ?> </span>
            </div>
          <?php } else { ?>
            <div class="price">
              <?php if (!empty($normal_price)) {
                echo number_format($normal_price, 0, '.', ',');
              } ?>
              <span> <?php echo $woo_currency; ?></span>
            </div>
          <?php } ?>
        <?php }
      } else {
        ?>

        

          <?php if ($product->is_on_sale()){ ?>
            <div class="offer">
              <?php if (!empty($max_regular_price)) {
                echo number_format($max_regular_price, 0, '.', ',');
              } ?>
            </div>
            <div class="price">
              <?php echo number_format($min_sale_price, 0, '.', ','); ?>
              <span> <?php echo $woo_currency; ?> </span>
            </div>
          <?php } else { ?>
            <div class="price">
          <!-- show range -->
          <?php if ($min_regular_price !== $max_regular_price): ?>
            <?php if (!empty($min_regular_price)): ?>
              <?php echo number_format($min_regular_price, 0, '.', ',') . ' - ' . number_format($max_regular_price, 0, '.', ',') . ' '; ?>
            <?php endif; ?>
          <?php else: ?>
            <?php if (!empty($min_regular_price)): ?>
              <?php echo number_format($min_regular_price, 0, '.', ',') . ' '; ?>
            <?php endif; ?>
          <?php endif; ?>
          <!-- show range -->
              <span> <?php echo $woo_currency; ?></span>
            </div>
          <?php } ?>




        <?php
      }
      
        }
        ?>
    </div>
</div>