<?php
$product = wc_get_product(get_the_ID());
$sale_price = $product->get_sale_price();
$normal_price = $product->get_regular_price();
$options = get_option('kaveh_frame');
$woo_currency = get_woocommerce_currency_symbol();
$stocka = $product->get_stock_status();
$pr_id = get_the_ID();

?>

<div <?php wc_product_class('product product-new-one position-relative bg-white d-flex flex-column', $product); ?>>
    <?php if ($product->is_on_sale()): ?>
        <div class="offer d-flex flex-column position-absolute align-items-center justify-content-center">
            <i class="icon-discount-2 d-flex align-items-center justify-content-center"></i>
            <?php 
                $offer_percentage = kavehWoo::showofferpercentage($product);
                echo $offer_percentage;
            ?>
        </div>
    <?php endif; ?>
    <div class="image">
        <a href="<?php the_permalink(); ?>" class="d-block">
            <img src="<?php if (get_the_post_thumbnail_url()): ?>
            <?php the_post_thumbnail_url('full'); ?>
            <?php else: ?>
            <?php echo wc_placeholder_img_src(); ?>
            <?php endif; ?>" alt="product" width="161" height="161" class="d-block mx-auto">
        </a>
    </div>
    <h2 class="title overflow-hidden">
        <a href="<?php the_permalink(); ?>"> <?php the_title(); ?> </a>
    </h2>
    <?php if ($product->is_type('simple')): ?>
        <?php if ($product->is_on_sale()): ?>
            <div class="d-flex align-items-center justify-content-between mt-auto">
                <?php if (!empty($normal_price)): ?>
                    <div class="offer-price">
                        <del> <?php echo number_format($normal_price, 0, '.', ','); ?> </del>
                        <div class="price">
                            <span> <?php echo number_format($sale_price, 0, '.', ','); ?> </span>
                            <?php echo $woo_currency; ?>
                        </div>
                    </div>
                    <button class="single_add_to_cart_button add-to-cart d-flex align-items-center justify-content-center" type="submit" name="add-to-cart" value="<?php echo $pr_id ?>">
                    <i class="icon-shoppin-bag"></i>
                </button>
                <?php endif; ?>
            </div>
        <?php else: ?>
            <div class="d-flex align-items-center justify-content-between mt-auto">
                <?php if (!empty($normal_price)): ?>
                    <div class="offer-price">
                        <div class="price">
                            <span> <?php echo number_format($normal_price, 0, '.', ','); ?> </span>
                            <?php echo $woo_currency; ?>
                        </div>
                    </div>
                    <button class="single_add_to_cart_button add-to-cart d-flex align-items-center justify-content-center" type="submit" name="add-to-cart" value="<?php echo $pr_id ?>">
                    <i class="icon-shoppin-bag"></i>
                </button>
                <?php endif; ?>
            </div>
        <?php endif; ?>
    <?php elseif ($product->is_type('variable')): ?>
        <?php
        $min_price = $product->get_variation_price('min', true);
        $max_price = $product->get_variation_price('max', true);
        ?>
        <div class="d-flex align-items-center justify-content-between mt-auto">
            <?php if (!empty($min_price)): ?>
                <?php if (!$product->is_on_sale()): ?>

                    
                        <div class="offer-price">
                            <div class="price">
                                <?php if ($min_price === $max_price): ?>
                                    <span> <?php echo number_format($min_price, 0, '.', ','); ?> </span>
                                    <?php echo $woo_currency; ?>
                                <?php else: ?>
                                    <span> <?php echo number_format($min_price, 0, '.', ','); ?> -
                                        <?php echo number_format($max_price, 0, '.', ','); ?> </span>
                                    <?php echo $woo_currency; ?>
                                <?php endif; ?>
                            </div>
                        </div>

                <?php else: ?>


                        <div class="offer-price">
                            <div class="price">
                                <?php if ($min_price === $max_price): ?>
                                    <span> <?php echo number_format($min_price, 0, '.', ','); ?> </span>
                                    <?php echo $woo_currency; ?>
                                <?php else: ?>
                                    <span> <?php echo number_format($min_price, 0, '.', ','); ?> -
                                        <?php echo number_format($max_price, 0, '.', ','); ?> </span>
                                    <?php echo $woo_currency; ?>
                                <?php endif; ?>
                            </div>
                        </div>

                <?php endif; ?>
                <a href="<?php echo esc_url(get_the_permalink()); ?>"
                    class="add-to-cart d-flex align-items-center justify-content-center">
                    <i class="icon-shoppin-bag"></i>
                </a>
            <?php endif; ?>
        </div>
    <?php else: ?>

    <?php endif; ?>


</div>