<?php
get_header();
while (have_posts()) {
    the_post();
    $tags = get_the_tags();
    if ($tags) {
        $tag_name = esc_html($tag->name);
    }
    $post_id = get_the_ID();
    $content = get_post_field('post_content', $post_id);
    $pattern = '/[\x{0600}-\x{06FF}]+/u'; // Unicode range for Persian script
    preg_match_all($pattern, $content, $matches);
    $word_count = count($matches[0]);
    $reading_time = ceil($word_count / 200);
    $categories = get_the_category(); // Get categories assigned to the post
    $category_name = !empty($categories) ? $categories[0]->name : ''; // Retrieve the first category name
    ?>
    <section class="detail-blog mt-4">
        <div class="container position-relative">
            <?php if (class_exists('kavehTheme')) {
                $breadcrumbs = kavehTheme::get_breadcrumb();
                echo $breadcrumbs;
            } ?>
            <div class="detail-blog-wrapper position-relative">
                <!-- Start Info -->
                <div class="detail-blog-info">
                    <img src="<?php the_post_thumbnail_url('full'); ?>"
                        alt="<?php echo get_the_title(); ?>" class="w-100 d-block" />
                    <div class="detail d-flex align-items-center justify-content-center">
                        <a href="javascript:void(0)" class="category">
                            <?php if (!empty($tag_name)):
                                echo $tag_name; endif; ?>
                        </a>
                        <ul class="d-flex align-items-center">
                            <li>
                                <div class="detail">
                                    <span>
                                        <?php
                                        // دسته‌بندی‌ها
                                        esc_html_e('Categories', 'kavehTheme');
                                        ?>
                                    </span>
                                    <a href="javascript:void(0)"> <?php echo $category_name; ?></a>
                                </div>
                            </li>
                            <li>
                                <i class="icon-user"></i>
                                <div class="detail">
                                    <span>
                                        <?php
                                        // نویسنده
                                        esc_html_e('Author', 'kavehTheme');
                                        ?>
                                    </span>
                                    <a href="javascript:void(0)"> <?php the_author(); ?> </a>
                                </div>
                            </li>
                            <li>
                                <div class="detail">
                                    <span>
                                        <?php
                                        // زمان مورد نیاز برای مطالعه
                                        esc_html_e('Estimated Reading Time', 'kavehTheme');
                                        ?>
                                    </span>
                                    <span>
                                        <b> <?php echo $reading_time; ?> </b>
                                        <?php
                                        // دقیقه
                                        esc_html_e('minutes', 'kavehTheme');
                                        ?>
                                    </span>
                                </div>
                            </li>
                        </ul>
                        <span class="date"> <?php echo get_the_date(); ?> </span>
                    </div>
                </div>
                <!-- End Info -->
                <h1 class="detail-blog-name"> <?php the_title(); ?></h1>
                <!-- Start Content -->
                <div class="detail-blog-content">
                    <?php the_content(); ?>
                </div>
                <!-- End Content -->
            </div>
        </div>
        <!-- Start Related Articles -->
        <div class="detail-blog-related overflow-hidden">
            <div class="container position-relative">
                <!-- Start Heading -->
                <div class="heading d-flex align-items-center justify-content-between">
                    <h4 class="fw-bold position-relative">
                        <span class="fw-light d-block">
                            <?php
                            // مطالب
                            esc_html_e('Articles', 'kavehTheme');
                            ?>
                        </span>
                        <?php
                        // مرتبط
                        esc_html_e('Related', 'kavehTheme');
                        ?>
                    </h4>
                    <a href="javascript:void(0)" class="btn btn-outline-dark rounded-pill">
                        <?php
                        // مشاهده همه
                        esc_html_e('View All', 'kavehTheme');
                        ?>
                    </a>
                </div>
                <!-- End Heading -->
                <div class="detail-blog-related-wrapper">
                    <div class="swiper swiper-related-articles"
                        data-swiper='{"loop":true,"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"breakpoints":{"320":{"slidesPerView":1,"spaceBetween":4},"768":{"slidesPerView":2,"spaceBetween":12},"992":{"slidesPerView":2,"spaceBetween":30}}}'>
                        <div class="swiper-wrapper">
                            <?php
                            // WP_Query args
                            $q_querylast_args = array(
                                'post_type' => array('post'),
                                'posts_per_page' => 5,
                                'order' => 'DESC',
                                'orderby' => 'date',
                            );

                            // The Query
                            $querylast = new WP_Query($q_querylast_args);

                            // The Loop
                            if ($querylast->have_posts()) {
                                while ($querylast->have_posts()) {
                                    $querylast->the_post();
                                    $categories = get_the_category(); // Get categories assigned to the post
                                    $category_name = !empty($categories) ? $categories[0]->name : ''; // Retrieve the first category name
                        
                                    ?>
                                    <div class="swiper-slide">
                                        <article class="article">
                                            <figure>
                                                <?php if (has_post_thumbnail(get_the_ID())) { ?>
                                                    <a href="<?php the_permalink(); ?>">
                                                        <img src="<?php the_post_thumbnail_url('full'); ?>" alt="<?php the_title(); ?>"
                                                            class="d-flex w-100" />
                                                    </a>
                                                <?php } ?>
                                                <div class="category-time">
                                                    <a href="javascript:void(0)">
                                                        <?php echo $category_name; ?>
                                                    </a>
                                                    <span><?php echo get_the_date(); ?></span>
                                                </div>
                                            </figure>
                                            <h2>
                                                <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                                            </h2>
                                            <p><?php echo get_the_excerpt(); ?></p>
                                        </article>
                                    </div>
                                    <?php
                                }
                            } else {
                                // There are no posts
                            }
                            // Reset Original Post Data
                            wp_reset_postdata();
                            ?>
                        </div>
                        <div class="swiper-button-next"></div>
                        <div class="swiper-button-prev"></div>
                    </div>
                </div>
            </div>
        </div>
        <!-- End Related Articles -->
        <?php comments_template(); ?>
    </section>

<?php }
get_footer();