<?php /* Template Name: Kaveh Login Template */
get_header();
$options = get_option('kaveh_frame');
$bglogin = $options['bglogin'];
?>
<style>
  .bg__four {
    background: #eef1f4;
    <?php if (empty($bglogin)): ?>
      background-image: url("<?php echo KAVEH_TEMPLATE_URI . '/assets/images/bglogink.jpg'; ?>") !important;
    <?php else: ?>
      background-image: url("<?php echo $bglogin; ?>") !important;
    <?php endif; ?>
    background-repeat: no-repeat;
    background-size: cover;
  }
</style>
<div class="auth__body bg__four">
    <div class="auth__page">
        <div class="auth__page__wrapper">
            <div class="auth__page__twelve auth__mx__auto loadlogin">
                <!-- Logo Section -->
                <a href="<?php echo esc_url(home_url()); ?>" class="auth__page__twelve__logo auth__block auth__mx__auto auth__w__fit auth__absolute">
                    <img src="<?php echo esc_url($options['kaveh_logo_up']); ?>" alt="<?php esc_attr_e('logo', 'kavehTheme'); ?>" width="127" height="40">
                </a>

                <div class="auth__page__twelve__wrapper auth__relative">
                    <!-- Tabs -->
                    <ul class="auth__page__twelve__tabs auth__flex auth__items__center auth__content__center">
                        <li class="active auth__ease__in__out" data-auth-toggle="tab" data-auth-target="login">
                            <?php esc_html_e('Login with SMS', 'kavehTheme'); // ورود با پیامک ?>
                        </li>
                        <li class="auth__ease__in__out" data-auth-toggle="tab" data-auth-target="register">
                            <?php esc_html_e('Login with Password', 'kavehTheme'); // ورود با رمز ?>
                        </li>
                    </ul>

                    <!-- Content -->
                    <div class="auth__page__twelve__content">
                        <div class="auth__tab__content">
                            <?php if ($options['kaveh_login_type'] === 'option-1' || $options['kaveh_login_type'] === 'option-3'): ?>
                                <!-- Login Tab Content -->
                                <div id="login" class="active auth__tab__pane">
                                    <img src="<?php echo esc_url(KAVEH_TEMPLATE_URI) . '/assets/images/user-avatar.svg'; ?>" alt="<?php esc_attr_e('user', 'kavehTheme'); ?>" width="105" height="105" class="auth__block auth__mx__auto">
                                    <form class="smslogin" method="post" action="#">
                                        <div class="auth__page__form__group position-relative">
                                            <i class="isax isax-user iabs"></i>
                                            <input id="phone" type="text" class="auth__page__form__control auth__ease__in__out" placeholder="<?php esc_attr_e('Enter your phone number...', 'kavehTheme'); // شماره همراه را وارد کنید ... ?>">
                                        </div>
                                        <button type="submit" class="auth__page__btn auth__page__btn__success auth__w__fit auth__block">
                                            <?php esc_html_e('Get Verification Code', 'kavehTheme'); // دریافت کد تایید ?>
                                        </button>
                                    </form>
                                </div>

                                <!-- Register Tab Content -->
                                <div id="register" class="auth__tab__pane">
                                    <img src="<?php echo esc_url(KAVEH_TEMPLATE_URI) . '/assets/images/user-avatar.svg'; ?>" alt="<?php esc_attr_e('user', 'kavehTheme'); ?>" width="105" height="105" class="auth__block auth__mx__auto">
                                    <form class="passlogin" method="post" action="#">
                                        <div class="auth__page__form__group position-relative">
                                            <i class="iconly iconly-Message iabs"></i>
                                            <input type="text" id="email" class="auth__page__form__control auth__ease__in__out" placeholder="<?php esc_attr_e('Enter a valid mobile number or email', 'kavehTheme'); // موبایل یا ایمیل معتبر ?>">
                                        </div>
                                        <div class="auth__page__form__group position-relative">
                                            <i class="iconly iconly-Password iabs"></i>
                                            <input type="password" id="password" class="auth__page__form__control auth__ease__in__out" placeholder="<?php esc_attr_e('Enter your password...', 'kavehTheme'); // رمز عبور را وارد کنید ... ?>">
                                        </div>
                                        <a href="javascript:void(0)" class="link auth__flex auth__items__center auth__ease__in__out forgotk">
                                            <i class="isax isax-lock-1"></i>
                                            <?php esc_html_e('Forgot your password?', 'kavehTheme'); // رمز عبور را فراموش کرده‌اید؟ ?>
                                        </a>
                                        <button type="submit" class="auth__page__btn auth__page__btn__success auth__w__fit auth__block">
                                            <?php esc_html_e('Login / Register', 'kavehTheme'); // ورود / ثبت نام ?>
                                        </button>
                                    </form>
                                </div>
                            <?php elseif ($options['kaveh_login_type'] === 'option-2'): ?>
                                <!-- SMS Login Only -->
                                <div id="login" class="auth__tab__pane">
                                    <img src="<?php echo esc_url(KAVEH_TEMPLATE_URI) . '/assets/images/user-avatar.svg'; ?>" alt="<?php esc_attr_e('user', 'kavehTheme'); ?>" width="105" height="105" class="auth__block auth__mx__auto">
                                    <form class="smslogin" method="post" action="#">
                                        <div class="auth__page__form__group position-relative">
                                            <input id="phone" type="text" class="auth__page__form__control auth__ease__in__out" placeholder="<?php esc_attr_e('Enter your phone number...', 'kavehTheme'); // شماره همراه را وارد کنید ... ?>">
                                        </div>
                                        <button type="submit" class="auth__page__btn auth__page__btn__success auth__w__fit auth__block">
                                            <?php esc_html_e('Get Verification Code', 'kavehTheme'); // دریافت کد تایید ?>
                                        </button>
                                    </form>
                                </div>

                                <!-- Password Login Active -->
                                <div id="register" class="active auth__tab__pane">
                                    <img src="<?php echo esc_url(KAVEH_TEMPLATE_URI) . '/assets/images/user-avatar.svg'; ?>" alt="<?php esc_attr_e('user', 'kavehTheme'); ?>" width="105" height="105" class="auth__block auth__mx__auto">
                                    <form class="passlogin" method="post" action="#">
                                        <div class="auth__page__form__group position-relative">
                                            <i class="iconly iconly-Message iabs"></i>
                                            <input type="text" id="email" class="auth__page__form__control auth__ease__in__out" placeholder="<?php esc_attr_e('Enter a valid mobile number or email', 'kavehTheme'); // موبایل یا ایمیل معتبر ?>">
                                        </div>
                                        <div class="auth__page__form__group position-relative">
                                            <i class="iconly iconly-Password iabs"></i>
                                            <input type="password" id="password" class="auth__page__form__control auth__ease__in__out" placeholder="<?php esc_attr_e('Enter your password...', 'kavehTheme'); // رمز عبور را وارد کنید ... ?>">
                                        </div>
                                        <a href="javascript:void(0)" class="link auth__flex auth__items__center auth__ease__in__out forgotk">
                                            <i class="isax isax-lock-1"></i>
                                            <?php esc_html_e('Forgot your password?', 'kavehTheme'); // رمز عبور را فراموش کرده‌اید؟ ?>
                                        </a>
                                        <button type="submit" class="auth__page__btn auth__page__btn__success auth__w__fit auth__block">
                                            <?php esc_html_e('Login / Register', 'kavehTheme'); // ورود / ثبت نام ?>
                                        </button>
                                    </form>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php get_footer();
