<?php
get_header();
$options = get_option('kaveh_frame');
if (!empty($options['kaveh_bl_cart_select'])) {
  $mkblogcart = $options['kaveh_bl_cart_select'];
}
if (!empty($options['blog-pic-repeater'])) {
  $blogslider = $options['blog-pic-repeater'];
}
?>
<!-- Start Blog -->
<div class="blog mt-4">
  <div class="container">
    <?php if ($options['search_kaveh_blog_switch_slides'] === '1'): ?>
      <!-- Start Slider -->
      <div class="swiper swiper-blog position-relative"
        data-swiper='{"slidesPerView":3,"spaceBetween":0,"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"pagination":{"el":".swiper-pagination","type":"bullets","clickable":true},"autoplay":{"delay":3000},"effect":"fade","fadeEffect":{"crossFade":true},"loop":true}'>
        <div class="swiper-wrapper">
          <?php
          if (!empty($options['blog-pic-repeater'])) {
            for ($i = 0; $i < count($blogslider); $i++) {
              ?>
              <div class="swiper-slide">
                <a href="javascript:void(0)">
                  <img src="<?php echo esc_url($blogslider[$i]['blog-pic']); ?>"
                    alt="<?php esc_attr_e('article', 'kavehTheme'); ?>" class="d-block w-100" />
                </a>
              </div>
              <?php
            }
          }
          ?>
        </div>
        <div class="swiper-pagination d-none d-md-block"></div>
        <div class="swiper-button-next d-none d-md-block"></div>
        <div class="swiper-button-prev d-none d-md-block"></div>
      </div>
      <!-- End Slider -->
    <?php else: ?>
      <div class="mb-4"></div>
    <?php endif; ?>
    <!-- Start Articles -->
    <button type="button" class="btn manblog category-btn-filter mb-4">
      <i class="icon-filter"></i>
      <?php esc_html_e('Filter Posts', 'kavehTheme'); ?>
    </button>
    <aside class="category-sidebar">
      <div class="category-sidebar-backdrop"></div>
      <div class="category-sidebar-content">
        <?php get_sidebar('blog') ?>
    </aside>
    <div class="row">
      <?php
      if (have_posts()) {
        while (have_posts()) {
          the_post();
          if (!empty($options['kaveh_bl_cart_select'])) {
            ?>
            <div class="col-lg-6 mb-4">
              <?php
              switch ($mkblogcart):
                case "value-1":
                  get_template_part("template-part/blog-cart-one");
                  break;
                case "value-2":
                  get_template_part("template-part/blog-cart-two");
                  break;
                case "value-3":
                  get_template_part("template-part/blog-cart-three");
                  break;
                case "value-4":
                  get_template_part("template-part/blog-cart-four");
                  break;
                case "value-5":
                  get_template_part("template-part/blog-cart-five");
                  break;
                case "value-6":
                  get_template_part("template-part/blog-cart-six");
                  break;
                case "value-7":
                  get_template_part("template-part/blog-cart-seven");
                  break;
                case "value-8":
                  get_template_part("template-part/blog-cart-eight");
                  break;
                case "value-9":
                  get_template_part("template-part/blog-cart-nine");
                  break;
              endswitch;
              ?>
            </div>
          <?php }
        } // end while
      } // end if
      ?>
    </div>
    <!-- End Articles -->
    <!-- Start Pagination -->
    <?php
    $args = array(
        'mid_size'  => 2,
        'prev_text' => __('Previous', 'kavehTheme'),
        'next_text' => __('Next', 'kavehTheme'),
        'screen_reader_text' => __('Posts navigation', 'kavehTheme'),
    );

    echo '<ul class="pagination justify-content-center mt-5 mb-5">';
    the_posts_pagination($args);
    echo '</ul>';
    ?>
    <!-- End Pagination -->

  </div>
</div>
<!-- End Blog -->
<?php
get_footer();
?>