<?php
// Brand Filter Widget
class Brand_Filter_Widget extends WP_Widget
{

    // Widget setup
    public function __construct()
    {
        $widget_options = array(
            'classname' => 'brand-filter-widget',
            'description' => 'Adds a widget for filtering products based on brands.',
        );
        parent::__construct('brand_filter_widget', 'فیلتر محصولات کاوه بر اساس برند', $widget_options);
    }

    // Output the widget
    public function widget($args, $instance)
    {
        echo $args['before_widget'];

        // Widget content
        ?>
        <div class="category-sidebar-box boxme">
            <div class="category-sidebar-box-heading">
                <i class="icon-filter"></i>
                <?php echo esc_html($instance['title']); ?>
            </div>
            <div class="category-sidebar-box-body">
                <ul class="category-sidebar-box-items brandhidden">
                    <input class="filterhiddeninputbrand" type="hidden" id="filters-brand" />
                    <?php
                    $current_brand = get_queried_object(); // Get the current brand object
                    $parent_id = 0;

                    if (is_object($current_brand) && isset($current_brand->term_id)) {
                        $parent_id = $current_brand->term_id;
                    }

                    $this->display_subbrands($parent_id);
                    ?>
                </ul>
            </div>
        </div>
        <?php

        echo $args['after_widget'];
    }

    // Recursive function to display subbrands
    public function display_subbrands($parent_id)
    {
        $subbrands = get_categories(array(
            'taxonomy' => 'brands',
            'parent' => $parent_id,
            'hide_empty' => false,
        ));

        if (!empty($subbrands)) {
            foreach ($subbrands as $brand) {
                $sub_subbrands = get_categories(array(
                    'taxonomy' => 'brands',
                    'parent' => $brand->term_id,
                    'hide_empty' => false,
                ));
                ?>
                <li class="<?php echo !empty($sub_subbrands) ? 'has-child' : ''; ?>">
                    <div class="form-check">
                        <input type="checkbox" name="brand" id="brand-<?php echo $brand->term_id; ?>"
                            myid="<?php echo $brand->term_id; ?>" class="form-check-input" />
                        <label for="brand-<?php echo $brand->term_id; ?>" class="form-check-label"><?php echo $brand->name; ?></label>
                    </div>
                    <?php if (!empty($sub_subbrands)): ?>
                        <span></span>
                        <ul>
                            <?php $this->display_subbrands($brand->term_id); ?>
                        </ul>
                    <?php endif; ?>
                </li>
                <?php
            }
        }
    }

    // Update the widget
    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['title'] = !empty($new_instance['title']) ? sanitize_text_field($new_instance['title']) : '';
        return $instance;
    }

    // Widget form
    public function form($instance)
    {
        $title = !empty($instance['title']) ? $instance['title'] : '';

        // Widget title field
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">عنوان ویجت</label>
            <input type="text" class="widefat" id="<?php echo $this->get_field_id('title'); ?>"
                name="<?php echo $this->get_field_name('title'); ?>" value="<?php echo esc_attr($title); ?>">
        </p>
        <?php
    }
}

// Category Filter Widget
class Category_Filter_Widget extends WP_Widget
{

    // Widget setup
    public function __construct()
    {
        $widget_options = array(
            'classname' => 'category-filter-widget',
            'description' => 'Adds a widget for filtering products based on categories.',
        );
        parent::__construct('category_filter_widget', 'فیلتر محصولات کاوه بر اساس دسته بندی', $widget_options);
    }

    // Output the widget
    public function widget($args, $instance)
    {
        echo $args['before_widget'];

        // Widget content
        ?>
        <div class="category-sidebar-box boxme">
            <div class="category-sidebar-box-heading">
                <i class="icon-filter"></i>
                <?php echo esc_html($instance['title']); ?>
            </div>
            <div class="category-sidebar-box-body">
                <ul class="category-sidebar-box-items cathidden">
                    <input class="filterhiddeninput" type="hidden" id="filters-category" />
                    <?php
                    $current_category = get_queried_object(); // Get the current category object
                    $parent_id = 0;

                    if (is_object($current_category) && isset($current_category->term_id)) {
                        $parent_id = $current_category->term_id;
                    }

                    $this->display_subcategories($parent_id);
                    ?>
                </ul>
            </div>
        </div>
        <?php

        echo $args['after_widget'];
    }

    // Recursive function to display subcategories
    public function display_subcategories($parent_id)
    {
        $subcategories = get_categories(array(
            'taxonomy' => 'product_cat',
            'parent' => $parent_id,
            'hide_empty' => false,
        ));

        if (!empty($subcategories)) {
            foreach ($subcategories as $category) {
                $sub_subcategories = get_categories(array(
                    'taxonomy' => 'product_cat',
                    'parent' => $category->term_id,
                    'hide_empty' => false,
                ));
                ?>
                <li class="<?php echo !empty($sub_subcategories) ? 'has-child' : ''; ?>">
                    <div class="form-check">
                        <input type="checkbox" name="category" id="category-<?php echo $category->term_id; ?>"
                            myid="<?php echo $category->term_id; ?>" class="form-check-input" />
                        <label for="category-<?php echo $category->term_id; ?>"
                            class="form-check-label"><?php echo $category->name; ?></label>
                    </div>
                    <?php if (!empty($sub_subcategories)): ?>
                        <span></span>
                        <ul>
                            <?php $this->display_subcategories($category->term_id); ?>
                        </ul>
                    <?php endif; ?>
                </li>
                <?php
            }
        }
    }


    // Update the widget
    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['title'] = !empty($new_instance['title']) ? sanitize_text_field($new_instance['title']) : '';
        return $instance;
    }

    // Widget form
    public function form($instance)
    {
        $title = !empty($instance['title']) ? $instance['title'] : '';

        // Widget title field
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">عنوان ویجت</label>
            <input type="text" class="widefat" id="<?php echo $this->get_field_id('title'); ?>"
                name="<?php echo $this->get_field_name('title'); ?>" value="<?php echo esc_attr($title); ?>">
        </p>
        <?php
    }
}

// WooCommerce Attribute Widget
class WooCommerce_Attribute_Widget extends WP_Widget
{

    // Widget setup
    public function __construct()
    {
        $widget_options = array(
            'classname' => 'woocommerce-attribute-widget',
            'description' => 'Adds a widget for selecting WooCommerce attributes and filtering products.',
        );
        parent::__construct('woocommerce_attribute_widget', 'فیلتر محصولات بر اساس ویژگی کاوه', $widget_options);
    }

    // Output the widget
    public function widget($args, $instance)
    {

        // Widget content
        $selected_attribute = isset($instance['selected_attribute']) ? $instance['selected_attribute'] : '';
        if ($selected_attribute) {
            $terms = get_terms(array(
                'taxonomy' => 'pa_' . $selected_attribute,
                'hide_empty' => false,
            ));

            if (!empty($terms)) {
                ?>
                <div class="category-sidebar-box boxme">
                    <div class="category-sidebar-box-heading">
                        <i class="icon-filter"></i>
                        <?php echo $instance['title']; ?>
                    </div>
                    <div class="category-sidebar-box-body">
                        <ul class="category-sidebar-box-items attrhidden">
                            <input class="attrhiddeninput" type="hidden" id="filters-category"
                                taxid="<?php echo 'pa_' . $selected_attribute; ?>" />
                            <?php foreach ($terms as $term): ?>
                                <li>
                                    <div class="form-check">
                                        <input type="checkbox" name="category" id="category-<?php echo $term->slug; ?>"
                                            myid="<?php echo $term->slug; ?>" class="form-check-input" />
                                        <label for="category-<?php echo $term->slug; ?>"
                                            class="form-check-label"><?php echo $term->name; ?></label>
                                    </div>
                                </li>
                            <?php endforeach; ?>

                        </ul>
                    </div>
                </div>
                <?php
            }
        }

        echo $args['after_widget'];
    }

    // Update the widget
    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['title'] = !empty($new_instance['title']) ? sanitize_text_field($new_instance['title']) : '';
        $instance['selected_attribute'] = !empty($new_instance['selected_attribute']) ? sanitize_text_field($new_instance['selected_attribute']) : '';
        return $instance;
    }

    // Widget form
    public function form($instance)
    {
        $title = !empty($instance['title']) ? $instance['title'] : '';
        $selected_attribute = !empty($instance['selected_attribute']) ? $instance['selected_attribute'] : '';

        // Widget title field
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">عنوان ویجت</label>
            <input type="text" class="widefat" id="<?php echo $this->get_field_id('title'); ?>"
                name="<?php echo $this->get_field_name('title'); ?>" value="<?php echo esc_attr($title); ?>">
        </p>
        <p>
            <label for="<?php echo $this->get_field_id('selected_attribute'); ?>">Select Attribute:</label>
            <select class="widefat" id="<?php echo $this->get_field_id('selected_attribute'); ?>"
                name="<?php echo $this->get_field_name('selected_attribute'); ?>">
                <option value="">Select Attribute</option>
                <?php
                $attributes = wc_get_attribute_taxonomies(); // Get all WooCommerce attributes
        
                foreach ($attributes as $attribute) {
                    $attribute_name = $attribute->attribute_name;
                    $selected = $selected_attribute === $attribute_name ? 'selected' : '';
                    ?>
                    <option value="<?php echo $attribute_name; ?>" <?php echo $selected; ?>><?php echo $attribute_name; ?></option>
                    <?php
                }
                ?>
            </select>
        </p>
        <?php
    }
}

// Range Price Widget
class Range_Price_Widget extends WP_Widget
{

    // Widget setup
    public function __construct()
    {
        $widget_options = array(
            'classname' => 'range-price-widget',
            'description' => 'Adds a widget for filtering products based on price range.',
        );
        parent::__construct('range_price_widget', 'بر اساس قیمت', $widget_options);
    }

    // Output the widget
    public function widget($args, $instance)
    {

        // Widget content
        ?>
        <div class="category-sidebar-box filter-price">
            <div class="category-sidebar-box-heading">
                <i class="icon-filter"></i>
                <?php echo $instance['title']; ?>
            </div>
            <div class="category-sidebar-box-body">
                <div id="category-price"></div>
                <div class="filter-price-value d-flex align-items-center">
                    <span> از </span>
                    <input type="text" id="category-price-min" class="form-control text-left" />
                </div>
                <div class="filter-price-value d-flex align-items-center">
                    <span> تا </span>
                    <input type="text" id="category-price-max" class="form-control text-left" />
                </div>
            </div>
        </div>
        <?php

        echo $args['after_widget'];
    }

    // Update the widget
    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['title'] = !empty($new_instance['title']) ? sanitize_text_field($new_instance['title']) : '';
        return $instance;
    }

    // Widget form
    public function form($instance)
    {
        $title = !empty($instance['title']) ? $instance['title'] : '';

        // Widget title field
        ?>
        <p>
            <label for="<?php echo $this->get_field_id('title'); ?>">عنوان ویجت</label>
            <input type="text" class="widefat" id="<?php echo $this->get_field_id('title'); ?>"
                name="<?php echo $this->get_field_name('title'); ?>" value="<?php echo esc_attr($title); ?>">
        </p>
        <?php
    }
}

// Fast Send Widget
class Fast_Send_Widget extends WP_Widget
{

    // Widget setup
    public function __construct()
    {
        $widget_options = array(
            'classname' => 'fast-send-widget',
            'description' => 'Adds a widget for filtering products by "Only Sale" option.',
        );
        parent::__construct('fast_send_widget', 'فقط تخفیف دار ها', $widget_options);
    }

    // Output the widget
    public function widget($args, $instance)
    {
        echo $args['before_widget'];

        // Widget content
        ?>
        <div class="category-sidebar-box">
            <div class="category-sidebar-box-heading">
                <div class="form-check form-switch">
                    <input class="form-check-input" type="checkbox" id="onlysale">
                    <label class="form-check-label" for="onlysale"> فقط تخفیف دار ها </label>
                </div>
            </div>
        </div>
        <?php

        echo $args['after_widget'];
    }

    // Update the widget
    public function update($new_instance, $old_instance)
    {
        $instance = array();
        return $instance;
    }

    // Widget form
    public function form($instance)
    {
        // No options to configure
    }
}

// Exists Products Widget
class Exists_Products_Widget extends WP_Widget
{

    // Widget setup
    public function __construct()
    {
        $widget_options = array(
            'classname' => 'exists-products-widget',
            'description' => 'Adds a widget for filtering products by "Exists Products" option.',
        );
        parent::__construct('exists_products_widget', 'فقط موجود ', $widget_options);
    }

    // Output the widget
    public function widget($args, $instance)
    {
        echo $args['before_widget'];

        // Widget content
        ?>
        <div class="category-sidebar-box exists-products">
            <div class="category-sidebar-box-heading">
                <div class="form-check form-switch">
                    <input class="form-check-input" type="checkbox" id="exists-products">
                    <label class="form-check-label" for="exists-products"> فقط کالاهای موجود </label>
                </div>
            </div>
        </div>
        <?php

        echo $args['after_widget'];
    }

    // Update the widget
    public function update($new_instance, $old_instance)
    {
        $instance = array();
        return $instance;
    }

    // Widget form
    public function form($instance)
    {
        // No options to configure
    }
}

// Latest Articles Widget
class Latest_Articles_Widget extends WP_Widget
{

    // Widget setup
    public function __construct()
    {
        $widget_options = array(
            'classname' => 'latest-articles-widget',
            'description' => 'Adds a widget for displaying the latest articles.',
        );
        parent::__construct('latest_articles_widget', 'آخرین مقالات', $widget_options);
    }

    // Output the widget
    public function widget($args, $instance)
    {
        echo $args['before_widget'];
        echo $args['before_title'] . $instance['title'] . $args['after_title'];

        // Widget content
        ?>
        <div class="lapost">
            <h5>آخرین مقالات</h5>
            <p>آخرین اخبار منتشر شده</p>
            <ul class="footer-three-articles">
                <?php
                // WP_Query args
                $q_query_args = array(
                    'post_type' => array('post'),
                    'posts_per_page' => 4,
                    'order' => 'DESC',
                    'orderby' => 'date',
                );
                // The Query
                $query = new WP_Query($q_query_args);
                // The Loop
                if ($query->have_posts()) {
                    while ($query->have_posts()) {
                        $query->the_post();
                        ?>
                        <li class="d-flex align-items-center">
                            <img src="<?php the_post_thumbnail_url('full'); ?>" alt="article" class="d-block w-100" />
                            <div class="detail w-100">
                                <h2 class="mb-0 text-nowrap overflow-hidden">
                                    <a href="<?php the_permalink(); ?>"><?php $tit = the_title();
                                      echo wp_trim_words($tit, 6) ?></a>
                                </h2>
                                <span
                                    class="d-block text-nowrap overflow-hidden"><?php $exp = get_the_excerpt();
                                    echo wp_trim_words($exp, 7) ?></span>
                            </div>
                        </li>
                        <?php
                    }
                }
                // Reset Original Post Data
                wp_reset_postdata();
                ?>
            </ul>
        </div>
        <?php

        echo $args['after_widget'];
    }

    // Update the widget
    public function update($new_instance, $old_instance)
    {
        $instance = array();
        $instance['title'] = !empty($new_instance['title']) ? sanitize_text_field($new_instance['title']) : '';
        return $instance;
    }

    // Widget form
    public function form($instance)
    {
        $title = !empty($instance['title']) ? $instance['title'] : '';

        // Widget title field

    }
}

// Blog Category Widget
class Blog_Category_Widget extends WP_Widget
{

    // Widget setup
    public function __construct()
    {
        $widget_options = array(
            'classname' => 'blog-category-widget',
            'description' => 'Adds a widget for displaying blog categories.',
        );
        parent::__construct('blog_category_widget', 'دسته بندی وبلاگ', $widget_options);
    }

    // Output the widget
    public function widget($args, $instance)
    {
        echo $args['before_widget'];

        // Widget content
        ?>
        <div class="lapost">
            <div class="category-sidebar-box">
                <div class="category-sidebar-box-heading">
                    <i class="icon-filter"></i>
                    دسته بندی وبلاگ
                </div>
                <div class="category-sidebar-box-body">
                    <ul class="category-sidebar-box-items">
                        <?php $categories = get_categories(); ?>
                        <?php foreach ($categories as $category): ?>
                            <li>
                                <a href="<?php echo home_url() . "/category/" . $category->slug; ?>">
                                    <?php echo $category->name; ?>
                                </a>
                            </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
            </div>
        </div>
        <?php

        echo $args['after_widget'];
    }

    // Update the widget
    public function update($new_instance, $old_instance)
    {
        $instance = array();
        return $instance;
    }

    // Widget form
    public function form($instance)
    {
        // No options to configure
    }
}