<?php
/**
 * OceanWP_Theme_Compatibility setup
 *
 * @package ag-theme-builder
 */

/**
 * Ag theme compatibility.
 */
class OceanWP_Theme_Compatibility {

	/**
	 * Instance of OceanWP_Theme_Compatibility.
	 *
	 * @var OceanWP_Theme_Compatibility
	 */
	private static $instance;

	/**
	 *  Initiator
	 */
	public static function instance() {
		if ( ! isset( self::$instance ) ) {
			self::$instance = new OceanWP_Theme_Compatibility();

			add_action( 'wp', array( self::$instance, 'hooks' ) );
		}

		return self::$instance;
	}

	/**
	 * Run all the Actions / Filters.
	 */
	public function hooks() {

		if ( get_post_type() === 'ag-themer' || ( \Elementor\Plugin::$instance->preview->is_preview_mode() && ag_theme_builder_is_singular_enabled() ) ) {
			add_filter( 'single_template', array( $this, 'blank_template' ) );
			return;
		}

		if ( ag_theme_builder_header_enabled() ) {
			remove_action( 'ocean_top_bar', 'oceanwp_top_bar_template' );
			remove_action( 'ocean_header', 'oceanwp_header_template' );
			remove_action( 'ocean_page_header', 'oceanwp_page_header_template' );
			add_action( 'ocean_header', 'ag_theme_builder_render_header' );
		}

		if ( ag_theme_builder_footer_enabled() ) {

			remove_action( 'ocean_footer', 'oceanwp_footer_template' );
			add_action( 'ocean_footer', 'ag_theme_builder_render_footer' );
		}

		if ( ag_theme_builder_is_singular_enabled() ) {

			add_filter( 'page_template', array( $this, 'empty_template' ) );
			add_filter( 'single_template', array( $this, 'empty_template' ) );
			add_filter( '404_template', array( $this, 'empty_template' ) );
			add_filter( 'frontpage_template', array( $this, 'empty_template' ) );

			if ( defined( 'WOOCOMMERCE_VERSION' ) && ( is_product() || is_cart() || is_checkout() || is_account_page() ) ) {
				add_action( 'template_redirect', array( $this, 'woo_template' ), 999 );
				add_action( 'template_include', array( $this, 'woo_template' ), 999 );
			}
		}

		if ( ag_theme_builder_is_archive_enabled() ) {

			add_filter( 'search_template', array( $this, 'empty_template' ) );
			add_filter( 'date_template', array( $this, 'empty_template' ) );
			add_filter( 'author_template', array( $this, 'empty_template' ) );
			add_filter( 'archive_template', array( $this, 'empty_template' ) );
			add_filter( 'category_template', array( $this, 'empty_template' ) );
			add_filter( 'tag_template', array( $this, 'empty_template' ) );
			add_filter( 'home_template', array( $this, 'empty_template' ) );

			if ( defined( 'WOOCOMMERCE_VERSION' ) && is_shop() || ( is_tax( 'product_cat' ) && is_product_category() ) || ( is_tax( 'product_tag' ) && is_product_tag() ) ) {
				add_action( 'template_redirect', array( $this, 'woo_template' ), 999 );
				add_action( 'template_include', array( $this, 'woo_template' ), 999 );
			}
		}
	}

	public function blank_template( $template ) {

		global $post;

		if ( file_exists( AG_THEME_BUILDER_DIR . 'inc/templates/blank.php' ) ) {
			return AG_THEME_BUILDER_DIR . 'inc/templates/blank.php';
		}

		return $template;
	}

	public function empty_template( $template ) {

		if ( file_exists( AG_THEME_BUILDER_DIR . 'inc/templates/empty.php' ) ) {
			return AG_THEME_BUILDER_DIR . 'inc/templates/empty.php';
		}

		return $template;
	}

	public function woo_template( $template ) {
		if ( file_exists( AG_THEME_BUILDER_DIR . 'inc/templates/woo.php' ) ) {
			return AG_THEME_BUILDER_DIR . 'inc/templates/woo.php';
		}

		return $template;

	}

}

OceanWP_Theme_Compatibility::instance();
