<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1">
  <?php wp_head(); ?>
</head>
<?php $options = get_option('kaveh_frame'); ?>

<body <?php body_class(); ?>>
<?php
	if ( function_exists( 'wp_body_open' ) ) {
		wp_body_open();
	}
?>
  <?php do_action('kaveh_before_header'); ?>
  <div class="app <?php echo esc_attr($options['kaveh_typoselect'] === 'value-1' ? 'irsans' : ($options['kaveh_typoselect'] === 'value-2' ? 'iryekan' : 'ybakh')); ?>">
    <?php if (!empty($options['kaveh_preload_switch'])): ?>
      <?php get_template_part('template-part/theme-preloader'); ?>
    <?php endif; ?>

    <?php if ((is_checkout() || is_cart()) && !empty($options['kcheckout_header'])): ?>
      <?php get_template_part('template-part/theme-checkout-header'); ?>
    <?php elseif(is_product_category()): ?>
      <?php if (!empty($options['kaveh_header_mobile_on']) && wp_is_mobile()): ?>
        <?php 
          $mobile_header_option = intval(preg_replace('/[^0-9]/', '', $options['kaveh_header_mobile_select']));
          get_template_part('template-part/header-mobile-' . $mobile_header_option); 
        ?>
      <?php else: ?>
        <?php 
        if (function_exists('boostify_header_active')) {
            get_template_part('template-part/header-archive-boostify'); 
        } else {
          get_template_part('template-part/theme-default-header');
        }
        ?>
      <?php endif; ?>
    <?php else: ?>
      <?php
      $page_id = '';
      $page = get_page_by_path('klogin');
      if (!empty($page)) {
        $page_id = $page->ID;
      }
      $account_page_id = get_option('woocommerce_myaccount_page_id');
      $is_product_single_page = $options['kaveh_pr_single_select'] == 'value-4' && $options['showheaderinsingle'] !== '1' && wp_is_mobile() && is_product();
      if (!is_page($account_page_id) && !is_page($page_id) && !$is_product_single_page): 
      ?>
        <?php if (!empty($options['kaveh_header_mobile_on']) && wp_is_mobile()): ?>
          <?php 
            $mobile_header_option = intval(preg_replace('/[^0-9]/', '', $options['kaveh_header_mobile_select']));
            get_template_part('template-part/header-mobile-' . $mobile_header_option); 
          ?>
        <?php else: ?>
          <?php 
          if (function_exists('boostify_header_active') && boostify_header_active()) {
            get_template_part('template-part/theme-boostify-header');
          } else {
            get_template_part('template-part/theme-default-header');
          }
          ?>
        <?php endif; ?>
      <?php endif; ?>
    <?php endif; ?>
