<?php
define('KAVEH_TEMPLATE_URI', get_template_directory_uri());
define('KAVEH_TEMPLATE_PATH', get_template_directory());
require_once 'kaveh-functions.php';


function custom_comment_template($comment, $args, $depth)
{
    // Get the rating value from the comment metadata
    $rating = get_comment_meta($comment->comment_ID, 'rating', true);
    $rating = !empty($rating) ? intval($rating) : 0; // Ensure the rating is an integer

    ?>
    <li <?php comment_class(); ?> id="comment-<?php comment_ID(); ?>">
        <div class="content">
            <div class="info d-flex align-items-center flex-column flex-sm-row">
                <?php echo get_avatar($comment, 64, '', '', array('class' => 'rounded-circle text-center mb-3 mb-sm-0')); ?>
                <div class="detail d-flex align-items-center justify-content-between flex-column flex-sm-row">
                    <div class="author-date text-center text-sm-right">
                        <div class="author"><?php comment_author(); ?></div>
                        <div class="date">
                            <?php
                            $date = get_comment_date('Y/n/j');
                            $persian_numbers = array('۰', '۱', '۲', '۳', '۴', '۵', '۶', '۷', '۸', '۹');
                            $english_numbers = array('0', '1', '2', '3', '4', '5', '6', '7', '8', '9');
                            echo str_replace($english_numbers, $persian_numbers, $date);
                            ?>
                        </div>
                    </div>
                    <div class="star-position d-flex align-items-center flex-column flex-sm-row">
                        <div class="star d-flex align-items-center">
                            <?php
                            // Render stars based on the rating value
                            for ($i = 1; $i <= 5; $i++) {
                                $star_class = ($i <= $rating) ? 'active' : '';
                                echo '<i class="icon-star ' . $star_class . '"></i>';
                            }
                            ?>
                        </div>
                        <?php
                        comment_reply_link(array_merge($args, array(
                            'reply_text' => 'پاسخ', // Text for the reply link
                            'depth' => $depth, // Current depth of the comment
                            'max_depth' => $args['max_depth'], // Maximum depth allowed
                            'add_below' => 'comment', // ID prefix for the reply form
                            'before' => '<div class="position rounded-pill">', // HTML before the link
                            'after' => '</div>', // HTML after the link
                        )));
                        ?>
                    </div>
                </div>
            </div>
            <div class="box">
                <?php comment_text(); ?>
            </div>
        </div>
        <?php
}


function custom_comment_form_fields($fields)
{
    // Check if WooCommerce is active and if the current page is a product page
    if (class_exists('WooCommerce') && is_product()) {
        // Add the rating field
        $fields['rating'] = '<div class="col-12">
                                <div class="form-group position-relative">
                                    <label for="rating">رتبه بندی شما</label>
                                    <select name="rating" id="rating" class="form-control rounded-pill">
                                        <option value="">' . esc_html__('Rate&hellip;', 'woocommerce') . '</option>
                                        <option value="5">' . esc_html__('Perfect', 'woocommerce') . '</option>
                                        <option value="4">' . esc_html__('Good', 'woocommerce') . '</option>
                                        <option value="3">' . esc_html__('Average', 'woocommerce') . '</option>
                                        <option value="2">' . esc_html__('Not that bad', 'woocommerce') . '</option>
                                        <option value="1">' . esc_html__('Very poor', 'woocommerce') . '</option>
                                    </select>
                                </div>
                            </div>';
    }

    // Add the default fields
    $fields['author'] = '<div class="col-12">
                            <div class="form-group position-relative">
                                <label for="author">نام شما</label>
                                <input type="text" name="author" id="author" class="form-control rounded-pill" />
                            </div>
                        </div>';

    $fields['email'] = '<div class="col-12">
                            <div class="form-group position-relative">
                                <label for="email">ایمیل شما</label>
                                <input type="email" name="email" id="email" class="form-control rounded-pill" />
                            </div>
                        </div>';

    $fields['url'] = '<div class="col-12">
                        <div class="form-group position-relative">
                            <label for="url">وب سایت شما</label>
                            <input type="url" name="url" id="url" class="form-control rounded-pill" />
                        </div>
                    </div>';

    return $fields;
}
add_filter('comment_form_default_fields', 'custom_comment_form_fields');