<?php
/**
 * The Template for displaying all single posts.
 *
 * @package dokan
 * @package dokan - 2014 1.0
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit; // Exit if accessed directly
}

$store_user   = dokan()->vendor->get( get_query_var( 'author' ) );
$store_info   = $store_user->get_shop_info();
$layout       = get_theme_mod( 'store_layout', 'right' );
$store_address    = dokan_get_seller_short_address( $store_user->get_id(), false );
global $product;
get_header( 'shop' );

/**
 * Hook: woocommerce_before_main_content.
 *
 * @hooked woocommerce_output_content_wrapper - 10 (outputs opening divs for the content)
 * @hooked woocommerce_breadcrumb - 20
 * @hooked WC_Structured_Data::generate_website_data() - 30
 */
do_action( 'woocommerce_before_main_content' );

?>
<style>
  .contact-us-content {
    margin-top: 55px !important;
}
.category .breadcrumb {
    margin-bottom: 20px;
}
.contact-us-image::before {
    content: "";
    background-image: -webkit-gradient(linear, left top, left bottom, from(rgba(238, 39, 58, 0)), to(#777777));
    background-image: -webkit-linear-gradient(top, rgba(238, 39, 58, 0),  #797979);
    background-image: -moz-linear-gradient(top, rgba(238, 39, 58, 0), #797979);
    background-image: -o-linear-gradient(top, rgba(238, 39, 58, 0), #797979);
    background-image: linear-gradient(to bottom, rgba(238, 39, 58, 0), #797979);
}
.contact-us-image img {
    height: 421px;
    -o-object-fit: cover;
    object-fit: cover;
    border-radius: 25px;
}
</style>
    <!-- Start Category -->
    <div class="category mt-4">
      <div class="container">
      <?php if (class_exists('kavehTheme')) { $breadcrumbs = kavehTheme::get_breadcrumb(); echo $breadcrumbs; } ?>
        <!-- Start Btn Filter Mobile -->
      
        <!-- End Btn Filter Mobile -->
        <div class="contact-us">
            <br>
            <br>
            <?php if(!empty($store_user->get_banner())): ?>
            <div class="contact-us-image position-relative">
                <img src="<?php echo esc_url( $store_user->get_banner() ); ?>" alt="<?php echo esc_attr( $store_user->get_shop_name() ); ?>" class="d-block w-100">
            </div>
            <?php endif; ?>

            <div class="container contact-us-content position-relative">
        <div class="row">
         
          <div class="col-lg-8">
            <!-- Start Socials -->
        
            <!-- End Socials -->
            <!-- Start Info Contact -->
            <div class="info-contact d-flex align-items-center flex-wrap">
              <div class="info-contact-item d-flex align-items-center w-100">
                <div class="image d-flex align-items-center justify-content-center">
                  <img class="rounded-pill" src="<?php echo esc_url( $store_user->get_avatar() ); ?>" alt="calling">
                </div>
                <div class="detail">
                  <div class="title">
                  <?php echo esc_html( $store_user->get_shop_name() ); ?>
                  </div>
                  <div class="sub-title">
                    راه های ارتباط 
                   
                  </div>
                </div>
              </div>
           
            </div>
            <!-- End Info Contact -->
            <!-- Start Note -->
            <div class="contact-us-note alert alert-warning text-center mb-0">
              برای ارتباط مستقیم با فروشنده از فرم روبرو استفاده کنید
            </div>
            <!-- End Note -->
            <!-- Start Full Info Contact -->
            <div class="full-info-contact d-flex align-items-center flex-wrap">
              <div class="full-info-contact-item position-relative w-100">
                <div class="d-flex align-items-center">
                  <i class="icon-location"></i>
                  <div class="detail">
                    <div class="title"> آدرس </div>
                    <div class="value"> <?php echo wp_kses_post( $store_address ); ?> </div>
                  </div>
                </div>
                <div class="d-flex align-items-center">
                  <i class="icon-phone"></i>
                  <div class="detail">
                    <div class="title"> شماره تماس </div>
                    <div class="value"> <?php echo esc_html( $store_user->get_phone() ); ?> </div>
                  </div>
                </div>
              </div>
          
            </div>
            <!-- End Full Info Contact -->
            <!-- Start Form -->
          
            <!-- End Form -->
          </div>
          <div class="col-lg-4">
                <div class="contact-us-form">
                    <div class="title text-center">
                        ارتباط با فروشنده
                    </div>
                    <form id="dokan-form-contact-seller" action="" method="post">
                        <div class="ajax-response"></div>

                        <?php wp_nonce_field( 'dokan_contact_seller', 'dokan_contact_seller_nonce' ); ?>
                        <input type="hidden" name="dokan_recaptcha_token" class="dokan_recaptcha_token">
                        <input type="hidden" name="seller_id" value="<?php echo esc_html( $seller_id ); ?>">
                        <input type="hidden" name="action" value="dokan_contact_seller">
                        <div class="row">
                     
                        <div class="col-sm-6">
                            <input type="text" name="name" class="form-control rounded-pill"
                            placeholder="نام و نام خانوادگی">
                        </div>
                        <div class="col-sm-6">
                            <input type="email" name="email" class="form-control rounded-pill" placeholder="ایمیل">
                        </div>
                        <div class="col-12">
                            <textarea name="message" class="form-control" placeholder="متن پیام"></textarea>
                        </div>
                        <div class="col-12">
                            <button type="submit" name="store_message_send" class="dokan-right dokan-btn dokan-btn-theme btn btn-success w-100 db rounded-pill fw-bold"> ارسال پیام </button>
                        </div>
                        </div>
                    </form>
                    </div>
                </div>
                </div>
            </div>
        </div>
        <br>
        <br>
        <br>
        <br>
        <br>



        <div class="row">
  
          </div>
<div class="col-lg-12">
            <div class="category-heading">
              <div class="d-flex align-items-center justify-content-between">
                <div class="name-category">
                  <span class="d-block"> محصولات</span>
                 <?php echo esc_html( $store_user->get_shop_name() ); ?>
                </div>
                <ul class="counter d-flex align-items-center">
                  <li>
                    <span class="d-block"> 
                    <?php if ( have_posts() ): ?>
                    <?php
                    $counter = [];
                    while ( have_posts() ) :
                        the_post();
                        $stocka = $product->get_stock_status();
                        if("instock"==$stocka){ 
                            $counter[] = get_the_ID();
                        } ?>

                        
                    <?php endwhile;  ?>
                    <?php endif; ?>
					<?php echo count($counter); ?> </span>
                    محصول موجود
                  </li>
                  <li>
                    <span class="d-block">
                    <?php if ( have_posts() ): ?>
                    <?php
                    $counter = [];
                    while ( have_posts() ) :
                        the_post();
                            $counter[] = get_the_ID();
                         ?>

                        
                    <?php endwhile;  ?>
                    <?php endif; ?>                    
					<?php echo count($counter); ?> </span>
                    محصول
                  </li>
                </ul>
              </div>
              
            <br>
              <!-- Start Products -->
              <div class="row" id="woor">
              <?php if ( have_posts() ) { ?>

                <div class="seller-items">

                <div class="<?php if ( wp_is_mobile() ) : echo 'row row-mobile';  else: echo 'row'; endif; ?>" id="woor">

                    <?php
                    while ( have_posts() ) :
                        the_post();
                        ?>

                        <div class="col-6 col-lg-3 mb-4">
                        <?php 
                        $options = get_option( 'kaveh_frame' );
                        $mkshopcart = $options['kaveh_sh_cart_select'];
                        switch ($mkshopcart):
                        case "value-1":
                            get_template_part("template-part/product-cart-one");
                            break; 
                        case "value-2":
                            get_template_part("template-part/product-cart-two"); 
                            break;
                        case "value-3":
                            get_template_part("template-part/product-cart-three"); 
                            break;
                        case "value-4":
                            get_template_part("template-part/product-cart-four"); 
                            break;
                        case "value-5":
                            get_template_part("template-part/product-cart-five"); 
                            break;
                        case "value-6":
                            get_template_part("template-part/product-cart-six"); 
                            break;
                        case "value-7":
                            get_template_part("template-part/product-cart-seven"); 
                            break;
                        case "value-8":
                            get_template_part("template-part/product-cart-eight"); 
                            break;
                        case "value-9":
                            get_template_part("template-part/product-cart-nine"); 
                            break;
                        case "value-10":
                            get_template_part("template-part/product-cart-ten"); 
                            break;
                        case "value-11":
                            get_template_part("template-part/product-cart-eleven"); 
                            break;
                        case "value-12":
                            get_template_part("template-part/product-cart-twelve"); 
                            break;
                        case "value-13":
                            get_template_part("template-part/product-cart-thirteen"); 
                            break;
                        case "value-14":
                            get_template_part("template-part/product-cart-fourteen"); 
                            break;
                        case "value-15":
                            get_template_part("template-part/product-cart-fifteen"); 
                            break;
                        case "value-16":
                            get_template_part("template-part/product-cart-sixteen"); 
                            break;
                        endswitch;	
                        ?>
                        </div>

                    <?php endwhile; // end of the loop. ?>

                    </div>

                </div>

                <?php dokan_content_nav( 'nav-below' ); ?>

                <?php } else { ?>

                <p class="dokan-info"><?php esc_html_e( 'No products were found of this vendor!', 'dokan-lite' ); ?></p>

                <?php } ?>
              
			  </div>
              <!-- End Products -->
            
            </div>

          </div>
        </div>
      </div>
    </div>
    <!-- End Category -->

<?php do_action( 'woocommerce_after_main_content' ); ?>

<?php get_footer( 'shop' ); ?>