
<?php if ( $sellers['users'] ) : ?>
<div class="mt-5 <?php if ( wp_is_mobile() ) : echo 'row row-mobile';  else: echo 'row'; endif; ?>">

<?php
foreach ( $sellers['users'] as $seller ) {
    $vendor                   = dokan()->vendor->get( $seller->ID );
    $store_banner_id          = $vendor->get_banner_id();
    $store_name               = $vendor->get_shop_name();
    $store_url                = $vendor->get_shop_url();
    $store_rating             = $vendor->get_rating();
    $is_store_featured        = $vendor->is_featured();
    $store_phone              = $vendor->get_phone();
    $store_info               = dokan_get_store_info( $seller->ID );
    $store_address            = dokan_get_seller_short_address( $seller->ID );
    $store_banner_url         = $store_banner_id ? wp_get_attachment_image_src( $store_banner_id, $image_size ) : DOKAN_PLUGIN_ASSEST . '/images/default-store-banner.png';
    $show_store_open_close    = dokan_get_option( 'store_open_close', 'dokan_appearance', 'on' );
    $dokan_store_time_enabled = isset( $store_info['dokan_store_time_enabled'] ) ? $store_info['dokan_store_time_enabled'] : '';
    $store_open_is_on         = ( 'on' === $show_store_open_close && 'yes' === $dokan_store_time_enabled && ! $is_store_featured ) ? 'store_open_is_on' : '';
    ?>
    <div class="col-6 col-lg-3 mb-4">
<div class="product-eight">
    <div class="image full-width">
        <a href="<?php echo esc_url( $store_url ); ?>">
        <img src="<?php echo is_array( $store_banner_url ) ? esc_attr( $store_banner_url[0] ) : esc_attr( $store_banner_url ); ?>" alt="product" />
        </a>
        <div class="offer">  <a href="<?php echo esc_url( $store_url ); ?>">
                                        <img src="<?php echo esc_url( $vendor->get_avatar() ); ?>"
                                            alt="<?php echo esc_attr( $vendor->get_shop_name() ); ?>"
                                            size="150">
                                    </a>  <a href="<?php echo esc_url( $store_url ); ?>"><span class="rotd">مشاهده</span></a></div>
                                  
    </div>
    <div class="content">
        <h2 class="product-name">
        <a href="<?php echo esc_url( $store_url ); ?>"> <?php echo esc_html( $store_name ); ?> </a>
        </h2>
        <?php if ( ! empty( $store_rating['count'] ) ) : ?>
                                            <div class="dokan-seller-rating"
                                                title="
                                                <?php
                                                    echo sprintf(
                                                        // translators: 1) seller rating
                                                        esc_attr__( 'Rated %s out of 5', 'dokan-lite' ), number_format_i18n( $store_rating['rating'] )
                                                    );
                                                ?>
                                                ">
                                                <?php echo wp_kses_post( dokan_generate_ratings( $store_rating['rating'], 5 ) ); ?>
                                                <p class="rating">
                                                    <?php
                                                    echo esc_html(
                                                        // translators: 1) seller rating
                                                        sprintf( __( '%s out of 5', 'dokan-lite' ), number_format_i18n( $store_rating['rating'] ) )
                                                    );
                                                    ?>
                                                </p>
                                            </div>
                                        <?php endif ?>

                                        <?php if ( ! dokan_is_vendor_info_hidden( 'address' ) && $store_address ) : ?>
                                            <?php
                                            $allowed_tags = [
                                                'span' => [
                                                    'class' => [],
                                                ],
                                                'br'   => [],
                                            ];
                                            ?>
                                            <p class="store-address"><?php echo wp_kses( $store_address, $allowed_tags ); ?></p>
                                        <?php endif ?>

                                        <?php if ( ! dokan_is_vendor_info_hidden( 'phone' ) && $store_phone ) { ?>
                                            <p class="store-phone">
                                                <i class="fas fa-phone-alt" aria-hidden="true"></i> <?php echo esc_html( $store_phone ); ?>
                                            </p>
                                        <?php } ?>

                                        <?php do_action( 'dokan_seller_listing_after_store_data', $seller, $store_info ); ?>
        <div class="d-flex align-items-center justify-content-between">
       
        <a href="<?php echo esc_url( $store_url ); ?>" class="btn btn-success-2 shadow-none">  نمایش محصولات </a>
        </div>
        <a href="<?php echo esc_url( $store_url ); ?>" class="btn btn-secondary rounded-pill"> مشاهده فروشگاه </a>
    </div>
</div>
</div>
<?php } ?>


</div>


            <?php
            $user_count   = $sellers['count'];
            $num_of_pages = ceil( $user_count / $limit );

            if ( $num_of_pages > 1 ) {
                echo '<div class="pagination-container clearfix">';

                $pagination_args = [
                    'current'   => $paged,
                    'total'     => $num_of_pages,
                    'base'      => $pagination_base,
                    'type'      => 'array',
                    'prev_text' => __( '&larr; Previous', 'dokan-lite' ),
                    'next_text' => __( 'Next &rarr;', 'dokan-lite' ),
                ];

                if ( ! empty( $search_query ) ) {
                    $pagination_args['add_args'] = [
                        'dokan_seller_search' => $search_query,
                    ];
                }

                $page_links = paginate_links( $pagination_args );

                if ( $page_links ) {
                    $pagination_links = '<div class="pagination-wrap">';
                    $pagination_links .= '<ul class="pagination"><li>';
                    $pagination_links .= join( "</li>\n\t<li>", $page_links );
                    $pagination_links .= "</li>\n</ul>\n";
                    $pagination_links .= '</div>';

                    echo wp_kses_post( $pagination_links );
                }

                echo '</div>';
            }
            ?>

        <?php else : ?>
            <p class="dokan-error"><?php esc_html_e( 'No vendor found!', 'dokan-lite' ); ?></p>
        <?php endif; ?>


        <style>
       .product-eight .content {
	height: auto;
}
.product-eight .image.full-width .offer img {
	border-radius: 100px;
	transform: rotate(-90deg);
}
.product-eight .image.full-width img {
	width: 100%;
	object-fit: cover;
}
.product-eight .image .offer {
	-webkit-border-radius: 50px;
	-moz-border-radius: 50px;
	border-radius: 192px;
	background-color: #ee232b;
	text-align: center;
	color: #fff;
	top: 15px;
	right: 15px;
	width: 40px;
	height: 104px;
	line-height: 30px;
}
.product-eight .btn-secondary {

	display: none;
}
.product-eight .image .offer {
	-webkit-border-radius: 50px;
	-moz-border-radius: 50px;
	border-radius: 192px;
	background-color: #8e8e8e;
	text-align: center;
	top: -20px;
	left: 48px;
	width: 40px;
	height: 104px;
	line-height: 30px;
	transform: rotate(90deg);
	right: unset;
}

.rotd {
	transform: rotate(-90deg) !important;
	position: relative;
	display: block;
	margin-top: 11px;
}

.product-eight {
	height: auto;
}
.fa-phone-alt::before {
	content: "\f879";
	transform: rotate(135deg);
	display: inherit;
	margin-left: 10px;
}


h1.list-st-dokan {
	
	margin-top: 75px;
	font-size: 32px;
	font-weight: 900;
	letter-spacing: 0;
	text-align: center;
}
#dokan-store-listing-filter-wrap{
		background: white;
		margin-top: 55px;
	border-radius: 125px;
	border: 1px solid #edf2f7;

	width: 100%;

	box-shadow: 1.21px 4.851px 27px 0px rgba(202, 210, 240, 0.2);
	position:relative;
}
#dokan-store-listing-filter-wrap::before{
	background: red;
  position: absolute;
  content: "";
  top: -5px;
  right: 30px;
  width: 95%;
  height: 92%;
  border-radius: 125px;
  z-index: -1;
}
#dokan-store-listing-filter-wrap::after{
	background: red;
  position: absolute;
  content: "";
  top: -10px;
  right: 70px;
  width: 88%;
  height: 92%;
  border-radius: 125px;
  z-index: -1;
	opacity:0.2;
}
#dokan-store-listing-filter-wrap .right .item .dokan-store-list-filter-button {
	border-radius: 134px;
}

#dokan-store-listing-filter-wrap .right .item select {

	border-radius: 150px;
	margin-right: 3px;
}
#dokan-store-listing-filter-form-wrap .store-lists-other-filter-wrap .item {
	display: none;
	align-items: center;
}
#dokan-store-listing-filter-form-wrap {

	border-radius: 20px;
}
#dokan-store-listing-filter-form-wrap button,#dokan-store-listing-filter-form-wrap input {
		border-radius: 200px !important;
}

@media screen and (max-width: 480px) {
    .product-eight .image .offer {
        -webkit-border-radius: 50px;
        -moz-border-radius: 50px;
        border-radius: 192px;
        background-color: #8e8e8e;
        text-align: center;
        top: -12px;
        left: 30px;
        width: 23px;
        height: 65px;
        line-height: 30px;
        transform: rotate(90deg);
        right: unset;
    }
    .rotd {
	margin-top: 0px;
	font-size: 10px;
}
.store-phone {
	font-size: 12px;
}

.product-eight .d-flex .btn {
	font-size: 11px;
	line-height: 18px;
	width: 100%;
	height: 22px;
	bottom: -9px;
	margin-bottom: ;
}
#dokan-store-listing-filter-wrap::before{
	background: red;
  position: absolute;
  content: "";
  top: -5px;
  right: 6px;
  width: 95%;
  height: 92%;
  border-radius: 125px;
  z-index: -1;
}
#dokan-store-listing-filter-wrap::after{
	background: red;
  position: absolute;
  content: "";
  top: -10px;
  right: 10px;
  width: 88%;
  height: 92%;
  border-radius: 125px;
  z-index: -1;
	opacity:0.2;
}
h1.list-st-dokan {
	margin-top: 75px;
	font-size: 18px;
	font-weight: 900;
	letter-spacing: 0;
	text-align: center;
}
}
        </style>

