<?php 

class kavehwoosingle{

    private $options;

    public function __construct() {

        $this->options = get_option('kaveh_frame');
        if($this->options['kaveh_pr_single_select']=='value-4'){

            remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_sharing', 50 );
            remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_title', 5 );
            remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_add_to_cart', 30 );
            remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_price', 10 );
            remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_rating', 10 );
            remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_meta', 40 );
            remove_action( 'woocommerce_single_product_summary', 'woocommerce_template_single_excerpt', 20 );
            remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_sale_flash', 10 );
            // remove_action( 'woocommerce_before_single_product_summary', 'woocommerce_show_product_images', 20 );
            remove_action( 'woocommerce_after_single_product_summary', 'woocommerce_output_related_products', 20 );
            remove_action('woocommerce_after_single_product_summary ','woocommerce_upsell_display',15);
            remove_action('woocommerce_after_single_product_summary ','woocommerce_output_product_data_tabs',10);

            add_action( 'kaveh_single_price', [$this,'kaveh_single_price']);
            add_action( 'kaveh_single_add_to_cart', [$this,'kaveh_single_add_to_cart']);
            add_action( 'kaveh_single_excerpt', [$this,'kaveh_single_excerpt']);
            add_action( 'kaveh_single_title', [$this,'kaveh_single_title']);
            add_action( 'kaveh_single_meta', [$this,'kaveh_single_meta']);
            add_action( 'kaveh_single_options', [$this,'kaveh_single_options']);
            add_action( 'kaveh_single_tabs', [$this,'kaveh_single_tabs']);
            add_action( 'mobile_header', [$this,'mobile_header']);
            
        }
        add_action( 'kaveh_single_modal_gallery', [$this,'kaveh_single_modal_gallery']);
        
        if($this->options['prtamas']==='1'){
            add_action('woocommerce_single_product_summary', [$this, 'replace_add'], 5);
        }
    }

    public function replace_add(){
        global $product;
        $product_id = $product->get_id();
        if($this->options['prtamas_apply_all'] ==='1'):
            $this->modify_add_to_cart_actions();
        else:
            if(!empty($this->options['prtamas_apply_onpr']) || !empty($this->options['prtamas_apply_oncat'])):
                if (has_term($this->options['prtamas_apply_oncat'], 'product_cat', $product_id)):
                    $this->modify_add_to_cart_actions();
                endif;
                if((in_array($product_id, $this->options['prtamas_apply_onpr']))):
                    $this->modify_add_to_cart_actions();
                endif;
            endif;
        endif;
    }

    public function modify_add_to_cart_actions() {
        remove_action( 'woocommerce_simple_add_to_cart', 'woocommerce_simple_add_to_cart', 30 );
        remove_action('woocommerce_single_variation', 'woocommerce_single_variation_add_to_cart_button', 20);
        add_action( 'woocommerce_simple_add_to_cart',[$this, 'single_prtamas'], 30 );
        add_action( 'woocommerce_variable_add_to_cart', [$this,'single_prtamas'], 30 );
    }

    public function single_prtamas(){
        ?>
        <a class="buttonforprtamas text-white" href="<?php echo $this->options['prtamas_link']; ?>"><?php echo $this->options['prtamas_text']; ?></a>
        <?php
    }

    public function mobile_header(){
        ?>
        <!-- Start Header Mobile -->
        <header class="detail-product-four-header d-lg-none">
            <div class="container d-flex align-items-center justify-content-between">
                <ul class="back-home d-flex align-items-center gap-2">
                <li>
                    <a href="<?php echo wp_get_referer(); ?>" class="bg-white rounded-circle d-flex align-items-center justify-content-center">
                    <i class="icon-angle-right"></i>
                    </a>
                </li>
                <li>
                    <a href="<?php echo home_url(); ?>" class="bg-white rounded-circle d-flex align-items-center justify-content-center">
                    <i class="icon-home-5"></i>
                    </a>
                </li>
                </ul>
                <div class="icons-detail-product position-relative top-0 start-0 end-0 d-flex flex-row-reverse">
                <button type="button" class="d-flex align-items-center justify-content-center rounded-circle text-white ms-2"
                    aria-label="show icons"> .... </button>
                <ul class="d-flex align-items-center justify-content-center gap-3">
                    <li class="text-white inmob">
                    <?php
                    if ( is_plugin_active( 'woo-smart-compare/wpc-smart-compare.php' ) ) {
                      echo do_shortcode( '[woosc id="".<?php echo get_the_ID(); ?>.""]' ); 
                    } else {
                        
                    }
                    ?>
                    </li>
                    <li class="text-white inmob">
                    <i class="isax isax-share5" data-bs-toggle="modal" data-bs-target="#exampleModal"></i>
                    </li>
                    <li class="text-white inmob">
                    <?php
                    if ( is_plugin_active( 'woo-smart-wishlist/wpc-smart-wishlist.php' ) ) { ?>
                        <?php echo do_shortcode( '[woosw id="".<?php echo get_the_ID(); ?>.""]' ); ?>
                    <?php
                    } else {
                        
                    }
                    ?>
                    </li>
                </ul>
                </div>
            </div>
        </header>
        <!-- End Header Mobile -->
        <?php
    }

    public function kaveh_single_price(){
        woocommerce_template_single_price();
    }

    public function kaveh_single_add_to_cart(){
        woocommerce_template_single_add_to_cart();
    }

    public function kaveh_single_excerpt(){
        woocommerce_template_single_excerpt();
    }

    public function kaveh_single_title(){
        woocommerce_template_single_title();
    }

    public function kaveh_single_meta(){
        woocommerce_template_single_meta();
    }

    public function kaveh_single_modal_gallery(){
        global $product;
        $thumnail_id = $product->get_image_id();
        $thumnail_ids = $product->get_gallery_image_ids();
        $kaveh_pr_metas = get_post_meta( $product->get_id(), 'single_product_options', true );
        ?>
        <!-- Start Modal Gallery -->
        <div id="modal-gallery" class="modal detail-product-four-modal-gallery fade">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                <div class="modal-body d-flex flex-column pbipan">
                    <button type="button" class="modal-close position-absolute" aria-label="close" data-bs-dismiss="modal">
                    <i class="icon icon-close fs-5"></i>
                    </button>
                    <!-- Start Tab Contents -->
                    <div class="tab-content mb-auto">
                    <!-- Start Tab Content -->
                    <div id="images" class="tab-pane fade show active">
                        <div class="row gap-4 gap-lg-0">
                        <div class="col-lg-6">
                            <div class="detail-product-four-modal-gallery-origin position-relative">
                            <!-- Start Carousel -->
                            <div class="swiper swiper-detail-product-four-modal-galler-origin overflow-hidden">
                                <div class="swiper-wrapper">
                                <?php 
                                if (isset($kaveh_pr_metas['ksingle_options_off']) && $kaveh_pr_metas['ksingle_options_off'] === '0') {
                                    $kvideo_show = $kaveh_pr_metas['kvideo_show'];
                                } else {
                                    $kvideo_show = $this->options['kvideo_show'];
                                }
                                ?>
                                <?php 
                                if (isset($kaveh_pr_metas['ksingle_options_off']) && $kaveh_pr_metas['ksingle_options_off'] === '0') {
                                    $kvideo_iframe = $kaveh_pr_metas['kvideo_iframe'];
                                } else {
                                    $kvideo_iframe = $this->options['kvideo_iframe'];
                                }
                                ?>
                                <?php 
                                if (isset($kaveh_pr_metas['ksingle_options_off']) && $kaveh_pr_metas['ksingle_options_off'] === '0') {
                                    $kvideo_upload = $kaveh_pr_metas['kvideo_upload'];
                                } else {
                                    $kvideo_upload = $this->options['kvideo_upload'];
                                }
                                ?>
                                <?php if(!empty($kvideo_show)): ?>
                                <?php if($kvideo_show === '1'): ?>
                                <!-- Start Slide -->
                                <div class="swiper-slide h-auto">
                                    <?php
                                    if($kvideo_iframe):
                                     echo $kvideo_iframe; 
                                    elseif($kvideo_upload):
                                     ?>
                                     <video width="100%" controls>
                                    <source src="<?php echo $kvideo_upload; ?>" type="video/mp4">
                                        مرورگر شما از ویدیو پشتیبانی نمیکند
                                    </video>
                                     <?php
                                    endif;
                                    ?>
                                </div>
                                <!-- End Slide -->    
                                <?php endif; ?>
                                <?php endif; ?>
                                <!-- Start Slide -->
                                <div class="swiper-slide h-auto">
                                    <img src="<?php echo wp_get_attachment_url($thumnail_id); ?>" alt="product" width="451"
                                    height="474" class="w-100 d-block h-100">
                                </div>
                                <!-- End Slide -->
                                <?php foreach($thumnail_ids as $id): ?>
                                <!-- Start Slide -->
                                <div class="swiper-slide h-auto">
                                    <img src="<?php echo wp_get_attachment_url($id); ?>" alt="product" width="451"
                                    height="474" class="w-100 d-block h-100">
                                </div>
                                <!-- End Slide -->
                                    <?php endforeach; ?>
                                </div>
                                <!-- Start Button -->
                                <div
                                class="swiper-button-next d-flex align-items-center justify-content-center rounded-pill end-0">
                                </div>
                                <div
                                class="swiper-button-prev d-flex align-items-center justify-content-center rounded-pill start-0">
                                </div>
                                <!-- End Button -->
                            </div>
                            <!-- End Carousel -->
                            <!-- <div class="icons-detail-product position-absolute">
                                <button type="button"
                                class="d-flex align-items-center justify-content-center rounded-circle text-white mx-auto mb-2"
                                aria-label="show icons"> .... </button>
                                <ul class="d-flex flex-column align-items-center gap-4">
                                <li class="text-white">
                                    <i class="fas fa-bell"></i>
                                </li>
                                <li class="text-white">
                                    <i class="isax isax-share5"></i>
                                </li>
                                <li class="text-white">
                                    <i class="iconly iconly-Heart"></i>
                                </li>
                                </ul>
                            </div> -->
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <h2 class="title-detail-product fw-semibold fs-6"> <?php echo $product->get_name(); ?> </h2>
                            <div class="detail-product-four-modal-gallery-images d-flex flex-wrap">
                            <img src="<?php echo wp_get_attachment_url($thumnail_id); ?>" alt="product" width="71" height="71">
                            <?php foreach($thumnail_ids as $id): ?>
                                <img src="<?php echo wp_get_attachment_url($id); ?>" alt="product" width="71" height="71">
                            <?php endforeach; ?>
                            </div>
                            <!-- <div class="images-users">
                            <div class="d-flex align-items-center justify-content-between">
                                <div class="images-users-title fw-semibold">
                                عکس های خریداران این محصول <span class="ms-1"> (۳۹) </span>
                                </div>
                                <button type="button" class="images-users-link fw-semibold p-0" aria-label="show more">
                                مشاهده بیشتر
                                <i class="icon-angle-circle-left"></i>
                                </button>
                            </div>
                            <div class="images-users-items d-flex align-items-center justify-content-between gap-2">

                                <div class="item position-relative overflow-hidden">
                                <img src="./assets/images/detail-product/image-01.png" alt="image" width="55" height="55">
                                </div>

                            </div>
                            </div> -->
                        </div>
                        </div>
                    </div>
                    <!-- <div id="images-buy" class="tab-pane fade">
                        <div class="row gap-4 gap-lg-0">
                        <div class="col-lg-6">
                            <div class="detail-product-four-modal-gallery-origin position-relative">
                            <div class="swiper swiper-detail-product-four-modal-galler-users overflow-hidden">
                                <div class="swiper-wrapper">
                                <div class="swiper-slide h-auto">
                                    <img src="./assets/images/detail-product/image-01.png" alt="image" width="451" height="474"
                                    class="w-100 d-block h-100">
                                </div>

                                </div>
                                <div
                                class="swiper-button-next d-flex align-items-center justify-content-center rounded-pill end-0">
                                </div>
                                <div
                                class="swiper-button-prev d-flex align-items-center justify-content-center rounded-pill start-0">
                                </div>
                            </div>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="detail-product-four-modal-gallery-images-users d-flex flex-wrap">
                            <img src="./assets/images/detail-product/image-01.png" alt="image" width="71" height="71">

                            </div>
                        </div>
                        </div>
                    </div> -->
                    <!-- End Tab Content -->
                    </div>
                    <!-- End Tab Contents -->
                    <!-- Start Tabs -->
                    <!-- <ul class="nav nav-pills justify-content-center gap-2">
                    <li class="active rounded-pill" data-bs-toggle="tab" data-bs-target="#images">
                        <i class="icon-brush me-2"></i>
                        تصاویر رسمی
                    </li>
                    <li class="rounded-pill" data-bs-toggle="tab" data-bs-target="#images-buy">
                        <i class="icon-message-text me-2"></i>
                        تصاویر خریداران
                    </li>
                    </ul> -->
                    <!-- End Tabs -->
                </div>
                </div>
            </div>
        </div>
        <!-- End Modal Gallery -->

        <!-- Start Modal Share -->
        <div class="modal fade" id="exampleModal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">
                <div class="modal-content modalkshare">
                <div class="modal-header">
                    <p class="modal-title fs-5" id="exampleModalLabel">اشتراک گذاری</p>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                <div class="input-group mt-4 mb-5 px-5">
                    <span class="input-group-text" id="kcopysource">
                    <i class="isax isax-document-copy kcopied"></i>
                    </span>
                    <input type="text" id="kcopytarget" class="form-control border" value="<?php echo $product->get_permalink(); ?>">
                </div>
                    <h3 class="text-center font-bold fs-5">ارسال به شبکه های اجتماعی</h3>
                    <p class="text-center">اشتراک گذاری در شبکه های اجتماعی</p>
                    <div class="d-block mx-auto text-center socialsharek mb-4">
                        <a href="https://t.me/share/url?url=<?php echo $product->get_permalink(); ?>&text=<?php echo $product->get_name(); ?>" target="_blank"><i class="icon icon-telegram mx-1"></i></a>
                        <a href="https://api.whatsapp.com/send?text=<?php echo $product->get_permalink(); ?>" target="_blank"><i class="icon icon-whatsapp mx-1"></i></a>
                        <a href="https://twitter.com/intent/tweet?url=<?php echo $product->get_permalink(); ?>&text=<?php echo $product->get_name(); ?>" target="_blank"><i class="fab fa-twitter mx-1"></i></a>
                        <a href="https://www.linkedin.com/shareArticle?url=<?php echo $product->get_permalink(); ?>&title=<?php echo $product->get_name(); ?>" target="_blank"><i class="icon icon-linkedin mx-1"></i></a>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">بستن</button>
                </div>
                </div>
            </div>
        </div>
        <!-- End Modal Share -->

        <?php
    }

    public function kaveh_single_options(){
        $productfebox = $this->options['pro-pic-repeater'];
        $count = count($productfebox);
        ?>
        <?php if($this->options['pro-pic-repeater-show'] !== '1'){
            return;
        }
        ?>
        <div class="options-box">
        <div class="container">
            <ul class="d-flex align-items-center">
                <div class="swiper swiper-options-boxes overflow-hidden" data-swiper='{
                    "breakpoints": {
                        "320": {"slidesPerView": 3, "spaceBetween": 4},
                        "768": {"slidesPerView": 3, "spaceBetween": 6},
                        "992": {"slidesPerView": <?php echo $count; ?>, "spaceBetween": 8},
                        "1200": {"slidesPerView": <?php echo $count; ?>, "spaceBetween": 10}
                    },
                    "autoplay": true
                    }'>
                    <div class="swiper-wrapper">
                        <?php
                        if(!empty($this->options['pro-pic-repeater'])):
                        $productfebox = $this->options['pro-pic-repeater'];
                        for ($i = 0; $i < count($productfebox); $i++):
                            ?>
                            <div class="swiper-slide">
                            <li>
                                <i class="<?php echo $productfebox[$i]['pro-pic-icon']; ?>"></i>
                                <span> <?php echo $productfebox[$i]['pro-pic-text']; ?> </span>
                            </li>
                            </div>
                            <?php
                        endfor;
                        endif;
                        ?>
                    </div>
                </div>
            </ul>
        </div>
        </div>
        <?php
    }

    public function kaveh_single_tabs(){
        woocommerce_output_product_data_tabs();
        woocommerce_output_related_products();
        ?>
        <button class="position-fixed switch_footer_kaveh"><i class="isax isax-refresh-25"></i></button>
        <?php
    }

}
