<?php
class kavehproptions{

    private $prefix;

        public function __construct()
        {

            $this->prefix = 'single_product_options';
            add_action('init', array($this, 'init_metabox'));

        }

        public function init_metabox()
        {
            if (!class_exists('CSF')) {
                return;
            }


            CSF::createMetabox($this->prefix, array(
                'title' => 'متاهای اختصاصی کاوه',
                'post_type' => 'product',
            ));

            $this->add_section('متاهای عمومی', array(
                array(
                    'id'           => 'kpr_english_name',
                    'type'         => 'text',
                    'title'        => ' نام انگلیسی محصول ',
                ),
                array(
                    'id'      => 'ksingle_options_off',
                    'type'    => 'switcher',
                    'title'   => 'اعمال تنظیمات عمومی قالب',
                    'desc'   => 'اگر این گزینه خاموش باشد تنظیماتی برای شما فعال خواهد شد که به جای تنظیمات عمومی قالب برای این محصول خاص استفاده خواهد شد اما اگر روشن باشد تمام این تنظیمات از تنظیمات عمومی قابل فراخوانی خواهد شد',
                    'text_on'    => 'فعال',
                    'text_off'   => 'غیرفعال',
                    
                    'default' => true
                ),
                array(
                    'id'      => 'kvideo_show',
                    'type'    => 'switcher',
                    'title'   => 'ویدیو معرفی محصول',
                    'text_on'    => 'فعال',
                    'text_off'   => 'غیرفعال',
                    'dependency' => array(
                        array( 'ksingle_options_off', '==', 'false' ),
                      ),
                    'default' => false
                ),
                array(
                    'id' => 'kvideo_iframe',
                    'desc' => 'در این سبک شما از سرویس های ثالث مثل آپارات و ... استفاده میکنید',
                    'type'  => 'code_editor',
                    'sanitize' => false,
                    'title' => 'آی فریم ویدیو معرفی محصول',
                    'dependency' => array(
                        array( 'kvideo_show', '==', 'true' ),
                      ),
                ),
                array(
                    'id'    => 'kvideo_upload',
                    'type'  => 'upload',
                    'title' => 'آپلود ویدیو محصول',
                    'button_title' => 'آپلود ویدیو',
                    'remove_title' => 'حذف ویدیو',
                    'desc' => 'در این سبک مستقیما در هاست خود ویدیو را آپلود میکنید',
                    'dependency' => array(
                        array( 'kvideo_show', '==', 'true' ),
                      ),
          
                ),
                array(
                    'id'      => 'kcoupon_single',
                    'type'    => 'switcher',
                    'title'   => 'نمایش کد تخفیف',
                    'text_on'    => 'فعال',
                    'text_off'   => 'غیرفعال',
                    'dependency' => array(
                        array( 'ksingle_options_off', '==', 'false' ),
                      ),
                    'default' => true
                ),
                array(
                    'id'           => 'kcoupon_single_image',
                    'type'         => 'upload',
                    'title'        => 'تصویر تخفیف',
                    'library'      => 'image',
                    'placeholder'  => 'http://',
                    'button_title' => 'آپلود تصویر',
                    'remove_title' => 'حذف تصویر',
                    'dependency' => array(
                        array( 'kcoupon_single', '==', 1 ),
                        array( 'ksingle_options_off', '==', 'false' ),
                      ),
                    'default' => esc_url( KAVEH_TEMPLATE_URI ) . '/assets/images/single-pr/coupon.png',
                ),
                array(
                    'id'           => 'kcoupon_single_text',
                    'type'         => 'text',
                    'title'        => 'متن کد تخفیف',
                    'default' => 'کد تخفیف 10 درصدی خرید اول : new',
                    'dependency' => array(
                        array( 'kcoupon_single', '==', 1 ),
                        array( 'ksingle_options_off', '==', 'false' ),
                      ),
                ),
                array(
                    'id'           => 'kcoupon_single_link',
                    'type'         => 'text',
                    'title'        => 'لینک',
                    'default' => '#',
                    'dependency' => array(
                        array( 'kcoupon_single', '==', 1 ),
                        array( 'ksingle_options_off', '==', 'false' ),
                      ),
                ),
                array(
                    'id'      => 'kvideo_qr_single',
                    'type'    => 'switcher',
                    'title'   => 'نمایش بارکد محصول',
                    'text_on'    => 'فعال',
                    'text_off'   => 'غیرفعال',
                    'dependency' => array(
                        array( 'ksingle_options_off', '==', 'false' ),
                      ),
                    'default' => true
                ),
                array(
                    'id'           => 'kvideo_qr_single_text1',
                    'type'         => 'text',
                    'title'        => 'متن اول  بارکد اسکن',
                    'default' => 'مشاهده در موبایل',
                    'dependency' => array(
                        array( 'kvideo_qr_single', '==', 1 ),
                        array( 'ksingle_options_off', '==', 'false' ),

                    ),
                ),
                array(
                    'id'           => 'kvideo_qr_single_text2',
                    'type'         => 'text',
                    'title'        => 'متن دوم بارکد اسکن',
                    'default' => 'همین حالا اسکن کنید',
                    'dependency' => array(
                        array( 'kvideo_qr_single', '==', 1 ),
                        array( 'ksingle_options_off', '==', 'false' ),

                    ),
                ),
                array(
                    'id'      => 'kvideo_ersalrygan_single',
                    'type'    => 'switcher',
                    'title'   => 'باکس ارسال رایگان',
                    'text_off'   => 'غیرفعال',
                    'dependency' => array(
                        array( 'ksingle_options_off', '==', 'false' ),
                      ),
                    'default' => true
                ),
                array(
                    'id'           => 'kvideo_ersalrygan_single_text1',
                    'type'         => 'text',
                    'title'        => 'متن اول باکس',
                    'default' => 'ارسال رایگان سفارش‌ها برای اعضای دیجی‌پلاس',
                    'dependency' => array(
                        array( 'kvideo_ersalrygan_single', '==', 1 ),
                        array( 'ksingle_options_off', '==', 'false' ),

                    ),
                ),
                array(
                    'id'           => 'kvideo_ersalrygan_single_text2',
                    'type'         => 'text',
                    'title'        => 'متن دوم باکس',
                    'default' => '۳۹ هزارتومان هزینه ارسال به سراسر ایران برای کاربران غیر دیجی‌پلاس',
                    'dependency' => array(
                        array( 'kvideo_ersalrygan_single', '==', 1 ),
                        array( 'ksingle_options_off', '==', 'false' ),

                    ),
                ),
                array(
                    'id'           => 'kvideo_ersalrygan_single_image',
                    'type'         => 'upload',
                    'title'        => 'تصویر سمت چپ باکس',
                    'library'      => 'image',
                    'placeholder'  => 'http://',
                    'button_title' => 'آپلود تصویر',
                    'remove_title' => 'حذف تصویر',
                    'dependency' => array(
                        array( 'kvideo_ersalrygan_single', '==', '1' ),
                        array( 'ksingle_options_off', '==', 'false' ),
                    ),
                    'default' => esc_url( KAVEH_TEMPLATE_URI ) . '/assets/images/single-pr/date-send.svg',
                ),
                array(
                    'id'        => 'ktickets_single',
                    'type'      => 'repeater',
                    'title'     => 'باکس های دلخواه زیر توضیحات',
                    'dependency' => array(
                        array( 'ksingle_options_off', '==', 'false' ),
                      ),
                    'fields'    => array(
                        array(
                            'id'           => 'ktickets_single_image',
                            'type'         => 'upload',
                            'title'        => 'تصویر باکس',
                            'library'      => 'image',
                            'placeholder'  => 'http://',
                            'button_title' => 'آپلود تصویر',
                            'remove_title' => 'حذف تصویر',
                            
                        ),
                        array(
                            'id'           => 'ktickets_single_text1',
                            'type'         => 'text',
                            'title'        => 'متن اول باکس',
                        ),
                        array(
                            'id'           => 'ktickets_single_text2',
                            'type'         => 'text',
                            'title'        => 'متن دوم باکس',
                        ),
                        array(
                            'id'           => 'ktickets_single_link',
                            'type'         => 'text',
                            'title'        => 'لینک باکس',
                        ),
                        array(
                            'id'    => 'ktickets_single_color1',
                            'type'  => 'color',
                            'title' => 'رنگ کل باکس',
                        ),
                        array(
                            'id'    => 'ktickets_single_color2',
                            'type'  => 'color',
                            'title' => 'رنگ باکس تصویر',
                        ),
                        array(
                            'id'    => 'ktickets_single_color3',
                            'type'  => 'color',
                            'title' => 'رنگ متن',
                        ),
          
                ),
                    'default'   => array(
                        array(
                            'ktickets_single_image' => esc_url( KAVEH_TEMPLATE_URI ) . '/assets/images/single-pr/snappaylogo.png',
                            'ktickets_single_text1' => 'پرداخت اقساطی با اسنپ پی',
                            'ktickets_single_text2' => 'بدون نیاز به ضمانت چک یا سفته',
                            'ktickets_single_link'  => '#',
                            'ktickets_single_color1' => '#008efa',
                            'ktickets_single_color2' => '#096db9',
                            'ktickets_single_color3' => '#fff',
                        ),
                        array(
                            'ktickets_single_image' => esc_url( KAVEH_TEMPLATE_URI ) . '/assets/images/single-pr/tara.svg',
                            'ktickets_single_text1' => 'پرداخت اعتباری با تارا ',
                            'ktickets_single_text2' => ' الان بخرید آخر ماه پرداخت کنید ',
                            'ktickets_single_link'  => '#',
                            'ktickets_single_color1' => '#581f81',
                            'ktickets_single_color2' => '#f9abe0',
                            'ktickets_single_color3' => '#fff',
                        ),
                    )
                ),
                array(
                'id'        => 'kticketsthumnail_single',
                'type'      => 'repeater',
                'title'     => 'باکس های دلخواه زیر تصاویر',
                'dependency' => array(
                    array( 'ksingle_options_off', '==', 'false' ),
                  ),
                'fields'    => array(
                    array(
                        'id'           => 'kticketsthumnail_single_image',
                        'type'         => 'upload',
                        'title'        => 'تصویر باکس',
                        'library'      => 'image',
                        'placeholder'  => 'http://',
                        'button_title' => 'آپلود تصویر',
                        'remove_title' => 'حذف تصویر',
                        
                    ),
                    array(
                        'id'           => 'kticketsthumnail_single_text1',
                        'type'         => 'text',
                        'title'        => 'متن باکس',
                    ),
                    array(
                        'id'           => 'kticketsthumnail_single_link',
                        'type'         => 'text',
                        'title'        => 'لینک باکس',
                    ),
                    array(
                        'id'    => 'kticketsthumnail_single_color1',
                        'type'  => 'color',
                        'title' => 'رنگ کل باکس',
                    ),
                    array(
                        'id'    => 'kticketsthumnail_single_color2',
                        'type'  => 'color',
                        'title' => 'رنگ باکس تصویر',
                    ),
                    array(
                        'id'    => 'kticketsthumnail_single_color3',
                        'type'  => 'color',
                        'title' => 'رنگ متن',
                    ),
          
                ),
                'default'   => array(
                    array(
                    'kticketsthumnail_single_image' => esc_url( KAVEH_TEMPLATE_URI ) . '/assets/images/single-pr/telegram.png',
                    'kticketsthumnail_single_text1' => 'ارتباط در تلگرام',
                    'kticketsthumnail_single_link' => '#',
                    'kticketsthumnail_single_color1' => '#40b1e3',
                    'kticketsthumnail_single_color2' => '#0090c7',
                    'kticketsthumnail_single_color3' => '#fff',
                    ),
                    array(
                    'kticketsthumnail_single_image' => esc_url( KAVEH_TEMPLATE_URI ) . '/assets/images/single-pr/whatsapp.png',
                    'kticketsthumnail_single_text1' => 'ارتباط در واتساپ',
                    'kticketsthumnail_single_link' => '#',
                    'kticketsthumnail_single_color1' => '#41bf55',
                    'kticketsthumnail_single_color2' => '#32a346',
                    'kticketsthumnail_single_color3' => '#fff',
                    ),
                    array(
                    'kticketsthumnail_single_image' => esc_url( KAVEH_TEMPLATE_URI ) . '/assets/images/single-pr/rubika.png',
                    'kticketsthumnail_single_text1' => 'ارتباط در روبیکا',
                    'kticketsthumnail_single_link' => '#',
                    'kticketsthumnail_single_color1' => '#fe6600',
                    'kticketsthumnail_single_color2' => '#fff',
                    'kticketsthumnail_single_color3' => '#fff',
                    ),
                    array(
                    'kticketsthumnail_single_image' => esc_url( KAVEH_TEMPLATE_URI ) . '/assets/images/single-pr/bale.png',
                    'kticketsthumnail_single_text1' => 'ارتباط در بله',
                    'kticketsthumnail_single_link' => '#',
                    'kticketsthumnail_single_color1' => '#01b894',
                    'kticketsthumnail_single_color2' => '#04f2c4',
                    'kticketsthumnail_single_color3' => '#fff',
                    ),
            
                )
                ),
                array(
                'id'        => 'klis_single',
                'type'      => 'repeater',
                'dependency' => array(
                    array( 'ksingle_options_off', '==', 'false' ),
                  ),
                'title'     => 'ویژگی های لیستی محصول',
                'fields'    => array(
                    array(
                        'id'           => 'klis_single_icon',
                        'type'         => 'text',
                        'title'        => 'آیکون',
                    ),
                    array(
                        'id'           => 'klis_single_text1',
                        'type'         => 'text',
                        'title'        => 'متن قسمت اول',
                    ),
                    array(
                        'id'           => 'klis_single_text2',
                        'type'         => 'text',
                        'title'        => 'متن قسمت دوم',
                    ),
                ),
                'default'   => array(
                    array(
                        'klis_single_icon' => 'far fa-dot-circle',
                        'klis_single_text1' => 'ارسال از',
                        'klis_single_text2' => '۲ روز کاری',
                    ),
                    array(
                        'klis_single_icon' => 'far fa-dot-circle',
                        'klis_single_text1' => 'ارسال فوری',
                        'klis_single_text2' => 'در شهر تهران',
                    ),
                    array(
                        'klis_single_icon' => 'far fa-dot-circle',
                        'klis_single_text1' => 'گارانتی',
                        'klis_single_text2' => ' اصالت و سلامت فیزیکی کالا',
                    ),
                )
                ),

            ));

            $this->add_section('متاهای نظرات', array(
                array(
                    'id' => 'opt-textarea',
                    'type' => 'textarea',
                    'title' => 'Simple Textarea',
                ),
            ));
        }

        public function add_section($title, $fields)
        {

            if (!class_exists('CSF')) {
                return;
            }
            CSF::createSection($this->prefix, array(
                'title' => $title,
                'fields' => $fields,
            ));
        }

}
