<?php

class kavehOptions
{

  private $prefix;

  public function __construct($prefix)
  {
    $this->prefix = $prefix;
    $this->create_options();
    add_filter('csf_field_typography_customwebfonts', [$this, 'my_custom_font_family']);

  }

  public function create_options()
  {
    if (class_exists('CSF')) {
      CSF::createOptions(
        $this->prefix,
        array(
          'menu_title' => 'تنظیمات کاوه',
          'menu_slug' => 'kaveh-options',
        )
      );

      $sections = array(
        array(
          'id' => 'one_tab', // Set a unique slug-like ID
          'title' => 'تنظیمات عمومی',
          'fields' => $this->get_section_general_fields(),
        ),
        array(
          'id' => 'four_tab', // Set a unique slug-like ID
          'title' => 'تنظیمات ظاهری',
        ),
        array(
          'parent' => 'four_tab', // Set a unique slug-like ID
          'title' => 'تنظیمات رنگ ها',
          'fields' => $this->get_section_appearance_fields(),
        ),
        array(
          'parent' => 'four_tab', // Set a unique slug-like ID
          'title' => 'تنظیمات تایپوگرافی',
          'fields' => $this->get_section_typo_fields(),
        ),
        array(
          'id' => 'mobile_tab', // Set a unique slug-like ID
          'title' => 'تنظیمات موبایل',
          'fields' => $this->get_section_mobile_fields(),
        ),
        array(
          'id' => 'two_tab', // Set a unique slug-like ID
          'title' => 'تنظیمات وبلاگ',
          'fields' => $this->get_section_blog_fields(),
        ),
        array(
          'id' => 'three_tab', // Set a unique slug-like ID
          'title' => 'تنظیمات فروشگاه',
        ),
        // array(
        //   'id' => 'three_tab', // Set a unique slug-like ID
        //   'title' => 'تنظیمات 404',
        //   'fields' => $this->get_section_404_fields(),
        // ),
        array(
          'parent' => 'three_tab', // Set a unique slug-like ID
          'title' => 'تنظیمات عمومی ووکامرس',
          'fields' => $this->get_section_woo_general_fields(),
        ),
        array(
          'parent' => 'three_tab', // Set a unique slug-like ID
          'title' => 'تنظیمات تسویه حساب',
          'fields' => $this->get_section_woo_checkout_fields(),
        ),
        array(
          'parent' => 'three_tab', // Set a unique slug-like ID
          'title' => 'تنظیمات سبد خرید',
          'fields' => $this->get_section_woo_cart_fields(),
        ),
        array(
          'parent' => 'three_tab', // Set a unique slug-like ID
          'title' => 'تنظیمات صفحه آرشیو',
          'fields' => $this->get_section_woo_archive_fields(),
        ),
        array(
          'parent' => 'three_tab', // Set a unique slug-like ID
          'title' => 'تنظیمات صفحه محصول تکی',
          'fields' => $this->get_section_woo_single_fields(),
        ),
        array(
          'parent' => 'three_tab', // Set a unique slug-like ID
          'title' => 'تنظیمات پنل کاربری',
          'fields' => $this->get_section_panel_fields(),
        ),
        array(
          'id' => 'vor_tab', // Set a unique slug-like ID
          'title' => 'تنظیمات ورود و ثبت نام',
        ),
        array(
          'parent' => 'vor_tab', // Set a unique slug-like ID
          'title' => 'تنظیمات کلی',
          'fields' => $this->get_section_login_general_fields(),
        ),
        array(
          'parent' => 'vor_tab', // Set a unique slug-like ID
          'title' => 'تنظیمات فیلد ها',
          'fields' => $this->get_secion_inputs_fields(),
        ),
        array(
          'parent' => 'vor_tab', // Set a unique slug-like ID
          'title' => 'تنظیمات سامانه پیامکی',
          'fields' => $this->get_secion_sms_gateway_fields(),
        ),
        array(
          'parent' => 'vor_tab', // Set a unique slug-like ID
          'title' => 'مشخصات سامانه پیامکی اصلی',
          'fields' => $this->get_secion_main_gateway(),
        ),
        array(
          'parent' => 'vor_tab', // Set a unique slug-like ID
          'title' => 'مشخصات سامانه پیامکی بکاپ',
          'fields' => $this->get_secion_backup_gateway(),
        ),
        array(
          'id' => 'kaveh_custom_code', // Set a unique slug-like ID
          'title' => 'کد های سفارشی',
          'fields' => $this->get_section_custom_code(),
        ),
        array(
          'id' => 'kaveh_backup_options', // Set a unique slug-like ID
          'title' => 'درون ریزی و برون بری تنظیمات',
          'fields' => $this->get_secion_export_import(),
        ),
      );

      foreach ($sections as $section) {
        CSF::createSection($this->prefix, $section);
      }
    }
  }

  private function get_section_general_fields()
  {
    return array(
      array(
        'id' => 'kaveh_announcement_banner',
        'type' => 'switcher',
        'title' => 'بنر اطلاعیه بالای صفحه ',
        'text_on' => 'فعال',
        'text_off' => 'غیرفعال',
        'default' => false
      ),
      array(
        'id' => 'kaveh_announcement_banner_link',
        'type' => 'text',
        'title' => 'لینک بنر اطلاعیه بالای صفحه',
        'default' => '#',
        'dependency' => array(
          array('kaveh_announcement_banner', '==', '1'),
        ),
      ),
      array(
        'id' => 'kaveh_announcement_banner_image',
        'type' => 'upload',
        'desc' => 'سایز مناسب برای بنر اطلاعیه 2800 پیکسل در عرض و 100 پیکسل در ارتفاع است',
        'title' => 'آپلود بنر اطلاعیه بالای صفحه مختص دسکتاپ',
        'library' => 'image',
        'placeholder' => 'http://',
        'button_title' => 'آپلود تصویر',
        'remove_title' => 'حذف تصویر',
        'dependency' => array('kaveh_announcement_banner', '==', '1'),
        'default' => esc_url(KAVEH_TEMPLATE_URI) . '/assets/images/top-banner.jpg',
      ),
      array(
        'id' => 'kaveh_announcement_banner_image_mobile',
        'type' => 'upload',
        'desc' => 'سایز مناسب برای بنر اطلاعیه 500 پیکسل در عرض و 100 پیکسل در ارتفاع است',
        'title' => ' آپلود بنر اطلاعیه بالای صفحه مختص موبایل',
        'library' => 'image',
        'placeholder' => 'http://',
        'button_title' => 'آپلود تصویر',
        'remove_title' => 'حذف تصویر',
        'dependency' => array('kaveh_announcement_banner', '==', '1'),
        'default' => esc_url(KAVEH_TEMPLATE_URI) . '/assets/images/top-banner-mobile.jpg',
      ),
      array(
        'id' => 'bglogin',
        'type' => 'upload',
        'title' => 'آپلود بک گراند صفحه لاگین وردپرس',
        'library' => 'image',
        'placeholder' => 'http://',
        'button_title' => 'آپلود تصویر',
        'remove_title' => 'حذف تصویر',
        'default' => 'https://s21.uupload.ir/files/garousiamir/autumn-season-leafs-plant-scene-generative-ai.jpg',
      ),
      array(
        'id' => 'kaveh_logo_up',
        'type' => 'upload',
        'title' => 'آپلود لوگو',
        'library' => 'image',
        'placeholder' => 'http://',
        'button_title' => 'آپلود تصویر',
        'remove_title' => 'حذف تصویر',
        'default' => 'https://kaveh.moeinwp.com/1/wp-content/uploads/2022/10/demo1.svg',
      ),
      array(
        'id' => 'kaveh_preload_switch',
        'type' => 'switcher',
        'title' => 'پیش بارگزاری صفحات',
        'text_on' => 'فعال',
        'text_off' => 'غیرفعال',
        'default' => false
      ),


      array(
        'id' => 'search_kaveh_tasavir',
        'type' => 'switcher',
        'title' => 'بنر های تبلیغاتی در بخش سرچ',
        'default' => false
      ),

      array(
        'id' => 'search-pic-repeater',
        'type' => 'repeater',
        'title' => 'تصاویر اسلایدر باکس سرچ',
        'dependency' => array('search_kaveh_tasavir', '==', '1'),
        'fields' => array(

          array(
            'id' => 'searc-pic',
            'type' => 'upload',
            'title' => 'تصویر اسلایدر',
            'library' => 'image',
            'placeholder' => 'http://',
            'button_title' => 'آپلود تصویر',
            'remove_title' => 'حذف تصویر',
          ),
          array(
            'id' => 'searc-pic-url',
            'type' => 'link',
            'title' => 'لینک آیکون دوم',
            'add_title' => 'اضافه کردن لینک',
            'edit_title' => 'ویرایش لینک',
            'remove_title' => 'حذف لینک',
          ),


        ),
        'default' => array(
          array(
            'searc-pic' => 'https://kaveh.moeinwp.com/4/wp-content/uploads/2023/02/slider.png',
          ),
          array(
            'searc-pic' => 'https://kaveh.moeinwp.com/4/wp-content/uploads/2023/02/cloths3.jpg',
          ),
          array(
            'searc-pic' => 'https://kaveh.moeinwp.com/4/wp-content/uploads/2023/02/cloths2.jpg',
          ),
        )
      ),

      array(
        'id' => 'aj-search',
        'type' => 'upload',
        'title' => 'تصویر کوچک اول سرچ',
        'library' => 'image',
        'placeholder' => 'http://',
        'button_title' => 'آپلود تصویر',
        'remove_title' => 'حذف تصویر',
        'dependency' => array('search_kaveh_tasavir', '==', '1'),
        'default' => 'https://kaveh.moeinwp.com/1/wp-content/uploads/2022/08/banner-03.png',

      ),
      array(
        'id' => 'aj-search2',
        'type' => 'upload',
        'title' => 'تصویر کوچک اول دوم',
        'library' => 'image',
        'placeholder' => 'http://',
        'button_title' => 'آپلود تصویر',
        'remove_title' => 'حذف تصویر',
        'dependency' => array('search_kaveh_tasavir', '==', '1'),
        'default' => 'https://kaveh.moeinwp.com/1/wp-content/uploads/2022/08/banner-02.png',
      ),
    );
  }

  private function get_section_appearance_fields()
  {
    return array(
      array(
        'id' => 'opt-color-5',
        'type' => 'color',
        'title' => 'رنگ اولیه سایت',
      ),
      array(
        'id' => 'opt-color-5-hover',
        'type' => 'color',
        'title' => 'رنگ ثانویه سایت',
      ),
      array(
        'id' => 'pricecolor',
        'type' => 'color',
        'title' => 'رنگ قیمت های ووکامرس',
      ),



    );
  }

  private function get_section_typo_fields()
  {
    return array(

      array(
        'id' => 'kaveh_advanced_typo',
        'type' => 'switcher',
        'title' => 'حالت پیشرفته تایپوگرافی',
        'text_on' => 'فعال',
        'text_off' => 'غیرفعال',
        'default' => false
      ),
      array(
        'id' => 'kaveh_typoselect',
        'type' => 'image_select',
        'title' => 'انتخاب فونت',
        'dependency' => array(
          array('kaveh_advanced_typo', '!=', '1'),
        ),
        'options' => array(
          'value-1' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/preloader/irsans.svg",
          'value-2' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/preloader/iryekan.svg",
          'value-3' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/preloader/ybakh.svg",
          'value-4' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/preloader/dana.svg",
          'value-5' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/preloader/moraba.svg",
          'value-6' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/preloader/abr.svg",
          'value-7' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/preloader/doran.svg",
          'value-8' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/preloader/anjoman.svg",
          'value-9' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/preloader/peyda.svg",

        ),
        'default' => 'value-3'
      ),

      array(
        'id' => 'opt-typography-h1',
        'type' => 'typography',
        'title' => 'تایپوگرافی H1',
        'text_transform' => false,
        'text_align' => false,
        'subset' => false,
        'preview' => false,
        'dependency' => array(
          array('kaveh_advanced_typo', '==', '1'),
        ),
        'color' => false,
        'exclude' => 'google,safe',
        'default' => array(
          'font-family' => 'YekanBakh',
          'font-weight' => '900',
          'font-size' => '',
          'line-height' => '',
          'letter-spacing' => '0',
        ),
      ),
      array(
        'id' => 'opt-typography-h2',
        'type' => 'typography',
        'title' => 'تایپوگرافی H2',
        'text_transform' => false,
        'text_align' => false,
        'subset' => false,
        'preview' => false,
        'dependency' => array(
          array('kaveh_advanced_typo', '==', '1'),
        ),
        'color' => false,
        'exclude' => 'google,safe',
        'default' => array(
          'font-family' => 'YekanBakh',
          'font-weight' => '800',
          'font-size' => '',
          'line-height' => '',
          'letter-spacing' => '0',
        ),
      ),
      array(
        'id' => 'opt-typography-h3',
        'type' => 'typography',
        'title' => 'تایپوگرافی H3',
        'text_transform' => false,
        'text_align' => false,
        'subset' => false,
        'preview' => false,
        'dependency' => array(
          array('kaveh_advanced_typo', '==', '1'),
        ),
        'color' => false,
        'exclude' => 'google,safe',
        'default' => array(
          'font-family' => 'YekanBakh',
          'font-weight' => '700',
          'font-size' => '',
          'line-height' => '',
          'letter-spacing' => '0',
        ),
      ),
      array(
        'id' => 'opt-typography-h4',
        'type' => 'typography',
        'title' => 'تایپوگرافی H4',
        'text_transform' => false,
        'text_align' => false,
        'subset' => false,
        'preview' => false,
        'dependency' => array(
          array('kaveh_advanced_typo', '==', '1'),
        ),
        'color' => false,
        'exclude' => 'google,safe',
        'default' => array(
          'font-family' => 'YekanBakh',
          'font-weight' => '600',
          'font-size' => '',
          'line-height' => '',
          'letter-spacing' => '0',
        ),
      ),
      array(
        'id' => 'opt-typography-h5',
        'type' => 'typography',
        'title' => 'تایپوگرافی H5',
        'text_transform' => false,
        'text_align' => false,
        'subset' => false,
        'preview' => false,
        'dependency' => array(
          array('kaveh_advanced_typo', '==', '1'),
        ),
        'color' => false,
        'exclude' => 'google,safe',
        'default' => array(
          'font-family' => 'YekanBakh',
          'font-weight' => '500',
          'font-size' => '',
          'line-height' => '',
          'letter-spacing' => '0',
        ),
      ),
      array(
        'id' => 'opt-typography-h6',
        'type' => 'typography',
        'title' => 'تایپوگرافی H6',
        'text_transform' => false,
        'text_align' => false,
        'subset' => false,
        'preview' => false,
        'dependency' => array(
          array('kaveh_advanced_typo', '==', '1'),
        ),
        'color' => false,
        'exclude' => 'google,safe',
        'default' => array(
          'font-family' => 'YekanBakh',
          'font-weight' => '500',
          'font-size' => '',
          'line-height' => '',
          'letter-spacing' => '0',
        ),
      ),
      array(
        'id' => 'opt-typography-p',
        'type' => 'typography',
        'title' => 'تایپوگرافی پاراگراف',
        'text_transform' => false,
        'text_align' => false,
        'subset' => false,
        'preview' => false,
        'dependency' => array(
          array('kaveh_advanced_typo', '==', '1'),
        ),
        'color' => false,
        'exclude' => 'google,safe',
        'default' => array(
          'font-family' => 'YekanBakh',
          'font-weight' => '400',
          'font-size' => '',
          'line-height' => '',
          'letter-spacing' => '0',
        ),
      ),
      array(
        'id' => 'opt-typography-a',
        'type' => 'typography',
        'title' => 'تایپوگرافی لینک',
        'text_transform' => false,
        'text_align' => false,
        'subset' => false,
        'preview' => false,
        'dependency' => array(
          array('kaveh_advanced_typo', '==', '1'),
        ),
        'color' => false,  // Set to true if you want to allow color customization for links
        'exclude' => 'google,safe',
        'default' => array(
          'font-family' => 'YekanBakh',
          'font-weight' => '400',
          'font-size' => '',
          'line-height' => '',
          'letter-spacing' => '0',
        ),
      ),
      array(
        'id' => 'opt-typography-li',
        'type' => 'typography',
        'title' => 'تایپوگرافی لیست آیتم',
        'text_transform' => false,
        'text_align' => false,
        'subset' => false,
        'preview' => false,
        'dependency' => array(
          array('kaveh_advanced_typo', '==', '1'),
        ),
        'color' => false,
        'exclude' => 'google,safe',
        'default' => array(
          'font-family' => 'YekanBakh',
          'font-weight' => '400',
          'font-size' => '',
          'line-height' => '',
          'letter-spacing' => '0',
        ),
      ),
      array(
        'id' => 'opt-typography-ul',
        'type' => 'typography',
        'title' => 'تایپوگرافی لیست',
        'text_transform' => false,
        'text_align' => false,
        'subset' => false,
        'preview' => false,
        'dependency' => array(
          array('kaveh_advanced_typo', '==', '1'),
        ),
        'color' => false,
        'exclude' => 'google,safe',
        'default' => array(
          'font-family' => 'YekanBakh',
          'font-weight' => '400',
          'font-size' => '',
          'line-height' => '',
          'letter-spacing' => '0',
        ),
      ),


    );
  }

  private function get_section_mobile_fields()
  {
    return array(

      array(
        'id' => 'kaveh_header_mobile_on',
        'type' => 'switcher',
        'title' => 'هدر اختصاصی موبایل(آزمایشی)',
        'text_on' => 'فعال',
        'text_off' => 'غیرفعال',
        'default' => false
      ),

      array(
        'id' => 'kaveh_header_mobile_select',
        'type' => 'image_select',
        'title' => 'انتخاب نوع هدر موبایل',
        'dependency' => array(
          array('kaveh_header_mobile_on', '==', 'true'),
        ),
        'options' => array(
          'value-1' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/res-nav/header/1.png",
          'value-2' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/res-nav/header/2.png",
          'value-3' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/res-nav/header/3.png",
          'value-4' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/res-nav/header/4.png",
          'value-5' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/res-nav/header/5.png",
          'value-6' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/res-nav/header/6.png",
          'value-7' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/res-nav/header/7.png",
          'value-8' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/res-nav/header/8.png",
        ),
        'default' => 'value-1'
      ),

      array(
        'id' => 'kaveh_phone_header_mobile',
        'type' => 'text',
        'title' => 'شماره تلفن در هدر اختصاصی موبایل',
        'default' => '09120000000',
        'dependency' => array(
          array('kaveh_header_mobile_select', '==', 'value-2'),
        ),
      ),

      array(
        'id' => 'kaveh_menu_mobile_type',
        'type' => 'image_select',
        'title' => 'انتخاب نوع منوی موبایل',
        'dependency' => array(
          array('kaveh_header_mobile_on', '==', 'true'),
        ),
        'options' => array(
          'value-1' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/res-nav/1.png",
          'value-2' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/res-nav/2.png",
        ),
        'default' => 'value-1'
      ),




      array(
        'id' => 'kaveh_footer_mobile_on',
        'type' => 'switcher',
        'title' => 'فوتر اختصاصی موبایل',
        'text_on' => 'فعال',
        'text_off' => 'غیرفعال',
        'default' => true
      ),

      array(
        'id' => 'kaveh_footer_mobile',
        'type' => 'image_select',
        'title' => 'انتخاب نوع فوتر موبایل',
        'dependency' => array(
          array('kaveh_footer_mobile_on', '==', 'true'),
        ),
        'options' => array(
          'value-1' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/fmobile1.png",
          'value-2' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/fmobile2.png",
          'value-3' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/fmobile3.png",
          'value-4' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/fmobile4.png",
        ),
        'default' => 'value-1'
      ),
      array(
        'id' => 'kaveh_footer_mobile_texten',
        'type' => 'switcher',
        'title' => 'استفاده از متن در زیر آیکون ها',
        'text_on' => 'فعال',
        'text_off' => 'غیرفعال',
        'dependency' => array(
          array('kaveh_footer_mobile', 'any', 'value-2,value-3,value-4'),
        ),
        'default' => false
      ),
      array(
        'id' => 'kaveh_foomobile_icon1',
        'type' => 'text',
        'title' => 'آیکون اول فوتر',
        'default' => 'icon-home-4',
        'dependency' => array(
          array('kaveh_footer_mobile_on', '==', 1),
        ),
      ),
      array(
        'id' => 'kaveh_foomobile_text1',
        'type' => 'text',
        'title' => 'متن آیکون اول فوتر',
        'default' => 'خانه',
        'dependency' => array(
          array('kaveh_footer_mobile_texten', '==', 1),
        ),
      ),
      array(
        'id' => 'kaveh_foomobile_url_icon1',
        'type' => 'link',
        'title' => 'لینک آیکون اول فوتر',
        'add_title' => 'اضافه کردن لینک',
        'edit_title' => 'ویرایش لینک',
        'remove_title' => 'حذف لینک',
        'default' => array(
          'url' => home_url(),
        ),
        'dependency' => array(
          array('kaveh_footer_mobile_on', '==', 1),
        ),
      ),
      array(
        'id' => 'kaveh_foomobile_icon2',
        'type' => 'text',
        'title' => 'آیکون دوم فوتر',
        'default' => 'icon-grid',
        'dependency' => array(
          array('kaveh_footer_mobile_on', '==', 1),
        ),
      ),
      array(
        'id' => 'kaveh_foomobile_text2',
        'type' => 'text',
        'title' => 'متن آیکون دوم فوتر',
        'default' => 'فروشگاه',
        'dependency' => array(
          array('kaveh_footer_mobile_texten', '==', 1),
        ),
      ),
      array(
        'id' => 'kaveh_foomobile_url_icon2',
        'type' => 'link',
        'title' => 'لینک آیکون دوم فوتر',
        'add_title' => 'اضافه کردن لینک',
        'edit_title' => 'ویرایش لینک',
        'remove_title' => 'حذف لینک',
        'default' => array(
          'url' => home_url('/shop'),
        ),
        'dependency' => array(
          array('kaveh_footer_mobile_on', '==', 1),
        ),
      ),

      array(
        'id' => 'kaveh_foomobile_icon3',
        'type' => 'text',
        'title' => 'آیکون سوم فوتر',
        'default' => 'icon-cart-3',
        'dependency' => array(
          array('kaveh_footer_mobile_on', '==', 1),
        ),
      ),
      array(
        'id' => 'kaveh_foomobile_text3',
        'type' => 'text',
        'title' => 'متن آیکون سوم فوتر',
        'default' => 'سبد خرید',
        'dependency' => array(
          array('kaveh_footer_mobile_texten', '==', 1),
        ),
      ),

      array(
        'id' => 'kaveh_foomobile_url_icon3',
        'type' => 'link',
        'title' => 'لینک آیکون سوم فوتر',
        'add_title' => 'اضافه کردن لینک',
        'edit_title' => 'ویرایش لینک',
        'remove_title' => 'حذف لینک',
        'default' => array(
          'url' => '#',
        ),
        'dependency' => array(
          array('kaveh_footer_mobile_on', '==', 1),
        ),
      ),

      array(
        'id' => 'kaveh_foomobile_icon4',
        'type' => 'text',
        'title' => 'آیکون چهارم فوتر',
        'default' => 'icon-folder',
        'dependency' => array(
          array('kaveh_footer_mobile_on', '==', 1),
        ),
      ),
      array(
        'id' => 'kaveh_foomobile_text4',
        'type' => 'text',
        'title' => 'متن آیکون چهارم فوتر',
        'default' => 'وبلاگ',
        'dependency' => array(
          array('kaveh_footer_mobile_texten', '==', 1),
        ),
      ),
      array(
        'id' => 'kaveh_foomobile_url_icon4',
        'type' => 'link',
        'title' => 'لینک آیکون چهارم فوتر',
        'add_title' => 'اضافه کردن لینک',
        'edit_title' => 'ویرایش لینک',
        'remove_title' => 'حذف لینک',
        'default' => array(
          'url' => home_url('/blog'),
        ),
        'dependency' => array(
          array('kaveh_footer_mobile_on', '==', 1),
        ),
      ),

      array(
        'id' => 'kaveh_foomobile_icon5',
        'type' => 'text',
        'title' => 'آیکون پنجم فوتر',
        'default' => 'icon-user-2',
        'dependency' => array(
          array('kaveh_footer_mobile_on', '==', 1),
        ),
      ),
      array(
        'id' => 'kaveh_foomobile_text5',
        'type' => 'text',
        'title' => 'متن آیکون پنجم فوتر',
        'default' => 'حساب کاربری',
        'dependency' => array(
          array('kaveh_footer_mobile_texten', '==', 1),
        ),
      ),
      array(
        'id' => 'kaveh_foomobile_url_icon5',
        'type' => 'link',
        'title' => 'لینک آیکون پنجم فوتر',
        'add_title' => 'اضافه کردن لینک',
        'edit_title' => 'ویرایش لینک',
        'remove_title' => 'حذف لینک',
        'default' => array(
          'url' => home_url('/my-account'),
        ),
        'dependency' => array(
          array('kaveh_footer_mobile_on', '==', 1),
        ),
      ),

      array(
        'id' => 'kaveh_mobile_select',
        'type' => 'select',
        'title' => 'منوی موبایل کاوه',
        'placeholder' => 'یک منو را انتخاب کنید ',
        'chosen' => false,
        'ajax' => true,
        'options' => 'menus',
      ),

      array(
        'id' => 'kaveh_header_mobile_bg_type',
        'type' => 'select',
        'title' => 'نوع بک گراند منو موبایل',
        'options' => array(
          'option-1' => 'بک گراند تصویر',
          'option-2' => 'رنگ بک گراند',
        ),
        'default' => 'option-2'
      ),
      array(
        'id' => 'kaveh_mobile_header_bg_image',
        'type' => 'upload',
        'title' => 'تصویر بگ گراند منو',
        'library' => 'image',
        'placeholder' => 'http://',
        'button_title' => 'آپلود تصویر',
        'remove_title' => 'حذف تصویر',
        'default' => 'https://kaveh.moeinwp.com/1/wp-content/themes/kavehTheme/assets/images/bg-nav-responsive.png',
        'dependency' => array(
          array('kaveh_header_mobile_bg_type', '==', 'option-1'),
        ),
      ),

      array(
        'id' => 'kaveh_boxmenudown_mobile_on',
        'type' => 'switcher',
        'title' => 'باکس پایین منوی موبایل',
        'text_on' => 'فعال',
        'text_off' => 'غیرفعال',
        'default' => true
      ),
      array(
        'id' => 'kaveh_boxmenudown_text',
        'type' => 'text',
        'title' => 'متن دکمه تخفیف',
        'default' => 'تخفیف ها',
        'dependency' => array(
          array('kaveh_boxmenudown_mobile_on', '==', 1),
        ),
      ),
      array(
        'id' => 'kaveh_boxmenudown_iconclass',
        'type' => 'text',
        'title' => 'آیکون دکمه تخفیف',
        'default' => 'icon-offer-2',
        'dependency' => array(
          array('kaveh_boxmenudown_mobile_on', '==', 1),
        ),
      ),
      array(
        'id' => 'kaveh_boxmenudown_url',
        'type' => 'link',
        'title' => 'لینک دکمه تخفیف',
        'add_title' => 'اضافه کردن لینک',
        'edit_title' => 'ویرایش لینک',
        'remove_title' => 'حذف لینک',
        'dependency' => array(
          array('kaveh_boxmenudown_mobile_on', '==', 1),
        ),
      ),
      array(
        'id' => 'kaveh_boxmenudown_icon1',
        'type' => 'text',
        'title' => 'آیکون اول کنار دکمه تخفیف',
        'default' => 'icon-document',
        'dependency' => array(
          array('kaveh_boxmenudown_mobile_on', '==', 1),
        ),
      ),
      array(
        'id' => 'kaveh_boxmenudown_url_icon1',
        'type' => 'link',
        'title' => 'لینک آیکون اول',
        'add_title' => 'اضافه کردن لینک',
        'edit_title' => 'ویرایش لینک',
        'remove_title' => 'حذف لینک',
        'dependency' => array(
          array('kaveh_boxmenudown_mobile_on', '==', 1),
        ),
      ),
      array(
        'id' => 'kaveh_boxmenudown_icon2',
        'type' => 'text',
        'title' => 'آیکون دوم کنار دکمه تخفیف',
        'default' => 'icon-phone-4',
        'dependency' => array(
          array('kaveh_boxmenudown_mobile_on', '==', 1),
        ),
      ),
      array(
        'id' => 'kaveh_boxmenudown_url_icon2',
        'type' => 'link',
        'title' => 'لینک آیکون دوم',
        'add_title' => 'اضافه کردن لینک',
        'edit_title' => 'ویرایش لینک',
        'remove_title' => 'حذف لینک',
        'dependency' => array(
          array('kaveh_boxmenudown_mobile_on', '==', 1),
        ),
      ),



      array(
        'id' => 'kaveh_icons_mobile_on',
        'type' => 'switcher',
        'title' => 'شبکه های اجتماعی منوی موبایل',
        'text_on' => 'فعال',
        'text_off' => 'غیرفعال',
        'default' => true
      ),

      array(
        'id' => 'kaveh_mobile_menu-repeater',
        'type' => 'repeater',
        'title' => 'آیکون شبک های اجتماعی',
        'dependency' => array(
          array('kaveh_icons_mobile_on', '==', true),
        ),
        'fields' => array(

          array(
            'id' => 'kaveh_mobile_menu_icon',
            'type' => 'text',
            'title' => 'کلاس آیکون',
          ),
          array(
            'id' => 'kaveh_mobile_menu_text',
            'type' => 'link',
            'title' => 'لینک',
            'add_title' => 'اضافه کردن لینک',
            'edit_title' => 'ویرایش لینک',
            'remove_title' => 'حذف لینک',
          ),

        ),
        'default' => array(
          array(
            'kaveh_mobile_menu_icon' => 'icon-whatsapp',
            'kaveh_mobile_menu_text' => '#',
          ),
          array(
            'kaveh_mobile_menu_icon' => 'icon-linkedin',
            'kaveh_mobile_menu_text' => '#',
          ),
          array(
            'kaveh_mobile_menu_icon' => 'icon-twitter',
            'kaveh_mobile_menu_text' => '#',
          ),
          array(
            'kaveh_mobile_menu_icon' => 'icon-instagram',
            'kaveh_mobile_menu_text' => '#',
          ),

        )
      )


    );
  }

  private function get_section_blog_fields()
  {
    return array(
      array(
        'id' => 'kaveh_bl_cart_select',
        'type' => 'image_select',
        'title' => 'انتخاب نوع کارت بلاگ',
        'description' => 'این آپشن نوع استایل کارت های صفحه وبلاگ و صفحه دسته بندی های نوشته ها را تغییر خواهد داد و مابقی مکان هایی که دارای کارت وبلاگ است از المنتور قابل شخصی سازی هست',
        'options' => array(
          'value-1' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/blog-cart/bl-single-1.png",
          'value-2' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/blog-cart/bl-single-2.png",
          'value-3' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/blog-cart/bl-single-3.png",
          'value-4' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/blog-cart/bl-single-4.png",
          'value-5' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/blog-cart/bl-single-5.png",
          'value-6' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/blog-cart/bl-single-6.png",
          'value-7' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/blog-cart/bl-single-7.png",
          'value-8' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/blog-cart/bl-single-8.png",
          'value-9' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/blog-cart/bl-single-9.png",
        ),
        'default' => 'value-1'
      ),

      array(
        'id' => 'search_kaveh_blog_switch_slides',
        'type' => 'switcher',
        'text_on' => 'فعال',
        'text_off' => 'غیرفعال',
        'title' => 'نمایش بنر های بالای وبلاگ',
        'default' => true
      ),

      array(
        'id' => 'blog-pic-repeater',
        'type' => 'repeater',
        'title' => 'تصاویر اسلایدر وبلاگ',
        'dependency' => array('search_kaveh_blog_switch_slides', '==', '1'),
        'fields' => array(

          array(
            'id' => 'blog-pic',
            'type' => 'upload',
            'title' => 'تصویر اسلایدر',
            'library' => 'image',
            'placeholder' => 'http://',
            'button_title' => 'آپلود تصویر',
            'remove_title' => 'حذف تصویر',
          ),


        ),
        'default' => array(
          array(
            'blog-pic' => 'https://kaveh.moeinwp.com/4/wp-content/uploads/2023/02/slider.png',
          ),
          array(
            'blog-pic' => 'https://kaveh.moeinwp.com/4/wp-content/uploads/2023/02/cloths3.jpg',
          ),
          array(
            'blog-pic' => 'https://kaveh.moeinwp.com/4/wp-content/uploads/2023/02/cloths2.jpg',
          ),
        )
      ),
    );
  }

  private function get_section_woo_general_fields()
  {
    return array(

      array(
        'id' => 'opencartonaddtocart',
        'type' => 'switcher',
        'text_on' => 'فعال',
        'text_off' => 'غیرفعال',
        'title' => 'باز کردن سبد خرید سایدباری بعد از هر بار اضافه کردن به سبد',
        'default' => true
      ),
      array(
        'id' => 'auto_register_guest_user',
        'type' => 'switcher',
        'text_on' => 'فعال',
        'text_off' => 'غیرفعال',
        'title' => 'ثبت نام خودکار کاربر مهمان در تسویه حساب ووکامرس',
        'default' => false
      ),
      array(
        'id' => 'prtamas',
        'type' => 'switcher',
        'text_on' => 'فعال',
        'text_off' => 'غیرفعال',
        'title' => 'تماس بگیرید به جای دکمه افزودن به سبد خرید',
        'default' => false
      ),
      array(
        'id' => 'prtamas_text',
        'type' => 'text',
        'title' => 'متن تماس بگیرید',
        'dependency' => array(
          array('prtamas', '==', true),
        ),
        'default' => 'جهت سفارش با ما در ارتباط باشید',
      ),
      array(
        'id' => 'prtamas_link',
        'type' => 'text',
        'title' => 'لینک تماس بگیرید',
        'dependency' => array(
          array('prtamas', '==', true),
        ),
        'default' => '#',
      ),
      array(
        'id' => 'prtamas_apply_all',
        'type' => 'switcher',
        'text_on' => 'فعال',
        'text_off' => 'غیرفعال',
        'title' => 'اعمال دکمه تماس روی تمام محصولات ',
        'dependency' => array(
          array('prtamas', '==', true),
        ),
        'default' => true
      ),
      // Select with AJAX search CPT (custom post type) Categories
      array(
        'id' => 'prtamas_apply_oncat',
        'type' => 'select',
        'title' => 'اعمال دکمه روی دسته های خاص',
        'placeholder' => 'دسته های مربوطه را انتخاب کنید',
        'chosen' => true,
        'ajax' => true,
        'multiple' => true,
        'dependency' => array(
          array('prtamas_apply_all', '!=', '1'),
          array('prtamas', '==', '1'),
        ),
        'options' => 'categories',
        'query_args' => array(
          'taxonomy' => 'product_cat'
        )
      ),
      // Select with AJAX search CPT (custom post type) Posts
      array(
        'id' => 'prtamas_apply_onpr',
        'type' => 'select',
        'title' => 'اعمال دکمه روی محصولات خاص',
        'placeholder' => 'محصولات مربوطه را انتخاب کنید',
        'chosen' => true,
        'ajax' => true,
        'multiple' => true,
        'dependency' => array(
          array('prtamas_apply_all', '!=', '1'),
          array('prtamas', '==', '1'),
        ),
        'options' => 'posts',
        'query_args' => array(
          'post_type' => 'product'
        )
      ),


    );
  }

  private function get_section_woo_checkout_fields()
  {
    return array(


      // array(
      //   'id' => 'kcheckout_modern',
      //   'type' => 'switcher',
      //   'text_on' => 'فعال',
      //   'text_off' => 'غیرفعال',
      //   'title' => 'فعال سازی حالت مدرن و چند آدرسه',
      //   'desc' => 'با فعال سازی این گزینه تسویه حساب شما مشابه دیجی کالا چند آدرسی خواهد شد. اگر تداخلی با سایر افزونه های شما به وجود آمد کافیست این مورد را خاموش کنید',
      //   'default' => false
      // ),
      array(
        'id' => 'woofieldscontrol',
        'type' => 'switcher',
        'text_on' => 'فعال',
        'text_off' => 'غیرفعال',
        'title' => 'کنترل فیلد های تسویه حساب',
        'dependency' => array('kcheckout_modern', '==', '1'),
        'default' => false
      ),
      array(
        'id' => 'kwoofields',
        'type' => 'sorter',
        'title' => 'فیلد های تسویه حساب',
        'default' => array(
          'enabled' => array(
            'billing_first_name' => 'نام',
            'billing_last_name' => 'نام خانوادگی',
            'billing_phone' => 'شماره موبایل',
            'billing_email' => 'ایمیل',
            'billing_state' => 'استان',
            'billing_city' => 'شهر',
            'billing_address_1' => 'فیلد اول آدرس',
            'billing_address_2' => 'فیلد دوم آدرس',
            'billing_postcode' => 'کد پستی',
          ),
          'disabled' => array(
            'billing_company' => 'شرکت',
            'billing_country' => 'کشور',
          ),
        ),
        'dependency' => array(
          array('kcheckout_modern', '==', '1'),
          array('woofieldscontrol', '==', '1'),
        ),
        'disabled_title' => 'فیلد های غیر فعال',
        'enabled_title' => 'فیلد های فعال',
      ),
      array(
        'id' => 'fixed_checkout_submit',
        'type' => 'switcher',
        'text_on' => 'فعال',
        'text_off' => 'غیرفعال',
        'title' => 'فعال سازی دکمه چسبان تسویه حساب در موبایل',
        'desc' => 'با فعال سازی این گزینه یک دکمه چسبان در قسمت تسویه حساب قرار خواهد گرفت که فرآیند خرید را برای کاربر بسیار راحت تر میکند',
        'default' => true
      ),
      array(
        'id' => 'kcheckout_header',
        'type' => 'switcher',
        'text_on' => 'فعال',
        'text_off' => 'غیرفعال',
        'title' => 'فعال سازی هدر اختصاصی تسویه حساب ',
        'desc' => 'در صورت قعال بودن این گزینه هدری بهتر جهت تمرکز روی خرید به کاربر نمایش داده خواهد شد و هدر بقیه صفحات مخفی خواهد شد',
        'default' => true
      ),
      array(
        'id' => 'kcheckout_header_text1',
        'type' => 'text',
        'title' => 'متن مرحله سبد خرید',
        'default' => 'بازبینی سبد خرید',
        'dependency' => array(
          array('kcheckout_header', '==', 1),
        ),
      ),
      array(
        'id' => 'kcheckout_header_text2',
        'type' => 'text',
        'title' => 'متن مرحله تسویه حساب',
        'default' => 'انتخاب شیوه ارسال و پرداخت',
        'dependency' => array(
          array('kcheckout_header', '==', 1),
        ),
      ),
      array(
        'id' => 'kcheckout_header_text3',
        'type' => 'text',
        'title' => 'متن مرحله اتمام خرید',
        'default' => 'اتمام فرایند خرید',
        'dependency' => array(
          array('kcheckout_header', '==', 1),
        ),
      ),
      array(
        'id' => 'kwoocheckoutdesc',
        'type' => 'wp_editor',
        'title' => 'توضیحات سفارش',
        'sanitize' => false,
      ),

    );

  }

  private function get_section_woo_archive_fields()
  {
    return array(
      array(
        'id' => 'kaveh_sh_cart_select',
        'type' => 'image_select',
        'title' => 'انتخاب نوع کارت فروشگاه',
        'options' => array(
          'value-1' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/cart-shop/c-shop-10.jpg",
          'value-2' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/cart-shop/c-shop-9.jpg",
          'value-3' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/cart-shop/c-shop-6.jpg",
          'value-4' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/cart-shop/c-shop-5.jpg",
          'value-5' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/cart-shop/c-shop-3.jpg",
          'value-6' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/cart-shop/c-shop-2.jpg",
          'value-7' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/cart-shop/c-shop-8.jpg",
          'value-8' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/cart-shop/c-shop-4.jpg",
          'value-9' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/cart-shop/c-shop-1.jpg",
          'value-10' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/cart-shop/c-shop-7.jpg",
          'value-11' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/cart-shop/c-shop-11.jpg",
          'value-12' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/cart-shop/c-shop-12.jpg",
          'value-13' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/cart-shop/c-shop-13.jpg",
          'value-14' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/cart-shop/c-shop-14.jpg",
          'value-15' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/cart-shop/c-shop-15.jpg",
          'value-16' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/cart-shop/c-shop-16.jpg",
          'value-17' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/cart-shop/c-shop-17.png",
          'value-18' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/cart-shop/c-shop-18.png",
          'value-19' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/cart-shop/c-shop-19.png",
          'value-20' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/cart-shop/c-shop-20.png",
          'value-21' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/cart-shop/c-shop-21.png",
        ),
        'default' => 'value-1'
      ),
    );
  }

  private function get_section_woo_single_fields()
  {
    return array(

      array(
        'id' => 'kaveh_pr_single_select',
        'type' => 'image_select',
        'title' => 'انتخاب نوع صفحه محصول تکی',
        'options' => array(
          'value-1' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/single-pr/1-pr-single.svg",
          'value-2' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/single-pr/2-pr-single.svg",
          'value-3' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/single-pr/3-pr-single.svg",
          'value-4' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/single-pr/4-pr-single.svg",

        ),
        'default' => 'value-2'
      ),
      array(
        'id' => 'kaveh_pr_single_select_fixed_footer',
        'type' => 'switcher',
        'text_on' => 'فعال',
        'text_off' => 'غیرفعال',
        'title' => 'فعال سازی افزودن به سبد چسبان',
        'dependency' => array('kaveh_pr_single_select', 'any', 'value-1,value-4'),
        'default' => true
      ),
      array(
        'id' => 'ajaxnosingle',
        'type' => 'switcher',
        'text_on' => 'فعال',
        'text_off' => 'غیرفعال',
        'title' => 'غیر فعال کردن ایجکس در صفحه محصول تکی',
        'desc' => 'اگر از افزونه های جانبی استفاده میکنید که اضافه کردن به سبد خرید در صفحه محصول تکی شما به مشکل خورده این گزینه را فعال کنیددر غیر این صورت خاموش باشد',
        'default' => false
      ),
      array(
        'id' => 'featuresinsingle',
        'type' => 'switcher',
        'text_on' => 'فعال',
        'text_off' => 'غیرفعال',
        'title' => 'نمایش ویژگی ها بالای توضیحات کوتاه',
        'default' => true
      ),
      array(
        'id' => 'catlimitinsingle',
        'type' => 'switcher',
        'text_on' => 'فعال',
        'text_off' => 'غیرفعال',
        'title' => 'محدود سازی نمایش دسته بندی ها به یک عدد',
        'default' => true
      ),
      array(
        'id' => 'excerptinsingle',
        'type' => 'switcher',
        'text_on' => 'فعال',
        'text_off' => 'غیرفعال',
        'title' => 'نمایش توضیحات کوتاه',
        'default' => true
      ),
      array(
        'id' => 'excerptlimit',
        'type' => 'switcher',
        'text_on' => 'فعال',
        'text_off' => 'غیرفعال',
        'title' => 'محدود سازی تعداد کلمات توضیحات کوتاه',
        'default' => true
      ),
      array(
        'id' => 'excerptinsinglenumber',
        'type' => 'number',
        'dependency' => array(
          array('excerptlimit', '==', true),
        ),
        'title' => 'محدود کردن تعداد کلمات توضیحات کوتاه',
        'default' => 40,
      ),
      array(
        'id' => 'pro-desc-show-more',
        'type' => 'switcher',
        'text_on' => 'فعال',
        'text_off' => 'غیرفعال',
        'title' => 'نمایش توضیحات کامل به شکل مختصر با دکمه نمایش بیشتر',
        'default' => true
      ),
      array(
        'id' => 'pro-pic-repeater-show',
        'type' => 'switcher',
        'text_on' => 'فعال',
        'text_off' => 'غیرفعال',
        'title' => 'نمایش آیکون باکس های محصول',
        'default' => true
      ),
      array(
        'id' => 'pro-pic-repeater',
        'type' => 'repeater',
        'title' => 'آیکون باکس های محصول',
        'dependency' => array(
          array('pro-pic-repeater-show', '==', true),
        ),
        'fields' => array(

          array(
            'id' => 'pro-pic-icon',
            'type' => 'text',
            'title' => 'کلاس آیکون',
          ),
          array(
            'id' => 'pro-pic-text',
            'type' => 'text',
            'title' => 'متن باکس',
          ),
        ),
        'default' => array(
          array(
            'pro-pic-icon' => 'icon-box',
            'pro-pic-text' => ' تحویل اکسپرس ',
          ),
          array(
            'pro-pic-icon' => 'icon-money',
            'pro-pic-text' => ' پرداخت در محل ',
          ),
          array(
            'pro-pic-icon' => 'icon-seven-plus',
            'pro-pic-text' => ' هفت روز ضمانت بازگشت ',
          ),
          array(
            'pro-pic-icon' => 'icon-security',
            'pro-pic-text' => '  ضمانت کالا  ',
          ),
          array(
            'pro-pic-icon' => 'icon-suport',
            'pro-pic-text' => ' پشتیبانی آنلاین ',
          ),

        )
      ),
      array(
        'id' => 'boxprsinglecustomcolor',
        'type' => 'switcher',
        'text_on' => 'فعال',
        'text_off' => 'غیرفعال',
        'title' => 'سفارشی سازی رنگ باکس های صفحه محصول',
        'default' => false
      ),
      array(
        'id' => 'boxsingleprbg',
        'type' => 'color',
        'title' => 'بک گراند باکس آیکون ها',
        'dependency' => array(
          array('boxprsinglecustomcolor', '==', true),
        ),

      ),
      array(
        'id' => 'boxsingleprbgicon',
        'type' => 'color',
        'title' => 'بک گراند پشت آیکون ها',
        'dependency' => array(
          array('boxprsinglecustomcolor', '==', true),
        ),

      ),
      array(
        'id' => 'boxsinglepriconcolor',
        'type' => 'color',
        'title' => 'رنگ آیکون ها',
        'dependency' => array(
          array('boxprsinglecustomcolor', '==', true),
        ),

      ),
      array(
        'id' => 'showheaderinsingle',
        'type' => 'switcher',
        'text_on' => 'فعال',
        'text_off' => 'غیرفعال',
        'title' => 'نمایش هدر عادی به جای هدر موبایل سبک 4',
        'dependency' => array(
          array('kaveh_pr_single_select', '==', 'value-4'),
        ),
        'default' => false
      ),
      array(
        'type' => 'notice',
        'style' => 'info',
        'content' => 'تنظیمات پایین همگی هم در اینجا به صورت کلی وجود دارد و هم به صورت اختصاصی در صفحه ویرایش محصول برای هر محصول در ووکامرس هست در واقع میتوانید برای هر محصول نیز تنظیمات زیر را به صورت اختصاصی قرار دهید',
      ),
      array(
        'id' => 'kvideo_show',
        'type' => 'switcher',
        'title' => 'ویدیو معرفی محصول',
        'text_on' => 'فعال',
        'text_off' => 'غیرفعال',
        'default' => false
      ),
      array(
        'id' => 'kvideo_iframe',
        'desc' => 'در این سبک شما از سرویس های ثالث مثل آپارات و ... استفاده میکنید',
        'type' => 'code_editor',
        'sanitize' => false,
        'title' => 'آی فریم ویدیو معرفی محصول',
        'dependency' => array(
          array('kvideo_show', '==', 'true'),
        ),
      ),
      array(
        'id' => 'kvideo_upload',
        'type' => 'upload',
        'title' => 'آپلود ویدیو محصول',
        'button_title' => 'آپلود ویدیو',
        'remove_title' => 'حذف ویدیو',
        'desc' => 'در این سبک مستقیما در هاست خود ویدیو را آپلود میکنید',
        'dependency' => array(
          array('kvideo_show', '==', 'true'),
        ),

      ),
      array(
        'id' => 'kcoupon_single',
        'type' => 'switcher',
        'title' => 'نمایش کد تخفیف',
        'text_on' => 'فعال',
        'text_off' => 'غیرفعال',
        'default' => true
      ),
      array(
        'id' => 'kcoupon_single_image',
        'type' => 'upload',
        'title' => 'تصویر تخفیف',
        'library' => 'image',
        'placeholder' => 'http://',
        'button_title' => 'آپلود تصویر',
        'remove_title' => 'حذف تصویر',
        'dependency' => array('kcoupon_single', '==', 1),
        'default' => esc_url(KAVEH_TEMPLATE_URI) . '/assets/images/single-pr/coupon.png',
      ),
      array(
        'id' => 'kcoupon_single_text',
        'type' => 'text',
        'title' => 'متن کد تخفیف',
        'default' => 'کد تخفیف 10 درصدی خرید اول : new',
        'dependency' => array(
          array('kcoupon_single', '==', 1),
        ),
      ),
      array(
        'id' => 'kcoupon_single_link',
        'type' => 'text',
        'title' => 'لینک',
        'default' => '#',
        'dependency' => array(
          array('kcoupon_single', '==', 1),
        ),
      ),
      array(
        'id' => 'kvideo_qr_single',
        'type' => 'switcher',
        'title' => 'نمایش بارکد محصول',
        'text_on' => 'فعال',
        'text_off' => 'غیرفعال',
        'default' => true
      ),
      array(
        'id' => 'kvideo_qr_single_text1',
        'type' => 'text',
        'title' => 'متن اول  بارکد اسکن',
        'default' => 'مشاهده در موبایل',
        'dependency' => array(
          array('kvideo_qr_single', '==', 1),
        ),
      ),
      array(
        'id' => 'kvideo_qr_single_text2',
        'type' => 'text',
        'title' => 'متن دوم بارکد اسکن',
        'default' => 'همین حالا اسکن کنید',
        'dependency' => array(
          array('kvideo_qr_single', '==', 1),
        ),
      ),
      array(
        'id' => 'kvideo_ersalrygan_single',
        'type' => 'switcher',
        'title' => 'باکس ارسال رایگان',
        'text_off' => 'غیرفعال',
        'default' => true
      ),
      array(
        'id' => 'kvideo_ersalrygan_single_text1',
        'type' => 'text',
        'title' => 'متن اول باکس',
        'default' => 'ارسال رایگان سفارش‌ها برای اعضای دیجی‌پلاس',
        'dependency' => array(
          array('kvideo_ersalrygan_single', '==', 1),
        ),
      ),
      array(
        'id' => 'kvideo_ersalrygan_single_text2',
        'type' => 'text',
        'title' => 'متن دوم باکس',
        'default' => '۳۹ هزارتومان هزینه ارسال به سراسر ایران برای کاربران غیر دیجی‌پلاس',
        'dependency' => array(
          array('kvideo_ersalrygan_single', '==', 1),
        ),
      ),
      array(
        'id' => 'kvideo_ersalrygan_single_image',
        'type' => 'upload',
        'title' => 'تصویر سمت چپ باکس',
        'library' => 'image',
        'placeholder' => 'http://',
        'button_title' => 'آپلود تصویر',
        'remove_title' => 'حذف تصویر',
        'dependency' => array('kvideo_ersalrygan_single', '==', '1'),
        'default' => esc_url(KAVEH_TEMPLATE_URI) . '/assets/images/single-pr/date-send.svg',
      ),
      array(
        'id' => 'ktickets_single',
        'type' => 'repeater',
        'title' => 'باکس های دلخواه زیر توضیحات',
        'fields' => array(
          array(
            'id' => 'ktickets_single_image',
            'type' => 'upload',
            'title' => 'تصویر باکس',
            'library' => 'image',
            'placeholder' => 'http://',
            'button_title' => 'آپلود تصویر',
            'remove_title' => 'حذف تصویر',

          ),
          array(
            'id' => 'ktickets_single_text1',
            'type' => 'text',
            'title' => 'متن اول باکس',
          ),
          array(
            'id' => 'ktickets_single_text2',
            'type' => 'text',
            'title' => 'متن دوم باکس',
          ),
          array(
            'id' => 'ktickets_single_link',
            'type' => 'text',
            'title' => 'لینک باکس',
          ),
          array(
            'id' => 'ktickets_single_color1',
            'type' => 'color',
            'title' => 'رنگ کل باکس',
          ),
          array(
            'id' => 'ktickets_single_color2',
            'type' => 'color',
            'title' => 'رنگ باکس تصویر',
          ),
          array(
            'id' => 'ktickets_single_color3',
            'type' => 'color',
            'title' => 'رنگ متن',
          ),

        ),
        'default' => array(
          array(
            'ktickets_single_image' => esc_url(KAVEH_TEMPLATE_URI) . '/assets/images/single-pr/snappaylogo.png',
            'ktickets_single_text1' => 'پرداخت اقساطی با اسنپ پی',
            'ktickets_single_text2' => 'بدون نیاز به ضمانت چک یا سفته',
            'ktickets_single_link' => '#',
            'ktickets_single_color1' => '#008efa',
            'ktickets_single_color2' => '#096db9',
            'ktickets_single_color3' => '#fff',
          ),
          array(
            'ktickets_single_image' => esc_url(KAVEH_TEMPLATE_URI) . '/assets/images/single-pr/tara.svg',
            'ktickets_single_text1' => 'پرداخت اعتباری با تارا ',
            'ktickets_single_text2' => ' الان بخرید آخر ماه پرداخت کنید ',
            'ktickets_single_link' => '#',
            'ktickets_single_color1' => '#581f81',
            'ktickets_single_color2' => '#f9abe0',
            'ktickets_single_color3' => '#fff',
          ),
        )
      ),
      array(
        'id' => 'kticketsthumnail_single',
        'type' => 'repeater',
        'title' => 'باکس های دلخواه زیر تصاویر',
        'fields' => array(
          array(
            'id' => 'kticketsthumnail_single_image',
            'type' => 'upload',
            'title' => 'تصویر باکس',
            'library' => 'image',
            'placeholder' => 'http://',
            'button_title' => 'آپلود تصویر',
            'remove_title' => 'حذف تصویر',

          ),
          array(
            'id' => 'kticketsthumnail_single_text1',
            'type' => 'text',
            'title' => 'متن باکس',
          ),
          array(
            'id' => 'kticketsthumnail_single_link',
            'type' => 'text',
            'title' => 'لینک باکس',
          ),
          array(
            'id' => 'kticketsthumnail_single_color1',
            'type' => 'color',
            'title' => 'رنگ کل باکس',
          ),
          array(
            'id' => 'kticketsthumnail_single_color2',
            'type' => 'color',
            'title' => 'رنگ باکس تصویر',
          ),
          array(
            'id' => 'kticketsthumnail_single_color3',
            'type' => 'color',
            'title' => 'رنگ متن',
          ),

        ),
        'default' => array(
          array(
            'kticketsthumnail_single_image' => esc_url(KAVEH_TEMPLATE_URI) . '/assets/images/single-pr/telegram.png',
            'kticketsthumnail_single_text1' => 'ارتباط در تلگرام',
            'kticketsthumnail_single_link' => '#',
            'kticketsthumnail_single_color1' => '#40b1e3',
            'kticketsthumnail_single_color2' => '#0090c7',
            'kticketsthumnail_single_color3' => '#fff',
          ),
          array(
            'kticketsthumnail_single_image' => esc_url(KAVEH_TEMPLATE_URI) . '/assets/images/single-pr/whatsapp.png',
            'kticketsthumnail_single_text1' => 'ارتباط در واتساپ',
            'kticketsthumnail_single_link' => '#',
            'kticketsthumnail_single_color1' => '#41bf55',
            'kticketsthumnail_single_color2' => '#32a346',
            'kticketsthumnail_single_color3' => '#fff',
          ),
          array(
            'kticketsthumnail_single_image' => esc_url(KAVEH_TEMPLATE_URI) . '/assets/images/single-pr/rubika.png',
            'kticketsthumnail_single_text1' => 'ارتباط در روبیکا',
            'kticketsthumnail_single_link' => '#',
            'kticketsthumnail_single_color1' => '#fe6600',
            'kticketsthumnail_single_color2' => '#fff',
            'kticketsthumnail_single_color3' => '#fff',
          ),
          array(
            'kticketsthumnail_single_image' => esc_url(KAVEH_TEMPLATE_URI) . '/assets/images/single-pr/bale.png',
            'kticketsthumnail_single_text1' => 'ارتباط در بله',
            'kticketsthumnail_single_link' => '#',
            'kticketsthumnail_single_color1' => '#01b894',
            'kticketsthumnail_single_color2' => '#04f2c4',
            'kticketsthumnail_single_color3' => '#fff',
          ),

        )
      ),
      array(
        'id' => 'klis_single',
        'type' => 'repeater',
        'title' => 'ویژگی های لیستی محصول',
        'fields' => array(
          array(
            'id' => 'klis_single_icon',
            'type' => 'text',
            'title' => 'آیکون',
          ),
          array(
            'id' => 'klis_single_text1',
            'type' => 'text',
            'title' => 'متن قسمت اول',
          ),
          array(
            'id' => 'klis_single_text2',
            'type' => 'text',
            'title' => 'متن قسمت دوم',
          ),
        ),
        'default' => array(
          array(
            'klis_single_icon' => 'far fa-dot-circle',
            'klis_single_text1' => 'ارسال از',
            'klis_single_text2' => '۲ روز کاری',
          ),
          array(
            'klis_single_icon' => 'far fa-dot-circle',
            'klis_single_text1' => 'ارسال فوری',
            'klis_single_text2' => 'در شهر تهران',
          ),
          array(
            'klis_single_icon' => 'far fa-dot-circle',
            'klis_single_text1' => 'گارانتی',
            'klis_single_text2' => ' اصالت و سلامت فیزیکی کالا',
          ),
        )
      ),

    );
  }

  private function get_section_woo_cart_fields()
  {
    return array(
      array(
        'id' => 'kaveh_pr_cart_drop_select',
        'type' => 'image_select',
        'title' => 'انتخاب نوع سبد خرید باز شونده',
        'options' => array(
          'value-1' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/single-pr/cart1.png",
          'value-2' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/single-pr/cart2.png",
        ),
        'default' => 'value-2'
      ),
    );
  }

  private function get_section_panel_fields()
  {
    return array(
      array(
        'id' => 'kaveh_panel_select',
        'type' => 'image_select',
        'title' => 'انتخاب استایل پنل کاربری',
        'options' => array(
          'value-1' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/single-pr/panel.png",
          'value-2' => esc_url(KAVEH_TEMPLATE_URI) . "/assets/images/single-pr/panel2.png",

        ),
        'default' => 'value-1'
      ),
      array(
        'id' => 'kaveh_logo_panel',
        'type' => 'upload',
        'title' => 'آپلود لوگو پنل کاربری',
        'library' => 'image',
        'placeholder' => 'http://',
        'button_title' => 'آپلود تصویر',
        'remove_title' => 'حذف تصویر',
        'default' => 'https://s2.uupload.ir/files/kavele_3a0u.png',
      ),
      array(
        'id' => 'kaveh_copy_panel',
        'type' => 'text',
        'title' => 'متن کپی رایت پنل کاربری',
        'default' => 'کپی رایت قالب کاوه 1402',
      ),
      array(
        'id' => 'kaveh_call_panel',
        'type' => 'text',
        'title' => 'شماره تماس پنل کاربری',
        'default' => '09122222222',
      ),
    );
  }

  private function get_section_login_general_fields()
  {
    return array(
      array(
        'id' => 'kaveh_login_redirect',
        'type' => 'switcher',
        'title' => 'ریدایرکت به صفحه ورود کاوه',
        'desc' => 'با خاموش کردن کردن این گزینه سیستم ورود و عضویت کاوه کاملا غیر فعال می شود و میتوانید از افزونه های دلخواه این مورد استفاده کنید',
        'text_on' => 'فعال',
        'text_off' => 'غیرفعال',
        'default' => true
      ),
      array(
        'id' => 'kaveh_login_type',
        'type' => 'select',
        'title' => 'انتخاب سیستم ورود و ثبت نام',
        'options' => array(
          'option-1' => 'فقط با پیامک',
          'option-2' => 'فقط با رمز ثابت',
          'option-3' => 'پیامک و رمز ثابت',
        ),
        'default' => 'option-3'
      ),



    );
  }

  private function get_secion_sms_gateway_fields()
  {
    return array(



      array(
        'id' => 'kaveh_login_switchtobackup',
        'type' => 'switcher',
        'title' => 'فعال سازی ارسال مجدد از پنل پیامک بکاپ',
        'desc' => 'در صورت روشن کردن این گزینه بعد از مدت معین و دلخواه شما کاربر با کلیک روی گزینه ارسال مجدد از پنل پیامک بکاپ یا ثانویه شما کد مجدد ارسال میشود. این آپشن خیال شما را از بابت اختلال های پنل های پیامکی راحت میکند',
        'text_on' => 'فعال',
        'text_off' => 'غیرفعال',
        'default' => false,
      ),

      array(
        'id' => 'kaveh_login_send_again',
        'title' => 'مدت زمان فعال شدن دکمه ارسال مجدد (به ثانیه)',
        'type' => 'text',
        'default' => '45',
        'dependency' => array('kaveh_login_switchtobackup', 'any', '1'),
      ),

    );
  }

  private function get_secion_inputs_fields()
  {

    return array(



      array(
        'id' => 'kaveh_login_latin_fields',
        'type' => 'switcher',
        'title' => 'اجبار به استفاده از حروف لاتین وانگلیسی برای فیلد ها',
        'text_on' => 'فعال',
        'text_off' => 'غیرفعال',
        'default' => false,
      ),
      array(
        'id' => 'kloginfields',
        'type' => 'sorter',
        'title' => 'فیلد های ورود و ثبت نام',
        'default' => array(
          'enabled' => array(
            'first_name' => 'نام',
            'last_name' => 'نام خانوادگی',
            'password' => 'رمز عبور',
          ),
          'disabled' => array(

          ),
        ),
        'disabled_title' => 'فیلد های غیر فعال',
        'enabled_title' => 'فیلد های فعال',
      ),


    );

  }

  private function get_secion_main_gateway()
  {

    return array(
      array(
        'type' => 'notice',
        'style' => 'info',
        'content' => ' نکته: پنل های پیامکی فراز اس ام اس، مکس اس ام اس و مدیانا از ippanel استفاده می کنند
              . اکثر پنل های پیامکی نماینده آی پی پنل هستند و در کاوه پشتیبانی میشود',
      ),
      array(
        'id' => 'kaveh_sms_gateway',
        'type' => 'select',
        'title' => 'انتخاب پنل پیامک',
        'options' => array(
          'option-1' => 'ippanel',
          'option-2' => 'sms.ir',
          'option-3' => 'melipayamak',
          'option-4' => 'kavenegar',
          'option-5' => 'raygansms',
        ),
        'default' => 'option-1'
      ),
      array(
        'id' => 'kaveh_username_sms',
        'type' => 'text',
        'title' => 'نام کاربری	',
        'dependency' => array('kaveh_sms_gateway', 'any', 'option-1,option-3,option-5'),
      ),
      array(
        'id' => 'kaveh_password_sms',
        'type' => 'text',
        'title' => 'رمز عبور	',
        'dependency' => array('kaveh_sms_gateway', 'any', 'option-1,option-3,option-5'),
      ),
      array(
        'id' => 'kaveh_matn_raygansms',
        'type' => 'text',
        'title' => 'متن پیامک شما',
        'dafault' => 'خوش آمدید! کد تایید شما:',
        'dependency' => array('kaveh_sms_gateway', 'any', 'option-5'),
      ),
      array(
        'id' => 'kaveh_password_api',
        'type' => 'text',
        'title' => 'کلید وب سرویس (API key)',
        'dependency' => array('kaveh_sms_gateway', 'any', 'option-2,option-4'),
      ),
      array(
        'id' => 'kaveh_number_sms',
        'type' => 'text',
        'title' => ' شماره فرستنده ',
        'dependency' => array('kaveh_sms_gateway', 'any', 'option-1'),
      ),
      array(
        'id' => 'kaveh_pattern_sms',
        'type' => 'text',
        'title' => 'پترن قالب',
        'dependency' => array('kaveh_sms_gateway', 'any', 'option-1,option-2,option-3,option-4'),
      ),
      array(
        'type' => 'notice',
        'style' => 'info',
        'content' => 'حتما یک پترن به صورت زیر در پنل پیامک خود ایجاد کنید و کد آن را در پترن قالب قرار دهید. لازم به ذکر است تا زمان تایید پترن امکان ارسال وجود ندارد',
      ),
      array(
        'type' => 'notice',
        'style' => 'warning',
        'content' => 'کد تأیید شما %verification-code%
              نام سایت شما
              Yoursite.com',
        'dependency' => array('kaveh_sms_gateway', '==', 'option-1'),

      ),
      array(
        'type' => 'notice',
        'style' => 'warning',
        'content' => 'کد تأیید شما [code] 
      
                      نام سایت شما
                      Yoursite.com',
        'dependency' => array('kaveh_sms_gateway', '==', 'option-2'),

      ),
      array(
        'type' => 'notice',
        'style' => 'warning',
        'content' => 'کد تأیید شما {0} 
      
                      نام سایت شما
                      Yoursite.com',
        'dependency' => array('kaveh_sms_gateway', '==', 'option-3'),

      ),

    );

  }

  private function get_secion_backup_gateway()
  {

    return array(
      array(
        'type' => 'notice',
        'style' => 'info',
        'content' => ' نکته: پنل های پیامکی فراز اس ام اس، مکس اس ام اس و مدیانا از ippanel استفاده می کنند
              . اکثر پنل های پیامکی نماینده آی پی پنل هستند و در کاوه پشتیبانی میشود',
      ),
      array(
        'id' => 'kaveh_sms_gateway2',
        'type' => 'select',
        'title' => 'انتخاب پنل پیامک',
        'options' => array(
          'option-1' => 'ippanel',
          'option-2' => 'sms.ir',
          'option-3' => 'melipayamak',
          'option-4' => 'kavenegar',
          'option-5' => 'raygansms',
        ),
        'default' => 'option-1'
      ),
      array(
        'id' => 'kaveh_username_sms2',
        'type' => 'text',
        'title' => 'نام کاربری	',
        'dependency' => array('kaveh_sms_gateway2', 'any', 'option-1,option-3,option-5'),
      ),
      array(
        'id' => 'kaveh_password_sms2',
        'type' => 'text',
        'title' => 'رمز عبور	',
        'dependency' => array('kaveh_sms_gateway2', 'any', 'option-1,option-3,option-5'),
      ),
      array(
        'id' => 'kaveh_matn_raygansms2',
        'type' => 'text',
        'title' => 'متن پیامک شما',
        'dafault' => 'خوش آمدید! کد تایید شما:',
        'dependency' => array('kaveh_sms_gateway2', 'any', 'option-5'),
      ),
      array(
        'id' => 'kaveh_password_api2',
        'type' => 'text',
        'title' => 'کلید وب سرویس (API key)',
        'dependency' => array('kaveh_sms_gateway2', 'any', 'option-2,option-4'),
      ),
      array(
        'id' => 'kaveh_number_sms2',
        'type' => 'text',
        'title' => ' شماره فرستنده ',
        'dependency' => array('kaveh_sms_gateway2', 'any', 'option-1'),
      ),
      array(
        'id' => 'kaveh_pattern_sms2',
        'type' => 'text',
        'title' => 'پترن قالب',
        'dependency' => array('kaveh_sms_gateway2', 'any', 'option-1,option-2,option-3,option-4'),
      ),
      array(
        'type' => 'notice',
        'style' => 'info',
        'content' => 'حتما یک پترن به صورت زیر در پنل پیامک خود ایجاد کنید و کد آن را در پترن قالب قرار دهید. لازم به ذکر است تا زمان تایید پترن امکان ارسال وجود ندارد',
      ),
      array(
        'type' => 'notice',
        'style' => 'warning',
        'content' => 'کد تأیید شما %verification-code%
              نام سایت شما
              Yoursite.com',
        'dependency' => array('kaveh_sms_gateway2', '==', 'option-1'),

      ),
      array(
        'type' => 'notice',
        'style' => 'warning',
        'content' => 'کد تأیید شما [code] 
      
                      نام سایت شما
                      Yoursite.com',
        'dependency' => array('kaveh_sms_gateway2', '==', 'option-2'),

      ),
      array(
        'type' => 'notice',
        'style' => 'warning',
        'content' => 'کد تأیید شما {0} 
      
                      نام سایت شما
                      Yoursite.com',
        'dependency' => array('kaveh_sms_gateway2', '==', 'option-3'),

      ),

    );

  }

  private function get_secion_export_import()
  {
    return array(
      array(
        'type' => 'notice',
        'style' => 'info',
        'content' => 'اگر بخواید از تنظیمات بکاپ بگیرید و در سایت دیگر یا همین سایت بعدا مجدد ریستور کنید از این بخش اقدام میکنید',
      ),
      array(
        'type' => 'backup',
      ),
    );

  }

  private function get_section_custom_code()
  {
    return array(

      array(
        'id' => 'kaveh_header_code',
        'type' => 'code_editor',
        'sanitize' => false,
        'title' => 'کد های سفارشی در قسمت هدر ',
        'subtitle' => 'قرار دادن کد های سفارشی مانند کد های اتصال به گوگل آنالیتیکس و ...',
        'settings' => array(
          'theme' => 'shadowfox',
          'mode' => 'htmlmixed',
        ),
        'default' => '
<!-- <div class="wrapper">
  <h1>Hello world</h1>
  <p>Lorem <strong>ipsum</strong> dollar.</p>
</div> -->',
      ),


      array(
        'id' => 'kaveh_footer_code',
        'type' => 'code_editor',
        'sanitize' => false,
        'title' => 'کدهای سفارشی در قسمت فوتر',
        'subtitle' => 'قرار دادن کد های سفارشی مانند کد های اتصال به گوگل آنالیتیکس و ...',
        'settings' => array(
          'theme' => 'shadowfox',
          'mode' => 'htmlmixed',
        ),
        'default' => '
<!-- <div class="wrapper">
  <h1>Hello world</h1>
  <p>Lorem <strong>ipsum</strong> dollar.</p>
</div> -->',
      ),

      array(
        'id' => 'kaveh_js_code',
        'type' => 'code_editor',
        'sanitize' => false,
        'title' => 'کد های جاواسکریپت سفارشی',
        'subtitle' => 'اگر بخواهید کد جاواسکریپت سفارشی به قالب اضافه کنید از این قسمت اقدام کنید',
        'settings' => array(
          'theme' => 'dracula',
          'mode' => 'javascript',
        ),
        'default' => '
jQuery(document).ready(function () {


});
        ',
      ),

      array(
        'id' => 'kaveh_css_code',
        'type' => 'code_editor',
        'sanitize' => false,
        'title' => 'کد های سفارشی سی اس اس',
        'subtitle' => 'اگر بخواهید کد سی اس اس به قالب اضافه کنید اینجا این کار را انجام دهید',
        'settings' => array(
          'theme' => 'mbo',
          'mode' => 'css',
        ),
        'default' => '
.body {
 /*code*/
}',
      ),
    );
  }

  public function my_custom_font_family($fonts)
  {

    // Adding new icons
    $fonts['YekanBakh'] = array('100', '200', '300', 'normal', '500', '600', '700', '800', '900');
    $fonts['IRANSansX'] = array('100', '200', '300', 'normal', '500', '600', '700', '800', '900');
    $fonts['IRANYekanX'] = array('100', '200', '300', 'normal', '500', '600', '700', '800', '900');
    $fonts['Morabba'] = array('100', '200', '300', 'normal', '500', '600', '700', '800', '900');
    $fonts['Dana'] = array('100', '200', '300', 'normal', '500', '600', '700', '800', '900');
    $fonts['Abr'] = array('100', '200', '300', 'normal', '500', '600', '700', '800', '900');
    $fonts['Doran'] = array('100', '200', '300', 'normal', '500', '600', '700', '800', '900');
    $fonts['Anjoman'] = array('100', '200', '300', 'normal', '500', '600', '700', '800', '900');

    return $fonts;

  }

}