<?php
class kavehElementor {

    public function __construct() {
        add_action('elementor/editor/before_enqueue_scripts', array($this, 'enqueueStyles'));
        if (did_action('elementor/loaded')) {
            add_action('elementor/editor/before_enqueue_scripts', array($this, 'customizeWidgetIcons'));
        }
    }


    public function enqueueStyles() {
        wp_register_style('kaveh-elementor-editor-style', KAVEH_TEMPLATE_URI . '/assets/css/kaveh-elementor-editor-style.css', array(), '1.0.0');
        wp_enqueue_style('kaveh-elementor-editor-style');
    }


    public function customizeWidgetIcons() {
        if (get_locale() == 'fa_IR' || get_locale() == 'fa_AF') {
            $logo_url = KAVEH_TEMPLATE_URI . '/assets/images/kaveh/logo-el.png';
            $css = '.elementor-element .icon .eicon-archive-posts:before {
                color: transparent;
                background-image: url(' . $logo_url . ');
                display: block;
                background-size: contain;
                background-repeat: no-repeat;
                background-position: center center;
                height: 100%;
                width: 80px;
            }';
            wp_add_inline_style('kaveh-elementor-editor-style', $css);
        }
    }
}