<?php
class kavehDemos {
    public function __construct() {
        add_filter( 'hdi_import_files', array($this, 'kaveh_demo_imports' ));
    }

    public function kaveh_demo_imports(){
        return array(
            'demo1' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی یک - دموی دیجیتال',
                'external_url' => 'https://kaveh.moeinwp.com/demos/full-importers/demo1.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/1.png',
                'preview_url' => 'https://kaveh.moeinwp.com/1',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'full' => 'دمو و محتوا (محصولات و نوشته ها)',
                )
            ),
            'demo2' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی دو - دموی مبلمان',
                'external_url' => 'https://kaveh.moeinwp.com/demos/full-importers/demo2.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/2.png',
                'preview_url' => 'https://kaveh.moeinwp.com/2',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-مبلمان',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'full' => 'دمو و محتوا (محصولات و نوشته ها)',
                )
            ),
            'demo3' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی سه - دموی اکسسوری',
                'external_url' => 'https://kaveh.moeinwp.com/demos/full-importers/demo3.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/3.png',
                'preview_url' => 'https://kaveh.moeinwp.com/3',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-اکسسوری',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'full' => 'دمو و محتوا (محصولات و نوشته ها)',
                )
            ),
            'demo4' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دمو چهار - دمو لباس',
                'external_url' => 'https://kaveh.moeinwp.com/demos/full-importers/demo4.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/4.png',
                'preview_url' => 'https://kaveh.moeinwp.com/4',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-لباس',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'full' => 'دمو و محتوا (محصولات و نوشته ها)',
                )
            ),
            'demo5' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی پنج - دمو پت شاپ',
                'external_url' => 'https://kaveh.moeinwp.com/demos/full-importers/demo5.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/5.png',
                'preview_url' => 'https://kaveh.moeinwp.com/5',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-پت-شاپ',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'full' => 'دمو و محتوا (محصولات و نوشته ها)',
                )
            ),
            'demo6' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی شش - دمو ورزشی',
                'external_url' => 'https://kaveh.moeinwp.com/demos/full-importers/demo6.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/6.png',
                'preview_url' => 'https://kaveh.moeinwp.com/6',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-ورزشی',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'full' => 'دمو و محتوا (محصولات و نوشته ها)',
                )
            ),
            'demo7' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی هفت - دموی مکمل ورزشی',
                'external_url' => 'https://kaveh.moeinwp.com/demos/full-importers/demo7.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/7.png',
                'preview_url' => 'https://kaveh.moeinwp.com/7',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                    'visibility-logic-elementor' => array(
                        'name' => 'visibility-logic-elementor',
                        'source' => 'remote',
                        'file_path' => 'visibility-logic-elementor/conditional.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/visibility-logic-elementor.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                    'visibility-logic-elementor-pro' => array(
                        'name' => 'visibility-logic-elementor-pro',
                        'source' => 'remote',
                        'file_path' => 'visibility-logic-elementor-pro/conditional.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/visibility-logic-elementor-pro.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-مکمل-ورزشی',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'full' => 'دمو و محتوا (محصولات و نوشته ها)',
                )
            ),
            'demo8' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دمو هشت - دمو کوهنوردی',
                'external_url' => 'https://kaveh.moeinwp.com/demos/full-importers/demo8.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/8.png',
                'preview_url' => 'https://kaveh.moeinwp.com/8',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-کوهنوردی',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'full' => 'دمو و محتوا (محصولات و نوشته ها)',
                )
            ),
            'demo9' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی نه - دموی کنسول بازی',
                'external_url' => 'https://kaveh.moeinwp.com/demos/full-importers/demo9.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/9.png',
                'preview_url' => 'https://kaveh.moeinwp.com/9',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                    'visibility-logic-elementor' => array(
                        'name' => 'visibility-logic-elementor',
                        'source' => 'remote',
                        'file_path' => 'visibility-logic-elementor/conditional.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/visibility-logic-elementor.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                    'visibility-logic-elementor-pro' => array(
                        'name' => 'visibility-logic-elementor-pro',
                        'source' => 'remote',
                        'file_path' => 'visibility-logic-elementor-pro/conditional.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/visibility-logic-elementor-pro.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-کنسول-بازی',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'full' => 'دمو و محتوا (محصولات و نوشته ها)',
                )
            ),
            'demo11' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دمو یازده - دمو ابزار آلات',
                'external_url' => 'https://kaveh.moeinwp.com/demos/full-importers/demo11.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/11.png',
                'preview_url' => 'https://kaveh.moeinwp.com/11',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-ابزار-آلات',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'full' => 'دمو و محتوا (محصولات و نوشته ها)',
                )
            ),
            'demo12' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دمو دوازده - دمو لوازم خانگی',
                'external_url' => 'https://kaveh.moeinwp.com/demos/full-importers/demo12.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/12.png',
                'preview_url' => 'https://kaveh.moeinwp.com/12',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-لوازم-خانگی',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'full' => 'دمو و محتوا (محصولات و نوشته ها)',
                )
            ),
            'demo13' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی سیزده - دموی گیمینگ',
                'external_url' => 'https://kaveh.moeinwp.com/demos/full-importers/demo13.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/13.png',
                'preview_url' => 'https://kaveh.moeinwp.com/13',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                    'visibility-logic-elementor' => array(
                        'name' => 'visibility-logic-elementor',
                        'source' => 'remote',
                        'file_path' => 'visibility-logic-elementor/conditional.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/visibility-logic-elementor.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                    'visibility-logic-elementor-pro' => array(
                        'name' => 'visibility-logic-elementor-pro',
                        'source' => 'remote',
                        'file_path' => 'visibility-logic-elementor-pro/conditional.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/visibility-logic-elementor-pro.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-گیمینگ',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'full' => 'دمو و محتوا (محصولات و نوشته ها)',
                )
            ),
            'demo14' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی چهارده - دموی عطر و ادکلن',
                'external_url' => 'https://kaveh.moeinwp.com/demos/full-importers/demo14.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/14.png',
                'preview_url' => 'https://kaveh.moeinwp.com/14',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-عطر-و-ادکلن',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'full' => 'دمو و محتوا (محصولات و نوشته ها)',
                )
            ),
            'demo15' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی پانزده - دموی صنایع دستی ',
                'external_url' => 'https://kaveh.moeinwp.com/demos/full-importers/demo15.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/15.png',
                'preview_url' => 'https://kaveh.moeinwp.com/15',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-صنایع-دستی',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'full' => 'دمو و محتوا (محصولات و نوشته ها)',
                )
            ),
            'demo16' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی شانزده - دموی سوپر مارکت ',
                'external_url' => 'https://kaveh.moeinwp.com/demos/full-importers/demo16.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/16.png',
                'preview_url' => 'https://kaveh.moeinwp.com/16',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-سوپر-مارکت',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'full' => 'دمو و محتوا (محصولات و نوشته ها)',
                )
            ),
            'demo17' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی هفده  دموی دیجیتال دو',
                'external_url' => 'https://kaveh.moeinwp.com/demos/full-importers/demo17.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/17.png',
                'preview_url' => 'https://kaveh.moeinwp.com/17',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال-دو',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'full' => 'دمو و محتوا (محصولات و نوشته ها)',
                )
            ),
            'demo18' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی هجده - دموی فروشگاه کتاب',
                'external_url' => 'https://kaveh.moeinwp.com/demos/full-importers/demo18.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/18.png',
                'preview_url' => 'https://kaveh.moeinwp.com/18',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال-دو',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'full' => 'دمو و محتوا (محصولات و نوشته ها)',
                )
            ),
            'demo19' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی نوزده - دموی لپ تاپ',
                'external_url' => 'https://kaveh.moeinwp.com/demos/full-importers/demo19.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/19.png',
                'preview_url' => 'https://kaveh.moeinwp.com/19',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال-دو',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'full' => 'دمو و محتوا (محصولات و نوشته ها)',
                )
            ),
            'demo20' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی بیست - دموی اسباب بازی',
                'external_url' => 'https://kaveh.moeinwp.com/demos/full-importers/demo20.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/20.png',
                'preview_url' => 'https://kaveh.moeinwp.com/20',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال-دو',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'full' => 'دمو و محتوا (محصولات و نوشته ها)',
                )
            ),
            'demo21' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی بیست و یک - دموی فرش',
                'external_url' => 'https://kaveh.moeinwp.com/demos/full-importers/demo21.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/21.png',
                'preview_url' => 'https://kaveh.moeinwp.com/21',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال-دو',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'full' => 'دمو و محتوا (محصولات و نوشته ها)',
                )
            ),
            'demo22' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی بیست و دوم - دموی چرم',
                'external_url' => 'https://kaveh.moeinwp.com/demos/full-importers/demo22.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/22.png',
                'preview_url' => 'https://kaveh.moeinwp.com/22',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال-دو',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'full' => 'دمو و محتوا (محصولات و نوشته ها)',
                )
            ),
            'demo23' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی بیست و سوم - دموی سیسمونی',
                'external_url' => 'https://kaveh.moeinwp.com/demos/full-importers/demo23.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/23.png',
                'preview_url' => 'https://kaveh.moeinwp.com/23',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال-دو',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'full' => 'دمو و محتوا (محصولات و نوشته ها)',
                )
            ),
            'demo24' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی بیست و چهار - دموی پزشکی',
                'external_url' => 'https://kaveh.moeinwp.com/demos/full-importers/demo24.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/24.png',
                'preview_url' => 'https://kaveh.moeinwp.com/24',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال-دو',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'full' => 'دمو و محتوا (محصولات و نوشته ها)',
                )
            ),
            'demo25' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی بیست و پنج - دموی آرایشی',
                'external_url' => 'https://kaveh.moeinwp.com/demos/full-importers/demo25.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/25.png',
                'preview_url' => 'https://kaveh.moeinwp.com/25',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال-دو',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'full' => 'دمو و محتوا (محصولات و نوشته ها)',
                )
            ),
            'demo26' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی بیست و شش - دموی دوربین و تولید محتوا',
                'external_url' => 'https://kaveh.moeinwp.com/demos/full-importers/demo26.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/26.png',
                'preview_url' => 'https://kaveh.moeinwp.com/26',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال-دو',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'full' => 'دمو و محتوا (محصولات و نوشته ها)',
                )
            ),
            'demo27' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی بیست و هفت - دموی دیجیکالا',
                'external_url' => 'https://kaveh.moeinwp.com/demos/full-importers/demo27.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/27.png',
                'preview_url' => 'https://kaveh.moeinwp.com/27',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال-دو',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'full' => 'دمو و محتوا (محصولات و نوشته ها)',
                )
            ),
            'demo28' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی بیست و هشت - دموی شیر آلات',
                'external_url' => 'https://kaveh.moeinwp.com/demos/full-importers/demo28.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/28.png',
                'preview_url' => 'https://kaveh.moeinwp.com/28',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال-دو',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'full' => 'دمو و محتوا (محصولات و نوشته ها)',
                )
            ),
            'demo29' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی بیست و نه - دموی آرایشی',
                'external_url' => 'https://kaveh.moeinwp.com/demos/full-importers/demo29.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/29.png',
                'preview_url' => 'https://kaveh.moeinwp.com/29',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال-دو',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'full' => 'دمو و محتوا (محصولات و نوشته ها)',
                )
            ),
            'demo30' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی سی - دموی کادویی',
                'external_url' => 'https://kaveh.moeinwp.com/demos/full-importers/demo30.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/30.png',
                'preview_url' => 'https://kaveh.moeinwp.com/30',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال-دو',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'full' => 'دمو و محتوا (محصولات و نوشته ها)',
                )
            ),
            'demo31' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی سی و یک - دموی لباس و پوشاک',
                'external_url' => 'https://kaveh.moeinwp.com/demos/full-importers/demo31.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/31.png',
                'preview_url' => 'https://kaveh.moeinwp.com/31',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال-دو',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'full' => 'دمو و محتوا (محصولات و نوشته ها)',
                )
            ),
            'demo32' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی سی و دو - دموی گل و گیاه',
                'external_url' => 'https://kaveh.moeinwp.com/demos/full-importers/demo32.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/32.png',
                'preview_url' => 'https://kaveh.moeinwp.com/32',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال-دو',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'full' => 'دمو و محتوا (محصولات و نوشته ها)',
                )
            ),
            'demo33' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی سی و سه - دموی اپل ان آی سی',
                'external_url' => 'https://kaveh.moeinwp.com/demos/full-importers/demo33.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/33.png',
                'preview_url' => 'https://kaveh.moeinwp.com/33',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال-دو',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'full' => 'دمو و محتوا (محصولات و نوشته ها)',
                )
            ),
            'demo34' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی سی و چهار - دموی دیجی استایل',
                'external_url' => 'https://kaveh.moeinwp.com/demos/full-importers/demo34.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/34.png',
                'preview_url' => 'https://kaveh.moeinwp.com/34',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال-دو',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'full' => 'دمو و محتوا (محصولات و نوشته ها)',
                )
            ),
            'demo35' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی سی و پنج - دموی بانی مند',
                'external_url' => 'https://kaveh.moeinwp.com/demos/full-importers/demo35.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/35.png',
                'preview_url' => 'https://kaveh.moeinwp.com/35',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال-دو',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'full' => 'دمو و محتوا (محصولات و نوشته ها)',
                )
            ),
            
 
    
            'demo36' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی یک - دموی دیجیتال',
                'external_url' => 'https://kaveh.moeinwp.com/demos/empty-importers/demo27.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/1.png',
                'preview_url' => 'https://kaveh.moeinwp.com/1',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'home_slug' => 'دمو-دیجیتال',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'empty' => 'دموی خام',
                )
            ),
            'demo37' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی دو - دموی مبلمان',
                'external_url' => 'https://kaveh.moeinwp.com/demos/empty-importers/demo28.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/2.png',
                'preview_url' => 'https://kaveh.moeinwp.com/2',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-مبلمان',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'empty' => 'دموی خام',
                )
            ),
            'demo38' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی سه - دموی اکسسوری',
                'external_url' => 'https://kaveh.moeinwp.com/demos/empty-importers/demo29.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/3.png',
                'preview_url' => 'https://kaveh.moeinwp.com/3',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-اکسسوری',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'empty' => 'دموی خام',
                )
            ),
            'demo39' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دمو چهار - دمو لباس',
                'external_url' => 'https://kaveh.moeinwp.com/demos/empty-importers/demo30.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/4.png',
                'preview_url' => 'https://kaveh.moeinwp.com/4',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-لباس',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'empty' => 'دموی خام',
                )
            ),
            'demo40' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی پنج - دمو پت شاپ',
                'external_url' => 'https://kaveh.moeinwp.com/demos/empty-importers/demo31.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/5.png',
                'preview_url' => 'https://kaveh.moeinwp.com/5',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-پت-شاپ',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'empty' => 'دموی خام',
                )
            ),
            'demo41' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی شش - دمو ورزشی',
                'external_url' => 'https://kaveh.moeinwp.com/demos/empty-importers/demo32.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/6.png',
                'preview_url' => 'https://kaveh.moeinwp.com/6',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-ورزشی',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'empty' => 'دموی خام',
                )
            ),
            'demo42' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی هفت - دموی مکمل ورزشی',
                'external_url' => 'https://kaveh.moeinwp.com/demos/empty-importers/demo33.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/7.png',
                'preview_url' => 'https://kaveh.moeinwp.com/7',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                    'visibility-logic-elementor' => array(
                        'name' => 'visibility-logic-elementor',
                        'source' => 'remote',
                        'file_path' => 'visibility-logic-elementor/conditional.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/visibility-logic-elementor.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                    'visibility-logic-elementor-pro' => array(
                        'name' => 'visibility-logic-elementor-pro',
                        'source' => 'remote',
                        'file_path' => 'visibility-logic-elementor-pro/conditional.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/visibility-logic-elementor-pro.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-مکمل-ورزشی',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'empty' => 'دموی خام',
                )
            ),
            'demo43' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دمو هشت - دمو کوهنوردی',
                'external_url' => 'https://kaveh.moeinwp.com/demos/empty-importers/demo34.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/8.png',
                'preview_url' => 'https://kaveh.moeinwp.com/8',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-کوهنوردی',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'empty' => 'دموی خام',
                )
            ),
            'demo44' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی نه - دموی کنسول بازی',
                'external_url' => 'https://kaveh.moeinwp.com/demos/empty-importers/demo35.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/9.png',
                'preview_url' => 'https://kaveh.moeinwp.com/9',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                    'visibility-logic-elementor' => array(
                        'name' => 'visibility-logic-elementor',
                        'source' => 'remote',
                        'file_path' => 'visibility-logic-elementor/conditional.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/visibility-logic-elementor.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                    'visibility-logic-elementor-pro' => array(
                        'name' => 'visibility-logic-elementor-pro',
                        'source' => 'remote',
                        'file_path' => 'visibility-logic-elementor-pro/conditional.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/visibility-logic-elementor-pro.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-کنسول-بازی',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'empty' => 'دموی خام',
                )
            ),
            'demo45' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دمو یازده - دمو ابزار آلات',
                'external_url' => 'https://kaveh.moeinwp.com/demos/empty-importers/demo36.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/11.png',
                'preview_url' => 'https://kaveh.moeinwp.com/11',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-ابزار-آلات',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'empty' => 'دموی خام',
                )
            ),
            'demo46' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دمو دوازده - دمو لوازم خانگی',
                'external_url' => 'https://kaveh.moeinwp.com/demos/empty-importers/demo37.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/12.png',
                'preview_url' => 'https://kaveh.moeinwp.com/12',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-لوازم-خانگی',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'empty' => 'دموی خام',
                )
            ),
            'demo47' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی سیزده - دموی گیمینگ',
                'external_url' => 'https://kaveh.moeinwp.com/demos/empty-importers/demo38.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/13.png',
                'preview_url' => 'https://kaveh.moeinwp.com/13',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                    'visibility-logic-elementor' => array(
                        'name' => 'visibility-logic-elementor',
                        'source' => 'remote',
                        'file_path' => 'visibility-logic-elementor/conditional.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/visibility-logic-elementor.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                    'visibility-logic-elementor-pro' => array(
                        'name' => 'visibility-logic-elementor-pro',
                        'source' => 'remote',
                        'file_path' => 'visibility-logic-elementor-pro/conditional.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/visibility-logic-elementor-pro.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-گیمینگ',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'empty' => 'دموی خام',
                )
            ),
            'demo48' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی چهارده - دموی عطر و ادکلن',
                'external_url' => 'https://kaveh.moeinwp.com/demos/empty-importers/demo39.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/14.png',
                'preview_url' => 'https://kaveh.moeinwp.com/14',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-عطر-و-ادکلن',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'empty' => 'دموی خام',
                )
            ),
            'demo49' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی پانزده - دموی صنایع دستی ',
                'external_url' => 'https://kaveh.moeinwp.com/demos/empty-importers/demo40.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/15.png',
                'preview_url' => 'https://kaveh.moeinwp.com/15',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-صنایع-دستی',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'empty' => 'دموی خام',
                )
            ),
            'demo50' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی شانزده - دموی سوپر مارکت ',
                'external_url' => 'https://kaveh.moeinwp.com/demos/empty-importers/demo41.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/16.png',
                'preview_url' => 'https://kaveh.moeinwp.com/16',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-سوپر-مارکت',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'empty' => 'دموی خام',
                )
            ),
            'demo51' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی هفده  دموی دیجیتال دو',
                'external_url' => 'https://kaveh.moeinwp.com/demos/empty-importers/demo42.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/17.png',
                'preview_url' => 'https://kaveh.moeinwp.com/17',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال-دو',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'empty' => 'دموی خام',
                )
            ),
            'demo52' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی هجده - دموی فروشگاه کتاب',
                'external_url' => 'https://kaveh.moeinwp.com/demos/empty-importers/demo43.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/18.png',
                'preview_url' => 'https://kaveh.moeinwp.com/18',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال-دو',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'empty' => 'دموی خام',
                )
            ),
            'demo53' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی نوزده - دموی لپ تاپ',
                'external_url' => 'https://kaveh.moeinwp.com/demos/empty-importers/demo44.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/19.png',
                'preview_url' => 'https://kaveh.moeinwp.com/19',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال-دو',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'empty' => 'دموی خام',
                )
            ),
            'demo54' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی بیست - دموی اسباب بازی',
                'external_url' => 'https://kaveh.moeinwp.com/demos/empty-importers/demo45.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/20.png',
                'preview_url' => 'https://kaveh.moeinwp.com/20',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال-دو',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'empty' => 'دموی خام',
                )
            ),
            'demo55' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی بیست و یک - دموی فرش',
                'external_url' => 'https://kaveh.moeinwp.com/demos/empty-importers/demo46.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/21.png',
                'preview_url' => 'https://kaveh.moeinwp.com/21',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال-دو',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'empty' => 'دموی خام',
                )
            ),
            'demo56' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی بیست و دوم - دموی چرم',
                'external_url' => 'https://kaveh.moeinwp.com/demos/empty-importers/demo47.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/22.png',
                'preview_url' => 'https://kaveh.moeinwp.com/22',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال-دو',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'empty' => 'دموی خام',
                )
            ),
            'demo57' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی بیست و سوم - دموی سیسمونی',
                'external_url' => 'https://kaveh.moeinwp.com/demos/empty-importers/demo48.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/23.png',
                'preview_url' => 'https://kaveh.moeinwp.com/23',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال-دو',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'empty' => 'دموی خام',
                )
            ),
            'demo58' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی بیست و چهار - دموی پزشکی',
                'external_url' => 'https://kaveh.moeinwp.com/demos/empty-importers/demo49.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/24.png',
                'preview_url' => 'https://kaveh.moeinwp.com/24',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال-دو',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'empty' => 'دموی خام',
                )
            ),
            'demo59' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی بیست و پنج - دموی آرایشی',
                'external_url' => 'https://kaveh.moeinwp.com/demos/empty-importers/demo50.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/25.png',
                'preview_url' => 'https://kaveh.moeinwp.com/25',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال-دو',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'empty' => 'دموی خام',
                )
            ),
            'demo60' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی بیست و شش - دموی دوربین و تولید محتوا',
                'external_url' => 'https://kaveh.moeinwp.com/demos/empty-importers/demo51.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/26.png',
                'preview_url' => 'https://kaveh.moeinwp.com/26',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال-دو',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'empty' => 'دموی خام',
                )
            ),
            'demo61' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی بیست و هفت - دموی دیجیکالا',
                'external_url' => 'https://kaveh.moeinwp.com/demos/empty-importers/demo52.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/27.png',
                'preview_url' => 'https://kaveh.moeinwp.com/27',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال-دو',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'empty' => 'دموی خام',
                )
            ),
            'demo62' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی بیست و هشت - دموی شیر آلات',
                'external_url' => 'https://kaveh.moeinwp.com/demos/empty-importers/demo53.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/28.png',
                'preview_url' => 'https://kaveh.moeinwp.com/28',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال-دو',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'empty' => 'دموی خام',
                )
            ),
            'demo63' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی بیست و نه - دموی آرایشی',
                'external_url' => 'https://kaveh.moeinwp.com/demos/empty-importers/demo54.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/29.png',
                'preview_url' => 'https://kaveh.moeinwp.com/29',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال-دو',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'empty' => 'دموی خام',
                )
            ),
            'demo64' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی سی - دموی کادویی',
                'external_url' => 'https://kaveh.moeinwp.com/demos/empty-importers/demo55.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/30.png',
                'preview_url' => 'https://kaveh.moeinwp.com/30',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال-دو',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'empty' => 'دموی خام',
                )
            ),
            'demo65' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی سی و یک - دموی لباس و پوشاک',
                'external_url' => 'https://kaveh.moeinwp.com/demos/empty-importers/demo56.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/31.png',
                'preview_url' => 'https://kaveh.moeinwp.com/31',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال-دو',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'empty' => 'دموی خام',
                )
            ),
            'demo66' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی سی و دو - دموی گل و گیاه',
                'external_url' => 'https://kaveh.moeinwp.com/demos/empty-importers/demo57.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/32.png',
                'preview_url' => 'https://kaveh.moeinwp.com/32',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال-دو',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'empty' => 'دموی خام',
                )
            ),
            'demo67' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی سی و سه - دموی اپل ان آی سی',
                'external_url' => 'https://kaveh.moeinwp.com/demos/empty-importers/demo58.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/33.png',
                'preview_url' => 'https://kaveh.moeinwp.com/33',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال-دو',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'empty' => 'دموی خام',
                )
            ),
            'demo68' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی سی و چهار - دموی دیجی استایل',
                'external_url' => 'https://kaveh.moeinwp.com/demos/empty-importers/demo59.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/34.png',
                'preview_url' => 'https://kaveh.moeinwp.com/34',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال-دو',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'empty' => 'دموی خام',
                )
            ),
            'demo69' => array( // demo-slug should match the 'external_url' zip file name
                'name' => 'دموی سی و پنج - دموی بانی مند',
                'external_url' => 'https://kaveh.moeinwp.com/demos/empty-importers/demo60.zip', // zip file should contain content.xml, customizer.dat, widget.wie, option_name1.json, option_name2.json, revslider.zip(exported slider content from revolution slider) - you can skip any of the files if your demo does not need it
                'image' => 'https://kaveh.moeinwp.com/demos/pics/35.png',
                'preview_url' => 'https://kaveh.moeinwp.com/35',
                'menu_array' => array( // list of menus
                    'primary' => 'main',
                ),
                'plugins' => array( // these plugins will be installed automatically before demo import
                    'boostify-header-footer-builder' => array(
                        'name' => 'مگامنو ساز کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'boostify-header-footer-builder/boostify-header-footer-builder.php'
                    ),
                    'elementor' => array(
                        'name' => 'المنتور',
                        'source' => 'wordpress',
                        'file_path' => 'elementor/elementor.php'
                    ),
                    'wck-custom-fields-and-custom-post-types-creator' => array(
                        'name' => 'فیلد های اختصاصی کاوه',
                        'source' => 'wordpress',
                        'file_path' => 'wck-custom-fields-and-custom-post-types-creator/wck.php'
                    ),
                    'woocommerce' => array(
                        'name' => 'ووکامرس',
                        'source' => 'wordpress',
                        'file_path' => 'woocommerce/woocommerce.php'
                    ),
                    'woo-smart-compare' => array(
                        'name' => 'افزونه مقایسه محصولات',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-compare/wpc-smart-compare.php'
                    ),
                    'woo-smart-wishlist' => array(
                        'name' => 'افزونه علاقه مندی',
                        'source' => 'wordpress',
                        'file_path' => 'woo-smart-wishlist/wpc-smart-wishlist.php'
                    ),
                    'wpc-variation-swatches' => array(
                        'name' => 'افزونه محصولات متغیر',
                        'source' => 'wordpress',
                        'file_path' => 'wpc-variation-swatches/wpc-variation-swatches.php'
                    ),
                    'kaveh-core' => array(
                        'name' => 'افزونه هسته کاوه',
                        'source' => 'remote',
                        'file_path' => 'kaveh-core/theme-core.php',
                        'location' => 'https://kaveh.moeinwp.com/demos/plugins/kaveh-core.zip' , // if source is 'remote', add the location of the plugin zip
                    ),
                ),
                'home_slug' => 'دمو-دیجیتال-دو',
                'blog_slug' => 'blog',
                'tags' => array( // Optional - add filter tab on the header to sort the demo by their type
                    'empty' => 'دموی خام',
                )
            ),
            
        );
    }
    
}