<?php
class kavehAssets {

    private $options;

    public function __construct() {
        $this->options = get_option('kaveh_frame');
        add_action('wp_enqueue_scripts', array($this, 'oenqueue_styles'));
        add_action('wp_enqueue_scripts', array($this, 'oenqueue_scripts'));
        add_action('wp_footer', array($this, 'kaveh_inline_assets'));
        // add_action('wp_head', array($this, 'pace'));
    }

    public function oenqueue_styles() {
        $this->enqueue_styles();
        $this->enqueue_font_styles();
    }

    public function oenqueue_scripts() {
        $this->enqueue_scripts();
    }

    public function pace(){
        ?>
        <script src="<?php echo KAVEH_TEMPLATE_URI . '/assets/js/pace.min.js'; ?>"></script>
        <?php
    }


    private function enqueue_scripts() {
        $scripts = array(
            'bootstrap.bundle.min' => '/assets/js/bootstrap.bundle.min.js',
            'swiper-bundle.min'    => '/assets/js/swiper-bundle.min.js',
            'nouislider.min'       => '/assets/js/nouislider.min.js',
            'main'                 => '/assets/js/main.min.js',
            'notiflix'             => '/assets/js/notiflix.js',
            'select2.min'          => '/assets/js/select2.min.js',
        );

        foreach ($scripts as $handle => $src) {
            wp_enqueue_script($handle, KAVEH_TEMPLATE_URI . $src, array('jquery'), null, true);
        }

        if ($this->options['kaveh_preload_switch'] == 1) {
            wp_enqueue_script('preloader', KAVEH_TEMPLATE_URI . '/assets/js/preloader.js', array('jquery'), null, true);
        }
    }

    private function enqueue_styles() {

        $styles = array(
            'swiper-bundle.min'  => '/assets/css/swiper-bundle.min.css',
            'nouislider.min'     => '/assets/css/nouislider.min.css',
            'select2.min'        => '/assets/css/select2.min.css',
            'notiflix'           => '/assets/css/notiflix.css',
            'icomoon'            => '/assets/css/icomoon.css',
            'iconsax'            => '/assets/css/iconsax.css',
            'iconly'             => '/assets/css/iconly.css',
            // 'pace'               => '/assets/css/pace.css',
            'bootstrap.min'      => is_rtl() ? '/assets/css/rtl/bootstrap.rtl.min.css' : '/assets/css/ltr/bootstrap.min.css',
            'main.min'           => is_rtl() ? '/assets/css/rtl/main.min.css' : '/assets/css/ltr/main.min.css',
        );

        if(is_checkout() || is_cart()){

            if(is_rtl()){
                $styles['kaveh.min'] = '/assets/css/rtl/kaveh.min.css';
            }else{
                $styles['kaveh.min'] = '/assets/css/ltr/kaveh.min.css';
            }

        }


            
            if(is_rtl()){
                $styles['single-product-page-one'] = '/assets/css/rtl/single-product-page-one.min.css';
            }else{
                $styles['single-product-page-one'] = '/assets/css/ltr/single-product-page-one.min.css';
            }


            if(is_rtl()){
                $styles['single-product-page-two'] = '/assets/css/rtl/single-product-page-two.min.css';
            }else{
                $styles['single-product-page-two'] = '/assets/css/ltr/single-product-page-two.min.css';
            }


            if(is_rtl()){
                $styles['single-product-page-three'] = '/assets/css/rtl/single-product-page-three.min.css';
            }else{
                $styles['single-product-page-three'] = '/assets/css/ltr/single-product-page-three.min.css';
            }


            if(is_rtl()){
                $styles['single-product-page-four'] = '/assets/css/rtl/single-product-page-four.min.css';
            }else{
                $styles['single-product-page-four'] = '/assets/css/ltr/single-product-page-four.min.css';
            }

        

        if ($this->options['kaveh_panel_select'] === 'value-1') {

            if(is_rtl()){
                $styles['panel-one-style'] = '/assets/css/rtl/panel-one-style.min.css';
            }else{
                $styles['panel-one-style'] = '/assets/css/ltr/panel-one-style.min.css';
            }

        }elseif($this->options['kaveh_panel_select'] === 'value-2'){

            if(is_rtl()){
                $styles['panel-two-style'] = '/assets/css/rtl/panel-two-style.min.css';
            }else{
                $styles['panel-two-style'] = '/assets/css/ltr/panel-two-style.min.css';
            }

        }


        foreach ($styles as $handle => $src) {
            wp_enqueue_style($handle, KAVEH_TEMPLATE_URI . $src, false, null, 'all');
        }

        wp_enqueue_style('kaveh', get_bloginfo('stylesheet_url'), false, null, 'all');

    }

    private function enqueue_font_styles() {
        if (is_rtl()) {
            
           if($this->options['kaveh_advanced_typo'] !== '1'):

                if (!empty($this->options['kaveh_typoselect'])) {
                    $fontkaveh = $this->options['kaveh_typoselect'];
                    $rtl_fonts = array(
                        'value-1' => 'kavehirsans.css',
                        'value-2' => 'kavehiryekan.css',
                        'value-3' => 'kavehyekanbakh.css',
                        'value-4' => 'kavehdana.css',
                        'value-5' => 'kavehmoraba.css',
                        'value-6' => 'kavehabr.css',
                        'value-7' => 'kavehdoran.css',
                        'value-8' => 'kavehanjoman.css',
                        'value-9' => 'kavehpeyda.css',
                    );

                    if (isset($rtl_fonts[$fontkaveh])) {
                        wp_enqueue_style('kaveh_' . $fontkaveh, KAVEH_TEMPLATE_URI . '/assets/css/rtl/' . $rtl_fonts[$fontkaveh], false, null, 'all');
                    }
                }

            endif;
        } 
        
        else {
            wp_enqueue_style('custom-google-fonts', 'https://fonts.googleapis.com/css2?family=Plus+Jakarta+Sans:wght@200..800&display=swap', array(), null);
            wp_enqueue_style('kavehltrtypo', KAVEH_TEMPLATE_URI . '/assets/css/ltr/kavehltrtypo.css', false, null, 'all');
        }
    }

    public function kaveh_inline_assets() {
        if (!is_checkout() && in_array($this->options['kaveh_typoselect'], array('value-1', 'value-2', 'value-4'))):
        ?>
            <?php if($this->options['kaveh_advanced_typo'] !== '1'): ?>
                <script type="text/javascript">
                    document.addEventListener("DOMContentLoaded", function() {
                        document.body.innerHTML = document.body.innerHTML.replace(/تومان/g, 'تومانء');
                        document.body.innerHTML = document.body.innerHTML.replace(/ریال/g, 'ریالء');
                    });
                </script>
                <?php
            endif;
        endif;
    }
}
