<?php
class kavehajaxHandler
{

    private $options;

    public function __construct()
    {
        $this->options = get_option('kaveh_frame');
        add_action('wp_enqueue_scripts', array($this, 'enqueueAjaxAssets'));
        add_action('init', array($this, 'initRewriteRules'));
    }

    public function enqueueAjaxAssets()
    {

        $highest_price = 1;
        $lowest_price = 1;
        if (class_exists('woocommerce')) {
            $products = wc_get_products(array('status' => 'publish', 'limit' => -1));
            if (!empty($products)) {
                $all_prices = array();
                foreach ($products as $product) {
                    $all_prices[] = $product->get_price();
                }
                $min_price = min($all_prices);
                $max_price = max($all_prices);
                if (!empty($max_price) || !empty($min_price)) {
                    $highest_price = intval($max_price);
                    $highest_price = $highest_price + 0.1 * $highest_price;
                    $lowest_price = intval($min_price);
                    $lowest_price = $lowest_price - 0.1 * $lowest_price;
                }
            }
        }

        if (class_exists('woocommerce')) {
            $woocommerce_cart_redirect_after_add = get_option('woocommerce_cart_redirect_after_add');
            $cart_url = wc_get_cart_url();
        }
        $fontkaveh = $this->options['kaveh_typoselect'];
        $rtl_fonts = array(
            'value-1' => 'kavehirsans.css',
            'value-2' => 'kavehiryekan.css',
            'value-3' => 'kavehyekanbakh.css',
            'value-4' => 'kavehdana.css',
            'value-5' => 'kavehmoraba.css',
            'value-6' => 'kavehabr.css',
            'value-7' => 'kavehdoran.css',
            'value-8' => 'kavehanjoman.css',
            'value-9' => 'kavehpeyda.css',
        );
        $fontlocalize = array(
            $rtl_fonts[$fontkaveh],
        );
        $datashop = array(
            home_url(),
        );
        wp_enqueue_script('kaveh-ajax-method', KAVEH_TEMPLATE_URI . '/inc/kaveh-ajax-method/kaveh-ajax-method.js', array('jquery'), null, true);
        wp_localize_script('kaveh-ajax-method', 'kfont', $fontlocalize);
        if (!empty($products)) {
            wp_localize_script(
                'kaveh-ajax-method',
                'kavehShopData',
                array(
                    'ksiteurl' => $datashop,
                    'highestPrice' => $highest_price,
                    'lowestPrice' => $lowest_price,
                    'ajaxnoinsingle' => $this->options['ajaxnosingle'],
                    'opencartonaddtocart' => $this->options['opencartonaddtocart'],
                    'woocommerce_cart_redirect_after_add' => $woocommerce_cart_redirect_after_add,
                    'cart_url' => $cart_url,
                )
            );
        }


        if (class_exists('woocommerce')) {
            if (is_product_category() || is_shop()) {
                wp_enqueue_script('kaveh-ajax-shop-method', KAVEH_TEMPLATE_URI . '/inc/kaveh-ajax-method/kaveh-ajax-shop-method.js', array('jquery'), null, true);
                if (!empty($products)) {
                    wp_localize_script(
                        'kaveh-ajax-shop-method',
                        'kavehShopData',
                        array(
                            'ksiteurl' => $datashop,
                            'highestPrice' => $highest_price,
                            'lowestPrice' => $lowest_price,
                            'ajaxnoinsingle' => $this->options['ajaxnosingle'],
                            'woocommerce_cart_redirect_after_add' => $woocommerce_cart_redirect_after_add,
                            'cart_url' => $cart_url,
                        )
                    );
                }
                wp_localize_script('kaveh-ajax-shop-method', 'kfont', $fontlocalize);
            }
        }

        if (!is_user_logged_in()) {
            wp_enqueue_script('kaveh-login-ajax', KAVEH_TEMPLATE_URI . '/inc/kaveh-ajax-method/kaveh-login-ajax.js', array('jquery'), null, true);
            wp_localize_script('kaveh-login-ajax', 'ksiteurl', $datashop);
            wp_localize_script('kaveh-login-ajax', 'kfont', $fontlocalize);
            wp_localize_script('kaveh-login-ajax', 'kinputslatin', $this->options['kaveh_login_latin_fields']);
            wp_localize_script('kaveh-login-ajax', 'kbksms', $this->options['kaveh_login_switchtobackup']);
            wp_localize_script('kaveh-login-ajax', 'kbksmstime', $this->options['kaveh_login_send_again']);
        }

    }

    public function initRewriteRules()
    {

        $this->addRewriteRule('kaveh_ajax_popup', 'kaveh_ajax_popup');
        $this->addRewriteRule('kaveh_ajaxx_add_to_cart', 'kaveh_ajaxx_add_to_cart');
        $this->addRewriteRule('kaveh_ajax_update_cart_kk', 'kaveh_ajax_update_cart_kk');
        $this->addRewriteRule('ajax', 'ajax');
        $this->addRewriteRule('kfilters', 'kfilters');
        $this->addRewriteRule('kavehcss', 'kavehcss');
        $this->addRewriteRule('kaveh_ajax_queries', 'kaveh_ajax_queries');
        $this->addRewriteRule('kaveh_ajax_checkout', 'kaveh_ajax_checkout');
        $this->addRewriteRule('kaveh_product_search', 'kaveh_product_search');

    }

    private function addRewriteRule($tag, $rule)
    {
        add_rewrite_tag('%rewrite_' . $tag . '%', '([^&/]+)');
        add_rewrite_rule($rule . '/?([^/]*)', 'index.php?rewrite_' . $tag . '=$matches[1]', 'top');
    }

}