<?php

class kavehAjaxes
{
  private $options;

  public function __construct()
  {
    $this->options = get_option('kaveh_frame');
    add_action('template_redirect', array($this, 'kaveh_ajaxx_add_to_cart'));
    add_action('template_redirect', array($this, 'kaveh_ajax_popup'));
    add_action('template_redirect', array($this, 'kaveh_ajax_remove_cart_item'));
    add_action('template_redirect', array($this, 'filter_kaveh'));
    add_action('template_redirect', array($this, 'kaveh_ajax_update_cart_kk'));
    add_action('template_redirect', array($this, 'kaveh_ajax_checkout'));
    add_action('template_redirect', array($this, 'handle_product_search'));

  }

  public function handle_product_search() {
    // Verify nonce for security
    global $wp_query;
    $method = $wp_query->get('rewrite_kaveh_product_search');
    if (!$method) {
      return;
    }
    if($method === 'search') {
      $search_query = sanitize_text_field($_POST['search']);
      // Setup WooCommerce product query
      $args = array(
          'post_type'      => 'product',
          'post_status'    => 'publish',
          'posts_per_page' => 8,
          's'              => $search_query,
          'orderby'        => 'relevance',
          'tax_query'      => array(
              array(
                  'taxonomy' => 'product_visibility',
                  'field'    => 'name',
                  'terms'    => 'exclude-from-search',
                  'operator' => 'NOT IN',
              ),
          ),
      );
  
      // Create WC Query
      $query = new WP_Query($args);
      
      $results = array();
      
      if ($query->have_posts()) {
          while ($query->have_posts()) {
              $query->the_post();
              $product = wc_get_product(get_the_ID());
              
              if (!$product) {
                  continue;
              }
  
              // Get primary category
              $categories = get_the_terms(get_the_ID(), 'product_cat');
              $category = array();
              if ($categories && !is_wp_error($categories)) {
                  $category = array(
                      'name' => $categories[0]->name,
                      'slug' => $categories[0]->slug,
                      'link' => get_term_link($categories[0]->term_id, 'product_cat')
                  );
              }
  
              // Get product thumbnail
              $thumbnail_url = get_the_post_thumbnail_url(get_the_ID(), 'woocommerce_thumbnail');
              if (!$thumbnail_url) {
                  $thumbnail_url = wc_placeholder_img_src();
              }
  
              $results[] = array(
                  'id'          => $product->get_id(),
                  'name'        => $product->get_name(),
                  'permalink'   => get_permalink(),
                  'price_html'  => $product->get_price_html(),
                  'thumbnail'   => $thumbnail_url,
                  'category'    => $category,
                  'sku'         => $product->get_sku(),
                  'stock'       => $product->is_in_stock(),
                  'on_sale'     => $product->is_on_sale()
              );
          }
      }
      
      wp_reset_postdata();
      
      wp_send_json(array(
          'success' => true,
          'data'    => $results
      ));

    }
    
  }


  public function kaveh_ajax_checkout()
  {
    global $wp_query;
    $method = $wp_query->get('rewrite_kaveh_ajax_checkout');
    if (!$method) {
      return;
    }
    if ($method === 'new_address_modal'):
      $user_id = $_POST['user_id'];
      $billing_first_name = get_user_meta($user_id, 'billing_first_name', true);
      $billing_last_name = get_user_meta($user_id, 'billing_last_name', true);
      $billing_phone = get_user_meta($user_id, 'billing_phone', true);
      $billing_email = get_user_meta($user_id, 'billing_email', true);
      $billing_state = get_user_meta($user_id, 'billing_state', true);
      $billing_city = get_user_meta($user_id, 'billing_city', true);
      $billing_address_1 = get_user_meta($user_id, 'billing_address_1', true);
      $billing_address_2 = get_user_meta($user_id, 'billing_address_2', true);
      $billing_postcode = get_user_meta($user_id, 'billing_postcode', true);
      $billing_company = get_user_meta($user_id, 'billing_company', true);
      $billing_country = get_user_meta($user_id, 'billing_country', true);
      ?>
      <div class="modal-content">
        <div class="modal-header">
          <div class="modal-title fw-bold"> افزودن آدرس جدید </div>
          <button type="button" class="modal-close lh-1 p-0" data-bs-dismiss="modal">
            <i class="icon-close"></i>
          </button>
        </div>
        <div class="modal-body">
          <div class="woocommerce-billing-fields__field-wrapper">
            <?php if (!empty($this->options['kwoofields']['enabled'])): ?>

              <?php if (array_key_exists("billing_first_name", $this->options['kwoofields']['enabled'])): ?>
                <p class="form-row form-row-first" id="billing_first_name_field">
                  <input type="text" class="input-text " name="billing_first_name" id="billing_first_name" placeholder="نام"
                    autocomplete="given-name">
                </p>
              <?php endif; ?>

              <?php if (array_key_exists("billing_last_name", $this->options['kwoofields']['enabled'])): ?>
                <p class="form-row form-row-last" id="billing_last_name_field">
                  <input type="text" class="input-text" name="billing_last_name" id="billing_last_name" placeholder="نام خانوادگی"
                    autocomplete="family-name">
                </p>
              <?php endif; ?>

              <?php if (array_key_exists("billing_company", $this->options['kwoofields']['enabled'])): ?>
                <p class="form-row form-row-wide" id="billing_company_field">
                  <input type="text" class="input-text" name="billing_company" id="billing_company" placeholder="نام شرکت"
                    autocomplete="organization">
                </p>
              <?php endif; ?>

              <?php if (array_key_exists("billing_country", $this->options['kwoofields']['enabled'])): ?>
                <p class="form-row form-row-wide address-field update_totals_on_change" id="billing_country_field"
                  data-priority="40"><select name="billing_country" id="billing_country" class="country_to_state country_select"
                    autocomplete="country" data-placeholder="کشور/منطقه را انتخاب کنید…" data-label="کشور / منطقه" tabindex="-1"
                    aria-hidden="true">
                    <option value="">کشور/منطقه را انتخاب کنید…</option>
                    <option value="AZ">آذربایجان</option>
                    <option value="AR">آرژانتین</option>
                    <option value="AW">آروبا</option>
                    <option value="ZA">آفریقای جنوبی</option>
                    <option value="AL">آلبانی</option>
                    <option value="DE">آلمان</option>
                    <option value="US">آمریکا</option>
                    <option value="AG">آنتیگوا و باربودا</option>
                    <option value="AD">آندورا</option>
                    <option value="AO">آنگولا</option>
                    <option value="AI">آنگویلا</option>
                    <option value="AT">اتریش</option>
                    <option value="ET">اتیوپی</option>
                    <option value="JO">اردن</option>
                    <option value="AM">ارمنستان</option>
                    <option value="ER">اریتره</option>
                    <option value="UZ">ازبکستان</option>
                    <option value="ES">اسپانیا</option>
                    <option value="AU">استرالیا</option>
                    <option value="EE">استونی</option>
                    <option value="IL">اسرائیل</option>
                    <option value="SK">اسلواکی</option>
                    <option value="SI">اسلوونی</option>
                    <option value="AF">افغانستان</option>
                    <option value="EC">اکوادور</option>
                    <option value="DZ">الجزایر</option>
                    <option value="SV">السالوادور</option>
                    <option value="AE">امارات متحده عربی</option>
                    <option value="ID">اندونزی</option>
                    <option value="GB">انگلستان</option>
                    <option value="UY">اوروگوئه</option>
                    <option value="UA">اوکراین</option>
                    <option value="UG">اوگاندا</option>
                    <option value="IT">ایتالیا</option>
                    <option value="IR" selected="selected">ایران</option>
                    <option value="IE">ایرلند</option>
                    <option value="IS">ایسلند</option>
                    <option value="BB">باربادوس</option>
                    <option value="BS">باهاما</option>
                    <option value="BH">بحرین</option>
                    <option value="BR">برزیل</option>
                    <option value="BM">برمودا</option>
                    <option value="BN">برونئی</option>
                    <option value="BY">بلاروس</option>
                    <option value="BE">بلژیک</option>
                    <option value="BG">بلغارستان</option>
                    <option value="BZ">بلیز</option>
                    <option value="BD">بنگلادش</option>
                    <option value="BJ">بنین</option>
                    <option value="BT">بوتان</option>
                    <option value="BW">بوتسوانا</option>
                    <option value="BF">بورکینافاسو</option>
                    <option value="BI">بوروندی</option>
                    <option value="BA">بوسنی و هرزگوین</option>
                    <option value="BO">بولیوی</option>
                    <option value="PG">پاپوآ گینه نو</option>
                    <option value="PY">پاراگوئه</option>
                    <option value="PK">پاکستان</option>
                    <option value="PW">پالائو</option>
                    <option value="PA">پاناما</option>
                    <option value="PT">پرتغال</option>
                    <option value="PE">پرو</option>
                    <option value="PF">پلی‌نزی فرانسه</option>
                    <option value="PR">پورتوریکو</option>
                    <option value="TJ">تاجیکستان</option>
                    <option value="TZ">تانزانیا</option>
                    <option value="TH">تایلند</option>
                    <option value="TW">تایوان</option>
                    <option value="TM">ترکمنستان</option>
                    <option value="TR">ترکیه</option>
                    <option value="TT">ترینیداد و توباگو</option>
                    <option value="TK">توکلائو</option>
                    <option value="TG">توگو</option>
                    <option value="TN">تونس</option>
                    <option value="TO">تونگا</option>
                    <option value="TV">تووالو</option>
                    <option value="TL">تیمور شرقی</option>
                    <option value="JM">جامائیکا</option>
                    <option value="GI">جبل طارق</option>
                    <option value="JE">جرزی</option>
                    <option value="PN">جزایر پیت‌کرن</option>
                    <option value="TC">جزایر تورکس و کایکوس</option>
                    <option value="GS">جزایر ساندویچ/جورجیای جنوبی</option>
                    <option value="SB">جزایر سلیمان</option>
                    <option value="FO">جزایر فارو</option>
                    <option value="FK">جزایر فالکلند</option>
                    <option value="UM">جزایر کوچک حاشیه‌ای ایالات متحده آمریکا</option>
                    <option value="CK">جزایر کوک</option>
                    <option value="CC">جزایر کوکوس (کیلینگ)</option>
                    <option value="KY">جزایر کیمن</option>
                    <option value="MH">جزایر مارشال</option>
                    <option value="MP">جزایر ماریانای شمالی</option>
                    <option value="VI">جزایر ویرجین (ایالات متحده)</option>
                    <option value="VG">جزایر ویرجین (بریتانیایی)</option>
                    <option value="BV">جزیره بووه</option>
                    <option value="CX">جزیره کریسمس</option>
                    <option value="IM">جزیره من</option>
                    <option value="NF">جزیره نورفک</option>
                    <option value="HM">جزیره هرد و جزایر مک‌دونالد</option>
                    <option value="CF">جمهوری آفریقای مرکزی</option>
                    <option value="CZ">جمهوری چک</option>
                    <option value="DO">جمهوری دومینیکن</option>
                    <option value="DJ">جیبوتی</option>
                    <option value="TD">چاد</option>
                    <option value="CN">چین</option>
                    <option value="DK">دانمارک</option>
                    <option value="DM">دومینیکا</option>
                    <option value="RE">رئونیون</option>
                    <option value="RW">رواندا</option>
                    <option value="RU">روسیه</option>
                    <option value="RO">رومانی</option>
                    <option value="ZM">زامبیا</option>
                    <option value="ZW">زیمبابوه</option>
                    <option value="JP">ژاپن</option>
                    <option value="ST">سائوتومه و پرنسیپ</option>
                    <option value="CI">ساحل عاج</option>
                    <option value="WS">ساموآ</option>
                    <option value="AS">ساموآی آمریکا</option>
                    <option value="SM">سان مارینو</option>
                    <option value="TF">سرزمین‌های جنوبی فرانسه</option>
                    <option value="LK">سری‌لانکا</option>
                    <option value="BL">سن بارتلمی</option>
                    <option value="MF">سن مارتن (قسمت فرانسوی)</option>
                    <option value="SX">سن مارتن (قسمت هلندی)</option>
                    <option value="PM">سن-پیر-ا-میکلون</option>
                    <option value="KN">سنت کیتس و نویس</option>
                    <option value="LC">سنت لوسیا</option>
                    <option value="VC">سنت وینسنت و گرنادین‌ها</option>
                    <option value="SH">سنت هلن</option>
                    <option value="SG">سنگاپور</option>
                    <option value="SN">سنگال</option>
                    <option value="SJ">سوالبارد و یان ماین</option>
                    <option value="SE">سوئد</option>
                    <option value="CH">سوئیس</option>
                    <option value="SD">سودان</option>
                    <option value="SS">سودان جنوبی</option>
                    <option value="SR">سورینام</option>
                    <option value="SY">سوریه</option>
                    <option value="SO">سومالی</option>
                    <option value="BQ">سیبا و سینت یوستیشس، بونیر</option>
                    <option value="SL">سیرالئون</option>
                    <option value="SC">سیشل</option>
                    <option value="CL">شیلی</option>
                    <option value="EH">صحرای غربی</option>
                    <option value="RS">صربستان</option>
                    <option value="IQ">عراق</option>
                    <option value="SA">عربستان سعودی</option>
                    <option value="OM">عمان</option>
                    <option value="GH">غنا</option>
                    <option value="FR">فرانسه</option>
                    <option value="PS">فلسطین اشغالی</option>
                    <option value="FI">فنلاند</option>
                    <option value="FJ">فیجی</option>
                    <option value="PH">فیلیپین</option>
                    <option value="CY">قبرس</option>
                    <option value="KG">قرقیزستان</option>
                    <option value="KZ">قزاقستان</option>
                    <option value="AQ">قطب جنوب</option>
                    <option value="QA">قطر</option>
                    <option value="IO">قلمرو بریتانیا در اقیانوس هند</option>
                    <option value="CR">کاستاریکا</option>
                    <option value="NC">کالدونیای جدید</option>
                    <option value="KH">کامبوج</option>
                    <option value="CM">کامرون</option>
                    <option value="CA">کانادا</option>
                    <option value="HR">کرواسی</option>
                    <option value="KR">کره جنوبی</option>
                    <option value="KP">کره شمالی</option>
                    <option value="CO">کلمبیا</option>
                    <option value="CG">کنگو (برازاویل)</option>
                    <option value="CD">کنگو (کینشاسا)</option>
                    <option value="KE">کنیا</option>
                    <option value="CU">کوبا</option>
                    <option value="CW">کوراسائو</option>
                    <option value="KM">کومور</option>
                    <option value="KW">کویت</option>
                    <option value="CV">کیپ ورد</option>
                    <option value="KI">کیریباتی</option>
                    <option value="GA">گابن</option>
                    <option value="GM">گامبیا</option>
                    <option value="GE">گرجستان</option>
                    <option value="GD">گرنادا</option>
                    <option value="GG">گرنزی</option>
                    <option value="GL">گرینلند</option>
                    <option value="GU">گوآم</option>
                    <option value="GT">گواتمالا</option>
                    <option value="GP">گوادلوپ</option>
                    <option value="GY">گویان</option>
                    <option value="GF">گویان فرانسه</option>
                    <option value="GN">گینه</option>
                    <option value="GQ">گینه استوایی</option>
                    <option value="GW">گینه بیسائو</option>
                    <option value="LA">لائوس</option>
                    <option value="LB">لبنان</option>
                    <option value="LV">لتونی</option>
                    <option value="LS">لسوتو</option>
                    <option value="LU">لوکزامبورگ</option>
                    <option value="PL">لهستان</option>
                    <option value="LR">لیبریا</option>
                    <option value="LY">لیبی</option>
                    <option value="LT">لیتوانی</option>
                    <option value="LI">لیختن‌اشتاین</option>
                    <option value="MG">ماداگاسکار</option>
                    <option value="MQ">مارتینیک</option>
                    <option value="MO">ماکائو</option>
                    <option value="MW">مالاوی</option>
                    <option value="MT">مالت</option>
                    <option value="MV">مالدیو</option>
                    <option value="MY">مالزی</option>
                    <option value="ML">مالی</option>
                    <option value="YT">مایوت</option>
                    <option value="HU">مجارستان</option>
                    <option value="MA">مراکش</option>
                    <option value="EG">مصر</option>
                    <option value="MN">مغولستان</option>
                    <option value="MK">مقدونیه شمالی</option>
                    <option value="MX">مکزیک</option>
                    <option value="MR">موریتانی</option>
                    <option value="MU">موریس</option>
                    <option value="MZ">موزامبیک</option>
                    <option value="MD">مولداوی</option>
                    <option value="MC">موناکو</option>
                    <option value="MS">مونتسرات</option>
                    <option value="ME">مونته‌نگرو</option>
                    <option value="MM">میانمار</option>
                    <option value="FM">میکرونزی</option>
                    <option value="NR">نائورو</option>
                    <option value="NA">نامیبیا</option>
                    <option value="NP">نپال</option>
                    <option value="NO">نروژ</option>
                    <option value="NE">نیجر</option>
                    <option value="NG">نیجریه</option>
                    <option value="NI">نیکاراگوئه</option>
                    <option value="NZ">نیوزیلند</option>
                    <option value="NU">نیووی</option>
                    <option value="VA">واتیکان</option>
                    <option value="WF">والیس و فوتونا</option>
                    <option value="VU">وانواتو</option>
                    <option value="VE">ونزوئلا</option>
                    <option value="VN">ویتنام</option>
                    <option value="HT">هائیتی</option>
                    <option value="NL">هلند</option>
                    <option value="IN">هند</option>
                    <option value="HN">هندوراس</option>
                    <option value="HK">هنگ کنگ</option>
                    <option value="YE">یمن</option>
                    <option value="GR">یونان</option>
                    <option value="AX">Åland Islands</option>
                    <option value="SZ">Eswatini</option>
                  </select>
                </p>
              <?php endif; ?>

              <?php if (array_key_exists("billing_state", $this->options['kwoofields']['enabled'])): ?>
                <p class="form-row form-row-first address-field validate-state woocommerce-validated" id="billing_state_field"
                  data-priority="50"><label for="billing_state" class="screen-reader-text">استان&nbsp;<abbr class="required"
                      title="ضروری">*</abbr></label><span class="woocommerce-input-wrapper"><select name="billing_state"
                      id="billing_state" class="state_select " autocomplete="address-level1" data-placeholder="استان"
                      data-input-classes="" data-label="استان">
                      <option value="" selected="selected">یک گزینه انتخاب نمائید…</option>
                      <option value="KHZ">خوزستان</option>
                      <option value="THR">تهران</option>
                      <option value="ILM">ایلام</option>
                      <option value="BHR">بوشهر</option>
                      <option value="ADL">اردبیل</option>
                      <option value="ESF">اصفهان</option>
                      <option value="YZD">یزد</option>
                      <option value="KRH">کرمانشاه</option>
                      <option value="KRN">کرمان</option>
                      <option value="HDN">همدان</option>
                      <option value="GZN">قزوین</option>
                      <option value="ZJN">زنجان</option>
                      <option value="LRS">لرستان</option>
                      <option value="ABZ">البرز</option>
                      <option value="EAZ">آذربایجان شرقی</option>
                      <option value="WAZ">آذربایجان غربی</option>
                      <option value="CHB">چهارمحال و بختیاری</option>
                      <option value="SKH">خراسان جنوبی</option>
                      <option value="RKH">خراسان رضوی</option>
                      <option value="NKH">خراسان شمالی</option>
                      <option value="SMN">سمنان</option>
                      <option value="FRS">فارس</option>
                      <option value="QHM">قم</option>
                      <option value="KRD">کردستان</option>
                      <option value="KBD">کهگیلویه و بویراحمد</option>
                      <option value="GLS">گلستان</option>
                      <option value="GIL">گیلان</option>
                      <option value="MZN">مازندران</option>
                      <option value="MKZ">مرکزی</option>
                      <option value="HRZ">هرمزگان</option>
                      <option value="SBN">سیستان و بلوچستان</option>
                    </select></span>
                </p>
              <?php endif; ?>

              <?php if (array_key_exists("billing_city", $this->options['kwoofields']['enabled'])): ?>
                <p class="form-row form-row-last address-field" id="billing_city_field">
                  <input type="text" class="input-text" name="billing_city" id="billing_city" placeholder="شهر"
                    autocomplete="address-level2">
                </p>
              <?php endif; ?>

              <?php if (array_key_exists("billing_address_1", $this->options['kwoofields']['enabled'])): ?>
                <p class="form-row form-row-wide address-field" id="billing_address_1_field">
                  <input type="text" class="input-text" name="billing_address_1" id="billing_address_1" placeholder="آدرس خیابان"
                    autocomplete="address-line1"></span>
                </p>
              <?php endif; ?>

              <?php if (array_key_exists("billing_address_2", $this->options['kwoofields']['enabled'])): ?>
                <p class="form-row form-row-first address-field" id="billing_address_2_field">
                  <input type="text" class="input-text " name="billing_address_2" id="billing_address_2"
                    placeholder="آپارتمان، مجتمع، واحد و..." autocomplete="address-line2">
                </p>
              <?php endif; ?>

              <?php if (array_key_exists("billing_postcode", $this->options['kwoofields']['enabled'])): ?>
                <p class="form-row form-row-last address-field validate-postcode" id="billing_postcode_field">
                  <input type="text" class="input-text" name="billing_postcode" id="billing_postcode"
                    placeholder="کدپستی (بدون فاصله و با اعداد انگلیسی)" autocomplete="postal-code">
                </p>
              <?php endif; ?>

              <?php if (array_key_exists("billing_phone", $this->options['kwoofields']['enabled'])): ?>
                <p class="form-row form-row-first validate-phone" id="billing_phone_field">
                  <input type="tel" class="input-text" name="billing_phone" id="billing_phone" placeholder="تلفن"
                    autocomplete="tel"></span>
                </p>
              <?php endif; ?>

              <?php if (array_key_exists("billing_email", $this->options['kwoofields']['enabled'])): ?>
                <p class="form-row form-row-last validate-email" id="billing_email_field">
                  <input type="email" class="input-text " name="billing_email" id="billing_email" placeholder="آدرس ایمیل"
                    autocomplete="email">
                </p>
              <?php endif; ?>

            <?php endif; ?>
          </div>
          <button userid="<?php echo $user_id; ?>" id="kaveh_save_address" type="button"
            class="button alt btn-cart btn btn-success-5 mt-4 <?php if (wp_is_mobile()) {
              echo "w-50";
            } else {
              echo "w-25";
            } ?> py-3 float-end">
            ثبت و ذخیره
          </button>
        </div>
      </div>
      <?php

    elseif ($method === 'edit_address_modal'):
      $id = $_POST['id'];
      $user_id = $_POST['user_id'];
      if ($id === '0') {
        $billing_first_name = get_user_meta($user_id, 'billing_first_name', true);
        $billing_last_name = get_user_meta($user_id, 'billing_last_name', true);
        $billing_phone = get_user_meta($user_id, 'billing_phone', true);
        $billing_email = get_user_meta($user_id, 'billing_email', true);
        $billing_state = get_user_meta($user_id, 'billing_state', true);
        $billing_city = get_user_meta($user_id, 'billing_city', true);
        $billing_address_1 = get_user_meta($user_id, 'billing_address_1', true);
        $billing_address_2 = get_user_meta($user_id, 'billing_address_2', true);
        $billing_postcode = get_user_meta($user_id, 'billing_postcode', true);
        $billing_company = get_user_meta($user_id, 'billing_company', true);
        $billing_country = get_user_meta($user_id, 'billing_country', true);
      } else {
        $billing_first_name = get_user_meta($user_id, $id . 'shipping_first_name', true);
        $billing_last_name = get_user_meta($user_id, $id . 'shipping_last_name', true);
        $billing_email = get_user_meta($user_id, $id . 'shipping_email', true);
        $billing_state = get_user_meta($user_id, $id . 'shipping_state', true);
        $billing_city = get_user_meta($user_id, $id . 'shipping_city', true);
        $billing_address_1 = get_user_meta($user_id, $id . 'shipping_address_1', true);
        $billing_address_2 = get_user_meta($user_id, $id . 'shipping_address_2', true);
        $billing_postcode = get_user_meta($user_id, $id . 'shipping_postcode', true);
        $billing_company = get_user_meta($user_id, $id . 'shipping_company', true);
        $billing_country = get_user_meta($user_id, $id . 'shipping_country', true);
      }
      ?>
      <div class="modal-content">
        <div class="modal-header">
          <div class="modal-title fw-bold"> ویرایش آدرس </div>
          <button type="button" class="modal-close lh-1 p-0" data-bs-dismiss="modal">
            <i class="icon-close"></i>
          </button>
        </div>
        <div class="modal-body">
          <div class="woocommerce-billing-fields__field-wrapper">
            <?php if (!empty($this->options['kwoofields']['enabled'])): ?>

              <?php if (array_key_exists("billing_first_name", $this->options['kwoofields']['enabled'])): ?>
                <p class="form-row form-row-first" id="billing_first_name_field">
                  <input value="<?php echo $billing_first_name; ?>" type="text" class="input-text " name="billing_first_name"
                    id="billing_first_name" placeholder="نام" autocomplete="given-name">
                </p>
              <?php endif; ?>

              <?php if (array_key_exists("billing_last_name", $this->options['kwoofields']['enabled'])): ?>
                <p class="form-row form-row-last" id="billing_last_name_field">
                  <input value="<?php echo $billing_last_name; ?>" type="text" class="input-text" name="billing_last_name"
                    id="billing_last_name" placeholder="نام خانوادگی" autocomplete="family-name">
                </p>
              <?php endif; ?>

              <?php if (array_key_exists("billing_company", $this->options['kwoofields']['enabled'])): ?>
                <p class="form-row form-row-wide" id="billing_company_field">
                  <input value="<?php echo $billing_company; ?>" type="text" class="input-text" name="billing_company"
                    id="billing_company" placeholder="نام شرکت" autocomplete="organization">
                </p>
              <?php endif; ?>

              <?php if (array_key_exists("billing_country", $this->options['kwoofields']['enabled'])): ?>
                <p class="form-row form-row-wide address-field update_totals_on_change" id="billing_country_field"
                  data-priority="40"><select name="billing_country" id="billing_country"
                    class="country_to_state country_select select2-hidden-accessible" autocomplete="country"
                    data-placeholder="کشور/منطقه را انتخاب کنید…" data-label="کشور / منطقه" tabindex="-1" aria-hidden="true">
                    <option value="">کشور/منطقه را انتخاب کنید…</option>
                    <option value="AZ" <?php if ($billing_state === 'AZ') {
                      echo 'selected="selected"';
                    } ?>>آذربایجان</option>
                    <option value="AR" <?php if ($billing_state === 'AR') {
                      echo 'selected="selected"';
                    } ?>>آرژانتین</option>
                    <option value="AW" <?php if ($billing_state === 'AW') {
                      echo 'selected="selected"';
                    } ?>>آروبا</option>
                    <option value="ZA" <?php if ($billing_state === 'ZA') {
                      echo 'selected="selected"';
                    } ?>>آفریقای جنوبی</option>
                    <option value="AL" <?php if ($billing_state === 'AL') {
                      echo 'selected="selected"';
                    } ?>>آلبانی</option>
                    <option value="DE" <?php if ($billing_state === 'DE') {
                      echo 'selected="selected"';
                    } ?>>آلمان</option>
                    <option value="US" <?php if ($billing_state === 'US') {
                      echo 'selected="selected"';
                    } ?>>آمریکا</option>
                    <option value="AG" <?php if ($billing_state === 'AG') {
                      echo 'selected="selected"';
                    } ?>>آنتیگوا و باربودا
                    </option>
                    <option value="AD" <?php if ($billing_state === 'AD') {
                      echo 'selected="selected"';
                    } ?>>آندورا</option>
                    <option value="AO" <?php if ($billing_state === 'AO') {
                      echo 'selected="selected"';
                    } ?>>آنگولا</option>
                    <option value="AI" <?php if ($billing_state === 'AI') {
                      echo 'selected="selected"';
                    } ?>>آنگویلا</option>
                    <option value="AT" <?php if ($billing_state === 'AT') {
                      echo 'selected="selected"';
                    } ?>>اتریش</option>
                    <option value="ET" <?php if ($billing_state === 'ET') {
                      echo 'selected="selected"';
                    } ?>>اتیوپی</option>
                    <option value="JO" <?php if ($billing_state === 'JO') {
                      echo 'selected="selected"';
                    } ?>>اردن</option>
                    <option value="AM" <?php if ($billing_state === 'AM') {
                      echo 'selected="selected"';
                    } ?>>ارمنستان</option>
                    <option value="ER" <?php if ($billing_state === 'ER') {
                      echo 'selected="selected"';
                    } ?>>اریتره</option>
                    <option value="UZ" <?php if ($billing_state === 'UZ') {
                      echo 'selected="selected"';
                    } ?>>ازبکستان</option>
                    <option value="ES" <?php if ($billing_state === 'ES') {
                      echo 'selected="selected"';
                    } ?>>اسپانیا</option>
                    <option value="AU" <?php if ($billing_state === 'AU') {
                      echo 'selected="selected"';
                    } ?>>استرالیا</option>
                    <option value="EE" <?php if ($billing_state === 'EE') {
                      echo 'selected="selected"';
                    } ?>>استونی</option>
                    <option value="IL" <?php if ($billing_state === 'IL') {
                      echo 'selected="selected"';
                    } ?>>اسرائیل</option>
                    <option value="SK" <?php if ($billing_state === 'SK') {
                      echo 'selected="selected"';
                    } ?>>اسلواکی</option>
                    <option value="SI" <?php if ($billing_state === 'SI') {
                      echo 'selected="selected"';
                    } ?>>اسلوونی</option>
                    <option value="AF" <?php if ($billing_state === 'AF') {
                      echo 'selected="selected"';
                    } ?>>افغانستان</option>
                    <option value="EC" <?php if ($billing_state === 'EC') {
                      echo 'selected="selected"';
                    } ?>>اکوادور</option>
                    <option value="DZ" <?php if ($billing_state === 'DZ') {
                      echo 'selected="selected"';
                    } ?>>الجزایر</option>
                    <option value="SV" <?php if ($billing_state === 'SV') {
                      echo 'selected="selected"';
                    } ?>>السالوادور</option>
                    <option value="AE" <?php if ($billing_state === 'AE') {
                      echo 'selected="selected"';
                    } ?>>امارات متحده عربی
                    </option>
                    <option value="ID" <?php if ($billing_state === 'ID') {
                      echo 'selected="selected"';
                    } ?>>اندونزی</option>
                    <option value="GB" <?php if ($billing_state === 'GB') {
                      echo 'selected="selected"';
                    } ?>>انگلستان</option>
                    <option value="UY" <?php if ($billing_state === 'UY') {
                      echo 'selected="selected"';
                    } ?>>اوروگوئه</option>
                    <option value="UA" <?php if ($billing_state === 'UA') {
                      echo 'selected="selected"';
                    } ?>>اوکراین</option>
                    <option value="UG" <?php if ($billing_state === 'UG') {
                      echo 'selected="selected"';
                    } ?>>اوگاندا</option>
                    <option value="IT" <?php if ($billing_state === 'IT') {
                      echo 'selected="selected"';
                    } ?>>ایتالیا</option>
                    <option value="IR" <?php if ($billing_state === 'IR') {
                      echo 'selected="selected"';
                    } ?>>ایران</option>
                    <option value="IE" <?php if ($billing_state === 'IE') {
                      echo 'selected="selected"';
                    } ?>>ایرلند</option>
                    <option value="IS" <?php if ($billing_state === 'IS') {
                      echo 'selected="selected"';
                    } ?>>ایسلند</option>
                    <option value="BB" <?php if ($billing_state === 'BB') {
                      echo 'selected="selected"';
                    } ?>>باربادوس</option>
                    <option value="BS" <?php if ($billing_state === 'BS') {
                      echo 'selected="selected"';
                    } ?>>باهاما</option>
                    <option value="BH" <?php if ($billing_state === 'BH') {
                      echo 'selected="selected"';
                    } ?>>بحرین</option>
                    <option value="BR" <?php if ($billing_state === 'BR') {
                      echo 'selected="selected"';
                    } ?>>برزیل</option>
                    <option value="BM" <?php if ($billing_state === 'BM') {
                      echo 'selected="selected"';
                    } ?>>برمودا</option>
                    <option value="BN" <?php if ($billing_state === 'BN') {
                      echo 'selected="selected"';
                    } ?>>برونئی</option>
                    <option value="BY" <?php if ($billing_state === 'BY') {
                      echo 'selected="selected"';
                    } ?>>بلاروس</option>
                    <option value="BE" <?php if ($billing_state === 'BE') {
                      echo 'selected="selected"';
                    } ?>>بلژیک</option>
                    <option value="BG" <?php if ($billing_state === 'BG') {
                      echo 'selected="selected"';
                    } ?>>بلغارستان</option>
                    <option value="BZ" <?php if ($billing_state === 'BZ') {
                      echo 'selected="selected"';
                    } ?>>بلیز</option>
                    <option value="BD" <?php if ($billing_state === 'BD') {
                      echo 'selected="selected"';
                    } ?>>بنگلادش</option>
                    <option value="BJ" <?php if ($billing_state === 'BJ') {
                      echo 'selected="selected"';
                    } ?>>بنین</option>
                    <option value="BT" <?php if ($billing_state === 'BT') {
                      echo 'selected="selected"';
                    } ?>>بوتان</option>
                    <option value="BW" <?php if ($billing_state === 'BW') {
                      echo 'selected="selected"';
                    } ?>>بوتسوانا</option>
                    <option value="BF" <?php if ($billing_state === 'BF') {
                      echo 'selected="selected"';
                    } ?>>بورکینافاسو</option>
                    <option value="BI" <?php if ($billing_state === 'BI') {
                      echo 'selected="selected"';
                    } ?>>بوروندی</option>
                    <option value="BA" <?php if ($billing_state === 'BA') {
                      echo 'selected="selected"';
                    } ?>>بوسنی و هرزگوین</option>
                    <option value="BO" <?php if ($billing_state === 'BO') {
                      echo 'selected="selected"';
                    } ?>>بولیوی</option>
                    <option value="PG" <?php if ($billing_state === 'PG') {
                      echo 'selected="selected"';
                    } ?>>پاپوآ گینه نو</option>
                    <option value="PY" <?php if ($billing_state === 'PY') {
                      echo 'selected="selected"';
                    } ?>>پاراگوئه</option>
                    <option value="PK" <?php if ($billing_state === 'PK') {
                      echo 'selected="selected"';
                    } ?>>پاکستان</option>
                    <option value="PW" <?php if ($billing_state === 'PW') {
                      echo 'selected="selected"';
                    } ?>>پالائو</option>
                    <option value="PA" <?php if ($billing_state === 'PA') {
                      echo 'selected="selected"';
                    } ?>>پاناما</option>
                    <option value="PT" <?php if ($billing_state === 'PT') {
                      echo 'selected="selected"';
                    } ?>>پرتغال</option>
                    <option value="PE" <?php if ($billing_state === 'PE') {
                      echo 'selected="selected"';
                    } ?>>پرو</option>
                    <option value="PF" <?php if ($billing_state === 'PF') {
                      echo 'selected="selected"';
                    } ?>>پلی‌نزی فرانسه</option>
                    <option value="PR" <?php if ($billing_state === 'PR') {
                      echo 'selected="selected"';
                    } ?>>پورتوریکو</option>
                    <option value="TJ" <?php if ($billing_state === 'TJ') {
                      echo 'selected="selected"';
                    } ?>>تاجیکستان</option>
                    <option value="TZ" <?php if ($billing_state === 'TZ') {
                      echo 'selected="selected"';
                    } ?>>تانزانیا</option>
                    <option value="TH" <?php if ($billing_state === 'TH') {
                      echo 'selected="selected"';
                    } ?>>تایلند</option>
                    <option value="TW" <?php if ($billing_state === 'TW') {
                      echo 'selected="selected"';
                    } ?>>تایوان</option>
                    <option value="TM" <?php if ($billing_state === 'TM') {
                      echo 'selected="selected"';
                    } ?>>ترکمنستان</option>
                    <option value="TR" <?php if ($billing_state === 'TR') {
                      echo 'selected="selected"';
                    } ?>>ترکیه</option>
                    <option value="TT" <?php if ($billing_state === 'TT') {
                      echo 'selected="selected"';
                    } ?>>ترینیداد و توباگو
                    </option>
                    <option value="TK" <?php if ($billing_state === 'TK') {
                      echo 'selected="selected"';
                    } ?>>توکلائو</option>
                    <option value="TG" <?php if ($billing_state === 'TG') {
                      echo 'selected="selected"';
                    } ?>>توگو</option>
                    <option value="TN" <?php if ($billing_state === 'TN') {
                      echo 'selected="selected"';
                    } ?>>تونس</option>
                    <option value="TO" <?php if ($billing_state === 'TO') {
                      echo 'selected="selected"';
                    } ?>>تونگا</option>
                    <option value="TV" <?php if ($billing_state === 'TV') {
                      echo 'selected="selected"';
                    } ?>>تووالو</option>
                    <option value="TL" <?php if ($billing_state === 'TL') {
                      echo 'selected="selected"';
                    } ?>>تیمور شرقی</option>
                    <option value="JM" <?php if ($billing_state === 'JM') {
                      echo 'selected="selected"';
                    } ?>>جامائیکا</option>
                    <option value="GI" <?php if ($billing_state === 'GI') {
                      echo 'selected="selected"';
                    } ?>>جبل طارق</option>
                    <option value="JE" <?php if ($billing_state === 'JE') {
                      echo 'selected="selected"';
                    } ?>>جرزی</option>
                    <option value="PN" <?php if ($billing_state === 'PN') {
                      echo 'selected="selected"';
                    } ?>>جزایر پیت‌کرن</option>
                    <option value="TC" <?php if ($billing_state === 'TC') {
                      echo 'selected="selected"';
                    } ?>>جزایر تورکس و کایکوس
                    </option>
                    <option value="GS" <?php if ($billing_state === 'GS') {
                      echo 'selected="selected"';
                    } ?>>جزایر ساندویچ/جورجیای
                      جنوبی</option>
                    <option value="SB" <?php if ($billing_state === 'SB') {
                      echo 'selected="selected"';
                    } ?>>جزایر سلیمان</option>
                    <option value="FO" <?php if ($billing_state === 'FO') {
                      echo 'selected="selected"';
                    } ?>>جزایر فارو</option>
                    <option value="FK" <?php if ($billing_state === 'FK') {
                      echo 'selected="selected"';
                    } ?>>جزایر فالکلند</option>
                    <option value="UM" <?php if ($billing_state === 'UM') {
                      echo 'selected="selected"';
                    } ?>>جزایر کوچک حاشیه‌ای
                      ایالات متحده آمریکا</option>
                    <option value="CK" <?php if ($billing_state === 'CK') {
                      echo 'selected="selected"';
                    } ?>>جزایر کوک</option>
                    <option value="CC" <?php if ($billing_state === 'CC') {
                      echo 'selected="selected"';
                    } ?>>جزایر کوکوس (کیلینگ)
                    </option>
                    <option value="KY" <?php if ($billing_state === 'KY') {
                      echo 'selected="selected"';
                    } ?>>جزایر کیمن</option>
                    <option value="MH" <?php if ($billing_state === 'MH') {
                      echo 'selected="selected"';
                    } ?>>جزایر مارشال</option>
                    <option value="MP" <?php if ($billing_state === 'MP') {
                      echo 'selected="selected"';
                    } ?>>جزایر ماریانای شمالی
                    </option>
                    <option value="VI" <?php if ($billing_state === 'VI') {
                      echo 'selected="selected"';
                    } ?>>جزایر ویرجین (ایالات
                      متحده)</option>
                    <option value="VG" <?php if ($billing_state === 'VG') {
                      echo 'selected="selected"';
                    } ?>>جزایر ویرجین (بریتانیایی)
                    </option>
                    <option value="BV" <?php if ($billing_state === 'BV') {
                      echo 'selected="selected"';
                    } ?>>جزیره بووه</option>
                    <option value="CX" <?php if ($billing_state === 'CX') {
                      echo 'selected="selected"';
                    } ?>>جزیره کریسمس</option>
                    <option value="IM" <?php if ($billing_state === 'IM') {
                      echo 'selected="selected"';
                    } ?>>جزیره من</option>
                    <option value="NF" <?php if ($billing_state === 'NF') {
                      echo 'selected="selected"';
                    } ?>>جزیره نورفک</option>
                    <option value="HM" <?php if ($billing_state === 'HM') {
                      echo 'selected="selected"';
                    } ?>>جزیره هرد و جزایر
                      مک‌دونالد</option>
                    <option value="CF" <?php if ($billing_state === 'CF') {
                      echo 'selected="selected"';
                    } ?>>جمهوری آفریقای مرکزی
                    </option>
                    <option value="CZ" <?php if ($billing_state === 'CZ') {
                      echo 'selected="selected"';
                    } ?>>جمهوری چک</option>
                    <option value="DO" <?php if ($billing_state === 'DO') {
                      echo 'selected="selected"';
                    } ?>>جمهوری دومینیکن</option>
                    <option value="DJ" <?php if ($billing_state === 'DJ') {
                      echo 'selected="selected"';
                    } ?>>جیبوتی</option>
                    <option value="TD" <?php if ($billing_state === 'TD') {
                      echo 'selected="selected"';
                    } ?>>چاد</option>
                    <option value="CN" <?php if ($billing_state === 'CN') {
                      echo 'selected="selected"';
                    } ?>>چین</option>
                    <option value="DK" <?php if ($billing_state === 'DK') {
                      echo 'selected="selected"';
                    } ?>>دانمارک</option>
                    <option value="DM" <?php if ($billing_state === 'DM') {
                      echo 'selected="selected"';
                    } ?>>دومینیکا</option>
                    <option value="RE" <?php if ($billing_state === 'RE') {
                      echo 'selected="selected"';
                    } ?>>رئونیون</option>
                    <option value="RW" <?php if ($billing_state === 'RW') {
                      echo 'selected="selected"';
                    } ?>>رواندا</option>
                    <option value="RU" <?php if ($billing_state === 'RU') {
                      echo 'selected="selected"';
                    } ?>>روسیه</option>
                    <option value="RO" <?php if ($billing_state === 'RO') {
                      echo 'selected="selected"';
                    } ?>>رومانی</option>
                    <option value="ZM" <?php if ($billing_state === 'ZM') {
                      echo 'selected="selected"';
                    } ?>>زامبیا</option>
                    <option value="ZW" <?php if ($billing_state === 'ZW') {
                      echo 'selected="selected"';
                    } ?>>زیمبابوه</option>
                    <option value="JP" <?php if ($billing_state === 'JP') {
                      echo 'selected="selected"';
                    } ?>>ژاپن</option>
                    <option value="ST" <?php if ($billing_state === 'ST') {
                      echo 'selected="selected"';
                    } ?>>سائوتومه و پرنسیپ
                    </option>
                    <option value="CI" <?php if ($billing_state === 'CI') {
                      echo 'selected="selected"';
                    } ?>>ساحل عاج</option>
                    <option value="WS" <?php if ($billing_state === 'WS') {
                      echo 'selected="selected"';
                    } ?>>ساموآ</option>
                    <option value="AS" <?php if ($billing_state === 'AS') {
                      echo 'selected="selected"';
                    } ?>>ساموآی آمریکا</option>
                    <option value="SM" <?php if ($billing_state === 'SM') {
                      echo 'selected="selected"';
                    } ?>>سان مارینو</option>
                    <option value="TF" <?php if ($billing_state === 'TF') {
                      echo 'selected="selected"';
                    } ?>>سرزمین‌های جنوبی فرانسه
                    </option>
                    <option value="LK" <?php if ($billing_state === 'LK') {
                      echo 'selected="selected"';
                    } ?>>سری‌لانکا</option>
                    <option value="BL" <?php if ($billing_state === 'BL') {
                      echo 'selected="selected"';
                    } ?>>سن بارتلمی</option>
                    <option value="MF" <?php if ($billing_state === 'MF') {
                      echo 'selected="selected"';
                    } ?>>سن مارتن (قسمت فرانسوی)
                    </option>
                    <option value="SX" <?php if ($billing_state === 'SX') {
                      echo 'selected="selected"';
                    } ?>>سن مارتن (قسمت هلندی)
                    </option>
                    <option value="PM" <?php if ($billing_state === 'PM') {
                      echo 'selected="selected"';
                    } ?>>سن-پیر-ا-میکلون</option>
                    <option value="KN" <?php if ($billing_state === 'KN') {
                      echo 'selected="selected"';
                    } ?>>سنت کیتس و نویس</option>
                    <option value="LC" <?php if ($billing_state === 'LC') {
                      echo 'selected="selected"';
                    } ?>>سنت لوسیا</option>
                    <option value="VC" <?php if ($billing_state === 'VC') {
                      echo 'selected="selected"';
                    } ?>>سنت وینسنت و گرنادین‌ها
                    </option>
                    <option value="SH" <?php if ($billing_state === 'SH') {
                      echo 'selected="selected"';
                    } ?>>سنت هلن</option>
                    <option value="SG" <?php if ($billing_state === 'SG') {
                      echo 'selected="selected"';
                    } ?>>سنگاپور</option>
                    <option value="SN" <?php if ($billing_state === 'SN') {
                      echo 'selected="selected"';
                    } ?>>سنگال</option>
                    <option value="SJ" <?php if ($billing_state === 'SJ') {
                      echo 'selected="selected"';
                    } ?>>سوالبارد و یان ماین
                    </option>
                    <option value="SE" <?php if ($billing_state === 'SE') {
                      echo 'selected="selected"';
                    } ?>>سوئد</option>
                    <option value="CH" <?php if ($billing_state === 'CH') {
                      echo 'selected="selected"';
                    } ?>>سوئیس</option>
                    <option value="SD" <?php if ($billing_state === 'SD') {
                      echo 'selected="selected"';
                    } ?>>سودان</option>
                    <option value="SS" <?php if ($billing_state === 'SS') {
                      echo 'selected="selected"';
                    } ?>>سودان جنوبی</option>
                    <option value="SR" <?php if ($billing_state === 'SR') {
                      echo 'selected="selected"';
                    } ?>>سورینام</option>
                    <option value="SY" <?php if ($billing_state === 'SY') {
                      echo 'selected="selected"';
                    } ?>>سوریه</option>
                    <option value="SO" <?php if ($billing_state === 'SO') {
                      echo 'selected="selected"';
                    } ?>>سومالی</option>
                    <option value="BQ" <?php if ($billing_state === 'BQ') {
                      echo 'selected="selected"';
                    } ?>>سیبا و سینت یوستیشس،
                      بونیر</option>
                    <option value="SL" <?php if ($billing_state === 'SL') {
                      echo 'selected="selected"';
                    } ?>>سیرالئون</option>
                    <option value="SC" <?php if ($billing_state === 'SC') {
                      echo 'selected="selected"';
                    } ?>>سیشل</option>
                    <option value="CL" <?php if ($billing_state === 'CL') {
                      echo 'selected="selected"';
                    } ?>>شیلی</option>
                    <option value="EH" <?php if ($billing_state === 'EH') {
                      echo 'selected="selected"';
                    } ?>>صحرای غربی</option>
                    <option value="RS" <?php if ($billing_state === 'RS') {
                      echo 'selected="selected"';
                    } ?>>صربستان</option>
                    <option value="IQ" <?php if ($billing_state === 'IQ') {
                      echo 'selected="selected"';
                    } ?>>عراق</option>
                    <option value="SA" <?php if ($billing_state === 'SA') {
                      echo 'selected="selected"';
                    } ?>>عربستان سعودی</option>
                    <option value="OM" <?php if ($billing_state === 'OM') {
                      echo 'selected="selected"';
                    } ?>>عمان</option>
                    <option value="GH" <?php if ($billing_state === 'GH') {
                      echo 'selected="selected"';
                    } ?>>غنا</option>
                    <option value="FR" <?php if ($billing_state === 'FR') {
                      echo 'selected="selected"';
                    } ?>>فرانسه</option>
                    <option value="PS" <?php if ($billing_state === 'PS') {
                      echo 'selected="selected"';
                    } ?>>فلسطین اشغالی</option>
                    <option value="FI" <?php if ($billing_state === 'FI') {
                      echo 'selected="selected"';
                    } ?>>فنلاند</option>
                    <option value="FJ" <?php if ($billing_state === 'FJ') {
                      echo 'selected="selected"';
                    } ?>>فیجی</option>
                    <option value="PH" <?php if ($billing_state === 'PH') {
                      echo 'selected="selected"';
                    } ?>>فیلیپین</option>
                    <option value="CY" <?php if ($billing_state === 'CY') {
                      echo 'selected="selected"';
                    } ?>>قبرس</option>
                    <option value="KG" <?php if ($billing_state === 'KG') {
                      echo 'selected="selected"';
                    } ?>>قرقیزستان</option>
                    <option value="KZ" <?php if ($billing_state === 'KZ') {
                      echo 'selected="selected"';
                    } ?>>قزاقستان</option>
                    <option value="AQ" <?php if ($billing_state === 'AQ') {
                      echo 'selected="selected"';
                    } ?>>قطب جنوب</option>
                    <option value="QA" <?php if ($billing_state === 'QA') {
                      echo 'selected="selected"';
                    } ?>>قطر</option>
                    <option value="IO" <?php if ($billing_state === 'IO') {
                      echo 'selected="selected"';
                    } ?>>قلمرو بریتانیا در اقیانوس
                      هند</option>
                    <option value="CR" <?php if ($billing_state === 'CR') {
                      echo 'selected="selected"';
                    } ?>>کاستاریکا</option>
                    <option value="NC" <?php if ($billing_state === 'NC') {
                      echo 'selected="selected"';
                    } ?>>کالدونیای جدید</option>
                    <option value="KH" <?php if ($billing_state === 'KH') {
                      echo 'selected="selected"';
                    } ?>>کامبوج</option>
                    <option value="CM" <?php if ($billing_state === 'CM') {
                      echo 'selected="selected"';
                    } ?>>کامرون</option>
                    <option value="CA" <?php if ($billing_state === 'CA') {
                      echo 'selected="selected"';
                    } ?>>کانادا</option>
                    <option value="HR" <?php if ($billing_state === 'HR') {
                      echo 'selected="selected"';
                    } ?>>کرواسی</option>
                    <option value="KR" <?php if ($billing_state === 'KR') {
                      echo 'selected="selected"';
                    } ?>>کره جنوبی</option>
                    <option value="KP" <?php if ($billing_state === 'KP') {
                      echo 'selected="selected"';
                    } ?>>کره شمالی</option>
                    <option value="CO" <?php if ($billing_state === 'CO') {
                      echo 'selected="selected"';
                    } ?>>کلمبیا</option>
                    <option value="CG" <?php if ($billing_state === 'CG') {
                      echo 'selected="selected"';
                    } ?>>کنگو (برازاویل)</option>
                    <option value="CD" <?php if ($billing_state === 'CD') {
                      echo 'selected="selected"';
                    } ?>>کنگو (کینشاسا)</option>
                    <option value="KE" <?php if ($billing_state === 'KE') {
                      echo 'selected="selected"';
                    } ?>>کنیا</option>
                    <option value="CU" <?php if ($billing_state === 'CU') {
                      echo 'selected="selected"';
                    } ?>>کوبا</option>
                    <option value="CW" <?php if ($billing_state === 'CW') {
                      echo 'selected="selected"';
                    } ?>>کوراسائو</option>
                    <option value="KM" <?php if ($billing_state === 'KM') {
                      echo 'selected="selected"';
                    } ?>>کومور</option>
                    <option value="KW" <?php if ($billing_state === 'KW') {
                      echo 'selected="selected"';
                    } ?>>کویت</option>
                    <option value="CV" <?php if ($billing_state === 'CV') {
                      echo 'selected="selected"';
                    } ?>>کیپ ورد</option>
                    <option value="KI" <?php if ($billing_state === 'KI') {
                      echo 'selected="selected"';
                    } ?>>کیریباتی</option>
                    <option value="GA" <?php if ($billing_state === 'GA') {
                      echo 'selected="selected"';
                    } ?>>گابن</option>
                    <option value="GM" <?php if ($billing_state === 'GM') {
                      echo 'selected="selected"';
                    } ?>>گامبیا</option>
                    <option value="GE" <?php if ($billing_state === 'GE') {
                      echo 'selected="selected"';
                    } ?>>گرجستان</option>
                    <option value="GD" <?php if ($billing_state === 'GD') {
                      echo 'selected="selected"';
                    } ?>>گرنادا</option>
                    <option value="GG" <?php if ($billing_state === 'GG') {
                      echo 'selected="selected"';
                    } ?>>گرنزی</option>
                    <option value="GL" <?php if ($billing_state === 'GL') {
                      echo 'selected="selected"';
                    } ?>>گرینلند</option>
                    <option value="GU" <?php if ($billing_state === 'GU') {
                      echo 'selected="selected"';
                    } ?>>گوآم</option>
                    <option value="GT" <?php if ($billing_state === 'GT') {
                      echo 'selected="selected"';
                    } ?>>گواتمالا</option>
                    <option value="GP" <?php if ($billing_state === 'GP') {
                      echo 'selected="selected"';
                    } ?>>گوادلوپ</option>
                    <option value="GY" <?php if ($billing_state === 'GY') {
                      echo 'selected="selected"';
                    } ?>>گویان</option>
                    <option value="GF" <?php if ($billing_state === 'GF') {
                      echo 'selected="selected"';
                    } ?>>گویان فرانسه</option>
                    <option value="GN" <?php if ($billing_state === 'GN') {
                      echo 'selected="selected"';
                    } ?>>گینه</option>
                    <option value="GQ" <?php if ($billing_state === 'GQ') {
                      echo 'selected="selected"';
                    } ?>>گینه استوایی</option>
                    <option value="GW" <?php if ($billing_state === 'GW') {
                      echo 'selected="selected"';
                    } ?>>گینه بیسائو</option>
                    <option value="LA" <?php if ($billing_state === 'LA') {
                      echo 'selected="selected"';
                    } ?>>لائوس</option>
                    <option value="LB" <?php if ($billing_state === 'LB') {
                      echo 'selected="selected"';
                    } ?>>لبنان</option>
                    <option value="LV" <?php if ($billing_state === 'LV') {
                      echo 'selected="selected"';
                    } ?>>لتونی</option>
                    <option value="LS" <?php if ($billing_state === 'LS') {
                      echo 'selected="selected"';
                    } ?>>لسوتو</option>
                    <option value="LU" <?php if ($billing_state === 'LU') {
                      echo 'selected="selected"';
                    } ?>>لوکزامبورگ</option>
                    <option value="PL" <?php if ($billing_state === 'PL') {
                      echo 'selected="selected"';
                    } ?>>لهستان</option>
                    <option value="LR" <?php if ($billing_state === 'LR') {
                      echo 'selected="selected"';
                    } ?>>لیبریا</option>
                    <option value="LY" <?php if ($billing_state === 'LY') {
                      echo 'selected="selected"';
                    } ?>>لیبی</option>
                    <option value="LT" <?php if ($billing_state === 'LT') {
                      echo 'selected="selected"';
                    } ?>>لیتوانی</option>
                    <option value="LI" <?php if ($billing_state === 'LI') {
                      echo 'selected="selected"';
                    } ?>>لیختن‌اشتاین</option>
                    <option value="MG" <?php if ($billing_state === 'MG') {
                      echo 'selected="selected"';
                    } ?>>ماداگاسکار</option>
                    <option value="MQ" <?php if ($billing_state === 'MQ') {
                      echo 'selected="selected"';
                    } ?>>مارتینیک</option>
                    <option value="MO" <?php if ($billing_state === 'MO') {
                      echo 'selected="selected"';
                    } ?>>ماکائو</option>
                    <option value="MW" <?php if ($billing_state === 'MW') {
                      echo 'selected="selected"';
                    } ?>>مالاوی</option>
                    <option value="MT" <?php if ($billing_state === 'MT') {
                      echo 'selected="selected"';
                    } ?>>مالت</option>
                    <option value="MV" <?php if ($billing_state === 'MV') {
                      echo 'selected="selected"';
                    } ?>>مالدیو</option>
                    <option value="MY" <?php if ($billing_state === 'MY') {
                      echo 'selected="selected"';
                    } ?>>مالزی</option>
                    <option value="ML" <?php if ($billing_state === 'ML') {
                      echo 'selected="selected"';
                    } ?>>مالی</option>
                    <option value="YT" <?php if ($billing_state === 'YT') {
                      echo 'selected="selected"';
                    } ?>>مایوت</option>
                    <option value="HU" <?php if ($billing_state === 'HU') {
                      echo 'selected="selected"';
                    } ?>>مجارستان</option>
                    <option value="MA" <?php if ($billing_state === 'MA') {
                      echo 'selected="selected"';
                    } ?>>مراکش</option>
                    <option value="EG" <?php if ($billing_state === 'EG') {
                      echo 'selected="selected"';
                    } ?>>مصر</option>
                    <option value="MN" <?php if ($billing_state === 'MN') {
                      echo 'selected="selected"';
                    } ?>>مغولستان</option>
                    <option value="MK" <?php if ($billing_state === 'MK') {
                      echo 'selected="selected"';
                    } ?>>مقدونیه شمالی</option>
                    <option value="MX" <?php if ($billing_state === 'MX') {
                      echo 'selected="selected"';
                    } ?>>مکزیک</option>
                    <option value="MR" <?php if ($billing_state === 'MR') {
                      echo 'selected="selected"';
                    } ?>>موریتانی</option>
                    <option value="MU" <?php if ($billing_state === 'MU') {
                      echo 'selected="selected"';
                    } ?>>موریس</option>
                    <option value="MZ" <?php if ($billing_state === 'MZ') {
                      echo 'selected="selected"';
                    } ?>>موزامبیک</option>
                    <option value="MD" <?php if ($billing_state === 'MD') {
                      echo 'selected="selected"';
                    } ?>>مولداوی</option>
                    <option value="MC" <?php if ($billing_state === 'MC') {
                      echo 'selected="selected"';
                    } ?>>موناکو</option>
                    <option value="MS" <?php if ($billing_state === 'MS') {
                      echo 'selected="selected"';
                    } ?>>مونتسرات</option>
                    <option value="ME" <?php if ($billing_state === 'ME') {
                      echo 'selected="selected"';
                    } ?>>مونته‌نگرو</option>
                    <option value="MM" <?php if ($billing_state === 'MM') {
                      echo 'selected="selected"';
                    } ?>>میانمار</option>
                    <option value="FM" <?php if ($billing_state === 'FM') {
                      echo 'selected="selected"';
                    } ?>>میکرونزی</option>
                    <option value="NR" <?php if ($billing_state === 'NR') {
                      echo 'selected="selected"';
                    } ?>>نائورو</option>
                    <option value="NA" <?php if ($billing_state === 'NA') {
                      echo 'selected="selected"';
                    } ?>>نامیبیا</option>
                    <option value="NP" <?php if ($billing_state === 'NP') {
                      echo 'selected="selected"';
                    } ?>>نپال</option>
                    <option value="NO" <?php if ($billing_state === 'NO') {
                      echo 'selected="selected"';
                    } ?>>نروژ</option>
                    <option value="NE" <?php if ($billing_state === 'NE') {
                      echo 'selected="selected"';
                    } ?>>نیجر</option>
                    <option value="NG" <?php if ($billing_state === 'NG') {
                      echo 'selected="selected"';
                    } ?>>نیجریه</option>
                    <option value="NI" <?php if ($billing_state === 'NI') {
                      echo 'selected="selected"';
                    } ?>>نیکاراگوئه</option>
                    <option value="NZ" <?php if ($billing_state === 'NZ') {
                      echo 'selected="selected"';
                    } ?>>نیوزیلند</option>
                    <option value="NU" <?php if ($billing_state === 'NU') {
                      echo 'selected="selected"';
                    } ?>>نیووی</option>
                    <option value="VA" <?php if ($billing_state === 'VA') {
                      echo 'selected="selected"';
                    } ?>>واتیکان</option>
                    <option value="WF" <?php if ($billing_state === 'WF') {
                      echo 'selected="selected"';
                    } ?>>والیس و فوتونا</option>
                    <option value="VU" <?php if ($billing_state === 'VU') {
                      echo 'selected="selected"';
                    } ?>>وانواتو</option>
                    <option value="VE" <?php if ($billing_state === 'VE') {
                      echo 'selected="selected"';
                    } ?>>ونزوئلا</option>
                    <option value="VN" <?php if ($billing_state === 'VN') {
                      echo 'selected="selected"';
                    } ?>>ویتنام</option>
                    <option value="HT" <?php if ($billing_state === 'HT') {
                      echo 'selected="selected"';
                    } ?>>هائیتی</option>
                    <option value="NL" <?php if ($billing_state === 'NL') {
                      echo 'selected="selected"';
                    } ?>>هلند</option>
                    <option value="IN" <?php if ($billing_state === 'IN') {
                      echo 'selected="selected"';
                    } ?>>هند</option>
                    <option value="HN" <?php if ($billing_state === 'HN') {
                      echo 'selected="selected"';
                    } ?>>هندوراس</option>
                    <option value="HK" <?php if ($billing_state === 'HK') {
                      echo 'selected="selected"';
                    } ?>>هنگ کنگ</option>
                    <option value="YE" <?php if ($billing_state === 'YE') {
                      echo 'selected="selected"';
                    } ?>>یمن</option>
                    <option value="GR" <?php if ($billing_state === 'GR') {
                      echo 'selected="selected"';
                    } ?>>یونان</option>
                    <option value="AX" <?php if ($billing_state === 'AX') {
                      echo 'selected="selected"';
                    } ?>>Åland Islands</option>
                    <option value="SZ" <?php if ($billing_state === 'SZ') {
                      echo 'selected="selected"';
                    } ?>>Eswatini</option>

                  </select>
                </p>
              <?php endif; ?>

              <?php if (array_key_exists("billing_state", $this->options['kwoofields']['enabled'])): ?>
                <p class="form-row form-row-first address-field validate-state woocommerce-validated" id="billing_state_field"
                  data-priority="50"><label for="billing_state" class="screen-reader-text">استان&nbsp;<abbr class="required"
                      title="ضروری">*</abbr></label><span class="woocommerce-input-wrapper"><select name="billing_state"
                      id="billing_state" class="state_select " autocomplete="address-level1" data-placeholder="استان"
                      data-input-classes="" data-label="استان">
                      <option value="">یک گزینه انتخاب نمائید…</option>
                      <option value="KHZ" <?php if ($billing_state === 'KHZ') {
                        echo 'selected="selected"';
                      } ?>>خوزستان</option>
                      <option value="THR" <?php if ($billing_state === 'THR') {
                        echo 'selected="selected"';
                      } ?>>تهران</option>
                      <option value="ILM" <?php if ($billing_state === 'ILM') {
                        echo 'selected="selected"';
                      } ?>>ایلام</option>
                      <option value="BHR" <?php if ($billing_state === 'BHR') {
                        echo 'selected="selected"';
                      } ?>>بوشهر</option>
                      <option value="ADL" <?php if ($billing_state === 'ADL') {
                        echo 'selected="selected"';
                      } ?>>اردبیل</option>
                      <option value="ESF" <?php if ($billing_state === 'ESF') {
                        echo 'selected="selected"';
                      } ?>>اصفهان</option>
                      <option value="YZD" <?php if ($billing_state === 'YZD') {
                        echo 'selected="selected"';
                      } ?>>یزد</option>
                      <option value="KRH" <?php if ($billing_state === 'KRH') {
                        echo 'selected="selected"';
                      } ?>>کرمانشاه</option>
                      <option value="KRN" <?php if ($billing_state === 'KRN') {
                        echo 'selected="selected"';
                      } ?>>کرمان</option>
                      <option value="HDN" <?php if ($billing_state === 'HDN') {
                        echo 'selected="selected"';
                      } ?>>همدان</option>
                      <option value="GZN" <?php if ($billing_state === 'GZN') {
                        echo 'selected="selected"';
                      } ?>>قزوین</option>
                      <option value="ZJN" <?php if ($billing_state === 'ZJN') {
                        echo 'selected="selected"';
                      } ?>>زنجان</option>
                      <option value="LRS" <?php if ($billing_state === 'LRS') {
                        echo 'selected="selected"';
                      } ?>>لرستان</option>
                      <option value="ABZ" <?php if ($billing_state === 'ABZ') {
                        echo 'selected="selected"';
                      } ?>>البرز</option>
                      <option value="EAZ" <?php if ($billing_state === 'EAZ') {
                        echo 'selected="selected"';
                      } ?>>آذربایجان شرقی
                      </option>
                      <option value="WAZ" <?php if ($billing_state === 'WAZ') {
                        echo 'selected="selected"';
                      } ?>>آذربایجان غربی
                      </option>
                      <option value="CHB" <?php if ($billing_state === 'CHB') {
                        echo 'selected="selected"';
                      } ?>>چهارمحال و بختیاری
                      </option>
                      <option value="SKH" <?php if ($billing_state === 'SKH') {
                        echo 'selected="selected"';
                      } ?>>خراسان جنوبی</option>
                      <option value="RKH" <?php if ($billing_state === 'RKH') {
                        echo 'selected="selected"';
                      } ?>>خراسان رضوی</option>
                      <option value="NKH" <?php if ($billing_state === 'NKH') {
                        echo 'selected="selected"';
                      } ?>>خراسان شمالی</option>
                      <option value="SMN" <?php if ($billing_state === 'SMN') {
                        echo 'selected="selected"';
                      } ?>>سمنان</option>
                      <option value="FRS" <?php if ($billing_state === 'FRS') {
                        echo 'selected="selected"';
                      } ?>>فارس</option>
                      <option value="QHM" <?php if ($billing_state === 'QHM') {
                        echo 'selected="selected"';
                      } ?>>قم</option>
                      <option value="KRD" <?php if ($billing_state === 'KRD') {
                        echo 'selected="selected"';
                      } ?>>کردستان</option>
                      <option value="KBD" <?php if ($billing_state === 'KBD') {
                        echo 'selected="selected"';
                      } ?>>کهگیلویه و بویراحمد
                      </option>
                      <option value="GLS" <?php if ($billing_state === 'GLS') {
                        echo 'selected="selected"';
                      } ?>>گلستان</option>
                      <option value="GIL" <?php if ($billing_state === 'GIL') {
                        echo 'selected="selected"';
                      } ?>>گیلان</option>
                      <option value="MZN" <?php if ($billing_state === 'MZN') {
                        echo 'selected="selected"';
                      } ?>>مازندران</option>
                      <option value="MKZ" <?php if ($billing_state === 'MKZ') {
                        echo 'selected="selected"';
                      } ?>>مرکزی</option>
                      <option value="HRZ" <?php if ($billing_state === 'HRZ') {
                        echo 'selected="selected"';
                      } ?>>هرمزگان</option>
                      <option value="SBN" <?php if ($billing_state === 'SBN') {
                        echo 'selected="selected"';
                      } ?>>سیستان و بلوچستان
                      </option>
                    </select></span>
                </p>
              <?php endif; ?>

              <?php if (array_key_exists("billing_city", $this->options['kwoofields']['enabled'])): ?>
                <p class="form-row form-row-last address-field" id="billing_city_field">
                  <input value="<?php echo $billing_city; ?>" type="text" class="input-text" name="billing_city" id="billing_city"
                    placeholder="شهر" autocomplete="address-level2">
                </p>
              <?php endif; ?>

              <?php if (array_key_exists("billing_address_1", $this->options['kwoofields']['enabled'])): ?>
                <p class="form-row form-row-wide address-field" id="billing_address_1_field">
                  <input value="<?php echo $billing_address_1; ?>" type="text" class="input-text" name="billing_address_1"
                    id="billing_address_1" placeholder="آدرس خیابان" autocomplete="address-line1"></span>
                </p>
              <?php endif; ?>

              <?php if (array_key_exists("billing_address_2", $this->options['kwoofields']['enabled'])): ?>
                <p class="form-row form-row-first address-field" id="billing_address_2_field">
                  <input value="<?php echo $billing_address_2; ?>" type="text" class="input-text " name="billing_address_2"
                    id="billing_address_2" placeholder="آپارتمان، مجتمع، واحد و..." autocomplete="address-line2">
                </p>
              <?php endif; ?>

              <?php if (array_key_exists("billing_postcode", $this->options['kwoofields']['enabled'])): ?>
                <p class="form-row form-row-last address-field validate-postcode" id="billing_postcode_field">
                  <input value="<?php echo $billing_postcode; ?>" type="text" class="input-text" name="billing_postcode"
                    id="billing_postcode" placeholder="کدپستی (بدون فاصله و با اعداد انگلیسی)" autocomplete="postal-code">
                </p>
              <?php endif; ?>

              <?php if (array_key_exists("billing_phone", $this->options['kwoofields']['enabled'])): ?>
                <p class="form-row form-row-first validate-phone" id="billing_phone_field">
                  <input value="<?php echo $billing_phone; ?>" type="tel" class="input-text" name="billing_phone"
                    id="billing_phone" placeholder="تلفن" autocomplete="tel"></span>
                </p>
              <?php endif; ?>

              <?php if (array_key_exists("billing_email", $this->options['kwoofields']['enabled'])): ?>
                <p class="form-row form-row-last validate-email" id="billing_email_field">
                  <input value="<?php echo $billing_email; ?>" type="email" class="input-text " name="billing_email"
                    id="billing_email" placeholder="آدرس ایمیل" autocomplete="email">
                </p>
              <?php endif; ?>

            <?php endif; ?>
          </div>
          <button type="button"
            class="button alt btn-cart btn btn-success-5 mt-4 <?php if (wp_is_mobile()) {
              echo "w-50";
            } else {
              echo "w-25";
            } ?> py-3 float-end">
            ثبت و ذخیره
          </button>
        </div>
      </div>
      <?php

    elseif ($method === 'remove_address_modal'):
      $id = $_POST['id'];
      $user_id = $_POST['user_id'];
      if ($id === '0') {
        delete_user_meta($user_id, 'billing_first_name');
        delete_user_meta($user_id, 'billing_last_name');
        delete_user_meta($user_id, 'billing_state');
        delete_user_meta($user_id, 'billing_city');
        delete_user_meta($user_id, 'billing_address_1');
        delete_user_meta($user_id, 'billing_address_2');
        delete_user_meta($user_id, 'billing_postcode');
        delete_user_meta($user_id, 'billing_company');
        delete_user_meta($user_id, 'billing_country');
        delete_user_meta($user_id, 'billing_country');
        delete_user_meta($user_id, 'bill0');

      } else {
        delete_user_meta($user_id, $id . 'shipping_first_name');
        delete_user_meta($user_id, $id . 'shipping_last_name');
        delete_user_meta($user_id, $id . 'shipping_email');
        delete_user_meta($user_id, $id . 'shipping_state');
        delete_user_meta($user_id, $id . 'shipping_city');
        delete_user_meta($user_id, $id . 'shipping_address_1');
        delete_user_meta($user_id, $id . 'shipping_address_2');
        delete_user_meta($user_id, $id . 'shipping_postcode');
        delete_user_meta($user_id, $id . 'shipping_company');
        delete_user_meta($user_id, $id . 'shipping_country');
        delete_user_meta($user_id, 'bill' . $id);
      }
      ?>
      <?php do_action('woocommerce_checkout_billing'); ?>
      <?php
      $bill_meta_value0 = '';
      $max_bills = 100; // Set this to the maximum number of bills you expect
      
      for ($i = 0; $i < $max_bills; $i++) {
          $bill_meta_value = get_user_meta($user_id, 'bill' . $i, true);
          if (!empty($bill_meta_value)) {
              $bill_meta_value0 = $bill_meta_value;
              $num = $i;
              break;
          }
      }
      // Now $bill_meta_value0 will contain the first non-empty bill value found
      
      $billing_address = get_user_meta($user_id, 'billing_address_1', true);
      if (!empty($bill_meta_value0)):
        ?>
        <!-- Start Modal New Address -->
        <div id="modal-new-address" class="modal modal-new-address fade" role="dialog" aria-labelledby="myModalLabel"
          aria-hidden="true">
          <div class="modal-dialog modal-dialog-centered inner-modal">

          </div>
        </div>
        <!-- End Modal New Address -->
        <!-- Start Select Address -->
        <div class="checkout-two-select-address checkout-two-box bg-white shadow-cart position-relative">
          <!-- Start Heading -->
          <div class="checkout-two-select-address-heading d-flex align-items-center justify-content-between">
            <div class="checkout-two-select-address-heading-title fw-bold"> انتخاب آدرس </div>
            <button userid="<?php echo $user_id; ?>" id="kaveh_new_address" type="button"
              class="new-address d-flex align-items-center fw-bold" data-bs-toggle="modal" data-bs-target="#modal-new-address">
              <i class="isax isax-location-add"></i>
              ثبت آدرس جدید
            </button>
          </div>
          <!-- End Heading -->
          <!-- Start Body -->
          <div class="checkout-two-select-address-items d-flex d-md-block">

            <?php
            $j = false;
            // Loop through the bills
            for ($i = 1; ; $i++) {
              $bill_meta_key = 'bill' . $i;
              $bill_meta_value = get_user_meta($user_id, $bill_meta_key, true);

              // Check if meta key exists
              if ($bill_meta_value !== '') {
                // Meta key exists, continue to the next one
                continue;
              } else {
                // Meta key doesn't exist, update user meta for bill$i
                // update_user_meta($user_id, $bill_meta_key, 'new_value_for_bill' . $i);
                $j = $i;
                // Break the loop
                break;
              }
            }
            for ($z = 1; $z <= $num; $z++) {
              $shipping_address = get_user_meta($user_id, $z . 'shipping_address_1', true);
              ?>
              <!-- Start Address -->
              <div class="checkout-two-select-address-item position-relative">
                <input type="radio" name="address" class="position-absolute top-0 end-0 w-100 h-100" checked>
                <div class="position-relative d-flex bg-white">
                  <div class="right">
                    <span class="radio position-relative d-block"></span>
                  </div>
                  <div class="info">
                    <div class="address fw-bold">
                      <i class="isax isax-location4"></i>
                      آدرس:
                      <span>
                        <?php if (!empty($shipping_address)): ?>
                          <?php echo $shipping_address; ?>
                        <?php endif; ?>
                      </span>
                    </div>
                    <ul class="d-flex align-items-center flex-wrap">
                      <?php
                      $first_name = get_user_meta($user_id, $z . 'shipping_first_name', true);
                      $last_name = get_user_meta($user_id, $z . 'shipping_last_name', true);
                      if (!empty($first_name) && !empty($last_name)):
                        ?>
                        <li class="d-flex align-items-center">
                          <i class="icon-user-fill lh-1"></i>
                          <span>
                            <?php echo '&nbsp;' . $first_name . ' ' . $last_name; ?>
                          </span>
                        </li>
                      <?php endif; ?>
                    </ul>
                    <button userid="<?php echo $user_id; ?>" icd="<?php echo $z; ?>" id="kaveh_edit_address" type="button"
                      class="edit position-absolute top-50 translate-middle-y z-99" data-bs-toggle="modal"
                      data-bs-target="#modal-new-address">
                      <i class="isax isax-edit"></i> ویرایش
                    </button>
                    <button userid="<?php echo $user_id; ?>" icd="<?php echo $z; ?>" id="kaveh_remove_address" type="button"
                      class="edit position-absolute top-50 translate-middle-y left50 z-99">
                      <i class="isax isax-trash"></i> حذف
                    </button>
                  </div>
                </div>
              </div>
              <!-- End Address -->
              <?php
            }
            ?>
						<?php if (!empty($billing_address)): ?>

            <!-- Start Address -->
            <div class="checkout-two-select-address-item position-relative">
              <input type="radio" name="address" class="position-absolute top-0 end-0 w-100 h-100" checked>
              <div class="position-relative d-flex bg-white">
                <div class="right">
                  <span class="radio position-relative d-block"></span>
                </div>
                <div class="info">
                  <div class="address fw-bold">
                    <i class="isax isax-location4"></i>
                    آدرس:
                    <span>
                      <?php if (!empty($billing_address)): ?>
                        <?php echo $billing_address; ?>
                      <?php endif; ?>
                    </span>
                  </div>
                  <ul class="d-flex align-items-center flex-wrap">
                    <?php
                    $first_name = get_user_meta($user_id, 'billing_first_name', true);
                    $last_name = get_user_meta($user_id, 'billing_last_name', true);
                    if (!empty($first_name) && !empty($last_name)):
                      ?>
                      <li class="d-flex align-items-center">
                        <i class="icon-user-fill lh-1"></i>
                        <span>
                          <?php echo '&nbsp;' . $first_name . ' ' . $last_name; ?>
                        </span>
                      </li>
                    <?php endif; ?>
                  </ul>
                  <button userid="<?php echo $user_id; ?>" icd="0" id="kaveh_edit_address" type="button"
                    class="edit position-absolute top-50 translate-middle-y z-99" data-bs-toggle="modal"
                    data-bs-target="#modal-new-address">
                    <i class="isax isax-edit"></i> ویرایش
                  </button>
                  <button userid="<?php echo $user_id; ?>" icd="0" id="kaveh_remove_address" type="button"
                    class="edit position-absolute top-50 translate-middle-y left50 z-99">
                    <i class="isax isax-trash"></i> حذف
                  </button>
                </div>
              </div>
            </div>
            <!-- End Address -->

            <?php endif; ?>


          </div>
          <!-- End Body -->

        </div>
        <!-- End Select Address -->
      <?php else: ?>
        <!-- Start Select Address empty -->
        <div class="checkout-two-select-address checkout-two-box bg-white shadow-cart position-relative">
          <!-- Start Heading -->
          <div class="checkout-two-select-address-heading d-flex align-items-center justify-content-between">
            <div class="checkout-two-select-address-heading-title fw-bold"> انتخاب آدرس </div>
          </div>
          <!-- End Heading -->
          <!-- Start Body -->
          <div
            class="checkout-two-select-address-empty d-flex align-items-center justify-content-center flex-column position-relative">
            <img src="<?php echo esc_url(KAVEH_TEMPLATE_URI); ?>/assets/images/kaveh/location.svg" alt="location" width="85"
              height="85" class="d-block mx-auto">
            <div class="title text-center fw-bold"> آدرس تحویل ثبت نشده است. </div>
            <button userid="<?php echo $user_id; ?>" id="kaveh_new_address" type="button"
              class="btn btn-outline-success-2 d-flex align-items-center justify-content-center" data-bs-toggle="modal"
              data-bs-target="#modal-new-address">
              <i class="isax isax-location-add"></i>
              ثبت آدرس جدید
            </button>
          </div>
          <!-- End Body -->
        </div>
        <!-- End Select Address Empty -->
      <?php endif; ?>
      <!-- Start Type Send -->
      <div class="checkout-two-type-send checkout-two-box bg-white shadow-cart position-relative">
        <div class="title fw-bold"> توضیحات مهم سفارش </div>
        <div class="row">
          <!-- Start Tabs -->
          <div class="col-lg-12 mb-4">
            <!-- Start Tabs Contents -->
            <div class="tab-content">
              <?php echo $this->options['kwoocheckoutdesc']; ?>
            </div>
            <!-- End Tabs Contents -->
          </div>
        </div>
      </div>
      <!-- End Type Send -->
      <?php
    elseif ($method === 'add_address_modal'):
      $user_id = $_POST['user_id'];
      $form_array = [
        'billing_first_name' => $_POST['billing_first_name'],
        'billing_last_name' => $_POST['billing_last_name'],
        'billing_phone' => $_POST['billing_phone'],
        'billing_email' => $_POST['billing_email'],
        'billing_state' => $_POST['billing_state'],
        'billing_city' => $_POST['billing_city'],
        'billing_address_1' => $_POST['billing_address_1'],
        'billing_address_2' => $_POST['billing_address_2'],
        'billing_postcode' => $_POST['billing_postcode'],
        'billing_company' => $_POST['billing_company'],
        'billing_country' => $_POST['billing_country'],
      ];
      $form_array1 = [
        'shipping_first_name' => $_POST['billing_first_name'],
        'shipping_last_name' => $_POST['billing_last_name'],
        'shipping_phone' => $_POST['billing_phone'],
        'shipping_email' => $_POST['billing_email'],
        'shipping_state' => $_POST['billing_state'],
        'shipping_city' => $_POST['billing_city'],
        'shipping_address_1' => $_POST['billing_address_1'],
        'shipping_address_2' => $_POST['billing_address_2'],
        'shipping_postcode' => $_POST['billing_postcode'],
        'shipping_company' => $_POST['billing_company'],
        'shipping_country' => $_POST['billing_country'],
      ];

      if (empty(get_user_meta($user_id, 'billing_address_1', true))) {

        foreach ($form_array as $key => $value) {
          // Check if the value exists
          if (!empty($value)) {
            // Update user meta
            update_user_meta($user_id, $key, $value);
            update_user_meta($user_id, 'bill0', '1');
          }
        }

      } else {
        // Loop through the bills
        for ($i = 1; ; $i++) {
          $bill_meta_key = 'bill' . $i;
          $bill_meta_value = get_user_meta($user_id, $bill_meta_key, true);

          // Check if meta key exists
          if ($bill_meta_value !== '') {
            // Meta key exists, continue to the next one
            continue;
          } else {

            foreach ($form_array1 as $key => $value) {
              // Check if the value exists
              if (!empty($value)) {
                // Update user meta
                update_user_meta($user_id, $bill_meta_key, '1');
                update_user_meta($user_id, $i . $key, $value);
              }
            }
            // Break the loop
            break;
          }
        }
      }
      ?>
      <?php do_action('woocommerce_checkout_billing'); ?>
      <?php
      $bill_meta_value0 = '';
      $max_bills = 100; // Set this to the maximum number of bills you expect
      
      for ($i = 0; $i < $max_bills; $i++) {
          $bill_meta_value = get_user_meta($user_id, 'bill' . $i, true);
          if (!empty($bill_meta_value)) {
              $bill_meta_value0 = $bill_meta_value;
							$num = $i;
              break;
          }
      }
      // Now $bill_meta_value0 will contain the first non-empty bill value found
      
      $billing_address = get_user_meta($user_id, 'billing_address_1', true);
      if (!empty($bill_meta_value0)):
        ?>
        <!-- Start Modal New Address -->
        <div id="modal-new-address" class="modal modal-new-address fade" role="dialog" aria-labelledby="myModalLabel"
          aria-hidden="true">
          <div class="modal-dialog modal-dialog-centered inner-modal">

          </div>
        </div>
        <!-- End Modal New Address -->
        <!-- Start Select Address -->
        <div class="checkout-two-select-address checkout-two-box bg-white shadow-cart position-relative">
          <!-- Start Heading -->
          <div class="checkout-two-select-address-heading d-flex align-items-center justify-content-between">
            <div class="checkout-two-select-address-heading-title fw-bold"> انتخاب آدرس </div>
            <button userid="<?php echo $user_id; ?>" id="kaveh_new_address" type="button"
              class="new-address d-flex align-items-center fw-bold" data-bs-toggle="modal" data-bs-target="#modal-new-address">
              <i class="isax isax-location-add"></i>
              ثبت آدرس جدید
            </button>
          </div>
          <!-- End Heading -->
          <!-- Start Body -->
          <div class="checkout-two-select-address-items d-flex d-md-block">

            <?php
            $j = false;
            // Loop through the bills
            for ($i = 1; ; $i++) {
              $bill_meta_key = 'bill' . $i;
              $bill_meta_value = get_user_meta($user_id, $bill_meta_key, true);

              // Check if meta key exists
              if ($bill_meta_value !== '') {
                // Meta key exists, continue to the next one
                continue;
              } else {
                // Meta key doesn't exist, update user meta for bill$i
                // update_user_meta($user_id, $bill_meta_key, 'new_value_for_bill' . $i);
                $j = $i;
                // Break the loop
                break;
              }
            }
            for ($z = 1; $z <= $num; $z++) {
              $shipping_address = get_user_meta($user_id, $z . 'shipping_address_1', true);
              ?>
              <!-- Start Address -->
              <div class="checkout-two-select-address-item position-relative">
                <input type="radio" name="address" class="position-absolute top-0 end-0 w-100 h-100" checked>
                <div class="position-relative d-flex bg-white">
                  <div class="right">
                    <span class="radio position-relative d-block"></span>
                  </div>
                  <div class="info">
                    <div class="address fw-bold">
                      <i class="isax isax-location4"></i>
                      آدرس:
                      <span>
                        <?php if (!empty($shipping_address)): ?>
                          <?php echo $shipping_address; ?>
                        <?php endif; ?>
                      </span>
                    </div>
                    <ul class="d-flex align-items-center flex-wrap">
                      <?php
                      $first_name = get_user_meta($user_id, $z . 'shipping_first_name', true);
                      $last_name = get_user_meta($user_id, $z . 'shipping_last_name', true);
                      if (!empty($first_name) && !empty($last_name)):
                        ?>
                        <li class="d-flex align-items-center">
                          <i class="icon-user-fill lh-1"></i>
                          <span>
                            <?php echo '&nbsp;' . $first_name . ' ' . $last_name; ?>
                          </span>
                        </li>
                      <?php endif; ?>
                    </ul>
                    <button userid="<?php echo $user_id; ?>" icd="<?php echo $z; ?>" id="kaveh_edit_address" type="button"
                      class="edit position-absolute top-50 translate-middle-y z-99" data-bs-toggle="modal"
                      data-bs-target="#modal-new-address">
                      <i class="isax isax-edit"></i> ویرایش
                    </button>
                    <button userid="<?php echo $user_id; ?>" icd="<?php echo $z; ?>" id="kaveh_remove_address" type="button"
                      class="edit position-absolute top-50 translate-middle-y left50 z-99">
                      <i class="isax isax-trash"></i> حذف
                    </button>
                  </div>
                </div>
              </div>
              <!-- End Address -->
              <?php
            }
            ?>
						<?php if (!empty($billing_address)): ?>
            <!-- Start Address -->
            <div class="checkout-two-select-address-item position-relative">
              <input type="radio" name="address" class="position-absolute top-0 end-0 w-100 h-100" checked>
              <div class="position-relative d-flex bg-white">
                <div class="right">
                  <span class="radio position-relative d-block"></span>
                </div>
                <div class="info">
                  <div class="address fw-bold">
                    <i class="isax isax-location4"></i>
                    آدرس:
                    <span>
                      <?php if (!empty($billing_address)): ?>
                        <?php echo $billing_address; ?>
                      <?php endif; ?>
                    </span>
                  </div>
                  <ul class="d-flex align-items-center flex-wrap">
                    <?php
                    $first_name = get_user_meta($user_id, 'billing_first_name', true);
                    $last_name = get_user_meta($user_id, 'billing_last_name', true);
                    if (!empty($first_name) && !empty($last_name)):
                      ?>
                      <li class="d-flex align-items-center">
                        <i class="icon-user-fill lh-1"></i>
                        <span>
                          <?php echo '&nbsp;' . $first_name . ' ' . $last_name; ?>
                        </span>
                      </li>
                    <?php endif; ?>
                  </ul>
                  <button userid="<?php echo $user_id; ?>" icd="0" id="kaveh_edit_address" type="button"
                    class="edit position-absolute top-50 translate-middle-y z-99" data-bs-toggle="modal"
                    data-bs-target="#modal-new-address">
                    <i class="isax isax-edit"></i> ویرایش
                  </button>
                  <button userid="<?php echo $user_id; ?>" icd="0" id="kaveh_remove_address" type="button"
                    class="edit position-absolute top-50 translate-middle-y left50 z-99">
                    <i class="isax isax-trash"></i> حذف
                  </button>
                </div>
              </div>
            </div>
            <!-- End Address -->
            <?php endif; ?>


          </div>
          <!-- End Body -->

        </div>
        <!-- End Select Address -->
      <?php else: ?>
        <!-- Start Select Address empty -->
        <div class="checkout-two-select-address checkout-two-box bg-white shadow-cart position-relative">
          <!-- Start Heading -->
          <div class="checkout-two-select-address-heading d-flex align-items-center justify-content-between">
            <div class="checkout-two-select-address-heading-title fw-bold"> انتخاب آدرس </div>
          </div>
          <!-- End Heading -->
          <!-- Start Body -->
          <div
            class="checkout-two-select-address-empty d-flex align-items-center justify-content-center flex-column position-relative">
            <img src="<?php echo esc_url(KAVEH_TEMPLATE_URI); ?>/assets/images/kaveh/location.svg" alt="location" width="85"
              height="85" class="d-block mx-auto">
            <div class="title text-center fw-bold"> آدرس تحویل ثبت نشده است. </div>
            <button userid="<?php echo $user_id; ?>" id="kaveh_new_address" type="button"
              class="btn btn-outline-success-2 d-flex align-items-center justify-content-center" data-bs-toggle="modal"
              data-bs-target="#modal-new-address">
              <i class="isax isax-location-add"></i>
              ثبت آدرس جدید
            </button>
          </div>
          <!-- End Body -->
        </div>
        <!-- End Select Address Empty -->
      <?php endif; ?>
      <!-- Start Type Send -->
      <div class="checkout-two-type-send checkout-two-box bg-white shadow-cart position-relative">
        <div class="title fw-bold"> توضیحات مهم سفارش </div>
        <div class="row">
          <!-- Start Tabs -->
          <div class="col-lg-12 mb-4">
            <!-- Start Tabs Contents -->
            <div class="tab-content">
              <?php echo $this->options['kwoocheckoutdesc']; ?>
            </div>
            <!-- End Tabs Contents -->
          </div>
        </div>
      </div>
      <!-- End Type Send -->
      <?php

    endif;
    die();
  }


  public function kaveh_ajax_update_cart_kk()
  {
    global $wp_query;
    $method = $wp_query->get('rewrite_kaveh_ajax_update_cart_kk');
    if (!$method) {
      return;
    }
    if ($method === 'kaveh_ajax_update_cart_kk'):
      if (isset($_POST['cart_item_key']) && isset($_POST['quantity'])) {
        $cart_item_key = sanitize_text_field($_POST['cart_item_key']);
        $quantity = intval($_POST['quantity']);
        // Update the cart item quantity
        WC()->cart->set_quantity($cart_item_key, $quantity, true);
        // Calculate cart totals and fragments
        WC()->cart->calculate_totals();
        WC()->cart->maybe_set_cart_cookies();
        // Get updated cart fragments
        $fragments = WC_AJAX::get_refreshed_fragments();
        // Return the updated fragments as a JSON response
        wp_send_json_success(
          array(
            'fragments' => $fragments
          )
        );
      }
      wp_send_json_error('Invalid request.');
    elseif ($method === 'kaveh_ajax_update_cart_kk_remove'):
      $cart_item_key = sanitize_text_field($_POST['cart_item_key']);
      $quantity = intval($_POST['quantity']);
      // Update the cart item quantity
      WC()->cart->set_quantity($cart_item_key, $quantity, true);
      // Calculate cart totals and fragments
      WC()->cart->calculate_totals();
      WC()->cart->maybe_set_cart_cookies();
      // Get updated cart fragments
      $fragments = WC_AJAX::get_refreshed_fragments();
      // Return the updated fragments as a JSON response
      wp_send_json_success(
        array(
          'fragments' => $fragments
        )
      );
    endif;
    die();
  }

  public function filter_kaveh()
  {
    global $wp_query;
    $method = $wp_query->get('rewrite_kfilters');
    if (!$method) {
      return;
    }
    if (!isset($_POST['page'])) {
      $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
    } else {
      $paged = $_POST['page'];
    }

    $sortt = $_POST['sortt'];
    $onsalee = $_POST['onsalee'];
    $onstock = $_POST['onstock'];
    $catIdss = $_POST['catIds'];
    $brandIds = $_POST['brandIds'];
    $counttax = $_POST['count'];
    $serializedAttrId = $_POST['attrId'];
    $serializedTaxIds = $_POST['taxIds'];
    $serializedAttrId = stripslashes($serializedAttrId); // Remove the slashes
    $serializedTaxIds = stripslashes($serializedTaxIds); // Remove the slashes
    $attrId = json_decode($serializedAttrId, true);
    $taxIds = json_decode($serializedTaxIds, true);
    $pricemin = 0;
    $pricemax = 999999999999999999999999999999;
    if (isset($_POST['pricemin'])) {
      $pricemin = $_POST['pricemin'];
    }
    if (isset($_POST['pricemax'])) {
      $pricemax = $_POST['pricemax'];
    }
    $pricerange = array(
      'relation' => 'OR',
      array(
        'key' => '_price',
        'value' => array($pricemin, $pricemax),
        'compare' => 'BETWEEN',
        'type' => 'NUMERIC',
      ),
      array(
        'key' => '_price',
        'compare' => 'NOT EXISTS',
      )
    );

    if ($onstock == 'true') {
      $onstock = array(
        array(
          'key' => '_stock_status',
          'value' => 'outofstock',
          'compare' => '!=',
        )
      );
    }


    $sorttt = []; // Default value

    
    if ($sortt === 'sort-2') {
      $sorttt = [
        'orderby' => 'date',
        'order' => 'DESC',
      ];
    } elseif ($sortt === 'sort-3') {
      $sorttt = [
        'meta_key' => '_price',
        'orderby' => 'meta_value_num',
        'order' => 'asc',
      ];
    } elseif ($sortt === 'sort-4') {
      $sorttt = [
        'meta_key' => '_price',
        'orderby' => 'meta_value_num',
        'order' => 'desc',
      ];
    } elseif ($sortt === 'sort-5') {
      $sorttt = [
        'meta_key' => 'total_sales', // Set the meta key to order by (in this case, total sales)
        'orderby' => 'meta_value_num', // Order products by the numeric value of the meta key
        'order' => 'desc',
      ];
    }else{
      $sorttt = [
        'orderby' => 'date',
        'order' => 'DESC',
      ];
    }


    $tax_query_args = array(
      'relation' => 'AND',
    );

    if (!empty($catIdss) && is_array($catIdss) && count(array_filter($catIdss))) {
      $tax_query_args[] = array(
        'taxonomy' => 'product_cat',
        'field' => 'term_id',
        'terms' => $catIdss,
        'operator' => 'IN',
      );
    }
    if (!empty($catIdss) && !is_array($catIdss)) {
      $tax_query_args[] = array(
        'taxonomy' => 'product_cat',
        'field' => 'term_id',
        'terms' => $catIdss,
        'operator' => 'IN',
      );
    }


    if (!empty($brandIds) && is_array($brandIds) && count(array_filter($brandIds))) {
      $tax_query_args[] = array(
        'taxonomy' => 'brands',
        'field' => 'term_id',
        'terms' => $brandIds,
        'operator' => 'IN',
      );
    }


    if (!empty($taxIds) && is_array($taxIds) && count(array_filter($taxIds))) {
      $in = 0;
      foreach ($taxIds as $taxId) {
        $notEmptyFound = false;
        foreach ($taxId as $value) {
          if (!empty($value)) {
            $notEmptyFound = true;
            break;
          }
        }
        if ($notEmptyFound) {
          $tax_query_args[] = array(
            'taxonomy' => $attrId[$in],
            'field' => 'slug',
            'terms' => $taxId,
            'operator' => 'IN',
          );
        } else {

        }
        $in = $in + 1;
      }
    }

    $argspage = [
      'post_type' => 'product',
      'posts_per_page' => 9,
      'post_status' => 'publish',
      'orderby' => 'date',
      'order' => 'asc',
      'orderby_meta_key' => '_price',
      'paged' => $paged,
      'meta_query' => array(
        'relation' => 'AND',
        WC()->query->get_meta_query(),
        $pricerange,
        $onstock,
      ),
      'tax_query' => $tax_query_args,
    ];
    if ($onsalee === 'true') {
      $argspage['post__in'] = array_merge(array(0), wc_get_product_ids_on_sale());
    }

    $productsarg = [
      'post_type' => 'product',
      'posts_per_page' => 9,
      'post_status' => 'publish',
      'orderby' => $sorttt['orderby'],
      'order' => $sorttt['order'],
      'paged' => $paged,
      'meta_query' => array(
        'relation' => 'AND',
        WC()->query->get_meta_query(),
        $pricerange,
        $onstock,
      ),
      'tax_query' => $tax_query_args,
    ];
    if ($onsalee === 'true') {
      $productsarg['post__in'] = array_merge(array(0), wc_get_product_ids_on_sale());
    }

    $products = new WP_Query($productsarg);
    if ($products->have_posts()) {
      do_action('woocommerce_before_shop_loop');
      woocommerce_product_loop_start();

      while ($products->have_posts()) {
        $products->the_post();
        do_action('woocommerce_shop_loop');
        wc_get_template_part('content', 'product');
      }
      woocommerce_product_loop_end();
      // Add pagination links
      $total_pages = $products->max_num_pages;
      $base_url = get_permalink(wc_get_page_id('shop'));
      echo '<div class="pg1 d-block mx-auto text-center">';
      echo paginate_links(
        array(
          'base' => $base_url . '%_%',
          'format' => '?page=%#%',
          'current' => $paged,
          'total' => $total_pages,
          'prev_text' => '&laquo;',
          'next_text' => '&raquo;',
          'add_args' => array_merge(
            $argspage,  
            array(
              'page' => $paged,
            )
          ),
        )
      );
      echo '</div>';
    } else {
      echo '<p>هیچ محصولی یافت نشد</p>';
    }
    wp_reset_postdata();
    die();
  }


  public function kaveh_ajax_remove_cart_item()
  {
    global $wp_query;
    global $woocommerce;
    $method = $wp_query->get('rewrite_kaveh_cart_remove');
    if (!$method) {
      return;
    }
    if ($method === 'kaveh_cart_remove'):
      $cart_item_key = $_POST['product_id'];
      $cart = WC()->cart;
      $cart->remove_cart_item($cart_item_key);
      ob_start();
      ?>
      <ul class="tot-aj-cc">
        <?php
        if (WC()->cart->get_cart_contents_count() == 0) {
          ?>
          <div class="align-items-center">
            <img class="mx-auto w-50 d-block text-center position-relative mn-r"
              src="<?php echo KAVEH_TEMPLATE_URI . '/assets/images/emptybag.png'; ?>" alt="emptycart">
            <h6 class="text-center position-relative mn-r">هیچ محصولی در سبد نیست</h6>
          </div>
          <?php
        }
        ?>
        <?php
        foreach (WC()->cart->get_cart() as $cart_item_key => $cart_item) {
          $product = $cart_item['data'];
          $product_id = $cart_item['product_id'];
          $variation_id = $cart_item['variation_id'];
          $quantity = $cart_item['quantity'];
          $price = WC()->cart->get_product_price($product);
          $subtotal = WC()->cart->get_product_subtotal($product, $cart_item['quantity']);
          $link = $product->get_permalink($cart_item);
          // Anything related to $product, check $product tutorial
          $attributes = $product->get_attributes();
          $meta = wc_get_formatted_cart_item_data($cart_item);
          $sale_price = $product->get_sale_price();
          $normal_price = $product->get_regular_price();

          ?>

          <li class="position-relative">
            <a href="<?php echo wc_get_cart_remove_url($cart_item_key); ?>" type="button"
              class="delete position-absolute text-center rounded-pill fw-light remove"
              data-cart-item-key="<?php echo esc_attr($cart_item_key); ?>" aria-label="حذف این آیتم"
              data-product_id="<?php if ($variation_id == 0):
                echo $product_id; else:
                echo $variation_id; endif; ?>"> حذف </a>
            <img
              src="<?php $image = wp_get_attachment_image_src(get_post_thumbnail_id($product_id), 'thumbnail');
              echo $image[0]; ?>"
              alt="product" />
            <div class="detail">
              <h2>
                <a href="javascript:void(0)"> <?php echo $product->name; ?> </a>
              </h2>
              <?php if (!$product->is_type('variable')) { ?>
                <?php if (!empty($sale_price)) { ?>
                  <div class="offer">
                    <?php echo number_format($normal_price, 0, '.', ',');
                    ; ?>
                  </div>
                <?php } ?>
                <div class="price">
                  <?php echo number_format($sale_price, 0, '.', ','); ?>
                  <span> <?php echo get_woocommerce_currency_symbol(); ?> </span>
                </div>
              <?php } else {
                $price_v = $product->get_price_html();
                echo str_replace("&ndash;", "<span class=\"dashvar\"> – </span>", $price_v);
              } ?>
            </div>
          </li>
        <?php
        }
        ?>
      </ul>
      <?php
      $conttent = ob_get_clean();
      $response = array(
        'result' => 'success',
        'cart_count' => WC()->cart->get_cart_contents_count(),
        'cart_total' => WC()->cart->total,
        'cart_contents' => $conttent,
      );

      wp_send_json($response);
    endif;
    die();

  }


  public function kaveh_ajax_popup()
  {
    global $wp_query;
    $method = $wp_query->get('rewrite_kaveh_ajax_popup');
    if (!$method) {
      return;
    }
    if ($method === 'kaveh_ajax_popup'):
      $idofpost = $_POST['postid'];
      global $product;
      $product = wc_get_product($idofpost);
      $sale_price = $product->get_sale_price();
      $normal_price = $product->get_regular_price();
      $stocka = $product->get_stock_status();
      $product_type = $product->get_type();
      $sale_price_dates_from = $sale_price_dates_to = '';
      ?>
      <div class="modal-body position-relative d-flex flex-column flex-lg-row overflow-hidden hideme">
        <div class="icons d-flex align-items-center position-absolute">
          <button type="button" class="d-flex align-items-center justify-content-center" data-bs-dismiss="modal">
            <i class="isax isax-close-square5"></i>
          </button>
        </div>
        <div class="right">
          <div class="gallery position-relative">
            <?php if ("instock" == $stocka) {
              if (!empty($sale_price)) { ?>
                <div class="offer position-absolute">
                  تخفیف <?php
                  $percentage = round((($product->get_regular_price() - $product->get_sale_price()) / $product->get_regular_price()) * 100);
                  echo $percentage;
                  ?>%
                </div>
              <?php }
            } ?>
            <div class="d-flex position-relative">
              <div class="swiper swiper-modal-product overflow-hidden">
                <div class="swiper-wrapper">
                  <?php
                  $attachment_ids = $product->get_gallery_image_ids();
                  if ($attachment_ids && $product->get_image_id()) {
                    $cou = 0;
                    foreach ($attachment_ids as $attachment_id) {
                      if ($cou < 4) {
                        ?>
                        <div class="swiper-slide">
                          <div class="gallery-item">
                            <img src="<?php echo wp_get_attachment_image_url($attachment_id, 'full'); ?>" class="w-100 d-block"
                              data-gallery="gallery-origin<?php echo $idofpost; ?>">
                          </div>
                        </div>
                        <?php
                        $cou += 1;
                      }
                    }
                  }
                  ?>
                </div>
              </div>
              <div class="swiper-button-next"></div>
              <div class="swiper-button-prev"></div>
              <div class="gallery-origin">
                <img
                  src="<?php $image = wp_get_attachment_image_src(get_post_thumbnail_id($idofpost), 'full');
                  echo $image[0]; ?>"
                  id="gallery-origin<?php echo $idofpost; ?>" class="w-100 d-block">
              </div>
            </div>
            <button type="button">
            </button>
          </div>
          <a href="<?php echo get_permalink($idofpost); ?>" class="btn-view btn btn-primary d-none d-lg-inline-block">
            مشخصات بیشتر محصول
            <i class="isax isax-arrow-left5"></i>
          </a>
        </div>
        <div class="left w-100">
          <h2 class="name"> <?php echo $product->get_title(); ?> </h2>
          <br>
          <?php
          if ("instock" == $stocka) {
            if ($date_from = get_post_meta($product->get_id(), '_sale_price_dates_from', true)) {
              $sale_price_dates_from = date('Y-m-d 00:00:00', $date_from);
            }
            if ($date_to = get_post_meta($product->get_id(), '_sale_price_dates_to', true)) {
              $sale_price_dates_to = date('Y-m-d 23:59:59', $date_to);
            }
            $deal_start_date = $sale_price_dates_from;
            $deal_start_time = strtotime($deal_start_date);
            $deal_end_date = $sale_price_dates_to;
            $deal_end_time = strtotime($deal_end_date, current_time('timestamp'));
            //$current_date = current_time( 'Y-m-d H:i:s', true );
            $current_time = strtotime('NOW', current_time('timestamp'));
            $time_diff = ($deal_end_time - $current_time); ?>
            <?php if (!empty($deal_end_date)) { ?>
              <ul class="timear d-flex align-items-center" data-time="<?php echo $deal_end_date; ?>">
                <li class="text-center">
                  <span class="second d-block rounded-circle text-center text-white"> 00 </span>
                  ثانیه
                </li>
                <li class="text-center">
                  <span class="minute d-block rounded-circle text-center text-white"> 00 </span>
                  دقیقه
                </li>
                <li class="text-center">
                  <span class="hour d-block rounded-circle text-center text-white"> 00 </span>
                  ساعت
                </li>
                <li class="text-center">
                  <span class="day d-block rounded-circle text-center text-white"> 00 </span>
                  روز
                </li>
              </ul>
            <?php }
          } ?>
          <div class="row align-items-center">
            <div class="col-sm-6">
              <!-- Start Status -->
              <div class="status d-flex align-items-center">
                <span class="label fw-bold"> وضعیت </span>
                <?php if ("instock" == $stocka): ?>
                  <div class="badge rounded-pill fw-light"> موجود در انبار </div>
                <?php elseif ("onbackorder" == $stocka): ?>
                  <div class="badge rounded-pill fw-light obstock"> در پیش خرید </div>
                <?php else: ?>
                  <div class="badge rounded-pill fw-light oustock namo"> ناموجود </div>
                <?php endif; ?>
              </div>
              <br>
              <?php echo wp_trim_words($product->get_short_description(), 64); ?>
              <!-- End Status -->
              <div class="woocommerce mt-4">
                <?php
                if ($product->is_type('variable')) {
                  ?>
                  <a class="modaladdto" href="<?php echo get_permalink($idofpost); ?>">انتخاب گزینه ها</a>
                  <?php
                } else {
                  woocommerce_template_single_add_to_cart();
                }
                ?>
              </div>
            </div>
            <div class="col-sm-6">
              <?php
              $i = 0;
              $product_attributes = $product->get_attributes();
              if (!empty($product_attributes)):
                ?>
                <div class="options">
                  <div class="title"> ویژگی‌های ﻣﺤﺼﻮل </div>
                  <?php

                  // Loop through each attribute
                  foreach ($product_attributes as $attribute):
                    $attribute_slug = $attribute->get_name();
                    if ($i < 6):
                      ?>
                      <ul>
                        <li><?php echo wc_attribute_label($attribute_slug) ?> :
                          <?php echo $product->get_attribute($attribute_slug) ?></li>
                      </ul>
                      <?php
                      $i++;
                    endif;
                  endforeach;
                  ?>
                </div>
              <?php endif; ?>
            </div>
            <div class="col-lg-6">


            </div>
            <div class="col-lg-6">


            </div>
          </div>
        </div>
      </div>
      </div>
      </div>
      </div>
      </div>
      <script>
        // Swiper Gallery Image Modal Product
        new Swiper(".swiper-modal-product", {
          slidesPerView: 3,
          spaceBetween: 11,
          direction: "vertical",
          navigation: {
            nextEl: ".swiper-button-next",
            prevEl: ".swiper-button-prev",
          },
        });
      </script>
      <?php
    endif;
    die();
  }

  public function kaveh_ajaxx_add_to_cart()
  {
    global $wp_query;
    $method = $wp_query->get('rewrite_kaveh_ajaxx_add_to_cart');
    if (!$method) {
      return;
    }
    if ($method === 'kaveh_ajaxx_add_to_cart'):
      $product_id = apply_filters('woocommerce_add_to_cart_product_id', absint($_POST['product_id']));
      $quantity = empty($_POST['quantity']) ? 1 : wc_stock_amount($_POST['quantity']);
      $variation_id = absint($_POST['variation_id']);
      $passed_validation = apply_filters('woocommerce_add_to_cart_validation', true, $product_id, $quantity);
      $product_status = get_post_status($product_id);

      if ($passed_validation && WC()->cart->add_to_cart($product_id, $quantity, $variation_id) && 'publish' === $product_status) {

        do_action('woocommerce_ajax_added_to_cart', $product_id);

        if ('yes' === get_option('woocommerce_cart_redirect_after_add')) {
          wc_add_to_cart_message(array($product_id => $quantity), true);
        }
        WC_AJAX::get_refreshed_fragments();
      } else {

        $data = array(
          'error' => true,
          'product_url' => apply_filters('woocommerce_cart_redirect_after_error', get_permalink($product_id), $product_id)
        );

        echo wp_send_json($data);
      }
    endif;
    die();
  }

}