<?php
/**
 * Plugin Name: هسته کاوه
 * Plugin URI: https://www.rtl-theme.com/author/moein757/products/
 * Description: هسته کاوه شامل امکاناتی است که بهتر بود به عنوان یک افزونه و نه به عنوان قالب در کنار آن قرار گیرد
 * Version: 3.8.5
 * Author: معین وردپرس
 * Author URI: https://www.rtl-theme.com/author/moein757/products/
 * Text Domain: kaveh-core
 */

if (! defined('ABSPATH')) {
    exit;
}

class Kaveh_Core_Plugin {
    public function __construct() {

        $this->includes();
        add_action('elementor/elements/categories_registered', array($this, 'add_elementor_widget_categories'));
        add_action('elementor/elements/categories_registered', array($this, 'add_elementor_widget_categories_header'));
        add_action('elementor/elements/categories_registered', array($this, 'add_elementor_widget_categories_megamenu'));
        add_action('elementor/elements/categories_registered', array($this, 'add_elementor_widget_categories_woocommerce'));
        add_action('elementor/elements/categories_registered', array($this, 'add_elementor_widget_blog_single'));
        add_action('elementor/elements/categories_registered', array($this, 'add_elementor_widget_blog_archive'));

    }

    private function includes() {

        require_once(__DIR__ . '/kaveh-elementor-widgets.php');
        require_once(__DIR__ . '/icons/icomoon.php');
        require_once(__DIR__ . '/icons/iconsax.php');
        require_once(__DIR__ . '/icons/iconly.php');
        require_once(__DIR__ . '/boostiextend.php');

    }

    public function add_elementor_widget_categories($elements_manager) {

        $elements_manager->add_category(
            'kavehelements',
            [
                'title' => esc_html__('المان های کاوه', 'kaveh-core'),
                'icon' => 'eicon-instagram-nested-gallery',
            ]
        );

    }

    public function add_elementor_widget_categories_header($elements_manager) {

        $elements_manager->add_category(
            'headerfooterkavehelements',
            [
                'title' => esc_html__('المان های هدر و فوتر کاوه', 'kaveh-core'),
                'icon' => 'eicon-instagram-nested-gallery',
            ]
        );

    }

    public function add_elementor_widget_categories_megamenu($elements_manager) {

        $elements_manager->add_category(
            'megamenufooterkavehelements',
            [
                'title' => esc_html__('المان های مگامنو', 'kaveh-core'),
                'icon' => 'eicon-instagram-nested-gallery',
            ]
        );

    }

    public function add_elementor_widget_categories_woocommerce($elements_manager) {

        $elements_manager->add_category(
            'woocommercekavehelements',
            [
                'title' => esc_html__('المان های ووکامرس', 'kaveh-core'),
                'icon' => 'eicon-instagram-nested-gallery',
            ]
        );

    }

    public function add_elementor_widget_blog_archive($elements_manager) {

        $elements_manager->add_category(
            'blogarchiveelements',
            [
                'title' => esc_html__('المان های آرشیو وبلاگ', 'kaveh-core'),
                'icon' => 'eicon-instagram-nested-gallery',
            ]
        );

    }

    public function add_elementor_widget_blog_single($elements_manager) {

        $elements_manager->add_category(
            'blogsingleelements',
            [
                'title' => esc_html__('المان های نوشته تکی', 'kaveh-core'),
                'icon' => 'eicon-instagram-nested-gallery',
            ]
        );

    }
}

new Kaveh_Core_Plugin();