<?php

class BaseWidget {
    private $class_name;

    public function __construct($class_name) {
        $this->class_name = $class_name;
    }

    public function get_style_depends() {
        return array(strtolower($this->class_name));
    }

    public function __call($name, $arguments) {
        if (method_exists($this, $name)) {
            return call_user_func_array([$this, $name], $arguments);
        }
        return null;
    }
}

class KavehWidgetRegistrar {

    public $widgets_manager;
    public $widget_classes;

    public function __construct($widgets_manager) {
        add_action('wp_enqueue_scripts', [$this, 'register_widget_styles']);
        $this->widgets_manager = $widgets_manager;
        $this->widget_classes = [
            'Amazingoffercarouselkaveh',
            'Productscarouselkaveh',
            'Sliderfirstkaveh',
            'Productstabkaveh',
            'Categorycarouselkaveh',
            'Blogkaveh',
            'Aboutuskaveh',
            'Amazingoffersecondstkaveh',
            'Categorycarouselsecondstkaveh',
            'Blogcarouselkaveh',
            'Newsletterkaveh',
            'Customerreviewlkaveh',
            'Slidersecondkaveh',
            'Amazingofferthirdstkaveh',
            'Brandscarouselkaveh',
            'Productstabgridkaveh',
            'Productscarouselsecondstkaveh',
            'Productscarouselthirdstkaveh',
            'Aboutussecondstkaveh',
            'Categorycarouselthirdstkaveh',
            'Productscarouselfourthstkaveh',
            'Productscarouselfifthstkaveh',
            'Productstabgrid2ndstkaveh',
            'Aboutusthirdstkaveh',
            'Sliderthirdkaveh',
            'Categoryverticalcolkaveh',
            'Brandscarouselsecondstkaveh',
            'Amazingofferfourthstkaveh',
            'Priceboxkaveh',
            'Blogcarouselsecondstkaveh',
            'Sliderfourthkaveh',
            'Categorygridsecondstkaveh',
            'Productstablekaveh',
            'Sliderfifthkaveh',
            'Featureshopgridkaveh',
            'Slidersixthkaveh',
            'Amazingofferfifthstkaveh',
            'Amazingoffersixthstkaveh',
            'Sliderseventhkaveh',
            'Amazingoffersevenstkaveh',
            'Slidereighthkaveh',
            'Amazingoffereightstkaveh',
            'Categorycarouselfourthstkaveh',
            'Searchkaveh',
            'Loginandsignupkaveh',
            'Cartkaveh',
            'Wishlistkaveh',
            'Phonenumberkaveh',
            'Listkaveh',
            'Socialkaveh',
            'Newslettersecondstkaveh',
            'Iconboxkaveh',
            'Brandsgridkaveh',
            'Headingkaveh',
            'Uptotopkaveh',
            'Bloglistkaveh',
            'Megamenuonekaveh',
            'Megamenutwokaveh',
            'Counterkaveh',
            'Aparatframekaveh',
            'Logoupkaveh',
            'Sliderninethkaveh',
            'Categorycarouselfifthkaveh',
            'Brandsthirdstkaveh',
            'Productscarouselsixthstkaveh',
            'Categorycarouselsixthkaveh',
            'Aboutusfourthststkaveh',
            'Productstabsecondstkaveh',
            'Categorycarouselseventhkaveh',
            'Categorycarouseleighthkaveh',
            'Categorycarouselninethkaveh',
            'Brandsfourthstkaveh',
            'Categorycarouseltenthkaveh',
            'Categorycarouseleleventhkaveh',
            'Slidertenthkaveh',
            'Slidereleventhkaveh',
            'Brandsfifthstkaveh',
            'Categorycarouseltwelvethkaveh',
            'Productscarouselseventhstkaveh',
            'Productscarouseleighthstkaveh',
            'Productscarouselninthstkaveh',
            'Productsvertistkaveh',
            'Headingwtbuttonkaveh',
            'Productscarouseltenthstkaveh',
            'Slidertwelvethkaveh',
            'Categorycarouselthirteenthstkaveh',
            'Categorycarouselfourteenthstkaveh',
            'Megamenuthreekaveh',
            'Categoryverticalsecondstcolkaveh',
            'Amazingoffernineststkaveh',
            'kaveh_Story_Widget',
            'Categorycarouselseventeenthkaveh',
            'Cat__carousel__eighteenth',
            'class__landing__slider__kaveh',
            'Cat__carousel__nineteenth',
            'product__special__carousel',
            'Digipluskaveh',
            'Digikalabannercarouselkaveh',
            'Digikalaquicklinkskaveh',
            'Digikalaamazingoffermarketkaveh',
            'Digikalabrandscarouselkaveh',
            'Digikalatopsellingcarouselkaveh',
            'Digikalaproductscategoryonekaveh',
            'Digikalaproductscategorytwokaveh',
            'Digikalaamazingofferonekaveh',
            'Digikalaamazingoffertwokaveh',
            'Slidertthirteenkaveh',
            'Categorycarouseltwentythstkaveh',
            'Categorycarouseltwentyonethstkaveh',
            'Iconboxtwothstkaveh',
            'Categorycarouseltwentytwothstkaveh',
            'Categorycarouseltwentythreethstkaveh',
            'Sliderfourteenteenkaveh',
            'Iconboxthreethstkaveh',
            'Productscarouseleleventhstkaveh',
            'Productscarouseltwelvethstkaveh',
            'Productscarouselthirteenthstkaveh',
            'Productscarouselfourteenthstkaveh',
            'Productstabthirdstkaveh',
            'Productsrandomofferstkaveh',
            'Categorycarouseltwentyfourthstkaveh',
            'Categorycarouseltwentyfivethstkaveh',
            'Brandssixthstkaveh',
            'Productscarouselfifteenthstkaveh',
            'Productsdigistylecarouselkaveh',
            'Productsdigistylecarouselsecondstkaveh',
            'Blogdigikalagridkaveh',
            'Productsbanimodecarouselkaveh',
            'Productsbanimodesecondstcarouselkaveh',
            'Brandsseventhstkaveh',
            'Imageboxstkaveh',
            'Blogcarouselstkaveh',
            'WooArchivekaveh',
            'WooSidebarkaveh',
            'ButtonSidebarkaveh',
            'BlogArchivekaveh',
            'BlogArchiveSidebar',
            'WooRelatedkaveh',
            'kavehwoocommercesingletitle',
            'kavehwoocommercecontent',
            'kavehwoocommerceexcerpt',
            'kavehwoocommerceimages',
            'kavehwoocommercerating',
            'kavehwoocommerceattrexe',
            'kavehwoocommerceaddtocart',
            'kavehwoocommercemeta',
            'kavehwoocommerceprice',
            'kavehwoocommerceproducttabs',
            'kavehwoocommerceproductattr',
            'kavehwoocommerceproductcomment',
            'KavehBlogSinglecontent',
            'KavehBlogSingletitle',
            'KavehBlogSingleimage',
            'KavehBlogSinglemeta',
            'KavehBlogSingleRelated',
            'KavehBlogSingleComments',
        ];
    }

    public function registerWidgets() {
        $widget_classes = $this->widget_classes;
        foreach ($widget_classes as $class_name) {
            $file_path = __DIR__ . '/elements/' . strtolower($class_name) . '/' . strtolower($class_name) . '.php';

            
            if (file_exists($file_path)) {
                require_once($file_path);
  
                if (class_exists($class_name)) {
                    // Create a dynamic class extending the base class
                    $dynamic_class_name = $class_name . 'Dynamic';
                    if (!class_exists($dynamic_class_name)) {
                        eval("class $dynamic_class_name extends $class_name {
                            use DynamicWidgetExtension;
                            public function get_style_depends() {
                                return array(strtolower('$class_name'));
                            }
                        }");
                    }
                    $this->widgets_manager->register_widget_type(new $dynamic_class_name());
                }
            }
        }
    }

    public function register_widget_styles() {
        foreach ($this->widget_classes as $class_name) {
            if(is_rtl()){
                wp_register_style(strtolower($class_name), plugins_url('elements/' . strtolower($class_name) . '/' . strtolower($class_name) . '.css', __FILE__));
            }else{
                wp_register_style(strtolower($class_name), plugins_url('elements/' . strtolower($class_name) . '/' . strtolower($class_name) . '-ltr.css', __FILE__));
            }
        }
    }

    public static function init() {
        $self = new self(\Elementor\Plugin::$instance->widgets_manager);
        add_action('elementor/widgets/widgets_registered', [$self, 'registerWidgets']);
    }
}


trait DynamicWidgetExtension {
    public function __call($name, $arguments) {
        if (method_exists($this, $name)) {
            return call_user_func_array([$this, $name], $arguments);
        }
        return null;
    }
}

add_action('elementor/init', ['KavehWidgetRegistrar', 'init']);
