<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH'))
  exit; // Exit if accessed directly


class WooSidebarkaveh extends Widget_Base
{

  public function get_name()
  {
    return 'woosidebarkaveh';
  }

  public function get_title()
  {
    return esc_html__('المان سایدبار فروشگاه', 'kaveh-core');
  }

  public function get_icon()
  {
    return 'eicon-archive-posts';
  }

  public function get_categories()
  {
    return ['woocommercekavehelements'];
  }

  protected function register_controls()
  {

    $this->start_controls_section(
      'contentsocialkaveh',
      [
        'label' => esc_html__('محتوای المان', 'kaveh-core'),
        'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
      ]
    );


    $this->end_controls_section();

  }


  protected function render()
  {
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>

    <!-- Start Sidebar -->
    <aside class="category-sidebar">
      <div class="category-sidebar-backdrop"></div>
      <div class="category-sidebar-content">

        <!-- Start Sidebar -->
        <?php
        /**
         * Hook: woocommerce_sidebar.
         *
         * @hooked woocommerce_get_sidebar - 10
         */
        do_action('woocommerce_sidebar');
        ?>
        <!-- End Sidebar -->

      </div>
    </aside>
    <!-- End Sidebar -->
    <?php
  }


}
