<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly


class WooRelatedkaveh extends Widget_Base
{

    public function get_name()
    {
        return 'woorelatedkaveh';
    }

    public function get_title()
    {
        return esc_html__('المان محصولات مرتبط ووکامرس', 'kaveh-core');
    }

    public function get_icon()
    {
        return 'eicon-archive-posts';
    }

    public function get_categories()
    {
        return ['woocommercekavehelements'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'contentsocialkaveh',
            [
                'label' => esc_html__('محتوای المان', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );


        $this->end_controls_section();

    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $clsid = $this->get_id();
        $options = get_option('kaveh_frame');
        $mkshopcart = $options['kaveh_sh_cart_select'];
        ?>

        <!-- Start Products Related -->
        <section class="detail-product-four-related">
            <div class="container position-relative">
                <!-- Start Heading -->
                <div
                    class="section-heading-eight d-flex align-items-sm-center flex-wrap flex-lg-nowrap gap-4 gap-lg-0 flex-column flex-sm-row">
                    <div class="text-nowrap">
                        <div class="section-heading-eight-title">
                            محصولات مرتبط
                        </div>
                    </div>
                    <a href="<?php echo get_permalink(wc_get_page_id('shop')); ?>"
                        class="btn btn-purple-2 d-flex align-items-center justify-content-center text-nowrap ms-auto">
                        مشاهده همه
                        <i class="icon-angle-circle-top-left ms-2"></i>
                    </a>
                    <div class="swiper-bottom end-0 d-none d-md-flex align-items-md-center ms-lg-4">
                        <div
                            class="swiper-detail-product-four-related-pagination swiper-pagination m-0 position-relative top-0 start-0 bottom-0 end-0 d-flex">
                        </div>
                        <div
                            class="swiper-detail-product-four-related-button-prev swiper-button-prev m-0 w-auto h-auto position-relative top-0 start-0 bottom-0 end-0 mx-3">
                        </div>
                        <div
                            class="swiper-detail-product-four-related-button-next swiper-button-next m-0 w-auto h-auto position-relative top-0 start-0 bottom-0 end-0">
                        </div>
                    </div>
                </div>
                <!-- End Heading -->
                <!-- Start Carousel -->
                <div class="swiper swiper-detail-product-four-related swiper-button-arrow swiper-visible">
                    <div class="swiper-wrapper">
                        <?php
                        // Get the current product ID
                        $product_id = get_the_ID();

                        // Get related categories or tags for the current product
                        $related_categories = wp_get_post_terms($product_id, 'product_cat', array('fields' => 'ids'));
                        $related_tags = wp_get_post_terms($product_id, 'product_tag', array('fields' => 'ids'));

                        // Define the query parameters
                        $params = array(
                            'post_type' => 'product', // Get WooCommerce products
                            'posts_per_page' => 8, // Number of related products to retrieve
                            'post__not_in' => array($product_id), // Exclude the current product
                            'orderby' => 'rand', // Random order for related products
                            'tax_query' => array(
                                'relation' => 'OR',
                                array(
                                    'taxonomy' => 'product_cat',
                                    'field' => 'term_id',
                                    'terms' => $related_categories,
                                ),
                                array(
                                    'taxonomy' => 'product_tag',
                                    'field' => 'term_id',
                                    'terms' => $related_tags,
                                ),
                            ),
                        );

                        // Create a new WP_Query instance
                        $related_products = new WP_Query($params);
                        // Display related products
                        if ($related_products->have_posts()) {
                            while ($related_products->have_posts()) {
                                $related_products->the_post();
                                ?>
                                <div class="swiper-slide">
                                <?php
                                $template_parts = array(
                                    'value-1' => 'template-part/product-cart-one',
                                    'value-2' => 'template-part/product-cart-two',
                                    'value-3' => 'template-part/product-cart-three',
                                    'value-4' => 'template-part/product-cart-four',
                                    'value-5' => 'template-part/product-cart-five',
                                    'value-6' => 'template-part/product-cart-six',
                                    'value-7' => 'template-part/product-cart-seven',
                                    'value-8' => 'template-part/product-cart-eight',
                                    'value-9' => 'template-part/product-cart-nine',
                                    'value-10' => 'template-part/product-cart-ten',
                                    'value-11' => 'template-part/product-cart-eleven',
                                    'value-12' => 'template-part/product-cart-twelve',
                                    'value-13' => 'template-part/product-cart-thirteen',
                                    'value-14' => 'template-part/product-cart-fourteen',
                                    'value-15' => 'template-part/product-cart-fifteen',
                                    'value-16' => 'template-part/product-cart-sixteen',
                                    'value-18' => 'template-part/product-cart-eighteen',
                                    'value-19' => 'template-part/product-cart-nineteen',
                                    'value-20' => 'template-part/product-cart-twenty',
                                    'value-21' => 'template-part/product-cart-twenty-one',
                                );
                                if (array_key_exists($mkshopcart, $template_parts)) {
                                    get_template_part($template_parts[$mkshopcart]);
                                }
                                ?>
                            </div>
                            <?php
                            }
                        } else {
                            echo 'No related products found.';
                        }

                        // Reset post data
                        wp_reset_postdata();
                        ?>


                    </div>
                    <div
                        class="swiper-bottom position-absolute w-100 start-0 bottom-0 end-0 mx-auto d-flex d-md-none align-items-center justify-content-center">
                        <div
                            class="swiper-pagination swiper-pagination m-0 position-relative top-0 start-0 bottom-0 end-0 d-flex">
                        </div>
                        <div
                            class="swiper-button-prev swiper-button-prev m-0 w-auto h-auto position-relative top-0 start-0 bottom-0 end-0 mx-3">
                        </div>
                        <div
                            class="swiper-button-next swiper-button-next m-0 w-auto h-auto position-relative top-0 start-0 bottom-0 end-0">
                        </div>
                    </div>
                </div>
                <!-- End Carousel -->
            </div>
        </section>
        <!-- End Products Related -->
        <?php
    }


}
