<?php
use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly


class WooArchivekaveh extends Widget_Base
{

    public function get_name()
    {
        return 'wooarchivekaveh';
    }

    public function get_title()
    {
        return esc_html__('المان آرشیو صفحه فروشگاه', 'kaveh-core');
    }

    public function get_icon()
    {
        return 'eicon-archive-posts';
    }

    public function get_categories()
    {
        return ['woocommercekavehelements'];
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'contentsocialkaveh',
            [
                'label' => esc_html__('محتوای المان', 'kaveh-core'),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );


        $this->end_controls_section();

    }


    protected function render()
    {
        $settings = $this->get_settings_for_display();
        $clsid = $this->get_id();
        ?>

<div class="category-heading">
          <?php if (is_product_category()): ?>
            <div class="d-flex align-items-center justify-content-between">
              <div class="name-category" catid="<?php $current_category = get_queried_object();
              echo $current_category->term_id; ?>">
                <span class="d-block"> دسته بندی </span>
                <h1>
                  <?php
                  echo get_queried_object()->name;
                  ?>
                </h1>
              </div>
              <ul class="counter d-flex align-items-center">
                <li>
                  <span class="d-block"> <?php
                  $slugt = get_queried_object()->slug;
                  $argsa = array(
                    'posts_per_page' => -1,
                    'post_type' => 'product',
                    'product_cat' => $slugt,
                    'meta_query' => array(
                      array(
                        'key' => '_stock_status',
                        'value' => 'instock'
                      )
                    )
                  );
                  $querya = new WP_Query($argsa);

                  $countr = $querya->post_count;
                  ?>
                    <?php echo $countr; ?> </span>
                  محصول موجود
                </li>
                <li>
                  <span class="d-block"> <?php
                  $slugt = get_queried_object()->slug;
                  $argsa = array(
                    'posts_per_page' => -1,
                    'post_type' => 'product',
                    'product_cat' => $slugt,
                  );
                  $querya = new WP_Query($argsa);

                  $countr = $querya->post_count;
                  ?>
                    <?php echo $countr; ?> </span>
                  محصول
                </li>
              </ul>
            </div>
          <?php endif; ?>

          <!-- Start Sort -->
          <div class="category-sort d-flex align-items-center">
            <div class="title">
              <b class="d-block"> مرتب سازی </b>
              براساس
            </div>
            <ul class="d-flex align-items-center">

              <li>
                <input type="radio" name="sort" id="sort-2" hidden checked />
                <label for="sort-2"> جدیدترین </label>
              </li>
              <li>
                <input type="radio" name="sort" id="sort-3" hidden />
                <label for="sort-3"> ارزان ترین </label>
              </li>
              <li>
                <input type="radio" name="sort" id="sort-4" hidden />
                <label for="sort-4"> گران ترین </label>
              </li>
              <li>
                <input type="radio" name="sort" id="sort-1" hidden />
                <label for="sort-1"> پرفروش ترین </label>
              </li>

            </ul>
          </div>
          <!-- End Sort -->


          <!-- پاک شده است تگ هدر آرشیو فروشگاه -->
          <?php
          if (woocommerce_product_loop()) {

            /**
             * Hook: woocommerce_before_shop_loop.
             *
             * @hooked woocommerce_output_all_notices - 10
             * @hooked woocommerce_result_count - 20
             * @hooked woocommerce_catalog_ordering - 30
             */


            do_action('woocommerce_before_shop_loop');

            woocommerce_product_loop_start();

            if (wc_get_loop_prop('total')) {
              while (have_posts()) {
                the_post();

                /**
                 * Hook: woocommerce_shop_loop.
                 */
                do_action('woocommerce_shop_loop');

                wc_get_template_part('content', 'product');

              }
            }

            woocommerce_product_loop_end();

            /**
             * Hook: woocommerce_after_shop_loop.
             *
             * @hooked woocommerce_pagination - 10
             */
            do_action('woocommerce_after_shop_loop');
          } else {
            /**
             * Hook: woocommerce_no_products_found.
             *
             * @hooked wc_no_products_found - 10
             */
            do_action('woocommerce_no_products_found');
          }
          ?>
        </div>

        <?php
    }


}
