<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Wishlistkaveh extends Widget_Base{

  public function get_name(){
    return 'wishlistkaveh';
  }

  public function get_title(){
    return esc_html__( 'المان علاقه مندی', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['headerfooterkavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentwishlistkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
    $this->add_control(
      'iconewishlistkaveh',
      [
        'label' => esc_html__( 'آیکون علاقه مندی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'exclude_inline_options' => [ 'svg' ],
        'default' => [
          'value' => 'icon-heart',
        ],
      ]
    ); 
       $this->end_controls_section();
       $this->start_controls_section(
        'styleupwishlistkaveh',
        [
          'label' => esc_html__( 'استایل', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'iconsizewishlistkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 23,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-favorite' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'widthwishlistkaveh',
        [
          'label' => esc_html__( 'عرض دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 1000,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 50,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-favorite' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'heightwishlistkaveh',
        [
          'label' => esc_html__( 'ارتفاع دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 1000,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 50,
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-favorite' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'hrer3cartkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      ); 
      $this->add_control(
        'ticacolor2cartkaveh',
        [
          'label' => esc_html__( 'رنگ شمارنده علاقه مندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-header-favorite span' => 'color: {{VALUE}}',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'ticarttype2cartkaveh',
          'label' => esc_html__( 'تایپوگرافی شمارنده علاقه مندی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-header-favorite span',
        ]
      );
      $this->add_control(
        'tibgcolor2cartkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه شمارنده علاقه مندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-header-favorite span' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'iconbgcawidth2cartkaveh',
        [
          'label' => esc_html__( 'عرض پس زمینه شمارنده علاقه مندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-favorite span' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'iconbgheightca2cartkaveh',
        [
          'label' => esc_html__( 'ارتفاع پس زمینه شمارنده علاقه مندی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 1,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-favorite span' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      
      $this->start_controls_tabs(
        'style_tabs1wishlistkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tab1wishlistkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'icon1colorwishlistkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-header-favorite i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      
      $this->add_control(
        'bgcolor1wishlistkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-header-favorite' => 'background-color: {{VALUE}}',
          ],
        ]
      );  
      $this->add_control(
        'buttonradius1wishlistkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-header-favorite' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'border1wishlistkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-header-favorite',
        ]
      );
      $this->add_control(
        'buttonborders1wishlistkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],    'condition' => [
            'border1wishlistkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-favorite' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabwishlistkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'icon1buttonhovercolor5wishlistkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-header-favorite, .top-header-favorite:hover i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'bgcolorhover1wishlistkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .top-header-favorite:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushover1wishlistkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .top-header-favorite:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhover1wishlistkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-header-favorite:hover',
        ]
      );
      $this->add_control(
        'buttonbordershover1wishlistkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhover1wishlistkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .top-header-favorite:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_control(
        'hrer5wishlistkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadow15wishlistkaveh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .top-header-favorite',
        ]
      );
      $this->end_controls_section();
          
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    $wishlist_page_id = get_option('woosw_page_id');
    $wishlist_page_url = get_permalink($wishlist_page_id);
  ?>
    <a href="<?php echo $wishlist_page_url; ?>" class="top-header-favorite position-relative d-flex align-items-center justify-content-center">
      <i class="<?php echo  esc_attr($settings['iconewishlistkaveh']['value']); ?>"></i>
    </a>
    <?php
  }


}
