<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Socialkaveh extends Widget_Base{

  public function get_name(){
    return 'socialkaveh';
  }

  public function get_title(){
    return esc_html__( 'المان شبکه های اجتماعی', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['headerfooterkavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentsocialkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $this->add_control(
        'styledotsocialkaveh',
        [
          'label' => esc_html__( 'استایل المان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'one',
          'options' => [
            'one'  => esc_html__( 'طرح یک', 'kaveh-core' ),
            'two'  => esc_html__( 'طرح دو', 'kaveh-core' ),
            'three'  => esc_html__( 'طرح سه', 'kaveh-core' ),
            'four'  => esc_html__( 'طرح چهار', 'kaveh-core' ),

          ],
        ]
        ); 
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
          'iconsocialkaveh',
          [
            'label' => esc_html__( 'آیکون شبکه اجتماعی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::ICONS,
            'skin' => 'inline',
            'exclude_inline_options' => [ 'svg' ],
            'default' => [
              'value' => 'icon-instagram',
            ],
          ]
        );  
          $repeater->add_control(
            'sociallinksocialkaveh',
            [
                'label' => esc_html__( 'لینک', 'kaveh-core' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( '#', 'kaveh-core' ),
        
            ]
        );
        $this->add_control(
          'listsocialkaveh',
          [
            'label' => esc_html__( 'شبکه های اجتماعی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::REPEATER,
            'fields' => $repeater->get_controls(),
            'default' => [
              [
                'iconsocialkaveh' => esc_html__( 'icon-instagram', 'kaveh-core' ),
                'sociallinksocialkaveh' => esc_html__( '#', 'kaveh-core' ),
              ],
          ]
          ]
        
        );
        $this->add_control(
          'text_alignsocialkaveh',
          [
            'label' => esc_html__( 'چیدمان آیکون ها', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::CHOOSE,
            'condition' => [
              'styledotsocialkaveh!' =>'four',
            ],
            'options' => [
              'left' => [
                'title' => esc_html__( 'چپ چین', 'kaveh-core' ),
                'icon' => 'eicon-text-align-left',
              ],
              'center' => [
                'title' => esc_html__( 'وسط چین', 'kaveh-core' ),
                'icon' => 'eicon-text-align-center',
              ],
              'right' => [
                'title' => esc_html__( 'راست چین', 'kaveh-core' ),
                'icon' => 'eicon-text-align-right',
              ],
            ],
            'toggle' => true,
          ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
          'style_socialkaveh',
          [
            'label' => esc_html__( 'استایل', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          ]
        );
        $this->add_control(
          'iconsize1socialkaveh',
          [
            'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'condition' => [
              'styledotsocialkaveh' =>'one',
            ],
            'range' => [
              'px' => [
                'min' => 0,
                'max' => 200,
                'step' => 1,
              ],
              '%' => [
                'min' => 0,
                'max' => 100,
              ],
            ],
            'selectors' => [
              '{{WRAPPER}} .footer-two-socials li a' => 'font-size: {{SIZE}}{{UNIT}};',
            ],
          ]
        );
        $this->add_control(
          'iconcolor1socialkaveh',
          [
            'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'condition' => [
              'styledotsocialkaveh' =>'one',
            ],
            'selectors' => [
              '{{WRAPPER}} .footer-two-socials li a' => 'color: {{VALUE}}',
            ],
          ]
        );
        $this->add_control(
          'iconcolorhover1socialkaveh',
          [
            'label' => esc_html__( 'رنگ هاور آیکون', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'condition' => [
              'styledotsocialkaveh' =>'one',
            ],
            'selectors' => [
              '{{WRAPPER}} .footer-two-socials li a:hover i' => 'color: {{VALUE}}',
            ],
          ]
        );
        $this->add_control(
          'iconsize2socialkaveh',
          [
            'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'condition' => [
              'styledotsocialkaveh' =>'two',
            ],
            'range' => [
              'px' => [
                'min' => 0,
                'max' => 200,
                'step' => 1,
              ],
              '%' => [
                'min' => 0,
                'max' => 100,
              ],
            ],
            'selectors' => [
              '{{WRAPPER}} .nav-header-fourteen .socials li a' => 'font-size: {{SIZE}}{{UNIT}};',
            ],
          ]
        );
        $this->add_control(
          'iconcolor2socialkaveh',
          [
            'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'condition' => [
              'styledotsocialkaveh' =>'two',
            ],
            'selectors' => [
              '{{WRAPPER}} .nav-header-fourteen .socials li a' => 'color: {{VALUE}}',
            ],
          ]
        );
        $this->add_control(
          'iconhover2socialkaveh',
          [
            'label' => esc_html__( 'رنگ هاور آیکون', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'condition' => [
              'styledotsocialkaveh' =>'two',
            ],
            'selectors' => [
              '{{WRAPPER}} .nav-header-fourteen .socials li a:hover' => 'color: {{VALUE}}',
            ],
          ]
        );
        $this->add_control(
          'button1socialkaveh',
          [
            'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'condition' => [
              'styledotsocialkaveh' =>'two',
            ],
            'size_units' => [ 'px' ],
            'selectors' => [
              '{{WRAPPER}} .nav-header-fourteen .socials' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
          ]
        );
        $this->add_control(
          'iconbgcolor21socialkaveh',
          [
            'label' => esc_html__( 'رنگ اول پس زمینه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'condition' => [
              'styledotsocialkaveh' =>'two',
            ],
          ]
        );
        $this->add_control(
          'iconbgcolor22socialkaveh',
          [
            'label' => esc_html__( 'رنگ دوم پس زمینه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'condition' => [
              'styledotsocialkaveh' =>'two',
            ],
          ]
        );
        $this->add_control(
          'buttonradius2socialkaveh',
          [
            'label' => esc_html__( 'گوشه خمیده باکس', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'condition' => [
              'styledotsocialkaveh' =>'two',
            ],
            'size_units' => [ 'px' ],
            'selectors' => [
              '{{WRAPPER}} .nav-header-fourteen .socials' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
          ]
        );
        $this->add_control(
          'iconsize3socialkaveh',
          [
            'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'condition' => [
              'styledotsocialkaveh' =>'three',
            ],
            'range' => [
              'px' => [
                'min' => 0,
                'max' => 200,
                'step' => 1,
              ],
              '%' => [
                'min' => 0,
                'max' => 100,
              ],
            ],
            'selectors' => [
              '{{WRAPPER}} .footer-socials li a' => 'font-size: {{SIZE}}{{UNIT}};',
            ],
          ]
        );
        
        $this->start_controls_tabs(
          'style_tabs3socialkaveh'
        );
        
        $this->start_controls_tab(
          'style_normal_tab3socialkaveh',
          [
            'label' => esc_html__( 'عادی', 'kaveh-core' ),
            'condition' => [
              'styledotsocialkaveh' =>'three',
            ],
          ]
        );
        $this->add_control(
          'icon3color3socialkaveh',
          [
            'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'condition' => [
              'styledotsocialkaveh' =>'three',
            ],
            'selectors' => [
              '{{WRAPPER}} .footer-socials li a' => 'color: {{VALUE}}',
            ],
          ]
        ); 
        $this->add_control(
          'icon3bgcolor3socialkaveh',
          [
            'label' => esc_html__( 'رنگ پس زمینه آیکون', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'condition' => [
              'styledotsocialkaveh' =>'three',
            ],
            'selectors' => [
              '{{WRAPPER}} .footer-socials li a' => 'background-color: {{VALUE}}',
            ],
          ]
        ); 
        $this->end_controls_tab();
        $this->start_controls_tab(
          'style_hove_tab3socialkaveh',
          [
            'label' => esc_html__( 'هاور', 'kaveh-core' ),
            'condition' => [
              'styledotsocialkaveh' =>'three',
            ],
          ]
        );
        $this->add_control(
          'icon3buttonhovercolor3socialkaveh',
          [
            'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'condition' => [
              'styledotsocialkaveh' =>'three',
            ],
            'selectors' => [
              '{{WRAPPER}} .footer-socials li a:hover' => 'color: {{VALUE}}',
            ],
          ]
        ); 
        $this->add_control(
          'icon3bghovercolor3socialkaveh',
          [
            'label' => esc_html__( 'رنگ پس زمینه آیکون', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'condition' => [
              'styledotsocialkaveh' =>'three',
            ],
            'selectors' => [
              '{{WRAPPER}} .footer-socials li a:hover' => 'background-color: {{VALUE}}',
            ],
          ]
        ); 
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control(
          'hrsocialkaveh',
          [
            'type' => \Elementor\Controls_Manager::DIVIDER,
            'condition' => [
              'styledotsocialkaveh' =>'three',
            ],
          ]
        );
        $this->add_control(
          'width5socialkaveh',
          [
            'label' => esc_html__( 'عرض دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'condition' => [
              'styledotsocialkaveh' =>'three',
            ],
            'range' => [
              'px' => [
                'min' => 0,
                'max' => 1000,
                'step' => 1,
              ],
              '%' => [
                'min' => 0,
                'max' => 100,
              ],
            ],
            'default' => [
              'unit' => 'px',
              'size' => 40,
            ],
            'selectors' => [
              '{{WRAPPER}} .footer-socials li a' => 'width: {{SIZE}}{{UNIT}};',
            ],
          ]
        );
        $this->add_control(
          'height1socialkaveh',
          [
            'label' => esc_html__( 'ارتفاع دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'condition' => [
              'styledotsocialkaveh' =>'three',
            ],
            'range' => [
              'px' => [
                'min' => 0,
                'max' => 1000,
                'step' => 1,
              ],
              '%' => [
                'min' => 0,
                'max' => 100,
              ],
            ],
            'default' => [
              'unit' => 'px',
              'size' => 40,
            ],
            'selectors' => [
              '{{WRAPPER}} .footer-socials li a' => 'height: {{SIZE}}{{UNIT}};',
            ],
          ]
        );
        $this->add_control(
          'iconsize4socialkaveh',
          [
            'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::SLIDER,
            'size_units' => [ 'px', '%' ],
            'condition' => [
              'styledotsocialkaveh' =>'four',
            ],
            'range' => [
              'px' => [
                'min' => 0,
                'max' => 200,
                'step' => 1,
              ],
              '%' => [
                'min' => 0,
                'max' => 100,
              ],
            ],
            'selectors' => [
              '{{WRAPPER}} .contact-us .socials li a' => 'font-size: {{SIZE}}{{UNIT}};',
            ],
          ]
        );
        $this->add_control(
          'iconcolor4socialkaveh',
          [
            'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'condition' => [
              'styledotsocialkaveh' =>'four',
            ],
            'selectors' => [
              '{{WRAPPER}} .contact-us .socials li a' => 'color: {{VALUE}}',
            ],
          ]
        );
        $this->add_control(
          'iconhover4socialkaveh',
          [
            'label' => esc_html__( 'رنگ هاور آیکون', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'condition' => [
              'styledotsocialkaveh' =>'four',
            ],
            'selectors' => [
              '{{WRAPPER}} .contact-us .socials li a:hover' => 'color: {{VALUE}}',
            ],
          ]
        );
        $this->add_control(
          'button4socialkaveh',
          [
            'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'condition' => [
              'styledotsocialkaveh' =>'four',
            ],
            'size_units' => [ 'px' ],
            'selectors' => [
              '{{WRAPPER}} .contact-us .socials' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
          ]
        );
        $this->add_control(
          'buttonradius4socialkaveh',
          [
            'label' => esc_html__( 'گوشه خمیده باکس', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::DIMENSIONS,
            'condition' => [
              'styledotsocialkaveh' =>'four',
            ],
            'size_units' => [ 'px' ],
            'selectors' => [
              '{{WRAPPER}} .contact-us .socials::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
            ],
          ]
        );

        $this->end_controls_section();
          
        }
 

  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
  
?>
<?php if("two"===$settings['styledotsocialkaveh']){?>
<div class="nav-header-fourteen">
  <?php }elseif("three"===$settings['styledotsocialkaveh']){ ?>
<div class="footer-sixteen">
<?php }elseif("four"===$settings['styledotsocialkaveh']){ ?>
<div class="contact-us">
  <?php } ?>
<ul class="<?php if("one"===$settings['styledotsocialkaveh']){?>footer-two-socials d-flex align-items-center<?php }elseif("two"===$settings['styledotsocialkaveh']){?>socials d-flex<?php }elseif("three"===$settings['styledotsocialkaveh']){?>footer-socials d-flex<?php }elseif("four"===$settings['styledotsocialkaveh']){?>socials d-flex align-items-center position-relative<?php } ?> <?php if("right"===$settings['text_alignsocialkaveh']){?>justify-content-start<?php }elseif("center"===$settings['text_alignsocialkaveh']){?>justify-content-center<?php }elseif("left"===$settings['text_alignsocialkaveh']){?>justify-content-end<?php } ?>">
          <?php
                if ( $settings['listsocialkaveh'] ) {
                foreach (  $settings['listsocialkaveh'] as $item ) {
                ?>
          <li>
            <a href="<?php echo  esc_url($item['sociallinksocialkaveh']); ?>">
              <i class="<?php echo  esc_html($item['iconsocialkaveh']['value']); ?>"></i>
            </a>
          </li>
          <?php
                }
              }
          ?>
        </ul>
        <?php if("two"===$settings['styledotsocialkaveh']){?>
        </div>
        <style>
          <?php echo '.elementor-element-' . $clsid . ''; ?> .nav-header-fourteen .socials {
          background-image: -webkit-linear-gradient(top, <?php echo  esc_html($settings['iconbgcolor21socialkaveh']); ?>, <?php echo  esc_html($settings['iconbgcolor22socialkaveh']); ?>);
          background-image: -moz-linear-gradient(top, <?php echo  esc_html($settings['iconbgcolor21socialkaveh']); ?>, <?php echo  esc_html($settings['iconbgcolor22socialkaveh']); ?>);
          background-image: -o-linear-gradient(top, <?php echo  esc_html($settings['iconbgcolor21socialkaveh']); ?>, <?php echo  esc_html($settings['iconbgcolor22socialkaveh']); ?>);
          background-image: linear-gradient(to bottom, <?php echo  esc_html($settings['iconbgcolor21socialkaveh']); ?>, <?php echo  esc_html($settings['iconbgcolor22socialkaveh']); ?>);
          }
        </style>
        <?php }elseif("three"===$settings['styledotsocialkaveh']){ ?>
        </div>
        <?php }elseif("four"===$settings['styledotsocialkaveh']){ ?>
        </div>
  <?php } ?>
  <style>
    .contact-us .socials {
    margin: 0;
}
  </style>
    <?php
  }


}
