<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Slidertwelvethkaveh extends Widget_Base{

  public function get_name(){
    return 'slidertwelvethkaveh';
  }

  public function get_title(){
    return esc_html__( 'اسلایدر سبک دوازده', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentslidertwelvethkaveh',
        [
          'label' => esc_html__( 'Content', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      ); 
      $repeater = new \Elementor\Repeater();

      $repeater->add_control(
        'backslidertwelvethkaveh',
        [
          'label' => esc_html__( 'تصویر خود را انتخاب کنید', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
          ],
        ]
      );
      $repeater->add_control(
        'linkslidertwelvethkaveh',
        [
            'label' => esc_html__( 'لینک اسلاید', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( '#', 'kaveh-core' ),
    
        ]
    );
      $this->add_control(
        'slidesslidertwelvethkaveh',
        [
          'label' => esc_html__( 'اسلاید ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::REPEATER,
          'fields' => $repeater->get_controls(),
          ],
      );
      $this->add_control(
        'bulletsslidertwelvethkaveh',
        [
          'label' => esc_html__( 'نمایش پیمایشگر؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
      $this->end_controls_section();

      $this->start_controls_section(
        'style1_slidertwelvethkaveh',
        [
          'label' => esc_html__( 'استایل اسلایدر', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'heightbgslidertwelvethkaveh',
        [
          'label' => esc_html__( 'ارتفاع اسلایدر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 100,
              'max' => 2000,
              'step' => 5,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .swiper-carousel-home img' => 'max-height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'buttonradiusslidertwelvethkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده اسلایدر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .carousel-home img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
       $this->end_controls_section();

          
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <section class="carousel-home">
      <div class="container">
        <!-- Start Carousel -->
        <div class="swiper swiper-carousel-home position-relative overflow-hidden">
          <div class="swiper-wrapper">
          <?php
              if ( $settings['slidesslidertwelvethkaveh'] ) {
              foreach (  $settings['slidesslidertwelvethkaveh'] as $item ) {
              ?>
            <!-- Start Slide -->
            <div class="swiper-slide">
              <a href="<?php echo  esc_url($item['linkslidertwelvethkaveh']); ?>" class="d-block">
                <img src="<?php echo esc_url($item['backslidertwelvethkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['backslidertwelvethkaveh'] )); ?>" width="1160" height="475"
                  class="d-block w-100">
              </a>
            </div>
            <!-- End Slide -->
            <?php
                }
              }
                ?>
          </div>
          <?php if("yes"===$settings['bulletsslidertwelvethkaveh']){?>
          <!-- Start Pagination -->
          <div class="swiper-bottom position-absolute d-flex align-items-center start-50 translate-middle-x">
            <i class="icon-play"></i>
            <div class="swiper-pagination position-relative top-0 start-0 bottom-0 end-0"></div>
          </div>
          <?php } ?>
          <!-- End Pagination -->
        </div>
        <!-- End Carousel -->
      </div>
    </section>
    <?php if( \Elementor\Plugin::$instance->editor->is_edit_mode() ): ?>
    <script>      
     function init<?php echo $clsid; ?>() {
      // Swiper Carousel Home
      const carouselHome = document.querySelector(".swiper-carousel-home");
        if (carouselHome) {
          let timeSwiper = 0,
            timearSwiper;

          const iconPlayPause = carouselHome.querySelector(".swiper-bottom i");

          const swiperCarouselHome = new Swiper(".swiper-carousel-home", {
            slidesPerView: 1,
            spaceBetween: 0,
            effect: "fade",
            fadeEffect: {
              crossFade: true,
            },
            loop: true,
            pagination: {
              el: ".swiper-pagination",
              type: "bullets",
              clickable: true,
            },
            on: {
              init: () => {
                document.documentElement.style.setProperty(
                  "--time-carousel-home",
                  "5000ms"
                );
              },

              slideChange: () => {
                timeSwiper = 0;
              },
            },
          });

          const itemsPaginations = carouselHome.querySelectorAll(
            ".swiper-pagination-bullet"
          );

          const startCarouselHome = () => {
            timearSwiper = setInterval(() => {
              timeSwiper += 500;

              if (timeSwiper >= 5000) {
                timeSwiper = 0;
                swiperCarouselHome.slideNext(300);
              }
            }, 1 * 500);
          };

          startCarouselHome();

          carouselHome.addEventListener("mouseover", () => {
            [...itemsPaginations].map((item) => {
              item.classList.add("stoped");
            });

            clearInterval(timearSwiper);

            iconPlayPause.classList.remove("icon-play");
            iconPlayPause.classList.add("icon-pause");
          });

          carouselHome.addEventListener("mouseleave", () => {
            [...itemsPaginations].map((item) => {
              item.classList.remove("stoped");
            });

            startCarouselHome();

            iconPlayPause.classList.remove("icon-pause");
            iconPlayPause.classList.add("icon-play");
          });
        }
      }
      if (window.Swiper) {
        // Swiper library already loaded, initialize Swiper instance
        init<?php echo $clsid; ?>();
      } else {
        // Swiper library not yet loaded, wait for it to load
        window.addEventListener("load", function() {
          init<?php echo $clsid; ?>();
        });
      }

    </script>
    <?php endif; ?>
    <?php
  }


}
