<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Slidertthirteenkaveh extends Widget_Base{

  public function get_name(){
    return 'slidertthirteenkaveh';
  }

  public function get_title(){
    return esc_html__( 'اسلایدر سبک سیزده', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentslidertthirteenkaveh',
        [
          'label' => esc_html__( 'محتوای اسلایدر', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );

      $repeater = new \Elementor\Repeater();

      $repeater->add_control(
        'backslidertthirteenkaveh',
        [
          'label' => esc_html__( 'تصویر خود را انتخاب کنید', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
          ],
        ]
      );
      $repeater->add_control(
        'linkslidertthirteenkaveh',
        [
            'label' => esc_html__( 'لینک اسلاید', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( '#', 'kaveh-core' ),
    
        ]
    );
      $this->add_control(
        'slidesslidertthirteenkaveh',
        [
          'label' => esc_html__( 'اسلاید ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::REPEATER,
          'fields' => $repeater->get_controls(),
          ],
      );
      $this->add_control(
        'arrowsslidertthirteenkaveh',
        [
          'label' => esc_html__( 'نمایش فلش ها؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
      $this->add_control(
        'bulletsslidertthirteenkaveh',
        [
          'label' => esc_html__( 'نمایش نقطه ها؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
      $this->end_controls_section();

      $this->start_controls_section(
        'style1_slidertthirteenkaveh',
        [
          'label' => esc_html__( 'استایل اسلایدر', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'heightbgslidertthirteenkaveh',
        [
          'label' => esc_html__( 'ارتفاع اسلایدر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 2000,
              'step' => 5,
            ],
            'devices' => [ 'desktop', 'tablet', 'mobile' ],
          ],
          'selectors' => [
            '{{WRAPPER}} .carousel-gifts img' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );

      $this->add_control(
        'borderradiusslidertthirteenkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده اسلایدر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .carousel-gifts img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'arrowcolorslidertthirteenkavehh',
        [
          'label' => esc_html__( 'رنگ فلش ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'arrowsslidertthirteenkaveh' => 'yes',
        ],
          'selectors' => [
            '{{WRAPPER}} .carousel-gifts .swiper-button-next::after' => 'color: {{VALUE}}',
            '{{WRAPPER}} .carousel-gifts .swiper-button-prev::after' => 'color: {{VALUE}}',

          ],
        ]
      );
      $this->add_control(
        'bgdotscolorslidertthirteenkavehh',
        [
          'label' => esc_html__( 'رنگ پس زمینه نقطه ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'bulletsslidertthirteenkaveh' => 'yes',
        ],
          'selectors' => [
            '{{WRAPPER}} .carousel-gifts .swiper-pagination::before' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'dotscolorslidertthirteenkavehh',
        [
          'label' => esc_html__( 'رنگ نقطه ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'bulletsslidertthirteenkaveh' => 'yes',
        ],
          'selectors' => [
            '{{WRAPPER}} .carousel-gifts .swiper-pagination-bullet' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'borderdotscolorslidertthirteenkavehh',
        [
          'label' => esc_html__( 'رنگ حاشیه پس زمینه نقطه ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'bulletsslidertthirteenkaveh' => 'yes',
        ],
          'selectors' => [
            '{{WRAPPER}} .carousel-gifts .swiper-pagination::before' => 'border: 1px solid {{VALUE}}',
          ],
        ]
      );
       $this->end_controls_section();

          
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <section class="carousel-gifts">
      <div class="container">
        <div class="carousel-gifts-wrapper position-relative">
          <!-- Start Carousel -->
          <div class="swiper swiper-carousel-gifts overflow-hidden position-relative">
            <div class="swiper-wrapper">
              <?php
              if ( $settings['slidesslidertthirteenkaveh'] ) {
              foreach (  $settings['slidesslidertthirteenkaveh'] as $item ) {
              ?>
              <!-- Start Slide -->
              <div class="swiper-slide">
                <a href="<?php echo  esc_url($item['linkslidertthirteenkaveh']); ?>" class="d-block">
                  <img src="<?php echo esc_url($item['backslidertthirteenkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['backslidertthirteenkaveh'] )); ?>" width="1385" height="574"
                    class="w-100 d-block">
                </a>
              </div>
              <!-- End Slide -->
              <?php
                }
              }
                ?>
              
            </div>
            <!-- Start Button & Pagination -->
            <div
              class="swiper-bottom d-flex align-items-center justify-content-center position-absolute w-100 start-50 translate-middle-x">
              <?php if("yes"===$settings['arrowsslidertthirteenkaveh']){?>
              <div class="swiper-button-prev position-relative w-auto h-auto top-0 start-0 bottom-0 end-0 m-0"></div>
              <?php }
               if("yes"===$settings['bulletsslidertthirteenkaveh']){?>
              <div class="swiper-pagination position-relative w-auto h-auto top-0 start-0 bottom-0 end-0 m-0 mx-3">
              </div>
              <?php } 
               if("yes"===$settings['arrowsslidertthirteenkaveh']){?>
              <div class="swiper-button-next position-relative w-auto h-auto top-0 start-0 bottom-0 end-0 m-0"></div>
              <?php } ?>

            </div>
            <!-- End Button & Pagination -->
          </div>
          <!-- End Carousel -->
        </div>
      </div>
    </section>
<style>
  .carousel-gifts img {
    object-fit: cover !important;
}
</style>
    <script>
       function init<?php echo $clsid; ?>() {
// Carousel Gifts
new Swiper(".swiper-carousel-gifts", {
  slidesPerView: 1,
  spaceBetween: 0,
  pagination: {
    el: ".swiper-pagination",
    type: "bullets",
    clickable: true,
  },
  autoplay: {
    delay: 3000,
  },
  effect: "fade",
  fadeEffect: {
    crossFade: true,
  },
  loop: true,
  navigation: {
    nextEl: ".swiper-button-next",
    prevEl: ".swiper-button-prev",
  },
});
}
      if (window.Swiper) {
    // Swiper library already loaded, initialize Swiper instance
    init<?php echo $clsid; ?>();
  } else {
    // Swiper library not yet loaded, wait for it to load
    window.addEventListener("load", function() {
      init<?php echo $clsid; ?>();
    });
  }
  
    </script>

    <?php
  }


}
