<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Sliderthirdkaveh extends Widget_Base{

  public function get_name(){
    return 'sliderthirdkaveh';
  }

  public function get_title(){
    return esc_html__( 'اسلایدر سبک سه', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentsliderthirdkaveh',
        [
          'label' => esc_html__( 'محتوا', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      ); 
      $repeater = new \Elementor\Repeater();
      $repeater->add_control(
        'img1sliderthirdkaveh',
        [
          'label' => esc_html__( 'تصویر بالای عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,            
        ]
      );
      $repeater->add_control(
        'linkimg1lidersecondkaveh',
        [
            'label' => esc_html__( ' لینک تصویر بالای عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( '#', 'kaveh-core' ),
    
        ]
    );
      $repeater->add_control(
        'titlelidersecondkaveh',
        [
            'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'به روز ترین', 'kaveh-core' ),
    
        ]
    ); 
    $repeater->add_control(
      'title2lidersecondkaveh',
      [
          'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'محصولات ما', 'kaveh-core' ),
  
      ]
  );
  $repeater->add_control(
    'tagheading1sliderthirdkaveh',
    [
      'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'H2',
      'options' => [
        'H1'  => esc_html__( 'H1', 'kaveh-core' ),
        'H2' => esc_html__( 'H2', 'kaveh-core' ),
        'H3' => esc_html__( 'H3', 'kaveh-core' ),
        'H4' => esc_html__( 'H4', 'kaveh-core' ),
        'H5' => esc_html__( 'H5', 'kaveh-core' ),
        'H6' => esc_html__( 'H6', 'kaveh-core' ),
        'p' => esc_html__( 'p', 'kaveh-core' ),
        'div' => esc_html__( 'div', 'kaveh-core' ),
        'span' => esc_html__( 'span', 'kaveh-core' ),
      ],
    ]
  );   
      $repeater->add_control(
        'buttonsliderthirdkaveh',
        [
            'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'بیشتر', 'kaveh-core' ),
    
        ]
    );
    $repeater->add_control(
      'iconbuttsliderthirdkaveh',
      [
        'label' => esc_html__( 'آیکون', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'exclude_inline_options' => [ 'svg' ],
        'default' => [
          'value' => 'isax isax-arrow-left4',
        ],
      ]
    );
    $repeater->add_control(
      'linkbuttonsliderthirdkaveh',
      [
          'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( '#', 'kaveh-core' ),
  
      ]
  );
  $repeater->add_control(
    'backsliderthirdkaveh',
    [
      'label' => esc_html__( 'تصویر خود را انتخاب کنید', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::MEDIA,
    ]
  );
  $repeater->add_control(
    'backjsliderthirdkaveh',
    [
      'label' => esc_html__( 'تصویر پس زمینه', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::MEDIA,            
    ]
  );
      $this->add_control(
        'slidessliderthirdkaveh',
        [
          'label' => esc_html__( 'اسلاید ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::REPEATER,
          'default' => [
            [
              'linkimg1lidersecondkaveh' => esc_html__( '#', 'kaveh-core' ),
              'titlelidersecondkaveh' => esc_html__( 'به روز ترین', 'kaveh-core' ),
              'title2lidersecondkaveh' => esc_html__( 'محصولات ما', 'kaveh-core' ),
              'buttonsliderthirdkaveh' => esc_html__( 'بیشتر', 'kaveh-core' ),
              'linkbuttonsliderthirdkaveh' => esc_html__( '#', 'kaveh-core' ),
            ],
          ],
          'fields' => $repeater->get_controls()
          ],
      );
 
       $this->end_controls_section();
       $this->start_controls_section(
        'style1_sliderthirdkaveh',
        [
          'label' => esc_html__( 'استایل عنوان', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
       );
       $this->add_control(
        'titlestsliderthirdkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .landing-seven .swiper-slide .container .content .title .slider3h span' => 'color: {{VALUE}}',
          ],
        ]
       );
       $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title_sliderthirdkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان فرعی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .landing-seven .swiper-slide .container .content .title .slider3h span',
        ]
       );
       $this->add_control(
        'titlepstsliderthirdkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان اصلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .landing-seven .swiper-slide .container .content .title .slider3h' => 'color: {{VALUE}}',
          ],
        ]
       );
       $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'p_sliderthirdkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان اصلی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .landing-seven .swiper-slide .container .content .title .slider3h',
        ]
       );
       $this->end_controls_section();
       $this->start_controls_section(
        'style2_sliderthirdkaveh',
        [
          'label' => esc_html__( 'استایل دکمه', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
       );
       $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'button_sliderthirdkaveh',
          'label' => esc_html__( 'تایپوگرافی متن دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .landing-seven .swiper-slide .container .content .link a',
        ]
      );
      $this->add_control(
        'iconsizesliderthirdkaveh',
        [
          'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 200,
              'step' => 5,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .landing-seven .swiper-slide .container .content .link a i' => 'font-size: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Text_Shadow::get_type(),
        [
          'name' => 'text_shadowsliderthirdkaveh',
          'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .landing-seven .swiper-slide .container .content .link a',
        ]
      );
      $this->start_controls_tabs(
        'style_tabssliderthirdkaveh'
      );
      
      $this->start_controls_tab(
        'style_normal_tabsliderthirdkaveh',
        [
          'label' => esc_html__( 'عادی', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorsliderthirdkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .landing-seven .swiper-slide .container .content .link a' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'iconcolorsliderthirdkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .landing-seven .swiper-slide .container .content .link a i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorsliderthirdkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .landing-seven .swiper-slide .container .content .link a' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiussliderthirdkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .landing-seven .swiper-slide .container .content .link a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'bordersliderthirdkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .landing-seven .swiper-slide .container .content .link a',
        ]
      );
      $this->add_control(
        'buttonborderssliderthirdkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'bordersliderthirdkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .landing-seven .swiper-slide .container .content .link a' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->start_controls_tab(
        'style_hove_tabsliderthirdkaveh',
        [
          'label' => esc_html__( 'هاور', 'kaveh-core' ),
        ]
      );
      $this->add_control(
        'textbuttoncolorhoversliderthirdkaveh',
        [
          'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .landing-seven .swiper-slide .container .content .link a:hover' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'iconcolorhoversliderthirdkaveh',
        [
          'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .landing-seven .swiper-slide .container .content .link a:hover i' => 'color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttoncolorhoversliderthirdkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .landing-seven .swiper-slide .container .content .link a:hover' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'buttonradiushoversliderthirdkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .landing-seven .swiper-slide .container .content .link a:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
      $this->add_group_control(
        \Elementor\Group_Control_Border::get_type(),
        [
          'name' => 'borderhoversliderthirdkaveh',
          'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .landing-seven .swiper-slide .container .content .link a:hover',
        ]
      );
      $this->add_control(
        'buttonbordershoversliderthirdkaveh',
        [
          'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'condition' => [
            'borderhoversliderthirdkaveh!' => '',
          ],
          'selectors' => [
            '{{WRAPPER}} .landing-seven .swiper-slide .container .content .link a:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
          ],
        ]
      );
      $this->end_controls_tab();
      $this->end_controls_tabs();
      $this->add_group_control(
        \Elementor\Group_Control_Box_Shadow::get_type(),
        [
          'name' => 'box_shadowsliderthirdkavehh',
          'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .landing-seven .swiper-slide .container .content .link a',
        ]
      );
      $this->add_control(
        'hr1sliderthirdkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
      $this->add_control(
        'buttonpaddingsliderthirdkaveh',
        [
          'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .landing-seven .swiper-slide .container .content .link a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
       $this->end_controls_section();
       $this->start_controls_section(
        'style3_sliderthirdkaveh',
        [
          'label' => esc_html__( 'استایل تصاویر', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
       );
       $this->add_control(
        'widthupsliderthirdkaveh',
        [
          'label' => esc_html__( ' سایز تصویر بالای عنوان', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 2000,
              'step' => 5,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .landing-seven .swiper-slide .container .content .brand img' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'widthmainsliderthirdkaveh',
        [
          'label' => esc_html__( 'سایز تصویر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px', '%' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 2000,
              'step' => 5,
            ],
            '%' => [
              'min' => 0,
              'max' => 100,
            ],
          ],
          'selectors' => [
            '{{WRAPPER}} .landing-seven .swiper-slide .container > img' => 'width: {{SIZE}}{{UNIT}};',
          ],
        ]
      );

       $this->end_controls_section();
       $this->start_controls_section(
        'style4_sliderthirdkaveh',
        [
          'label' => esc_html__( 'استایل عمومی', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
       );
       $this->add_control(
        'bgmaincolorsliderthirdkaveh',
        [
          'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .landing-seven .swiper-slide' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'arrowcolorsliderthirdkaveh',
        [
          'label' => esc_html__( 'رنگ فلش ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .landing-seven .swiper-button-next' => 'border: 2px solid {{VALUE}}',
            '{{WRAPPER}} .landing-seven .swiper-button-prev' => 'border: 2px solid {{VALUE}}',
            '{{WRAPPER}} .landing-seven .swiper-button-next::after' => 'color:{{VALUE}}',
            '{{WRAPPER}} .landing-seven .swiper-button-prev::after' => 'color:{{VALUE}}',
          ],
        ]
      ); 
       $this->end_controls_section();

        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
<section class="landing-seven position-relative">
      <div class="swiper swiper-landing-tow" data-swiper='{"slidesPerView":1,"spaceBetween":0,"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"autoplay":{"delay":5000},"effect":"fade","fadeEffect":{"crossFade":true},"loop":true}'>
        <div class="swiper-wrapper">
        <?php
            if ( $settings['slidessliderthirdkaveh'] ) {
            foreach (  $settings['slidessliderthirdkaveh'] as $item ) {
            ?>
          <div class="swiper-slide" style="background-image: url('<?php echo esc_url($item['backjsliderthirdkaveh']['url']); ?>');">
            <div class="container position-relative d-flex align-items-center flex-column flex-lg-row">
              <img src="<?php echo esc_url($item['backsliderthirdkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['backsliderthirdkaveh'] )); ?>" />
              <div class="content">
                <a href="<?php echo  esc_url($item['linkimg1lidersecondkaveh']); ?>" class="brand d-block overflow-hidden">
                  <img src="<?php echo esc_url($item['img1sliderthirdkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['img1sliderthirdkaveh'] )); ?>" />
                </a>
                <div class="title overflow-hidden">
                  <<?php echo  esc_html($item['tagheading1sliderthirdkaveh']); ?> class="slider3h">
                    <span class="fw-light d-block"> <?php echo  esc_html($item['titlelidersecondkaveh']); ?> </span>
                    <?php echo  esc_html($item['title2lidersecondkaveh']); ?>
                  </<?php echo  esc_html($item['tagheading1sliderthirdkaveh']); ?>>
                </div>
                <div class="link overflow-hidden">
                  <a href="<?php echo  esc_url($item['linkbuttonsliderthirdkaveh']); ?>" class="d-inline-block">
                  <?php echo  esc_html($item['buttonsliderthirdkaveh']); ?>
                    <i class="<?php echo  esc_attr($item['iconbuttsliderthirdkaveh']['value']); ?>"></i>
                  </a>
                </div>
              </div>
            </div>
          </div>
          <?php
          }
        }
          ?>
        </div>
        <div class="swiper-button-next"></div>
        <div class="swiper-button-prev"></div>
      </div>
    </section>
    <?php do_action('kelementor_inline_scripts'); ?>

    <?php
  }


}
