<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Slidersixthkaveh extends Widget_Base{

  public function get_name(){
    return 'slidersixthkaveh';
  }

  public function get_title(){
    return esc_html__( 'اسلایدر سبک شش', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentslidersixthkaveh',
        [
          'label' => esc_html__( 'محتوای المان', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      ); 
      $repeater = new \Elementor\Repeater();
      $repeater->add_control(
        'titleslidersixthkaveh',
        [
            'label' => esc_html__( 'عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'کیس های گیمینگ', 'kaveh-core' ),
    
        ]
    );
    $repeater->add_control(
      'title2slidersixthkaveh',
      [
          'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'سامسونگ', 'kaveh-core' ),
  
      ]
  );
  $repeater->add_control(
    'tagheadingslidersixthkaveh',
    [
      'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'H3',
      'options' => [
        'H1'  => esc_html__( 'H1', 'kaveh-core' ),
        'H2' => esc_html__( 'H2', 'kaveh-core' ),
        'H3' => esc_html__( 'H3', 'kaveh-core' ),
        'H4' => esc_html__( 'H4', 'kaveh-core' ),
        'H5' => esc_html__( 'H5', 'kaveh-core' ),
        'H6' => esc_html__( 'H6', 'kaveh-core' ),
        'p' => esc_html__( 'p', 'kaveh-core' ),
        'div' => esc_html__( 'div', 'kaveh-core' ),
        'span' => esc_html__( 'span', 'kaveh-core' ),
      ],
    ]
  );
      $repeater->add_control(
        'buttonslidersixthkaveh',
        [
            'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'محصولات', 'kaveh-core' ),
    
        ]
    );
    $repeater->add_control(
      'iconbuttslidersixthkaveh',
      [
        'label' => esc_html__( 'آیکون', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'exclude_inline_options' => [ 'svg' ],
        'default' => [
          'value' => 'isax isax-arrow-left4',
        ],
      ]
    );
    $repeater->add_control(
      'linkbuttonslidersixthkaveh',
      [
          'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( '#', 'kaveh-core' ),
  
      ]
  );
  $repeater->add_control(
    'backslidersixthkaveh',
    [
      'label' => esc_html__( 'تصویر خود را انتخاب کنید', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::MEDIA,
    ]
  );
      $this->add_control(
        'slidesslidersixthkaveh',
        [
          'label' => esc_html__( 'اسلاید ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::REPEATER,
          'default' => [
            [
              'titleslidersixthkaveh' => esc_html__( 'کیس های گیمینگ', 'kaveh-core' ),
              'title2slidersixthkaveh' => esc_html__( 'سامسونگ', 'kaveh-core' ),
              'buttonslidersixthkaveh' => esc_html__( 'محصولات', 'kaveh-core' ),
              'linkbuttonslidersixthkaveh' => esc_html__( '#', 'kaveh-core' ),
            ],
          ],
          'fields' => $repeater->get_controls()
          ],
      );
      $this->add_control(
        'backjslidersixthkaveh',
        [
          'label' => esc_html__( 'تصویر پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,    
          'selectors' => [
            '{{WRAPPER}} .landing-thirteen ' => 'background: url({{URL}}) 0 0 no-repeat',
        ],        
        ]
      );
      
       $this->end_controls_section();
       $this->start_controls_section(
        'style1_slidersixthkaveh',
        [
          'label' => esc_html__( 'استایل عنوان', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
       );
       $this->add_control(
        'titlestslidersixthkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .landing-thirteen-item .detail .title .slidd6st' => 'color: {{VALUE}}',
          ],
        ]
       );
       $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title_slidersixthkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان فرعی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .landing-thirteen-item .detail .title .slidd6st',
        ]
       );
       $this->add_control(
        'titlepstslidersixthkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان اصلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .landing-thirteen-item .detail .title .slidd6st b' => 'color: {{VALUE}}',
          ],
        ]
       );
       $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'p_slidersixthkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان اصلی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .landing-thirteen-item .detail .title .slidd6st b',
        ]
       );
       $this->end_controls_section();
       
       
       
       
       
       $this->start_controls_section(
         'style2_slidersixthkaveh',
         [
           'label' => esc_html__( 'استایل دکمه', 'kaveh-core' ),
           'tab' => \Elementor\Controls_Manager::TAB_STYLE, 
         ]
        );
        $this->add_group_control(
         \Elementor\Group_Control_Typography::get_type(),
         [
           'name' => 'button_slidersixthkaveh',
           'label' => esc_html__( 'تایپوگرافی متن دکمه', 'kaveh-core' ),
           'selector' => '{{WRAPPER}} .landing-thirteen-item .detail .btn',
         ]
       );
       $this->add_control(
         'iconsizeslidersixthkaveh',
         [
           'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::SLIDER,
           'size_units' => [ 'px', '%' ],
           'range' => [
             'px' => [
               'min' => 0,
               'max' => 200,
               'step' => 5,
             ],
             '%' => [
               'min' => 0,
               'max' => 100,
             ],
           ],
           'selectors' => [
             '{{WRAPPER}} .landing-thirteen-item .detail .btn i' => 'font-size: {{SIZE}}{{UNIT}};',
           ],
         ]
       );
       $this->add_group_control(
         \Elementor\Group_Control_Text_Shadow::get_type(),
         [
           'name' => 'text_shadowslidersixthkaveh',
           'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
           'selector' => '{{WRAPPER}} .landing-thirteen-item .detail .btn',
         ]
       );
       $this->start_controls_tabs(
         'style_tabsslidersixthkaveh'
       );
       
       $this->start_controls_tab(
         'style_normal_tabslidersixthkaveh',
         [
           'label' => esc_html__( 'عادی', 'kaveh-core' ),
         ]
       );
       $this->add_control(
         'textbuttoncolorslidersixthkaveh',
         [
           'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
             '{{WRAPPER}} .landing-thirteen-item .detail .btn' => 'color: {{VALUE}}',
           ],
         ]
       ); 
       $this->add_control(
         'iconcolorslidersixthkaveh',
         [
           'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
             '{{WRAPPER}} .landing-thirteen-item .detail .btn i' => 'color: {{VALUE}}',
           ],
         ]
       ); 
       $this->add_control(
         'buttoncolorslidersixthkaveh',
         [
           'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
             '{{WRAPPER}} .landing-thirteen-item .detail .btn' => 'background-color: {{VALUE}}',
           ],
         ]
       ); 
       $this->add_control(
         'buttonradiusslidersixthkaveh',
         [
           'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::DIMENSIONS,
           'size_units' => [ 'px' ],
           'selectors' => [
             '{{WRAPPER}} .landing-thirteen-item .detail .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
           ],
         ]
       );
       $this->add_group_control(
         \Elementor\Group_Control_Border::get_type(),
         [
           'name' => 'borderslidersixthkaveh',
           'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
           'selector' => '{{WRAPPER}} .landing-thirteen-item .detail .btn',
         ]
       );
       $this->add_control(
         'buttonbordersslidersixthkaveh',
         [
           'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::DIMENSIONS,
           'size_units' => [ 'px' ],
           'condition' => [
             'borderslidersixthkaveh!' => '',
           ],
           'selectors' => [
             '{{WRAPPER}} .landing-thirteen-item .detail .btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
           ],
         ]
       );
       $this->end_controls_tab();
       $this->start_controls_tab(
         'style_hove_tabslidersixthkaveh',
         [
           'label' => esc_html__( 'هاور', 'kaveh-core' ),
         ]
       );
       $this->add_control(
         'textbuttoncolorhoverslidersixthkaveh',
         [
           'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
             '{{WRAPPER}} .landing-thirteen-item .detail .btn:hover' => 'color: {{VALUE}}',
           ],
         ]
       ); 
       $this->add_control(
         'iconcolorhoverslidersixthkaveh',
         [
           'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
             '{{WRAPPER}} .landing-thirteen-item .detail .btn:hover i' => 'color: {{VALUE}}',
           ],
         ]
       ); 
       $this->add_control(
         'buttoncolorhoverslidersixthkaveh',
         [
           'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
             '{{WRAPPER}} .landing-thirteen-item .detail .btn:hover' => 'background-color: {{VALUE}}',
           ],
         ]
       ); 
       $this->add_control(
         'buttonradiushoverslidersixthkaveh',
         [
           'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::DIMENSIONS,
           'size_units' => [ 'px' ],
           'selectors' => [
             '{{WRAPPER}} .landing-thirteen-item .detail .btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
           ],
         ]
       );
       $this->add_group_control(
         \Elementor\Group_Control_Border::get_type(),
         [
           'name' => 'borderhoverslidersixthkaveh',
           'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
           'selector' => '{{WRAPPER}} .landing-thirteen-item .detail .btn:hover',
         ]
       );
       $this->add_control(
         'buttonbordershoverslidersixthkaveh',
         [
           'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::DIMENSIONS,
           'size_units' => [ 'px' ],
           'condition' => [
             'borderhoverslidersixthkaveh!' => '',
           ],
           'selectors' => [
             '{{WRAPPER}} .landing-thirteen-item .detail .btn:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
           ],
         ]
       );
       $this->end_controls_tab();
       $this->end_controls_tabs();
       $this->add_control(
        'hr1slidersixthkaveh',
        [
          'type' => \Elementor\Controls_Manager::DIVIDER,
        ]
      );
       $this->add_group_control(
         \Elementor\Group_Control_Box_Shadow::get_type(),
         [
           'name' => 'box_shadowslidersixthkavehh',
           'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
           'selector' => '{{WRAPPER}} .landing-thirteen-item .detail .btn',
         ]
       );
       $this->add_control(
         'buttonpaddingslidersixthkaveh',
         [
           'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::DIMENSIONS,
           'size_units' => [ 'px' ],
           'selectors' => [
             '{{WRAPPER}} .landing-thirteen-item .detail .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
           ],
         ]
       );
        $this->end_controls_section();
       
       
       
        $this->start_controls_section(
         'style3_slidersixthkaveh',
         [
           'label' => esc_html__( 'استایل تصاویر', 'kaveh-core' ),
           'tab' => \Elementor\Controls_Manager::TAB_STYLE, 
         ]
        );
       $this->add_control(
         'widthmainslidersixthkaveh',
         [
           'label' => esc_html__( 'سایز تصویر', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::SLIDER,
           'size_units' => [ 'px', '%' ],
           'range' => [
             'px' => [
               'min' => 0,
               'max' => 2000,
               'step' => 5,
             ],
             '%' => [
               'min' => 0,
               'max' => 100,
             ],
           ],
           'default' => [
             'unit' => 'px',
             'size' => 605,
           ],
           'selectors' => [
             '{{WRAPPER}} .landing-thirteen-item .image img' => 'width: {{SIZE}}{{UNIT}};',
           ],
         ]
       );
        $this->end_controls_section();
        $this->start_controls_section(
         'style4_slidersixthkaveh',
         [
           'label' => esc_html__( 'استایل عمومی', 'kaveh-core' ),
           'tab' => \Elementor\Controls_Manager::TAB_STYLE,
         ]
        );
        $this->add_control(
         'bgmaincolorslidersixthkaveh',
         [
           'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
             '{{WRAPPER}} .landing-thirteen' => 'background-color: {{VALUE}}',
           ],
         ]
       ); 
       $this->add_control(
         'arrowbgcolorslidersixthkaveh',
         [
           'label' => esc_html__( 'رنگ پس زمینه فلش ها', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
            '{{WRAPPER}} .landing-thirteen::before' => 'background-color: {{VALUE}}',
            '{{WRAPPER}} .landing-thirteen::after' => 'background-color: {{VALUE}}',


          ],
         ]
       ); 
       $this->add_control(
         'arrowscolor2slidersixthkaveh',
         [
           'label' => esc_html__( 'رنگ فلش ها', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
            '{{WRAPPER}} .landing-thirteen .swiper-button-next::after' => 'color: {{VALUE}}',
            '{{WRAPPER}} .landing-thirteen .swiper-button-prev::after' => 'color: {{VALUE}}',

          ],
         ]
       ); 
       
       $this->add_control(
         'arrowsbordercolor2slidersixthkaveh',
         [
           'label' => esc_html__( 'رنگ حاشیه فلش ها', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
            '{{WRAPPER}} .landing-thirteen .swiper-button-next' => 'border: 2px slid {{VALUE}}',
            '{{WRAPPER}} .landing-thirteen .swiper-button-prev' => 'border: 2px slid {{VALUE}}',

          ],
         ]
       ); 
       
       $this->add_control(
         'dotscolor2slidersixthkaveh',
         [
           'label' => esc_html__( 'رنگ نقطه ها', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
             '{{WRAPPER}} .landing-thirteen .swiper-pagination-bullet' => 'background-color: {{VALUE}}',
           ],
         ]
       ); 
       $this->add_control(
         'dotsbordercolor2slidersixthkaveh',
         [
           'label' => esc_html__( 'رنگ حاشیه نقطه ها', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
            '{{WRAPPER}} .landing-thirteen .swiper-pagination' => 'border: 2px solid {{VALUE}}',
          ],
         ]
       ); 
       
       $this->add_control(
         'heightmainslidersixthkaveh',
         [
           'label' => esc_html__( 'ارتفاع اسلایدر', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::SLIDER,
           'size_units' => [ 'px', '%' ],
           'range' => [
             'px' => [
               'min' => 0,
               'max' => 2000,
               'step' => 5,
             ],
             '%' => [
               'min' => 0,
               'max' => 100,
             ],
           ],
           'selectors' => [
             '{{WRAPPER}} .landing-thirteen' => 'height: {{SIZE}}{{UNIT}};',
           ],
         ]
       );
        $this->end_controls_section();
          
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
<section class="landing-thirteen position-relative">
      <div class="container">
        <!-- Start Carousel -->
        <div class="swiper swiper-landing" data-swiper='{"slidesPerView":1,"spaceBetween":0,"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"pagination":{"el":".swiper-pagination","type":"bullets","clickable":true},"autoplay":{"delay":5000,"disableOnInteraction":false,"pauseOnMouseEnter":true},"effect":"fade","fadeEffect":{"crossFade":true},"loop":true}'>
          <div class="swiper swiper-wrapper">
          <?php
            if ( $settings['slidesslidersixthkaveh'] ) {
            foreach (  $settings['slidesslidersixthkaveh'] as $item ) {
            ?>
            <!-- Start Slide -->
            <div class="swiper-slide">
              <div class="landing-thirteen-item d-flex align-items-lg-center flex-column flex-lg-row">
                <div class="image position-relative">
                  <img src="<?php echo esc_url($item['backslidersixthkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['backslidersixthkaveh'] )); ?>" />
                  <img src="<?php echo esc_url($item['backslidersixthkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['backslidersixthkaveh'] )); ?>" />

                </div>
                <div class="detail">
                  <div class="title overflow-hidden">
                    <<?php echo  esc_html($item['tagheadingslidersixthkaveh']); ?> class="slidd6st">
                    <?php echo  esc_html($item['titleslidersixthkaveh']); ?>
                      <b class="d-block"><?php echo  esc_html($item['title2slidersixthkaveh']); ?></b>
                    </<?php echo  esc_html($item['tagheadingslidersixthkaveh']); ?>>
                  </div>
                  <a href="<?php echo  esc_url($item['linkbuttonslidersixthkaveh']); ?>" class="btn btn-success-4">
                  <?php echo  esc_html($item['buttonslidersixthkaveh']); ?>
                    <i class="<?php echo  esc_attr($item['iconbuttslidersixthkaveh']['value']); ?>"></i>
                  </a>
                </div>
              </div>
            </div>
            <!-- End Slide -->
            <?php
          }
        }
          ?>
          </div>
          <div class="swiper-button-next"></div>
          <div class="swiper-button-prev"></div>
          <div class="swiper-pagination"></div>
        </div>
        <!-- End Carousel -->
      </div>
    </section>
    <style>
        <?php echo '.elementor-element-' . $clsid . ''; ?> .landing-thirteen {
    -webkit-background-size: cover !important;
    -moz-background-size: cover !important;
    -o-background-size: cover !important;
    background-size: cover !important;
}
    </style>
    <?php do_action('kelementor_inline_scripts'); ?>
    <?php  
  }


}
