<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Sliderninethkaveh extends Widget_Base{

  public function get_name(){
    return 'sliderninethkaveh';
  }

  public function get_title(){
    return esc_html__( 'اسلایدر سبک نهم', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentsliderninethkaveh',
        [
          'label' => esc_html__( 'Content', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );
      $repeater = new \Elementor\Repeater();

      $repeater->add_control(
        'backsliderninethkaveh',
        [
          'label' => esc_html__( 'تصویر خود را انتخاب کنید', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
          ],
        ]
      );
      $repeater->add_control(
        'linksliderninethkaveh',
        [
            'label' => esc_html__( 'لینک اسلاید', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( '#', 'kaveh-core' ),
    
        ]
    );
    $repeater->add_control(
      'shape1color1sliderninethkaveh',
      [
        'label' => esc_html__( 'رنگ شیپ اول', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
      ]
    );
    $repeater->add_control(
      'shape2color1sliderninethkaveh',
      [
        'label' => esc_html__( 'رنگ شیپ دوم', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::COLOR,
      ]
    );
      $this->add_control(
        'slidessliderninethkaveh',
        [
          'label' => esc_html__( 'اسلاید ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::REPEATER,
          'fields' => $repeater->get_controls(),
          ],
      );
      $this->add_control(
        'arrowssliderninethkaveh',
        [
          'label' => esc_html__( 'نمایش فلش ها؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
      $this->add_control(
        'bulletssliderninethkaveh',
        [
          'label' => esc_html__( 'نمایش نقطه ها؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
      $this->end_controls_section();

      $this->start_controls_section(
        'style1_sliderninethkaveh',
        [
          'label' => esc_html__( 'استایل اسلایدر', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'heightbgsliderninethkaveh',
        [
          'label' => esc_html__( 'ارتفاع اسلایدر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 100,
              'max' => 2000,
              'step' => 5,
            ],
          ],
          'default' => [
            'unit' => 'px',
            'size' => 452,
          ],
          'selectors' => [
            '{{WRAPPER}} .slider-home-three-item img' => 'max-height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );
      $this->add_control(
        'dotno1sliderninethkaveh',
        [
          'label' => esc_html__( 'رنگ نقطه غیر فعال', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .slider-home-three-wrapper .swiper-pagination-bullet' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'doty1sliderninethkaveh',
        [
          'label' => esc_html__( 'رنگ نقطه فعال', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .slider-home-three-wrapper .swiper-pagination-bullet-active' => 'background-color: {{VALUE}}',
          ],
        ]
      );
       $this->end_controls_section();

          
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
        <section class="slider-home-three">
      <div class="container">
        <div class="slider-home-three-wrapper position-relative">
          <div class="swiper swiper-home-three swiper-button-fill" data-swiper='{"slidesPerView":1,"spaceBetween":0,"pagination":{"el":".swiper-pagination","type":"bullets","clickable":true},"autoplay":{"delay":5000},"effect":"fade","fadeEffect":{"crossFade":true},"loop":true,"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"}}'>
            <div class="swiper-wrapper">
            <?php
              if ( $settings['slidessliderninethkaveh'] ) {
              foreach (  $settings['slidessliderninethkaveh'] as $item ) {
              ?>
              <!-- Start Slide -->
              <div class="swiper-slide">
                <div class="slider-home-three-item position-relative">
                  <span class="shape-1 position-absolute" style="background-color: <?php echo  esc_attr($item['shape1color1sliderninethkaveh']); ?>;"></span>
                  <span class="shape-2 position-absolute" style="background-color: <?php echo  esc_attr($item['shape2color1sliderninethkaveh']); ?>;"></span>
                  <a href="<?php echo  esc_url($item['linksliderninethkaveh']); ?>">
                  <img src="<?php echo esc_url($item['backsliderninethkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['backsliderninethkaveh'] )); ?>" width="855" height="410"
                    class="w-100 d-block">
                    </a>
                </div>
              </div>
              <!-- End Slide -->
              <?php
                }
              }
                ?>
            </div>
            
            <?php if("yes"===$settings['bulletssliderninethkaveh']){?>
            <div class="swiper-pagination bottom-0"></div>
            <?php
            }
             if("yes"===$settings['arrowssliderninethkaveh']){?>
            <div class="swiper-button-next"></div>
            <div class="swiper-button-prev"></div>
            <?php } ?>
          </div>
        </div>
      </div>
    </section>
    <?php do_action('kelementor_inline_scripts'); ?>
    <?php
  }


}
