<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Sliderfourthkaveh extends Widget_Base{

  public function get_name(){
    return 'sliderfourthkaveh';
  }

  public function get_title(){
    return esc_html__( 'اسلایدر سبک چهار', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  } 

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentsliderfourthkaveh',
        [
          'label' => esc_html__( 'محتوا', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      ); 
      $this->add_control(
        'style1sliderfourthkaveh',
        [
          'label' => esc_html__( 'طرح بندی اسلایدر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SELECT,
          'default' => 'one',
          'options' => [
            'one'  => esc_html__( 'طرح بندی اول', 'kaveh-core' ),
            'two'  => esc_html__( 'طرح بندی دوم', 'kaveh-core' ),
    
          ],
        ]
        );  
      $repeater = new \Elementor\Repeater();
      $repeater->add_control(
        'titlelsliderfourthkaveh',
        [
            'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'فروش بازی های', 'kaveh-core' ),
    
        ]
    ); 
    $repeater->add_control(
      'title2lsliderfourthkaveh',
      [
          'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'پلی استیشن', 'kaveh-core' ),
  
      ]
  );
  $repeater->add_control(
    'tagheading1sliderfourthkaveh',
    [
      'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'H2',
      'options' => [
        'H1'  => esc_html__( 'H1', 'kaveh-core' ),
        'H2' => esc_html__( 'H2', 'kaveh-core' ),
        'H3' => esc_html__( 'H3', 'kaveh-core' ),
        'H4' => esc_html__( 'H4', 'kaveh-core' ),
        'H5' => esc_html__( 'H5', 'kaveh-core' ),
        'H6' => esc_html__( 'H6', 'kaveh-core' ),
        'p' => esc_html__( 'p', 'kaveh-core' ),
        'div' => esc_html__( 'div', 'kaveh-core' ),
        'span' => esc_html__( 'span', 'kaveh-core' ),
      ],
    ]
  );
      $repeater->add_control(
        'buttonsliderfourthkaveh',
        [
            'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'محصولات', 'kaveh-core' ),
    
        ]
    );
    $repeater->add_control(
      'iconbuttsliderfourthkaveh',
      [
        'label' => esc_html__( 'آیکون', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'exclude_inline_options' => [ 'svg' ],
        'default' => [
          'value' => 'isax isax-arrow-left4',
        ],
      ]
    );
    $repeater->add_control(
      'linkbuttonsliderfourthkaveh',
      [
          'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( '#', 'kaveh-core' ),
  
      ]
  );
  $repeater->add_control(
    'backsliderfourthkaveh',
    [
      'label' => esc_html__( 'تصویر خود را انتخاب کنید', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::MEDIA,
    ]
  );
      $this->add_control(
        'slidessliderfourthkaveh',
        [
          'label' => esc_html__( 'اسلاید ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::REPEATER,
          'condition' => [
            'style1sliderfourthkaveh' => 'one',
          ],
          'default' => [
            [
              'titlelsliderfourthkaveh' => esc_html__( 'فروش بازی های', 'kaveh-core' ),
              'title2lsliderfourthkaveh' => esc_html__( 'پلی استیشن', 'kaveh-core' ),
              'buttonsliderfourthkaveh' => esc_html__( 'محصولات', 'kaveh-core' ),
              'linkbuttonsliderfourthkaveh' => esc_html__( '#', 'kaveh-core' ),
            ],
          ],
          'fields' => $repeater->get_controls()
          ],
      );
      $repeater = new \Elementor\Repeater();
      $repeater->add_control(
        'titlel2sliderfourthkaveh',
        [
            'label' => esc_html__( 'عنوان', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'بزرگترین مرجع تخصصی', 'kaveh-core' ),
    
        ]
    );
    $repeater->add_control(
      'title2l2sliderfourthkaveh',
      [
          'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'عطر و ادکلن', 'kaveh-core' ),
  
      ]
  );
  $repeater->add_control(
    'tagheading2sliderfourthkaveh',
    [
      'label' => esc_html__( 'تگ عنوان', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'H2',
      'options' => [
        'H1'  => esc_html__( 'H1', 'kaveh-core' ),
        'H2' => esc_html__( 'H2', 'kaveh-core' ),
        'H3' => esc_html__( 'H3', 'kaveh-core' ),
        'H4' => esc_html__( 'H4', 'kaveh-core' ),
        'H5' => esc_html__( 'H5', 'kaveh-core' ),
        'H6' => esc_html__( 'H6', 'kaveh-core' ),
        'p' => esc_html__( 'p', 'kaveh-core' ),
        'div' => esc_html__( 'div', 'kaveh-core' ),
        'span' => esc_html__( 'span', 'kaveh-core' ),
      ],
    ]
  );
    $repeater->add_control(
      'link2sliderfourthkaveh',
      [
          'label' => esc_html__( 'لینک', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( '#', 'kaveh-core' ),
  
      ]
  );
  $repeater->add_control(
    'back2sliderfourthkaveh',
    [
      'label' => esc_html__( 'تصویر خود را انتخاب کنید', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::MEDIA,
    ]
  );
      $this->add_control(
        'slides2sliderfourthkaveh',
        [
          'label' => esc_html__( 'اسلاید ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::REPEATER,
          'condition' => [
            'style1sliderfourthkaveh' => 'two',
          ],
          'default' => [
            [
              'titlel2sliderfourthkaveh' => esc_html__( 'بزرگترین مرجع تخصصی' , 'kaveh-core' ),
              'title2l2sliderfourthkaveh' => esc_html__( 'عطر و ادکلن', 'kaveh-core' ),
              'link2sliderfourthkaveh' => esc_html__( '#', 'kaveh-core' ),
            ],
          ],
          'fields' => $repeater->get_controls()
          ],
      );
      $this->add_control(
        'backjsliderfourthkaveh',
        [
          'label' => esc_html__( 'تصویر پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,  
          'selectors' => [
            '{{WRAPPER}} .landing-eight::before' =>
                'background: url({{URL}}) 0 0 no-repeat',
        ],   
          'condition' => [
            'style1sliderfourthkaveh' => 'one',
          ],         
        ]
      );
      
      $this->add_control(
        'backj2sliderfourthkaveh',
        [
          'label' => esc_html__( 'تصویر دوم', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,   
          'selectors' => [
            '{{WRAPPER}} .landing-eight::after' =>
                'background: url({{URL}}) 0 0 no-repeat',
        ], 
          'condition' => [
            'style1sliderfourthkaveh' => 'one',
          ],        
        ]
      );
      
       $this->end_controls_section();
       $this->start_controls_section(
        'style1_1sliderfourthkaveh',
        [
          'label' => esc_html__( 'استایل عنوان', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
          'condition' => [
           'style1sliderfourthkaveh' => 'one',
         ],   
        ]
       );
       $this->add_control(
        'titlest1sliderfourthkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .landing-eight-item .title .slider4h' => 'color: {{VALUE}}',
          ],
        ]
       );
       $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title_1sliderfourthkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان فرعی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .landing-eight-item .title .slider4h',
        ]
       );
       $this->add_control(
        'titlepst1sliderfourthkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان اصلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .landing-eight-item .title .slider4h b' => 'color: {{VALUE}}',
          ],
        ]
       );
       $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'p_1sliderfourthkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان اصلی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .landing-eight-item .title .slider4h b',
        ]
       );
       $this->end_controls_section();
       
       
       
       
       
       $this->start_controls_section(
         'style2_1sliderfourthkaveh',
         [
           'label' => esc_html__( 'استایل دکمه', 'kaveh-core' ),
           'tab' => \Elementor\Controls_Manager::TAB_STYLE,
           'condition' => [
             'style1sliderfourthkaveh' => 'one',
           ],   
         ]
        );
        $this->add_group_control(
         \Elementor\Group_Control_Typography::get_type(),
         [
           'name' => 'button_1sliderfourthkaveh',
           'label' => esc_html__( 'تایپوگرافی متن دکمه', 'kaveh-core' ),
           'selector' => '{{WRAPPER}} .landing-eight-item .btn',
         ]
       );
       $this->add_control(
         'iconsize1sliderfourthkaveh',
         [
           'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::SLIDER,
           'size_units' => [ 'px', '%' ],
           'range' => [
             'px' => [
               'min' => 0,
               'max' => 200,
               'step' => 5,
             ],
             '%' => [
               'min' => 0,
               'max' => 100,
             ],
           ],
           'selectors' => [
             '{{WRAPPER}} .landing-eight-item .btn i' => 'font-size: {{SIZE}}{{UNIT}};',
           ],
         ]
       );
       $this->add_group_control(
         \Elementor\Group_Control_Text_Shadow::get_type(),
         [
           'name' => 'text_shadow1sliderfourthkaveh',
           'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
           'selector' => '{{WRAPPER}} .landing-eight-item .btn',
         ]
       );
       $this->start_controls_tabs(
         'style_tabs1sliderfourthkaveh'
       );
       
       $this->start_controls_tab(
         'style_normal_tab1sliderfourthkaveh',
         [
           'label' => esc_html__( 'عادی', 'kaveh-core' ),
         ]
       );
       $this->add_control(
         'textbuttoncolor1sliderfourthkaveh',
         [
           'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
             '{{WRAPPER}} .landing-eight-item .btn' => 'color: {{VALUE}}',
           ],
         ]
       ); 
       $this->add_control(
         'iconcolor1sliderfourthkaveh',
         [
           'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
             '{{WRAPPER}} .landing-eight-item .btn i' => 'color: {{VALUE}}',
           ],
         ]
       ); 
       $this->add_control(
         'buttoncolor1sliderfourthkaveh',
         [
           'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
             '{{WRAPPER}} .landing-eight-item .btn' => 'background-color: {{VALUE}}',
           ],
         ]
       ); 
       $this->add_control(
         'buttonradius1sliderfourthkaveh',
         [
           'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::DIMENSIONS,
           'size_units' => [ 'px' ],
           'selectors' => [
             '{{WRAPPER}} .landing-eight-item .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
           ],
         ]
       );
       $this->add_group_control(
         \Elementor\Group_Control_Border::get_type(),
         [
           'name' => 'border1sliderfourthkaveh',
           'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
           'selector' => '{{WRAPPER}} .landing-eight-item .btn',
         ]
       );
       $this->add_control(
         'buttonborders1sliderfourthkaveh',
         [
           'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::DIMENSIONS,
           'size_units' => [ 'px' ],
           'condition' => [
             'border1sliderfourthkaveh!' => '',
           ],
           'selectors' => [
             '{{WRAPPER}} .landing-eight-item .btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
           ],
         ]
       );
       $this->end_controls_tab();
       $this->start_controls_tab(
         'style_hove_tab1sliderfourthkaveh',
         [
           'label' => esc_html__( 'هاور', 'kaveh-core' ),
         ]
       );
       $this->add_control(
         'textbuttoncolorhover1sliderfourthkaveh',
         [
           'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
             '{{WRAPPER}} .landing-eight-item .btn:hover' => 'color: {{VALUE}}',
           ],
         ]
       ); 
       $this->add_control(
         'iconcolorhover1sliderfourthkaveh',
         [
           'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
             '{{WRAPPER}} .landing-eight-item .btn:hover i' => 'color: {{VALUE}}',
           ],
         ]
       ); 
       $this->add_control(
         'buttoncolorhover1sliderfourthkaveh',
         [
           'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
             '{{WRAPPER}} .landing-eight-item .btn:hover' => 'background-color: {{VALUE}}',
           ],
         ]
       ); 
       $this->add_control(
         'buttonradiushover1sliderfourthkaveh',
         [
           'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::DIMENSIONS,
           'size_units' => [ 'px' ],
           'selectors' => [
             '{{WRAPPER}} .landing-eight-item .btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
           ],
         ]
       );
       $this->add_group_control(
         \Elementor\Group_Control_Border::get_type(),
         [
           'name' => 'borderhover1sliderfourthkaveh',
           'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
           'selector' => '{{WRAPPER}} .landing-eight-item .btn:hover',
         ]
       );
       $this->add_control(
         'buttonbordershover1sliderfourthkaveh',
         [
           'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::DIMENSIONS,
           'size_units' => [ 'px' ],
           'condition' => [
             'borderhover1sliderfourthkaveh!' => '',
           ],
           'selectors' => [
             '{{WRAPPER}} .landing-eight-item .btn:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
           ],
         ]
       );
       $this->end_controls_tab();
       $this->end_controls_tabs();
       $this->add_group_control(
         \Elementor\Group_Control_Box_Shadow::get_type(),
         [
           'name' => 'box_shadow1sliderfourthkavehh',
           'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
           'selector' => '{{WRAPPER}} .landing-eight-item .btn',
         ]
       );
       $this->add_control(
         'hr11sliderfourthkaveh',
         [
           'type' => \Elementor\Controls_Manager::DIVIDER,
         ]
       );
       $this->add_control(
         'buttonpadding1sliderfourthkaveh',
         [
           'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::DIMENSIONS,
           'size_units' => [ 'px' ],
           'selectors' => [
             '{{WRAPPER}} .landing-eight-item .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
           ],
         ]
       );
        $this->end_controls_section();
       
       
       
        $this->start_controls_section(
         'style3_1sliderfourthkaveh',
         [
           'label' => esc_html__( 'استایل تصاویر', 'kaveh-core' ),
           'tab' => \Elementor\Controls_Manager::TAB_STYLE,
           'condition' => [
             'style1sliderfourthkaveh' => 'one',
           ],   
         ]
        );
       $this->add_control(
         'widthmain1sliderfourthkaveh',
         [
           'label' => esc_html__( 'سایز تصویر', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::SLIDER,
           'size_units' => [ 'px', '%' ],
           'range' => [
             'px' => [
               'min' => 0,
               'max' => 2000,
               'step' => 5,
             ],
             '%' => [
               'min' => 0,
               'max' => 100,
             ],
           ],
           'default' => [
             'unit' => 'px',
             'size' => 746,
           ],
           'selectors' => [
             '{{WRAPPER}} .landing-eight-item .image img' => 'width: {{SIZE}}{{UNIT}};',
           ],
         ]
       );
       $this->add_control(
         'width21sliderfourthkaveh',
         [
           'label' => esc_html__( 'عرض تصویر دوم', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::SLIDER,
           'size_units' => [ 'px', '%' ],
           'range' => [
             'px' => [
               'min' => 0,
               'max' => 2000,
               'step' => 5,
             ],
             '%' => [
               'min' => 0,
               'max' => 100,
             ],
           ],
           'selectors' => [
             '{{WRAPPER}} .landing-eight::after' => 'width: {{SIZE}}{{UNIT}};',
           ],
         ]
       );
        $this->end_controls_section();
        $this->start_controls_section(
         'style4_1sliderfourthkaveh',
         [
           'label' => esc_html__( 'استایل عمومی', 'kaveh-core' ),
           'tab' => \Elementor\Controls_Manager::TAB_STYLE,
           'condition' => [
             'style1sliderfourthkaveh' => 'one',
           ],   
         ]
        );
        $this->add_control(
         'bgmaincolor1sliderfourthkaveh',
         [
           'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
             '{{WRAPPER}} .landing-eight::before' => 'background-color: {{VALUE}}',
           ],
         ]
       ); 
       $this->add_control(
         'arrowcolor1sliderfourthkaveh2',
         [
           'label' => esc_html__( 'رنگ فلش ها', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
            '{{WRAPPER}} .landing-eight .swiper-button-prev::after' => 'color: {{VALUE}}',
            '{{WRAPPER}} .landing-eight .swiper-button-next::after' => 'color: {{VALUE}}',
            '{{WRAPPER}} .landing-eight .swiper-button-next' => 'border: 2px solid {{VALUE}}',
            '{{WRAPPER}} .landing-eight .swiper-button-prev' => 'border: 2px solid {{VALUE}}',

          ],
         ]
       ); 
       $this->add_control(
        'dotscolor1sliderfourthkaveh',
        [
          'label' => esc_html__( 'رنگ نقطه ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .landing-eight .swiper-pagination-bullet' => 'background-color: {{VALUE}}',
          ],
        ]
      ); 
      $this->add_control(
        'dotscolor12sliderfourthkaveh',
        [
          'label' => esc_html__( 'رنگ حاشیه نقطه ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .landing-eight .swiper-pagination' => 'border: 2px solid {{VALUE}}',
          ],
        ]
      ); 
       $this->add_control(
         'heightmain1sliderfourthkaveh',
         [
           'label' => esc_html__( 'ارتفاع اسلایدر', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::SLIDER,
           'size_units' => [ 'px', '%' ],
           'range' => [
             'px' => [
               'min' => 0,
               'max' => 2000,
               'step' => 5,
             ],
             '%' => [
               'min' => 0,
               'max' => 100,
             ],
           ],
           'selectors' => [
             '{{WRAPPER}} .landing-eight' => 'height: {{SIZE}}{{UNIT}};',
           ],
         ]
       );
        $this->end_controls_section();
        $this->start_controls_section(
          'style1_2sliderfourthkaveh',
          [
            'label' => esc_html__( 'استایل عنوان', 'kaveh-core' ),
            'tab' => \Elementor\Controls_Manager::TAB_STYLE,
            'condition' => [
             'style1sliderfourthkaveh' => 'two',
           ],   
          ]
         );
         $this->add_control(
          'titlest2sliderfourthkaveh',
          [
            'label' => esc_html__( 'رنگ عنوان فرعی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .landing-fourteen .slider41h a' => 'color: {{VALUE}}',
            ],
          ]
         );
         $this->add_group_control(
          \Elementor\Group_Control_Typography::get_type(),
          [
            'name' => 'title_2sliderfourthkaveh',
            'label' => esc_html__( 'تایپوگرافی عنوان فرعی', 'kaveh-core' ),
            'selector' => '{{WRAPPER}} .landing-fourteen .slider41h a',
          ]
         );
         $this->add_control(
          'titlepst2sliderfourthkaveh',
          [
            'label' => esc_html__( 'رنگ عنوان اصلی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::COLOR,
            'selectors' => [
              '{{WRAPPER}} .landing-fourteen .slider41h a b' => 'color: {{VALUE}}',
            ],
          ]
         );
         $this->add_group_control(
          \Elementor\Group_Control_Typography::get_type(),
          [
            'name' => 'p_2sliderfourthkaveh',
            'label' => esc_html__( 'تایپوگرافی عنوان اصلی', 'kaveh-core' ),
            'selector' => '{{WRAPPER}} .landing-fourteen .slider41h a b',
          ]
         );
         $this->end_controls_section();
         

 $this->start_controls_section(
  'style3_2sliderfourthkaveh',
  [
    'label' => esc_html__( 'استایل تصاویر', 'kaveh-core' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'condition' => [
      'style1sliderfourthkaveh' => 'two',
    ],   
  ]
 );
$this->add_control(
  'widthmain2sliderfourthkaveh',
  [
    'label' => esc_html__( 'سایز تصویر', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::SLIDER,
    'size_units' => [ 'px', '%' ],
    'range' => [
      'px' => [
        'min' => 0,
        'max' => 2000,
        'step' => 5,
      ],
      '%' => [
        'min' => 0,
        'max' => 100,
      ],
    ],
    'default' => [
      'unit' => 'px',
      'size' => 605,
    ],
    'selectors' => [
      '{{WRAPPER}} .imagesli42 img' => 'width: {{SIZE}}{{UNIT}} !important;',
    ],
  ]
);
 $this->end_controls_section();
 $this->start_controls_section(
  'style4_2sliderfourthkaveh',
  [
    'label' => esc_html__( 'استایل عمومی', 'kaveh-core' ),
    'tab' => \Elementor\Controls_Manager::TAB_STYLE,
    'condition' => [
      'style1sliderfourthkaveh' => 'two',
    ],   
  ]
 );
 $this->add_control(
  'bgmaincolor2sliderfourthkaveh',
  [
    'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::COLOR,
  ]
); 
$this->add_control(
  'dotscolor2sliderfourthkaveh',
  [
    'label' => esc_html__( 'رنگ نقطه ها', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::COLOR,
    'selectors' => [
      '{{WRAPPER}} .landing-fourteen .swiper-pagination-bullet' => 'background-color: {{VALUE}}',
    ],
  ]
); 
$this->add_control(
  'dotscolor22sliderfourthkaveh',
  [
    'label' => esc_html__( 'رنگ حاشیه نقطه ها', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::COLOR,
    'selectors' => [
      '{{WRAPPER}} .landing-fourteen .swiper-pagination' => 'border: 2px solid {{VALUE}}',
    ],
  ]
); 
$this->add_control(
  'heightmain2sliderfourthkaveh',
  [
    'label' => esc_html__( 'ارتفاع اسلایدر', 'kaveh-core' ),
    'type' => \Elementor\Controls_Manager::SLIDER,
    'size_units' => [ 'px', '%' ],
    'range' => [
      'px' => [
        'min' => 0,
        'max' => 2000,
        'step' => 5,
      ],
      '%' => [
        'min' => 0,
        'max' => 100,
      ],
    ],
    'selectors' => [
      '{{WRAPPER}} .landing-fourteen' => 'height: {{SIZE}}{{UNIT}};',
    ],
  ]
);
 $this->end_controls_section();
          
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <?php if('one'===$settings['style1sliderfourthkaveh']){ ?>
    <section class="landing-eight position-relative">
      <div class="container">
        <div class="swiper swiper-landing" data-swiper='{"slidesPerView":1,"spaceBetween":0,"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"pagination":{"el":".swiper-pagination","type":"bullets","clickable":true},"autoplay":{"delay":5000,"disableOnInteraction":false,"pauseOnMouseEnter":true},"effect":"fade","fadeEffect":{"crossFade":true},"loop":true}'>
          <div class="swiper-wrapper">
          <?php
            if ( $settings['slidessliderfourthkaveh'] ) {
            foreach (  $settings['slidessliderfourthkaveh'] as $item ) {
            ?>
            <!-- Start Landing Item -->
            <div class="swiper-slide">
              <div class="landing-eight-item">
                <div class="row align-items-center">
                  <div class="col-lg-7">
                    <div class="image">
                      <img src="<?php echo esc_url($item['backsliderfourthkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['backsliderfourthkaveh'] )); ?>" />
                    </div>
                  </div>
                  <div class="col-lg-5">
                    <div class="title overflow-hidden mb-3">
                      <<?php echo  esc_html($item['tagheading1sliderfourthkaveh']); ?> class="mb-0 slider4h">
                      <?php echo  esc_html($item['titlelsliderfourthkaveh']); ?>
                      <b class="d-block"><?php echo  esc_html($item['title2lsliderfourthkaveh']); ?></b>
                      </<?php echo  esc_html($item['tagheading1sliderfourthkaveh']); ?>>
                    </div>
                    <a href="<?php echo  esc_url($item['linkbuttonsliderfourthkaveh']); ?>" class="btn btn-danger-3">
                    <?php echo  esc_html($item['buttonsliderfourthkaveh']); ?>
                      <i class="<?php echo  esc_attr($item['iconbuttsliderfourthkaveh']['value']); ?>"></i>
                    </a>
                  </div>
                </div>
              </div>
            </div>
            <!-- End Landing Item -->
            <?php
          }
        }
          ?>
          </div>
          <div class="swiper-button-next"></div>
          <div class="swiper-button-prev"></div>
          <div class="swiper-pagination w-100 start-50 translate-middle-x"></div>
        </div>
      </div>
    </section>
    <?php }elseif('two'===$settings['style1sliderfourthkaveh']){ ?>
     <section class="landing-fourteen">
      <div class="container position-relative">
        <!-- Start Carousel -->
        <div class="swiper swiper-landing" data-swiper='{"slidesPerView":1,"spaceBetween":0,"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"pagination":{"el":".swiper-pagination","type":"bullets","clickable":true},"autoplay":{"delay":5000,"disableOnInteraction":false,"pauseOnMouseEnter":true},"effect":"fade","fadeEffect":{"crossFade":true},"loop":true}'>
          <div class="swiper-wrapper">
          <?php
            if ( $settings['slides2sliderfourthkaveh'] ) {
            foreach (  $settings['slides2sliderfourthkaveh'] as $item ) {
            ?>
            <!-- Start Slide -->
            <div class="swiper-slide">
              <div class="landing-fourteen-item">
                <div class="row align-items-center">
                  <div class="col-lg-6 order-2 order-lg-1">
                    <<?php echo  esc_html($item['tagheading2sliderfourthkaveh']); ?> class="overflow-hidden slider41h">
                      <a href="<?php echo  esc_url($item['link2sliderfourthkaveh']); ?>" class="fw-light d-block">
                      <?php echo  esc_html($item['titlel2sliderfourthkaveh']); ?>
                      <b class="d-block"><?php echo  esc_html($item['title2l2sliderfourthkaveh']); ?></b>
                      </a>
                    </<?php echo  esc_html($item['tagheading2sliderfourthkaveh']); ?>>
                  </div>
                  <div class="col-lg-6 order-1 order-lg-2">
                    <div class="image imagesli42 position-relative">
                      <img src="<?php echo esc_url($item['back2sliderfourthkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['back2sliderfourthkaveh'] )); ?>" class="d-block w-100" />
                      <img src="<?php echo esc_url($item['back2sliderfourthkaveh']['url']); ?>" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['back2sliderfourthkaveh'] )); ?>"
                        class="position-absolute d-block w-100 h-100 top-0 end-0" />
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <!-- End Slide -->
            <?php
          }
        }
          ?>
          </div>
          <!-- Start Navigation -->
          <div class="swiper-button-next d-none"></div>
          <div class="swiper-button-prev d-none"></div>
          <!-- End Navigation -->
          <!-- Start Pagination -->
          <div class="swiper-pagination"></div>
          <!-- End Pagination -->
        </div>
        <!-- Start Carousel -->
      </div>
    </section>
    <?php } ?>
    <style>
      .landing-eight::after {
    z-index: 0;
}
              <?php echo '.elementor-element-' . $clsid . ''; ?> .landing-eight::after {
              -webkit-background-size: contain;
          -moz-background-size: contain;
          -o-background-size: contain;
          background-size: contain;
          }
          <?php echo '.elementor-element-' . $clsid . ''; ?> .landing-eight::before {
          -webkit-background-size: cover !important;
          -moz-background-size: cover !important;
          -o-background-size: cover !important;
          background-size: cover !important;
      } 
<?php echo '.elementor-element-' . $clsid . ''; ?> .landing-fourteen {
    background-image: -webkit-linear-gradient(top, rgba(255, 255, 255, 0), <?php echo esc_html($settings['bgmaincolor2sliderfourthkaveh']); ?>);
    background-image: -moz-linear-gradient(top, rgba(255, 255, 255, 0), <?php echo esc_html($settings['bgmaincolor2sliderfourthkaveh']); ?>);
    background-image: -o-linear-gradient(top, rgba(255, 255, 255, 0), <?php echo esc_html($settings['bgmaincolor2sliderfourthkaveh']); ?>);
    background-image: linear-gradient(to bottom, rgba(255, 255, 255, 0), <?php echo esc_html($settings['bgmaincolor2sliderfourthkaveh']); ?>);
}
</style>
<?php do_action('kelementor_inline_scripts'); ?>
    <?php 
  }


}
