<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Sliderfourteenteenkaveh extends Widget_Base{

  public function get_name(){
    return 'sliderfourteenteenkaveh';
  }

  public function get_title(){
    return esc_html__( 'اسلایدر سبک چهارده', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentsliderfourteenteenkaveh',
        [
          'label' => esc_html__( 'محتوای اسلایدر', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      );

      $repeater = new \Elementor\Repeater();

      $repeater->add_control(
        'backsliderfourteenteenkaveh',
        [
          'label' => esc_html__( 'تصویر خود را انتخاب کنید', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'default' => [
            'url' => \Elementor\Utils::get_placeholder_image_src(),
          ],
        ]
      );
      $repeater->add_control(
        'linksliderfourteenteenkaveh',
        [
            'label' => esc_html__( 'لینک اسلاید', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( '#', 'kaveh-core' ),
    
        ]
    );
      $this->add_control(
        'slidessliderfourteenteenkaveh',
        [
          'label' => esc_html__( 'اسلاید ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::REPEATER,
          'fields' => $repeater->get_controls(),
          ],
      );
      $this->add_control(
        'bulletssliderfourteenteenkaveh',
        [
          'label' => esc_html__( 'نمایش نقطه ها؟', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SWITCHER,
          'yes' => esc_html__( 'بله', 'kaveh-core' ),
          'no' => esc_html__( 'خیر', 'kaveh-core' ),
          'return_value' => 'yes',
          'default' => 'yes',
        ]
      );
      $this->end_controls_section();

      $this->start_controls_section(
        'style1_sliderfourteenteenkaveh',
        [
          'label' => esc_html__( 'استایل اسلایدر', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
      );
      $this->add_control(
        'heightbgsliderfourteenteenkaveh',
        [
          'label' => esc_html__( 'ارتفاع اسلایدر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::SLIDER,
          'size_units' => [ 'px' ],
          'range' => [
            'px' => [
              'min' => 0,
              'max' => 2000,
              'step' => 5,
            ],
            'devices' => [ 'desktop', 'tablet', 'mobile' ],
          ],
          'selectors' => [
            '{{WRAPPER}} .carousel-home-two-item img' => 'height: {{SIZE}}{{UNIT}};',
          ],
        ]
      );

      $this->add_control(
        'borderradiussliderfourteenteenkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده اسلایدر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .carousel-home-two-item img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );

      $this->add_control(
        'bgdotscolorsliderfourteenteenkavehh',
        [
          'label' => esc_html__( 'رنگ پس زمینه نقطه ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'bulletssliderfourteenteenkaveh' => 'yes',
        ],
          'selectors' => [
            '{{WRAPPER}} .carousel-home-two .swiper-pagination::before' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'dotscolorsliderfourteenteenkavehh',
        [
          'label' => esc_html__( 'رنگ نقطه ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'bulletssliderfourteenteenkaveh' => 'yes',
        ],
          'selectors' => [
            '{{WRAPPER}} .carousel-home-two .swiper-pagination-bullet' => 'background-color: {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'borderdotscolorsliderfourteenteenkavehh',
        [
          'label' => esc_html__( 'رنگ حاشیه پس زمینه نقطه ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'condition' => [
            'bulletssliderfourteenteenkaveh' => 'yes',
        ],
          'selectors' => [
            '{{WRAPPER}} .carousel-home-two .swiper-pagination::before' => 'border: 1px solid {{VALUE}}',
          ],
        ]
      );
      $this->add_control(
        'borderradiusdotssliderfourteenteenkaveh',
        [
          'label' => esc_html__( 'گوشه خمیده اسلایدر', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::DIMENSIONS,
          'size_units' => [ 'px' ],
          'selectors' => [
            '{{WRAPPER}} .carousel-home-two .swiper-pagination::before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
          ],
        ]
      );
       $this->end_controls_section();

          
        }


  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <section class="carousel-home-two">
      <div class="container">
        <div class="carousel-home-two-wrapper position-relative">
          <!-- Start Carousel -->
          <div class="swiper swiper-carousel-home-two overflow-hidden">
            <div class="swiper-wrapper">
              <?php
              if ( $settings['slidessliderfourteenteenkaveh'] ) {
              foreach (  $settings['slidessliderfourteenteenkaveh'] as $item ) {
              ?>
              <!-- Start Slide -->
              <div class="swiper-slide">
                <div class="carousel-home-two-item">
                  <a href="<?php echo  esc_url($item['linksliderfourteenteenkaveh']); ?>" class="d-block">
                    <img src="<?php echo esc_url($item['backsliderfourteenteenkaveh']['url']); ?>" alt=""
                      class="w-100 d-block">
                  </a>
                </div>
              </div>
              <!-- End Slide -->
              <?php
                }
              }
                ?>
            </div>
            <!-- Start Pagination -->
            <?php 
               if("yes"===$settings['bulletssliderfourteenteenkaveh']){?>
            <div
              class="swiper-pagination d-none d-md-flex align-items-md-center justify-content-md-center mx-auto start-0 end-0 rounded-pill">
            </div>
            <?php } ?>
            <!-- End Pagination -->
          </div>
          <!-- End Carousel -->
        </div>
      </div>
    </section>
<style>
.carousel-home-two-item img {
  object-fit: cover !important;
}
</style>
    <script>
       function init<?php echo $clsid; ?>() {
// Carousel Home Two
new Swiper(".swiper-carousel-home-two", {
  slidesPerView: 1,
  spaceBetween: 0,
  pagination: {
    el: ".swiper-pagination",
    type: "bullets",
    clickable: true,
  },
  autoplay: {
    delay: 3000,
  },
  effect: "fade",
  fadeEffect: {
    crossFade: true,
  },
  loop: true,
});
}
      if (window.Swiper) {
    // Swiper library already loaded, initialize Swiper instance
    init<?php echo $clsid; ?>();
  } else {
    // Swiper library not yet loaded, wait for it to load
    window.addEventListener("load", function() {
      init<?php echo $clsid; ?>();
    });
  }
  
    </script>

    <?php
  }


}
