<?php



use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if (!defined('ABSPATH')) exit; // Exit if accessed directly


class Sliderfifthkaveh extends Widget_Base{

  public function get_name(){
    return 'sliderfifthkaveh';
  }

  public function get_title(){
    return esc_html__( 'اسلایدر سبک پنج', 'kaveh-core' );
  }

  public function get_icon(){
    return 'eicon-archive-posts';
  }

  public function get_categories(){
    return ['kavehelements'];
  }

  protected function register_controls(){
    
    $this->start_controls_section(
        'contentsliderfifthkaveh',
        [
          'label' => esc_html__( 'محتوا', 'kaveh-core' ),
                  'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
        ]
      ); 
      $repeater = new \Elementor\Repeater();
      $repeater->add_control(
        'titlesliderfifthkaveh',
        [
            'label' => esc_html__( 'عنوان فرعی', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'فروش انواع', 'kaveh-core' ),
    
        ]
    );
    $repeater->add_control(
      'tagheading1sliderfifthkaveh',
      [
        'label' => esc_html__( 'تگ عنوان فرعی', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::SELECT,
        'default' => 'H6',
        'options' => [
          'H1'  => esc_html__( 'H1', 'kaveh-core' ),
          'H2' => esc_html__( 'H2', 'kaveh-core' ),
          'H3' => esc_html__( 'H3', 'kaveh-core' ),
          'H4' => esc_html__( 'H4', 'kaveh-core' ),
          'H5' => esc_html__( 'H5', 'kaveh-core' ),
          'H6' => esc_html__( 'H6', 'kaveh-core' ),
          'p' => esc_html__( 'p', 'kaveh-core' ),
          'div' => esc_html__( 'div', 'kaveh-core' ),
          'span' => esc_html__( 'span', 'kaveh-core' ),
        ],
      ]
    );
    $repeater->add_control(
      'title2sliderfifthkaveh',
      [
          'label' => esc_html__( 'عنوان اصلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( 'ابزار شارژی و لیزری', 'kaveh-core' ),
  
      ]
  );
  $repeater->add_control(
    'tagheading2sliderfifthkaveh',
    [
      'label' => esc_html__( 'تگ عنوان اصلی', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::SELECT,
      'default' => 'H3',
      'options' => [
        'H1'  => esc_html__( 'H1', 'kaveh-core' ),
        'H2' => esc_html__( 'H2', 'kaveh-core' ),
        'H3' => esc_html__( 'H3', 'kaveh-core' ),
        'H4' => esc_html__( 'H4', 'kaveh-core' ),
        'H5' => esc_html__( 'H5', 'kaveh-core' ),
        'H6' => esc_html__( 'H6', 'kaveh-core' ),
        'p' => esc_html__( 'p', 'kaveh-core' ),
        'div' => esc_html__( 'div', 'kaveh-core' ),
        'span' => esc_html__( 'span', 'kaveh-core' ),
      ],
    ]
  );
      $repeater->add_control(
        'buttonsliderfifthkaveh',
        [
            'label' => esc_html__( 'عنوان دکمه', 'kaveh-core' ),
            'type' => \Elementor\Controls_Manager::TEXT,
            'default' => esc_html__( 'محصولات', 'kaveh-core' ),
    
        ]
    );
    $repeater->add_control(
      'iconbuttsliderfifthkaveh',
      [
        'label' => esc_html__( 'آیکون', 'kaveh-core' ),
        'type' => \Elementor\Controls_Manager::ICONS,
        'skin' => 'inline',
        'exclude_inline_options' => [ 'svg' ],
        'default' => [
          'value' => 'isax isax-arrow-left4',
        ],
      ]
    );
    $repeater->add_control(
      'linkbuttonsliderfifthkaveh',
      [
          'label' => esc_html__( 'لینک دکمه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::TEXT,
          'default' => esc_html__( '#', 'kaveh-core' ),
  
      ]
  );
  $repeater->add_control(
    'backsliderfifthkaveh',
    [
      'label' => esc_html__( 'تصویر خود را انتخاب کنید', 'kaveh-core' ),
      'type' => \Elementor\Controls_Manager::MEDIA,
    ]
  );
      $this->add_control(
        'slidessliderfifthkaveh',
        [
          'label' => esc_html__( 'اسلاید ها', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::REPEATER,
          'default' => [
            [
              'titlesliderfifthkaveh' => esc_html__( 'فروش انواع' , 'kaveh-core' ),
              'title2sliderfifthkaveh' => esc_html__( 'ابزار شارژی و لیزری' , 'kaveh-core' ),
              'buttonsliderfifthkaveh' => esc_html__( 'محصولات', 'kaveh-core' ),
              'linkbuttonsliderfifthkaveh' => esc_html__( '#', 'kaveh-core' ),
            ],
          ],
          'fields' => $repeater->get_controls()
          ],
      );
      $this->add_control(
        'backslidermainfifthkaveh',
        [
          'label' => esc_html__( 'تصویر پس زمینه', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::MEDIA,
          'selectors' => [
            '{{WRAPPER}} .landing-eleven::before' =>
                'background: url({{URL}}) 0 0 no-repeat',
        ],
        ]
      );
      
       $this->end_controls_section();
       $this->start_controls_section(
        'style1_sliderfifthkaveh',
        [
          'label' => esc_html__( 'استایل عنوان', 'kaveh-core' ),
          'tab' => \Elementor\Controls_Manager::TAB_STYLE,
        ]
       );
       $this->add_control(
        'titlestsliderfifthkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان فرعی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .landing-eleven-item .sup-title .subsli5t' => 'color: {{VALUE}}',
          ],
        ]
       );
       $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'title_sliderfifthkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان فرعی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .landing-eleven-item .sup-title .subsli5t',
        ]
       );
       $this->add_control(
        'titlepstsliderfifthkaveh',
        [
          'label' => esc_html__( 'رنگ عنوان اصلی', 'kaveh-core' ),
          'type' => \Elementor\Controls_Manager::COLOR,
          'selectors' => [
            '{{WRAPPER}} .landing-eleven-item .title .tisli5t' => 'color: {{VALUE}}',
          ],
        ]
       );
       $this->add_group_control(
        \Elementor\Group_Control_Typography::get_type(),
        [
          'name' => 'p_sliderfifthkaveh',
          'label' => esc_html__( 'تایپوگرافی عنوان اصلی', 'kaveh-core' ),
          'selector' => '{{WRAPPER}} .landing-eleven-item .title .tisli5t',
        ]
       );
       $this->end_controls_section();
       
       
       
       
       
       $this->start_controls_section(
         'style2_sliderfifthkaveh',
         [
           'label' => esc_html__( 'استایل دکمه', 'kaveh-core' ),
           'tab' => \Elementor\Controls_Manager::TAB_STYLE, 
         ]
        );
        $this->add_group_control(
         \Elementor\Group_Control_Typography::get_type(),
         [
           'name' => 'button_sliderfifthkaveh',
           'label' => esc_html__( 'تایپوگرافی متن دکمه', 'kaveh-core' ),
           'selector' => '{{WRAPPER}} .landing-eleven-item .btn',
         ]
       );
       $this->add_control(
         'iconsizesliderfifthkaveh',
         [
           'label' => esc_html__( 'سایز آیکون', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::SLIDER,
           'size_units' => [ 'px', '%' ],
           'range' => [
             'px' => [
               'min' => 0,
               'max' => 200,
               'step' => 5,
             ],
             '%' => [
               'min' => 0,
               'max' => 100,
             ],
           ],
           'selectors' => [
             '{{WRAPPER}} .landing-eleven-item .btn i' => 'font-size: {{SIZE}}{{UNIT}};',
           ],
         ]
       );
       $this->add_group_control(
         \Elementor\Group_Control_Text_Shadow::get_type(),
         [
           'name' => 'text_shadowsliderfifthkaveh',
           'label' => esc_html__( 'سایه متن', 'kaveh-core' ),
           'selector' => '{{WRAPPER}} .landing-eleven-item .btn',
         ]
       );
       $this->start_controls_tabs(
         'style_tabssliderfifthkaveh'
       );
       
       $this->start_controls_tab(
         'style_normal_tabsliderfifthkaveh',
         [
           'label' => esc_html__( 'عادی', 'kaveh-core' ),
         ]
       );
       $this->add_control(
         'textbuttoncolorsliderfifthkaveh',
         [
           'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
             '{{WRAPPER}} .landing-eleven-item .btn' => 'color: {{VALUE}}',
           ],
         ]
       ); 
       $this->add_control(
         'iconcolorsliderfifthkaveh',
         [
           'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
             '{{WRAPPER}} .landing-eleven-item .btn i' => 'color: {{VALUE}}',
           ],
         ]
       ); 
       $this->add_control(
         'buttoncolorsliderfifthkaveh',
         [
           'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
             '{{WRAPPER}} .landing-eleven-item .btn' => 'background-color: {{VALUE}}',
           ],
         ]
       ); 
       $this->add_control(
         'buttonradiussliderfifthkaveh',
         [
           'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::DIMENSIONS,
           'size_units' => [ 'px' ],
           'selectors' => [
             '{{WRAPPER}} .landing-eleven-item .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
           ],
         ]
       );
       $this->add_group_control(
         \Elementor\Group_Control_Border::get_type(),
         [
           'name' => 'bordersliderfifthkaveh',
           'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
           'selector' => '{{WRAPPER}} .landing-eleven-item .btn',
         ]
       );
       $this->add_control(
         'buttonborderssliderfifthkaveh',
         [
           'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::DIMENSIONS,
           'size_units' => [ 'px' ],
           'condition' => [
             'bordersliderfifthkaveh!' => '',
           ],
           'selectors' => [
             '{{WRAPPER}} .landing-eleven-item .btn' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
           ],
         ]
       );
       $this->end_controls_tab();
       $this->start_controls_tab(
         'style_hove_tabsliderfifthkaveh',
         [
           'label' => esc_html__( 'هاور', 'kaveh-core' ),
         ]
       );
       $this->add_control(
         'textbuttoncolorhoversliderfifthkaveh',
         [
           'label' => esc_html__( 'رنگ نوشته دکمه', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
             '{{WRAPPER}} .landing-eleven-item .btn:hover' => 'color: {{VALUE}}',
           ],
         ]
       ); 
       $this->add_control(
         'iconcolorhoversliderfifthkaveh',
         [
           'label' => esc_html__( 'رنگ آیکون', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
             '{{WRAPPER}} .landing-eleven-item .btn:hover i' => 'color: {{VALUE}}',
           ],
         ]
       ); 
       $this->add_control(
         'buttoncolorhoversliderfifthkaveh',
         [
           'label' => esc_html__( 'رنگ پس زمینه دکمه', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
             '{{WRAPPER}} .landing-eleven-item .btn:hover' => 'background-color: {{VALUE}}',
           ],
         ]
       ); 
       $this->add_control(
         'buttonradiushoversliderfifthkaveh',
         [
           'label' => esc_html__( 'گوشه خمیده دکمه بیشتر', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::DIMENSIONS,
           'size_units' => [ 'px' ],
           'selectors' => [
             '{{WRAPPER}} .landing-eleven-item .btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
           ],
         ]
       );
       $this->add_group_control(
         \Elementor\Group_Control_Border::get_type(),
         [
           'name' => 'borderhoversliderfifthkaveh',
           'label' => esc_html__( 'حاشیه', 'kaveh-core' ),
           'selector' => '{{WRAPPER}} .landing-eleven-item .btn:hover',
         ]
       );
       $this->add_control(
         'buttonbordershoversliderfifthkaveh',
         [
           'label' => esc_html__( 'عرض حاشیه', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::DIMENSIONS,
           'size_units' => [ 'px' ],
           'condition' => [
             'borderhoversliderfifthkaveh!' => '',
           ],
           'selectors' => [
             '{{WRAPPER}} .landing-eleven-item .btn:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}} !important;',
           ],
         ]
       );
       $this->end_controls_tab();
       $this->end_controls_tabs();
       $this->add_group_control(
         \Elementor\Group_Control_Box_Shadow::get_type(),
         [
           'name' => 'box_shadowsliderfifthkavehh',
           'label' => esc_html__( 'سایه دکمه', 'kaveh-core' ),
           'selector' => '{{WRAPPER}} .landing-eleven-item .btn',
         ]
       );
       $this->add_control(
         'hr1sliderfifthkaveh',
         [
           'type' => \Elementor\Controls_Manager::DIVIDER,
         ]
       );
       $this->add_control(
         'buttonpaddingsliderfifthkaveh',
         [
           'label' => esc_html__( 'فاصله داخلی', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::DIMENSIONS,
           'size_units' => [ 'px' ],
           'selectors' => [
             '{{WRAPPER}} .landing-eleven-item .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
           ],
         ]
       );
        $this->end_controls_section();
       
       
       
        $this->start_controls_section(
         'style3_sliderfifthkaveh',
         [
           'label' => esc_html__( 'استایل تصاویر', 'kaveh-core' ),
           'tab' => \Elementor\Controls_Manager::TAB_STYLE, 
         ]
        );
       $this->add_control(
         'widthmainsliderfifthkaveh',
         [
           'label' => esc_html__( 'سایز تصویر', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::SLIDER,
           'size_units' => [ 'px', '%' ],
           'range' => [
             'px' => [
               'min' => 0,
               'max' => 2000,
               'step' => 5,
             ],
             '%' => [
               'min' => 0,
               'max' => 100,
             ],
           ],
           'default' => [
             'unit' => 'px',
             'size' => 605,
           ],
           'selectors' => [
             '{{WRAPPER}} .imgsli5' => 'width: {{SIZE}}{{UNIT}};',
           ],
         ]
       );
        $this->end_controls_section();
        $this->start_controls_section(
         'style4_sliderfifthkaveh',
         [
           'label' => esc_html__( 'استایل عمومی', 'kaveh-core' ),
           'tab' => \Elementor\Controls_Manager::TAB_STYLE,
         ]
        );
        $this->add_control(
         'bgmaincolorsliderfifthkaveh',
         [
           'label' => esc_html__( 'رنگ پس زمینه', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
             '{{WRAPPER}} .landing-eleven' => 'background-color: {{VALUE}}',
           ],
         ]
       ); 
       $this->add_control(
         'arrowbgcolorsliderfifthkaveh',
         [
           'label' => esc_html__( 'رنگ پس زمینه فلش ها', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
            '{{WRAPPER}} .landing-eleven .swiper-button-next' => 'background-color: {{VALUE}}',
            '{{WRAPPER}} .landing-eleven .swiper-button-prev' => 'background-color: {{VALUE}}',

          ],
         ]
       ); 
       $this->add_control(
         'arrowcolor2sliderfifthkaveh',
         [
           'label' => esc_html__( 'رنگ فلش ها', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::COLOR,
           'selectors' => [
            '{{WRAPPER}} .landing-eleven .swiper-button-next::after' => 'color: {{VALUE}}',
            '{{WRAPPER}} .landing-eleven .swiper-button-prev::after' => 'color: {{VALUE}}',

          ],
         ]
       ); 
       $this->add_control(
         'heightmainsliderfifthkaveh',
         [
           'label' => esc_html__( 'ارتفاع اسلایدر', 'kaveh-core' ),
           'type' => \Elementor\Controls_Manager::SLIDER,
           'size_units' => [ 'px', '%' ],
           'range' => [
             'px' => [
               'min' => 0,
               'max' => 2000,
               'step' => 5,
             ],
             '%' => [
               'min' => 0,
               'max' => 100,
             ],
           ],
           'selectors' => [
             '{{WRAPPER}} .landing-eleven' => 'height: {{SIZE}}{{UNIT}};',
           ],
         ]
       );
        $this->end_controls_section();
          
        }
 

  protected function render(){
    $settings = $this->get_settings_for_display();
    $clsid = $this->get_id();
    ?>
    <section class="landing-eleven">
      <div class="container position-relative">
        <div class="swiper swiper-landing" data-swiper='{"slidesPerView":1,"spaceBetween":0,"navigation":{"nextEl":".swiper-button-next","prevEl":".swiper-button-prev"},"pagination":{"el":".swiper-pagination","type":"bullets","clickable":true},"autoplay":{"delay":5000,"disableOnInteraction":false,"pauseOnMouseEnter":true},"effect":"fade","fadeEffect":{"crossFade":true},"loop":true}'>
          <div class="swiper-wrapper">
          <?php
            if ( $settings['slidessliderfifthkaveh'] ) {
            foreach (  $settings['slidessliderfifthkaveh'] as $item ) {
            ?>
            <!-- Start Slide -->
            <div class="swiper-slide">
              <div class="landing-eleven-item d-flex align-items-lg-center position-relative flex-column flex-lg-row">
                <div class="image">
                  <img src="<?php echo esc_url($item['backsliderfifthkaveh']['url']); ?>" class="imgsli5" alt="<?php echo esc_attr(\Elementor\Control_Media::get_image_alt( $item['backsliderfifthkaveh'] )); ?>" />
                </div>
                <div class="detail">
                  <div class="sup-title overflow-hidden">
                    <<?php echo  esc_html($item['tagheading1sliderfifthkaveh']); ?> class="d-block subsli5t"><?php echo  esc_html($item['titlesliderfifthkaveh']); ?></<?php echo  esc_html($item['tagheading1sliderfifthkaveh']); ?>>
                  </div>
                  <div class="title overflow-hidden">
                    <<?php echo  esc_html($item['tagheading2sliderfifthkaveh']); ?> class="tisli5t"><?php echo  esc_html($item['title2sliderfifthkaveh']); ?></<?php echo  esc_html($item['tagheading2sliderfifthkaveh']); ?>>
                  </div>
                  <a href="<?php echo  esc_url($item['linkbuttonsliderfifthkaveh']); ?>" class="btn btn-primary">
                  <?php echo  esc_html($item['buttonsliderfifthkaveh']); ?>
                    <i class="<?php echo  esc_attr($item['iconbuttsliderfifthkaveh']['value']); ?>"></i>
                  </a>
                </div>
              </div>
            </div>
            <!-- End Slide -->
            <?php
          }
        }
          ?>
          </div>
          <div class="swiper-button-next"></div>
          <div class="swiper-button-prev"></div>
        </div>
      </div>
    </section>
    <style>
    .landing-eleven::before {
    background-repeat: no-repeat;
    background-size: cover;
}
    </style>
    <?php do_action('kelementor_inline_scripts'); ?>
   <?php

  }


}
